/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view.resourcegroup;

import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ResourceGroupLabelProvider
extends LabelProvider {
    private static final String RESOURCE_TYPE_IMAGE_PATH = "resource_type.png";
    private static final String RESOURCE_GROUP_IMAGE_PATH = "resource_group.png";

    public String getText(Object object) {
        String string = null;
        if (object instanceof ResourceType) {
            ResourceType resourceType = (ResourceType)object;
            string = String.valueOf(resourceType.getName()) + " [" + resourceType.getSystemId() + "]";
        } else {
            string = object instanceof ResourceGroup ? ((ResourceGroup)object).getName() : super.getText(object);
        }
        return string;
    }

    public Image getImage(Object object) {
        Image image = null;
        if (object instanceof ResourceType) {
            String string = RESOURCE_TYPE_IMAGE_PATH;
            image = this.createImage(string);
        } else if (object instanceof ResourceGroup) {
            String string = RESOURCE_GROUP_IMAGE_PATH;
            image = this.createImage(string);
        } else {
            image = super.getImage(object);
        }
        return image;
    }

    private Image createImage(String string) {
        if (string == null) {
            return null;
        }
        ImageDescriptor imageDescriptor = Utility.getImageDescriptor(string);
        return new Image((Device)Display.getCurrent(), imageDescriptor.getImageData());
    }
}

