/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.wizard.MessageWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class MessageWizard
extends Wizard {
    private long resourceTypeID;
    private IResourceTypeService rtService;
    private MessageWizardPage page;
    private Message message;

    public MessageWizard(long l) {
        this.resourceTypeID = l;
        this.rtService = ServiceFactory.createFactory().createResourceTypeService();
        this.setWindowTitle("New Resource Type Message");
    }

    public Message getMessage() {
        return this.message;
    }

    public boolean performFinish() {
        block3: {
            try {
                if (this.rtService.isMessageNameUnique(this.resourceTypeID, this.page.getMessageName())) break block3;
                this.page.setErrorMessage("A Message with this name already exist for this Resource Type");
                return false;
            }
            catch (Exception exception) {
                Utility.reportError("Error while creating the Message.", exception);
                return false;
            }
        }
        this.message = this.rtService.createMessage(this.buildMessage());
        return true;
    }

    public void addPages() {
        this.page = new MessageWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    private Message buildMessage() {
        Message message = this.page.getMessageObject();
        ResourceType resourceType = new ResourceType();
        resourceType.setId(this.resourceTypeID);
        message.setResourceType(resourceType);
        return message;
    }
}

