/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.ui.TemplateResourcesUtility;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.NonPersistableFileEditorInput;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.ServiceErrors;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.wizard.AbstractWatchPointWizard;
import com.tandbergtv.watchpoint.studio.ui.wizard.NewWatchPointTemplateWizardPage;
import com.tandbergtv.watchpoint.studio.ui.xml.WorkflowTemplateDomAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jbpm.gd.common.model.SemanticElementFactory;

public class NewWatchPointTemplateWizard
extends AbstractWatchPointWizard {
    private static final String INITIAL_GPD_XML = "initialGPD.xml";
    private static final String INITIAL_TEMPLATE_XML = "initialTemplate.xml";
    private WorkflowTemplateDTO initialDTO;
    private String pageTitle;
    private String pageDescription;
    protected NewWatchPointTemplateWizardPage page;

    public NewWatchPointTemplateWizard() {
        super("Template");
        this.setWindowTitle("New WatchPoint Template");
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super.init(iWorkbench, iStructuredSelection);
        this.initialDTO = this.createInitialTemplateDTO("");
        this.pageTitle = "Create WatchPoint Template";
        this.pageDescription = "Create a new WatchPoint template";
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection, WorkflowTemplateDTO workflowTemplateDTO) {
        super.init(iWorkbench, iStructuredSelection);
        this.initialDTO = Utility.createTemplateDTO(-1L, 1, "", workflowTemplateDTO.getXml(), workflowTemplateDTO.getGpd());
        this.setWindowTitle("Copy Template " + workflowTemplateDTO.getName());
        this.pageTitle = "Copy WatchPoint Template";
        this.pageDescription = "Create a new WatchPoint template from an existing template";
    }

    public void addPages() {
        this.page = new NewWatchPointTemplateWizardPage(this.pageTitle, this.pageDescription);
        this.addPage((IWizardPage)this.page);
    }

    protected boolean setupEditor() {
        try {
            if (Utility.getWindow() == null) {
                Utility.setWindow(this.getActiveWorkbenchWindow());
            }
            String string = this.setNameForProcessDefinition(this.getObjectName(), this.initialDTO.getXml());
            this.initialDTO.setXml(string);
            this.initialDTO.setName(this.getObjectName());
            this.saveTemplate();
            IFile iFile = TemplateResourcesUtility.createTemplateFile(this.initialDTO.getXml(), this.initialDTO.getGpd());
            IDE.openEditor((IWorkbenchPage)this.getActivePage(), (IEditorInput)new NonPersistableFileEditorInput(iFile, this.initialDTO), (String)"org.jbpm.gd.jpdl.editor");
            BasicNewResourceWizard.selectAndReveal((IResource)iFile, (IWorkbenchWindow)this.getActiveWorkbenchWindow());
        }
        catch (UIException uIException) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)uIException.getMessage());
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error initializing WatchPoint editor.");
        }
        return true;
    }

    protected boolean isNameDuplicate(String string) {
        return ServiceFactory.createFactory().createWorkflowTemplateService().nameExists(string);
    }

    protected String getObjectName() {
        return this.page.getProcessName();
    }

    protected WizardPage getCurrentPage() {
        return this.page;
    }

    protected void closeEditor() {
        Utility.closeEditor("org.jbpm.gd.jpdl.editor", true);
    }

    private String createInitialProcessDefinition(String string) {
        SemanticElementFactory semanticElementFactory = new SemanticElementFactory("org.jbpm.gd.jpdl.editor");
        WorkflowTemplate workflowTemplate = (WorkflowTemplate)semanticElementFactory.createById("org.jbpm.gd.jpdl.processDefinition");
        WorkflowTemplateDomAdapter workflowTemplateDomAdapter = (WorkflowTemplateDomAdapter)Utility.getAdapterFromStream(INITIAL_TEMPLATE_XML, ((Object)((Object)this)).getClass().getResourceAsStream(INITIAL_TEMPLATE_XML), semanticElementFactory);
        workflowTemplateDomAdapter.initialize(workflowTemplate);
        workflowTemplate.setName(string);
        return Utility.getXMLFromDocument(workflowTemplateDomAdapter.getNode().getOwnerDocument());
    }

    private String setNameForProcessDefinition(String string, String string2) {
        SemanticElementFactory semanticElementFactory = new SemanticElementFactory("org.jbpm.gd.jpdl.editor");
        WorkflowTemplate workflowTemplate = (WorkflowTemplate)semanticElementFactory.createById("org.jbpm.gd.jpdl.processDefinition");
        WorkflowTemplateDomAdapter workflowTemplateDomAdapter = (WorkflowTemplateDomAdapter)Utility.getAdapterFromString(string2, semanticElementFactory);
        workflowTemplateDomAdapter.initialize(workflowTemplate);
        workflowTemplate.setName(string);
        return Utility.getXMLFromDocument(workflowTemplateDomAdapter.getNode().getOwnerDocument());
    }

    private String createInitialGpdInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(INITIAL_GPD_XML)));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(String.valueOf(string) + LINE_SEPARATOR);
            }
        }
        catch (IOException iOException) {
            throw new UIException("Could not read from initialGPD.xml to get the initial gpd xml.", iOException);
        }
        return stringBuffer.toString();
    }

    private WorkflowTemplateDTO createInitialTemplateDTO(String string) {
        return Utility.createTemplateDTO(-1L, 1, string, this.createInitialProcessDefinition(string), this.createInitialGpdInfo());
    }

    private void saveTemplate() {
        try {
            this.initialDTO = ServiceFactory.createFactory().createWorkflowTemplateService().createTemplate(this.initialDTO, Utility.getUserName(), true);
        }
        catch (ServiceValidationException serviceValidationException) {
            Utility.updateValidationErrors(this.getActivePage().getActivePart().getSite(), serviceValidationException.getValidationMessages());
            throw new UIException("The template is invalid, can not save.", serviceValidationException);
        }
        catch (ServiceException serviceException) {
            throw new UIException(ServiceErrors.getInstance().getProperty(serviceException.getServiceErrorCode().getCode()), serviceException);
        }
    }
}

