/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.service.IResourceGroupService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.wizard.ResourceGroupWizardPage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ResourceGroupWizard
extends Wizard
implements INewWizard {
    private static final int MAX_IMAGE_FILE_SIZE = 51200;
    private static final int READ_SIZE = 1024;
    private ResourceGroupWizardPage page;
    private IResourceGroupService rgService;
    private ResourceGroupWizardPage.Mode mode;
    private ResourceGroup group;

    public ResourceGroupWizard() {
        this(ResourceGroupWizardPage.Mode.CREATE, null);
    }

    public ResourceGroupWizard(ResourceGroupWizardPage.Mode mode, ResourceGroup resourceGroup) {
        this.mode = mode;
        this.group = resourceGroup;
        this.setWindowTitle(mode.getTitle());
        this.rgService = ServiceFactory.createFactory().createResourceGroupService();
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        this.page = new ResourceGroupWizardPage(this.mode, this.group);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        switch (this.mode) {
            case CREATE: {
                try {
                    if (this.rgService.isNameExists(this.page.getResourceGroupName())) {
                        this.page.setErrorMessage("A Resource Group with this name already exists");
                        return false;
                    }
                }
                catch (Exception exception) {
                    Utility.reportError("Error while checking if Name is unique", exception);
                    return false;
                }
                return this.createResourceGroup();
            }
            case EDIT: {
                return this.editResourceGroup();
            }
        }
        return true;
    }

    private boolean createResourceGroup() {
        ResourceGroup resourceGroup = new ResourceGroup();
        try {
            this.fillEntityFromPage(resourceGroup, this.page);
            this.rgService.createResourceGroup(resourceGroup);
        }
        catch (Exception exception) {
            Utility.reportError("Resource Group Creation Failed.", exception);
            return false;
        }
        return true;
    }

    private boolean editResourceGroup() {
        try {
            this.fillEntityFromPage(this.group, this.page);
            this.rgService.updateResourceGroup(this.group);
        }
        catch (Exception exception) {
            Utility.reportError("Resource Group Edit Failed.", exception);
            return false;
        }
        return true;
    }

    private void fillEntityFromPage(ResourceGroup resourceGroup, ResourceGroupWizardPage resourceGroupWizardPage) {
        resourceGroup.setName(resourceGroupWizardPage.getResourceGroupName());
        resourceGroup.setResourceType(resourceGroupWizardPage.getResourceType());
        resourceGroup.setFunctionalType(this.convertBlankToNull(resourceGroupWizardPage.getFunctionalType()));
        resourceGroup.setInternallyAcquired(resourceGroupWizardPage.isAllocationStyleInternal());
        resourceGroup.setAllocationStrategyClassName(this.convertBlankToNull(resourceGroupWizardPage.getAllocationStrategy()));
        if (this.mode != ResourceGroupWizardPage.Mode.CREATE && resourceGroupWizardPage.isClearCurrentImage()) {
            resourceGroup.setImageContent(null);
            resourceGroup.setImageFileName(null);
        }
        if (resourceGroupWizardPage.getImageFile() != null && resourceGroupWizardPage.getImageFile().length() > 0) {
            resourceGroup.setImageContent(this.readFile(resourceGroupWizardPage.getImageFile()));
            resourceGroup.setImageFileName(new File(resourceGroupWizardPage.getImageFile()).getName());
        }
        resourceGroup.setProtectionKey(resourceGroupWizardPage.getProtectionKey());
    }

    private String convertBlankToNull(String string) {
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return null;
    }

    private byte[] readFile(String string) {
        File file = new File(string);
        int n = (int)file.length();
        if (n > 51200) {
            throw new UIException("File Too Big | Image File Max Size (bytes): 51200");
        }
        int n2 = n;
        byte[] byArray = new byte[n2];
        BufferedInputStream bufferedInputStream = null;
        try {
            int n3;
            int n4;
            int n5;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            int n6 = 0;
            while ((n5 = bufferedInputStream.read(byArray, n6, n4 = 1024 > (n3 = n2 - n6) ? n3 : 1024)) != -1 && (n6 += n5) != n2) {
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Exception exception) {
            String string2 = "Exception while reading the image file: " + string;
            throw new UIException(string2, exception);
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    String string3 = "Exception while closing the image file: " + string;
                    throw new UIException(string3, iOException);
                }
            }
        }
    }
}

