/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.dto.ProtectionKey;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceGroupService;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.util.UIValidator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ResourceGroupWizardPage
extends WizardPage {
    private Text nameText;
    private Text allocationStrategyText;
    private Text currentImageText;
    private Text imageText;
    private Combo resourceTypeCombo;
    private Combo functionalTypeCombo;
    private Combo protectionKeyCombo;
    private Group allocationStyleGroup;
    private Button internalRadio;
    private Button externalRadio;
    private Button clearCurrentImageCheck;
    private Button imageFileBrowseButton;
    private Map<String, ProtectionKey> protectionKeyNameObjectMap = new HashMap<String, ProtectionKey>();
    private Map<String, ResourceType> resourceTypeNameObjectMap = new HashMap<String, ResourceType>();
    private ModifyListener validationListener;
    private IResourceGroupService rgService;
    private IResourceTypeService rtService;
    private Mode mode;
    private ResourceGroup group;

    public ResourceGroupWizardPage(Mode mode, ResourceGroup resourceGroup) {
        super("Resource Group");
        this.mode = mode;
        this.setTitle(mode.getTitle());
        this.setDescription(mode.getDescription());
        this.rgService = ServiceFactory.createFactory().createResourceGroupService();
        this.rtService = ServiceFactory.createFactory().createResourceTypeService();
        if (mode != Mode.CREATE) {
            this.group = this.rgService.getResourceGroup(resourceGroup.getKey());
        }
        this.validationListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ResourceGroupWizardPage.this.validate();
            }
        };
    }

    public boolean isPageComplete() {
        return this.getErrorMessage() == null && this.nameText.getText().length() > 0;
    }

    public String getResourceGroupName() {
        return this.nameText.getText();
    }

    public ResourceType getResourceType() {
        return this.resourceTypeNameObjectMap.get(this.resourceTypeCombo.getText());
    }

    public String getFunctionalType() {
        return this.functionalTypeCombo.getText();
    }

    public boolean isAllocationStyleInternal() {
        return this.internalRadio.getSelection();
    }

    public String getAllocationStrategy() {
        return this.allocationStrategyText.getText();
    }

    public boolean isClearCurrentImage() {
        return this.mode != Mode.CREATE ? this.clearCurrentImageCheck.getSelection() : false;
    }

    public String getImageFile() {
        return this.imageText.getText();
    }

    public ProtectionKey getProtectionKey() {
        String string = this.protectionKeyCombo.getText();
        return this.protectionKeyNameObjectMap.containsKey(string) ? this.protectionKeyNameObjectMap.get(string) : new ProtectionKey(string);
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = this.createClientArea(composite);
        this.createNameControl(composite2, null);
        this.createrResourceTypeControl(composite2, (Control)this.nameText);
        this.createFunctionalTypeControl(composite2, (Control)this.resourceTypeCombo);
        this.createAllocationStyleControl(composite2, (Control)this.functionalTypeCombo);
        this.createAllocationStrategyControl(composite2, (Control)this.allocationStyleGroup);
        if (this.mode == Mode.CREATE) {
            this.createImageControl(composite2, (Control)this.allocationStrategyText);
        } else {
            this.createCurrentImageControl(composite2, (Control)this.allocationStrategyText);
            this.createImageControl(composite2, (Control)this.currentImageText);
        }
        this.createProtectionKeyCombo(composite2, (Control)this.imageText);
        this.setValuesAndState();
        this.disableControls();
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    private void disableControls() {
        switch (this.mode) {
            case CREATE: {
                break;
            }
            case EDIT: {
                this.disable(new Control[]{this.nameText, this.resourceTypeCombo});
                break;
            }
            case VIEW: {
                this.disable(new Control[]{this.nameText, this.resourceTypeCombo, this.functionalTypeCombo, this.allocationStyleGroup, this.allocationStrategyText, this.clearCurrentImageCheck, this.imageText, this.imageFileBrowseButton, this.protectionKeyCombo});
            }
        }
    }

    private void disable(Control ... controlArray) {
        if (controlArray != null) {
            Control[] controlArray2 = controlArray;
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray2[n2];
                control.setEnabled(false);
                ++n2;
            }
        }
    }

    private void setValuesAndState() {
        if (this.mode != Mode.CREATE) {
            this.nameText.setText(this.convertNullToEmpty(this.group.getName()));
            if (this.group.getResourceType() != null) {
                this.resourceTypeCombo.setText(this.convertNullToEmpty(this.group.getResourceType().getName()));
            }
            this.functionalTypeCombo.setText(this.convertNullToEmpty(this.group.getFunctionalType()));
            this.internalRadio.setSelection(this.group.isInternallyAcquired());
            this.externalRadio.setSelection(!this.group.isInternallyAcquired());
            this.allocationStrategyText.setText(this.convertNullToEmpty(this.group.getAllocationStrategyClassName()));
            this.allocationStrategyText.setEnabled(this.group.isInternallyAcquired());
            this.currentImageText.setText(this.convertNullToEmpty(this.group.getImageFileName()));
            if (this.group.getImageContent() == null || this.group.getImageContent().length == 0) {
                this.clearCurrentImageCheck.setEnabled(false);
            }
            if (this.group.getProtectionKey() != null) {
                this.protectionKeyCombo.setText(this.convertNullToEmpty(this.group.getProtectionKey().getName()));
            }
        }
    }

    private String convertNullToEmpty(String string) {
        return string == null ? "" : string;
    }

    private Composite createClientArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        composite2.setLayout((Layout)formLayout);
        return composite2;
    }

    private void createNameControl(Composite composite, Control control) {
        this.createLabel("Name : ", composite, control);
        this.nameText = this.createText(composite, control);
        this.nameText.setTextLimit(50);
        this.nameText.addModifyListener(this.validationListener);
    }

    private void createrResourceTypeControl(Composite composite, Control control) {
        this.createLabel("Resource Type : ", composite, control);
        this.resourceTypeCombo = this.createCombo(composite, control, true);
        this.fillResourceTypeCombo();
        this.resourceTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = ResourceGroupWizardPage.this.functionalTypeCombo.getText();
                ResourceGroupWizardPage.this.populateFunctionalTypeCombo();
                ResourceGroupWizardPage.this.functionalTypeCombo.setText(string);
            }
        });
    }

    private void fillResourceTypeCombo() {
        List<ResourceType> list = this.rtService.getResourceTypeList();
        if (list != null) {
            Collections.sort(list, new Comparator<ResourceType>(){

                @Override
                public int compare(ResourceType resourceType, ResourceType resourceType2) {
                    return ResourceGroupWizardPage.this.compareIgnoreCase(resourceType.getName(), resourceType2.getName());
                }
            });
            for (ResourceType resourceType : list) {
                this.resourceTypeCombo.add(resourceType.getName());
                this.resourceTypeNameObjectMap.put(resourceType.getName(), resourceType);
            }
            this.resourceTypeCombo.select(0);
        }
    }

    private void createFunctionalTypeControl(Composite composite, Control control) {
        this.createLabel("Functional Type : ", composite, control);
        this.functionalTypeCombo = this.createCombo(composite, control, false);
        this.functionalTypeCombo.setTextLimit(256);
        this.populateFunctionalTypeCombo();
        this.functionalTypeCombo.addModifyListener(this.validationListener);
    }

    private void populateFunctionalTypeCombo() {
        ResourceType resourceType = this.getResourceType();
        if (resourceType == null) {
            return;
        }
        List<String> list = this.rgService.getAllFunctionalTypesForResourceType(resourceType.getId());
        if (list != null) {
            Collections.sort(list, new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    return ResourceGroupWizardPage.this.compareIgnoreCase(string, string2);
                }
            });
            this.functionalTypeCombo.setItems(list.toArray(new String[0]));
        }
    }

    private void createAllocationStyleControl(Composite composite, Control control) {
        this.createLabel("Allocation Style : ", composite, control);
        this.allocationStyleGroup = this.createGroup(composite, control);
        this.internalRadio = new Button((Composite)this.allocationStyleGroup, 16);
        this.internalRadio.setBounds(10, 15, 70, 15);
        this.internalRadio.setText("Internal");
        this.internalRadio.setSelection(true);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ResourceGroupWizardPage.this.allocationStrategyText.setEnabled(ResourceGroupWizardPage.this.internalRadio.getSelection());
                if (ResourceGroupWizardPage.this.externalRadio.getSelection()) {
                    ResourceGroupWizardPage.this.allocationStrategyText.setText("");
                }
                ResourceGroupWizardPage.this.validate();
            }
        };
        this.internalRadio.addSelectionListener((SelectionListener)selectionAdapter);
        this.externalRadio = new Button((Composite)this.allocationStyleGroup, 16);
        this.externalRadio.setText("External");
        this.externalRadio.setBounds(120, 15, 70, 15);
        this.externalRadio.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private void createAllocationStrategyControl(Composite composite, Control control) {
        this.createLabel("Allocation Strategy: ", composite, control);
        this.allocationStrategyText = this.createText(composite, control);
        this.allocationStrategyText.setTextLimit(256);
        this.allocationStrategyText.addModifyListener(this.validationListener);
    }

    private void createCurrentImageControl(Composite composite, Control control) {
        this.createLabel("Current Image: ", composite, control);
        this.clearCurrentImageCheck = new Button(composite, 32);
        this.clearCurrentImageCheck.setText("Clear");
        FormData formData = new FormData();
        formData.right = new FormAttachment(100, -10);
        if (control != null) {
            formData.top = new FormAttachment(control, 10);
        }
        this.clearCurrentImageCheck.setLayoutData((Object)formData);
        this.currentImageText = new Text(composite, 2048);
        this.currentImageText.setEnabled(false);
        FormData formData2 = new FormData();
        formData2.left = new FormAttachment(30, 2);
        formData2.right = new FormAttachment((Control)this.clearCurrentImageCheck, -10);
        if (control != null) {
            formData2.top = new FormAttachment(control, 10);
        }
        this.currentImageText.setLayoutData((Object)formData2);
    }

    private void createImageControl(Composite composite, Control control) {
        this.createLabel("Image : ", composite, control);
        this.imageFileBrowseButton = new Button(composite, 8);
        this.imageFileBrowseButton.setText("Browse");
        FormData formData = new FormData();
        formData.right = new FormAttachment(100, -10);
        if (control != null) {
            formData.top = new FormAttachment(control, 10);
        }
        this.imageFileBrowseButton.setLayoutData((Object)formData);
        this.imageFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = ResourceGroupWizardPage.this.getPathFromUser();
                if (string != null) {
                    ResourceGroupWizardPage.this.imageText.setText(string);
                }
            }
        });
        this.imageText = new Text(composite, 2048);
        this.imageText.addModifyListener(this.validationListener);
        formData = new FormData();
        formData.left = new FormAttachment(30, 2);
        formData.right = new FormAttachment((Control)this.imageFileBrowseButton, -5);
        if (control != null) {
            formData.top = new FormAttachment(control, 10);
        }
        this.imageText.setLayoutData((Object)formData);
    }

    private String getPathFromUser() {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 131072);
        fileDialog.setText("Please select the image file.");
        return fileDialog.open();
    }

    private void createProtectionKeyCombo(Composite composite, Control control) {
        this.createLabel("Protection Key : ", composite, control);
        this.protectionKeyCombo = this.createCombo(composite, control, false);
        this.protectionKeyCombo.setTextLimit(50);
        this.protectionKeyCombo.addModifyListener(this.validationListener);
        this.protectionKeyCombo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ResourceGroupWizardPage.this.protectionKeyCombo.setText(ResourceGroupWizardPage.this.protectionKeyCombo.getText().toUpperCase());
            }
        });
        this.fillProtectionKeyCombo();
    }

    private void fillProtectionKeyCombo() {
        List<ProtectionKey> list = this.rgService.getAllProtectionKeys();
        if (list != null) {
            Collections.sort(list, new Comparator<ProtectionKey>(){

                @Override
                public int compare(ProtectionKey protectionKey, ProtectionKey protectionKey2) {
                    return ResourceGroupWizardPage.this.compareIgnoreCase(protectionKey.getName(), protectionKey2.getName());
                }
            });
        }
        for (ProtectionKey protectionKey : list) {
            this.protectionKeyCombo.add(protectionKey.getName());
            this.protectionKeyNameObjectMap.put(protectionKey.getName(), protectionKey);
        }
    }

    private void validate() {
        String string = null;
        string = UIValidator.validateValue("Name", this.nameText.getText(), UIValidator.Validation.NOT_BLANK, UIValidator.Validation.TRIMMED);
        if (string != null) {
            this.updateErrorMessage(string);
            return;
        }
        string = UIValidator.validateValue("Functional Type", this.functionalTypeCombo.getText(), UIValidator.Validation.TRIMMED);
        if (string != null) {
            this.updateErrorMessage(string);
            return;
        }
        if (this.internalRadio.getSelection() && (string = UIValidator.validateValue("Allocation Strategy", this.allocationStrategyText.getText(), UIValidator.Validation.TRIMMED)) != null) {
            this.updateErrorMessage(string);
            return;
        }
        string = UIValidator.validateValue("Image", this.imageText.getText(), UIValidator.Validation.TRIMMED);
        if (string != null) {
            this.updateErrorMessage(string);
            return;
        }
        string = UIValidator.validateValue("Protection Key", this.protectionKeyCombo.getText(), UIValidator.Validation.NOT_BLANK, UIValidator.Validation.TRIMMED);
        if (string != null) {
            this.updateErrorMessage(string);
            return;
        }
        this.updateErrorMessage(null);
    }

    private void updateErrorMessage(String string) {
        this.setErrorMessage(string);
        this.getContainer().updateButtons();
    }

    private Label createLabel(String string, Composite composite, Control control) {
        Label label = new Label(composite, 0);
        label.setText(string);
        label.setLayoutData((Object)this.getLSFormData(control));
        return label;
    }

    private Text createText(Composite composite, Control control) {
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)this.getRSFormData(control));
        return text;
    }

    private Combo createCombo(Composite composite, Control control, boolean bl) {
        int n = 772;
        if (bl) {
            n |= 8;
        }
        Combo combo = new Combo(composite, n);
        combo.setLayoutData((Object)this.getRSFormData(control));
        return combo;
    }

    private Group createGroup(Composite composite, Control control) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)this.getRSFormData(control));
        return group;
    }

    private FormData getLSFormData(Control control) {
        FormData formData = new FormData();
        if (control != null) {
            formData.top = new FormAttachment(control, 10);
        }
        return formData;
    }

    private FormData getRSFormData(Control control) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(30, 2);
        formData.right = new FormAttachment(100, -10);
        if (control != null) {
            formData.top = new FormAttachment(control, 10);
        }
        return formData;
    }

    private int compareIgnoreCase(String string, String string2) {
        if (string == null && string2 == null) {
            return 0;
        }
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareToIgnoreCase(string2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        CREATE("Create Resource Group", "Create a new Resource Group"),
        VIEW("View Resource Group", null),
        EDIT("Edit Resource Group", null);

        private String title;
        private String description;

        private Mode(String string2, String string3) {
            this.title = string2;
            this.description = string3;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

