/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.wizard.ResourceTypeWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ResourceTypeWizard
extends Wizard
implements INewWizard {
    ResourceTypeWizardPage page;
    IResourceTypeService rtService;
    ResourceType resourceType;

    public ResourceTypeWizard() {
        this.setWindowTitle("Create Resource Type");
        this.rtService = ServiceFactory.createFactory().createResourceTypeService();
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public boolean performFinish() {
        block5: {
            block4: {
                try {
                    if (this.rtService.isResourceTypeNameUnique(this.page.getResourceTypeName())) break block4;
                    this.page.setErrorMessage("A Resource Type with this name already exists");
                    return false;
                }
                catch (Exception exception) {
                    Utility.reportError("Resource Type Creation Failed.", exception);
                    return false;
                }
            }
            if (this.rtService.isResourceTypeSystemIdUnique(this.page.getResourceTypeSystemID())) break block5;
            this.page.setErrorMessage("A Resource Type with this System ID already exists");
            return false;
        }
        ResourceType resourceType = new ResourceType();
        resourceType.setName(this.page.getResourceTypeName());
        resourceType.setSystemId(this.page.getResourceTypeSystemID());
        resourceType.setDescription(this.page.getResourceTypeDescription());
        resourceType.setConnectionType(this.page.getConnectionType());
        this.resourceType = this.rtService.createResourceType(resourceType);
        return true;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        this.page = new ResourceTypeWizardPage();
        this.addPage((IWizardPage)this.page);
    }
}

