/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.xml;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.AbstractNode;
import org.jbpm.gd.jpdl.model.Description;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.ExceptionHandler;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;

public class NodeDefinitionDomAdapter
extends XmlAdapter {
    public void initialize(SemanticElement semanticElement) {
        super.initialize(semanticElement);
        NodeDefinition nodeDefinition = (NodeDefinition)semanticElement;
        if (this.getAttribute("name") != null && !this.getAttribute("name").equals("")) {
            nodeDefinition.setName(this.getAttribute("name"));
        }
        nodeDefinition.setDefinitionName(this.getAttribute("definitionName"));
        if (this.getAttribute("resourceType") != null && !this.getAttribute("resourceType").equals("")) {
            nodeDefinition.setResourceType(Long.parseLong(this.getAttribute("resourceType")));
        }
        if (this.getAttribute("id") != null && !this.getAttribute("id").equals("")) {
            nodeDefinition.setId(Long.parseLong(this.getAttribute("id")));
        }
        nodeDefinition.addPropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    public Map getNodeTypes() {
        Map map = super.getNodeTypes();
        map.put("auto-task", "node-element");
        map.put("super-state", "node-element");
        map.put("transition", "transition");
        map.put("variable", "variable");
        map.put("description", "description");
        return map;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("auto-task".equals(propertyChangeEvent.getPropertyName())) {
            this.setElement("auto-task", (SemanticElement)propertyChangeEvent.getOldValue(), (SemanticElement)propertyChangeEvent.getNewValue());
        } else if ("super-state".equals(propertyChangeEvent.getPropertyName())) {
            this.setElement("super-state", (SemanticElement)propertyChangeEvent.getOldValue(), (SemanticElement)propertyChangeEvent.getNewValue());
        } else if ("transitionAdd".equals(propertyChangeEvent.getPropertyName())) {
            this.addElement((SemanticElement)((Transition)propertyChangeEvent.getNewValue()));
        } else if ("transitionRemove".equals(propertyChangeEvent.getPropertyName())) {
            this.removeElement((SemanticElement)((Transition)propertyChangeEvent.getOldValue()));
        } else if ("name".equals(propertyChangeEvent.getPropertyName())) {
            this.setAttribute("name", (String)propertyChangeEvent.getNewValue());
        } else if ("resourceType".equals(propertyChangeEvent.getPropertyName())) {
            this.setAttribute("resourceType", propertyChangeEvent.getNewValue().toString());
        } else if ("definitionName".equals(propertyChangeEvent.getPropertyName())) {
            this.setAttribute("definitionName", (String)propertyChangeEvent.getNewValue());
        } else if ("id".equals(propertyChangeEvent.getPropertyName())) {
            this.setAttribute("id", propertyChangeEvent.getNewValue().toString());
        } else if ("variableAdd".equals(propertyChangeEvent.getPropertyName())) {
            this.addElement((SemanticElement)((WPVariable)((Object)propertyChangeEvent.getNewValue())));
        } else if ("variableRemove".equals(propertyChangeEvent.getPropertyName())) {
            this.removeElement((SemanticElement)((WPVariable)((Object)propertyChangeEvent.getOldValue())));
        } else if ("description".equals(propertyChangeEvent.getPropertyName())) {
            this.setElement("description", (SemanticElement)propertyChangeEvent.getOldValue(), (SemanticElement)((Description)propertyChangeEvent.getNewValue()));
        }
    }

    protected void initialize() {
        super.initialize();
        if (this.getSemanticElement() != null) {
            NodeDefinition nodeDefinition = (NodeDefinition)this.getSemanticElement();
            this.setAttribute("name", nodeDefinition.getName());
            this.setAttribute("definitionName", nodeDefinition.getDefinitionName());
            this.setAttribute("id", String.valueOf(nodeDefinition.getId()));
            this.setAttribute("resourceType", String.valueOf(nodeDefinition.getResourceType()));
            this.addElements((SemanticElement[])nodeDefinition.getNodeElements());
            if (nodeDefinition.getNode() instanceof NodeElementContainer) {
                List<WPVariable> list = nodeDefinition.getVariables();
                this.addElements((SemanticElement[])list.toArray(new WPVariable[list.size()]));
            }
            this.addElements((SemanticElement[])nodeDefinition.getTransitions());
            this.addElement((SemanticElement)nodeDefinition.getDescription());
        }
    }

    protected void doModelAdd(XmlAdapter xmlAdapter) {
        String string = xmlAdapter.getElementType();
        SemanticElement semanticElement = this.createSemanticElementFor(xmlAdapter);
        xmlAdapter.initialize(semanticElement);
        NodeDefinition nodeDefinition = (NodeDefinition)this.getSemanticElement();
        if ("event".equals(string)) {
            nodeDefinition.addEvent((Event)semanticElement);
        } else if ("exception-handler".equals(string)) {
            nodeDefinition.addExceptionHandler((ExceptionHandler)semanticElement);
        } else if ("transition".equals(string)) {
            nodeDefinition.addTransition((Transition)semanticElement);
        } else if ("auto-task".equals(string) || "super-state".equals(string)) {
            nodeDefinition.setNode((AbstractNode)semanticElement);
        } else if ("description".equals(this.getNodeType(string))) {
            nodeDefinition.setDescription((Description)semanticElement);
        } else if ("transition".equals(string)) {
            nodeDefinition.addTransition((Transition)semanticElement);
        } else if ("variable".equals(string)) {
            nodeDefinition.addVariable((WPVariable)semanticElement);
        } else if ("description".equals(this.getNodeType(string))) {
            nodeDefinition.setDescription((Description)semanticElement);
        }
    }

    protected void doModelRemove(XmlAdapter xmlAdapter) {
        String string = xmlAdapter.getElementType();
        NodeDefinition nodeDefinition = (NodeDefinition)this.getSemanticElement();
        if ("transition".equals(string)) {
            nodeDefinition.removeTransition((Transition)xmlAdapter.getSemanticElement());
        } else if ("description".equals(this.getNodeType(string))) {
            nodeDefinition.setDescription(null);
        }
    }

    protected void doModelUpdate(String string, String string2) {
        NodeDefinition nodeDefinition = (NodeDefinition)this.getSemanticElement();
        if ("name".equals(string)) {
            nodeDefinition.setName(string2);
        } else if ("resourceType".equals(string)) {
            nodeDefinition.setResourceType(Long.parseLong(string2));
        } else if ("definitionName".equals(string)) {
            nodeDefinition.setDefinitionName(string2);
        }
    }
}

