/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.xml;

import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.jbpm.gd.jpdl.model.Script;
import org.jbpm.gd.jpdl.xml.ScriptDomAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WPScriptDomAdapter
extends ScriptDomAdapter {
    private static final String PADDING = "\t";
    private static final String INTER_CHILD_SPACING = "\n";

    public void notifyChanged(INodeNotifier iNodeNotifier, int n, Object object, Object object2, Object object3, int n2) {
        if (2 == n) {
            this.handleDomAdd(object3);
        } else if (3 == n) {
            this.handleDomRemove(object2);
        } else if (object != null) {
            this.doModelUpdate(((Node)object).getNodeName(), (String)object3);
        }
    }

    protected void doModelUpdate(String string, String string2) {
        Script script = (Script)this.getSemanticElement();
        if ("#cdata-section".equals(string)) {
            String string3 = this.getTextContent();
            script.setScript(string3);
        } else if ("#text".equals(string)) {
            String string4 = this.getTextContent();
            this.replaceScriptContent(string4);
            script.setScript(string4);
        } else {
            super.doModelUpdate(string, string2);
        }
    }

    protected void setTextContent(String string) {
        String string2 = this.getTextContent();
        if (string == null) {
            string = "";
        }
        if (string.equals(string2)) {
            return;
        }
        this.replaceScriptContent(string);
    }

    private void replaceScriptContent(String string) {
        this.removeTextChildren();
        this.replaceTextChild(string);
    }

    private void removeTextChildren() {
        NodeList nodeList = this.getNode().getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            short s = nodeList.item(n).getNodeType();
            if (s == 3 || s == 4) {
                this.getNode().removeChild(nodeList.item(n--));
            }
            ++n;
        }
    }

    private void replaceTextChild(String string) {
        Node node = this.getNode();
        Document document = node.getOwnerDocument();
        if (string != null && !string.equals("")) {
            int n = this.getNodeLevel();
            node.appendChild(document.createTextNode(this.getElementSpacingString(n)));
            node.appendChild(document.createCDATASection(string));
            node.appendChild(document.createTextNode(this.getElementSpacingString(n - 1)));
        }
    }

    private int getNodeLevel() {
        int n = 0;
        Node node = this.getNode();
        Document document = node.getOwnerDocument();
        while (node != null && node != document) {
            ++n;
            node = node.getParentNode();
        }
        return n;
    }

    private String getElementSpacingString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(INTER_CHILD_SPACING);
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append(PADDING);
            ++n2;
        }
        return stringBuilder.toString();
    }
}

