/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation;

import com.tandbergtv.watchpoint.studio.util.ClassLoaderUtil;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.IValidator;
import com.tandbergtv.watchpoint.studio.validation.ValidationRuleInstantiationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValidatorFactory {
    private static final String DEFAULT_FACTORY = "com.tandbergtv.watchpoint.studio.validation.impl.DefaultValidatorFactory";

    protected ValidatorFactory() {
    }

    public static ValidatorFactory createFactory() {
        return ClassLoaderUtil.createFactoryInstance(DEFAULT_FACTORY, ValidatorFactory.class);
    }

    public abstract <T> IValidator<T> createValidator(Class<T> var1);

    public abstract <T> IValidator<T> createValidator(T var1);

    public IValidationRule<?> createValidationRule(String string) throws ValidationRuleInstantiationException {
        try {
            Class<?> clazz = Class.forName(string);
            if (!IValidationRule.class.isAssignableFrom(clazz)) {
                String string2 = "The Class: " + string + " does not implement interface: " + IValidationRule.class.getName() + ", cannot instantiate as Validation Rule.";
                throw new ValidationRuleInstantiationException(string2);
            }
            return (IValidationRule)clazz.newInstance();
        }
        catch (ValidationRuleInstantiationException validationRuleInstantiationException) {
            throw validationRuleInstantiationException;
        }
        catch (Exception exception) {
            String string3 = "Validation Rule class: " + string + " could not be instantiated.";
            throw new ValidationRuleInstantiationException(string3, exception);
        }
    }
}

