/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.graph;

import com.tandbergtv.watchpoint.studio.validation.graph.IWatchPointGraph;
import com.tandbergtv.watchpoint.studio.validation.graph.WatchPointDecorator;
import com.tandbergtv.watchpoint.studio.validation.graph.WatchPointGraphUtils;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.gd.jpdl.model.Fork;
import org.jbpm.gd.jpdl.model.Join;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForkPathLabeler {
    public static final String DEFAULT_FORK_NEST_LEVEL_KEY = "fork.NestLevel";
    public static final String DEFAULT_JOIN_VERTICES_KEY = "fork.JoinVertices";
    public static final String DEFAULT_REACHABLE_VERTICES_KEY = "fork.reachableVertices";
    public static final String DEFAULT_FORK_VERTICES_KEY = "join.ForkVertices";
    private String forkNestLevelKey;
    private String joinVerticesKey;
    private String reachableVerticesKey;
    private String forkVerticesKey;
    private WatchPointDecorator<String, Integer> nestLevelDecorator;
    private WatchPointDecorator<String, Set<Vertex>> joinVerticesDecorator;
    private WatchPointDecorator<String, Set<Vertex>> reachableVerticesDecorator;
    private WatchPointDecorator<String, Set<Vertex>> forkVerticesDecorator;
    private Set<Vertex> forkVertices;
    private Set<Vertex> joinVertices;
    private IWatchPointGraph graph;

    public ForkPathLabeler() {
        this(null, null, null, null);
    }

    public ForkPathLabeler(String string, String string2, String string3, String string4) {
        this.forkNestLevelKey = string != null ? string : DEFAULT_FORK_NEST_LEVEL_KEY;
        this.joinVerticesKey = string2 != null ? string2 : DEFAULT_JOIN_VERTICES_KEY;
        this.reachableVerticesKey = string3 != null ? string3 : DEFAULT_REACHABLE_VERTICES_KEY;
        this.forkVerticesKey = string4 != null ? string4 : DEFAULT_FORK_VERTICES_KEY;
        this.nestLevelDecorator = new WatchPointDecorator(this.forkNestLevelKey, UserData.SHARED);
        this.joinVerticesDecorator = new WatchPointDecorator(this.joinVerticesKey, UserData.SHARED);
        this.reachableVerticesDecorator = new WatchPointDecorator(this.reachableVerticesKey, UserData.SHARED);
        this.forkVerticesDecorator = new WatchPointDecorator(this.forkVerticesKey, UserData.SHARED);
    }

    public IWatchPointGraph getGraph() {
        return this.graph;
    }

    public Set<Vertex> getForkVertices() {
        return this.forkVertices;
    }

    public Set<Vertex> getJoinVertices() {
        return this.joinVertices;
    }

    public Set<Vertex> getJoinVertices(Vertex vertex) {
        return this.joinVerticesDecorator.getValue((UserDataContainer)vertex);
    }

    public Set<Vertex> getReachableVertices(Vertex vertex) {
        return this.reachableVerticesDecorator.getValue((UserDataContainer)vertex);
    }

    public Set<Vertex> getJoinVertices(Edge edge) {
        return this.joinVerticesDecorator.getValue((UserDataContainer)edge);
    }

    public Set<Vertex> getReachableVertices(Edge edge) {
        return this.reachableVerticesDecorator.getValue((UserDataContainer)edge);
    }

    public Set<Vertex> getForkVertices(Vertex vertex) {
        return this.forkVerticesDecorator.getValue((UserDataContainer)vertex);
    }

    public int getForkNestLevel(Vertex vertex) {
        return this.nestLevelDecorator.getValue((UserDataContainer)vertex);
    }

    public void labelForkPaths(IWatchPointGraph iWatchPointGraph) {
        this.initialize(iWatchPointGraph);
        for (Vertex vertex : this.forkVertices) {
            Set<Vertex> set = this.reachableVerticesDecorator.getValue((UserDataContainer)vertex);
            Set<Vertex> set2 = this.joinVerticesDecorator.getValue((UserDataContainer)vertex);
            Set set3 = vertex.getOutEdges();
            for (Object e : set3) {
                Edge edge = (Edge)e;
                this.labelForkTransition(vertex, edge);
                set.addAll((Collection<Vertex>)this.reachableVerticesDecorator.getValue((UserDataContainer)edge));
                set2.addAll((Collection<Vertex>)this.joinVerticesDecorator.getValue((UserDataContainer)edge));
            }
            for (Vertex vertex2 : set2) {
                this.forkVerticesDecorator.getValue((UserDataContainer)vertex2).add(vertex);
            }
        }
    }

    protected void initialize(IWatchPointGraph iWatchPointGraph) {
        this.graph = iWatchPointGraph;
        this.forkVertices = new HashSet<Vertex>();
        this.joinVertices = new HashSet<Vertex>();
        for (Object e : iWatchPointGraph.getVertices()) {
            Vertex vertex = (Vertex)e;
            Object object = WatchPointGraphUtils.getElement((UserDataContainer)vertex);
            if (object instanceof Fork) {
                this.forkVertices.add(vertex);
                this.nestLevelDecorator.setValue(1, (UserDataContainer)vertex);
                this.joinVerticesDecorator.setValue(new HashSet(), (UserDataContainer)vertex);
                this.reachableVerticesDecorator.setValue(new HashSet(), (UserDataContainer)vertex);
                Set set = vertex.getOutEdges();
                for (Object e2 : set) {
                    Edge edge = (Edge)e2;
                    this.joinVerticesDecorator.setValue(new HashSet(), (UserDataContainer)edge);
                    this.reachableVerticesDecorator.setValue(new HashSet(), (UserDataContainer)edge);
                }
                continue;
            }
            if (!(object instanceof Join)) continue;
            this.joinVertices.add(vertex);
            this.forkVerticesDecorator.setValue(new HashSet(), (UserDataContainer)vertex);
        }
    }

    protected void labelForkTransition(Vertex vertex, Edge edge) {
        Vertex vertex2 = edge.getOpposite(vertex);
        VertexVisitorState vertexVisitorState = new VertexVisitorState(vertex, edge);
        this.visitVertex(vertex2, vertexVisitorState);
        this.joinVerticesDecorator.setValue(vertexVisitorState.joinVertices, (UserDataContainer)edge);
        this.reachableVerticesDecorator.setValue(vertexVisitorState.reachableVertices, (UserDataContainer)edge);
    }

    private void visitVertex(Vertex vertex, VertexVisitorState vertexVisitorState) {
        int n;
        if (vertexVisitorState.reachableVertices.contains(vertex)) {
            return;
        }
        if (vertex.equals(vertexVisitorState.forkVertex)) {
            return;
        }
        Object object = WatchPointGraphUtils.getElement((UserDataContainer)vertex);
        if (object instanceof Join) {
            if (vertexVisitorState.currentNestLevel == vertexVisitorState.startNestLevel) {
                vertexVisitorState.joinVertices.add(vertex);
                return;
            }
            VertexVisitorState vertexVisitorState2 = vertexVisitorState;
            vertexVisitorState2.currentNestLevel = vertexVisitorState2.currentNestLevel - 1;
        } else if (object instanceof Fork) {
            VertexVisitorState vertexVisitorState3 = vertexVisitorState;
            vertexVisitorState3.currentNestLevel = vertexVisitorState3.currentNestLevel + 1;
            n = this.nestLevelDecorator.getValue((UserDataContainer)vertex);
            if (vertexVisitorState.currentNestLevel > n) {
                this.nestLevelDecorator.setValue(vertexVisitorState.currentNestLevel, (UserDataContainer)vertex);
            }
        }
        vertexVisitorState.reachableVertices.add(vertex);
        n = vertexVisitorState.currentNestLevel;
        for (Object e : vertex.getSuccessors()) {
            Vertex vertex2 = (Vertex)e;
            this.visitVertex(vertex2, vertexVisitorState);
            vertexVisitorState.currentNestLevel = n;
        }
    }

    private class VertexVisitorState {
        private Set<Vertex> joinVertices;
        private Set<Vertex> reachableVertices;
        private Vertex forkVertex;
        private int currentNestLevel;
        private int startNestLevel;

        VertexVisitorState(Vertex vertex, Edge edge) {
            this.forkVertex = vertex;
            this.joinVertices = (Set)ForkPathLabeler.this.joinVerticesDecorator.getValue((UserDataContainer)edge);
            this.reachableVertices = (Set)ForkPathLabeler.this.reachableVerticesDecorator.getValue((UserDataContainer)edge);
            this.currentNestLevel = this.startNestLevel = ((Integer)ForkPathLabeler.this.nestLevelDecorator.getValue((UserDataContainer)vertex)).intValue();
        }
    }
}

