/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.graph;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.validation.graph.IWatchPointGraph;
import com.tandbergtv.watchpoint.studio.validation.graph.NodeDefinitionGraph;
import com.tandbergtv.watchpoint.studio.validation.graph.WorkflowTemplateGraph;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.SimpleDirectedSparseVertex;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.utils.UserData;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphFactory {
    protected GraphFactory() {
    }

    public static GraphFactory createFactory() {
        return new GraphFactory();
    }

    public IWatchPointGraph createGraph(Object object) {
        DirectedSparseGraph directedSparseGraph = null;
        if (object instanceof WorkflowTemplate) {
            directedSparseGraph = new WorkflowTemplateGraph();
            this.buildGraph((NodeElementContainer)((WorkflowTemplate)object), (IWatchPointGraph)directedSparseGraph);
        } else if (object instanceof NodeDefinition) {
            directedSparseGraph = new NodeDefinitionGraph();
            this.buildGraph((NodeDefinition)object, (IWatchPointGraph)directedSparseGraph);
        } else {
            String string = object == null ? "a null object." : "an object of type: " + object.getClass().getName() + ".";
            throw new IllegalArgumentException("Cannot build a graph for " + string);
        }
        return directedSparseGraph;
    }

    public <T extends IWatchPointGraph> T createReverseGraph(T t) {
        IWatchPointGraph iWatchPointGraph = (IWatchPointGraph)t.copy();
        Set set = iWatchPointGraph.getEdges();
        HashSet<DirectedEdge> hashSet = new HashSet<DirectedEdge>();
        for (DirectedEdge directedEdge : set) {
            hashSet.add(this.createEdge(directedEdge.getDest(), directedEdge.getSource(), null));
        }
        GraphUtils.removeEdges((Graph)iWatchPointGraph, (Set)set);
        GraphUtils.addEdges((Graph)iWatchPointGraph, hashSet);
        return (T)iWatchPointGraph;
    }

    private void buildGraph(NodeElementContainer nodeElementContainer, IWatchPointGraph iWatchPointGraph) {
        NodeElement[] nodeElementArray = nodeElementContainer.getNodeElements();
        int n = nodeElementArray != null ? nodeElementArray.length : 0;
        iWatchPointGraph.addUserDatum("element", nodeElementContainer, UserData.SHARED);
        Vertex[] vertexArray = new Vertex[n];
        int n2 = 0;
        while (n2 < n) {
            vertexArray[n2] = this.createVertex(nodeElementArray[n2]);
            iWatchPointGraph.addVertex(vertexArray[n2]);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            Transition[] transitionArray = nodeElementArray[n2].getTransitions();
            int n3 = transitionArray != null ? transitionArray.length : 0;
            int n4 = 0;
            while (n4 < n3) {
                Transition transition = transitionArray[n4];
                String string = transition.getTo();
                Vertex vertex = this.findVertex(iWatchPointGraph, string);
                if (!vertex.isSuccessorOf(vertexArray[n2])) {
                    iWatchPointGraph.addEdge((Edge)this.createEdge(vertexArray[n2], vertex, transition));
                }
                ++n4;
            }
            ++n2;
        }
    }

    private Vertex createVertex(Object object) {
        SimpleDirectedSparseVertex simpleDirectedSparseVertex = new SimpleDirectedSparseVertex();
        simpleDirectedSparseVertex.addUserDatum((Object)"element", object, UserData.SHARED);
        return simpleDirectedSparseVertex;
    }

    private DirectedEdge createEdge(Vertex vertex, Vertex vertex2, Object object) {
        DirectedSparseEdge directedSparseEdge = new DirectedSparseEdge(vertex, vertex2);
        if (object != null) {
            directedSparseEdge.addUserDatum((Object)"element", object, UserData.SHARED);
        }
        return directedSparseEdge;
    }

    private Vertex findVertex(IWatchPointGraph iWatchPointGraph, String string) {
        Vertex vertex = null;
        for (Vertex vertex2 : iWatchPointGraph.getVertices()) {
            String string2;
            NodeElement nodeElement = (NodeElement)vertex2.getUserDatum((Object)"element");
            String string3 = string2 = nodeElement != null ? nodeElement.getName() : null;
            if (string2 == null || !string2.equals(string)) continue;
            vertex = vertex2;
            break;
        }
        return vertex;
    }
}

