/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.impl;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationRuleConfiguratonException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidationRuleReader {
    private static final String RESOURCE_NAME = "/validation-rules.properties";
    private static final Logger logger = Logger.getLogger(ValidationRuleReader.class);

    private ValidationRuleReader() {
    }

    public static Map<Class<?>, List<IValidationRule<?>>> readValidationRules() throws ValidationRuleConfiguratonException {
        Object object;
        HashMap hashMap = new HashMap();
        boolean bl = false;
        InputStream inputStream = null;
        try {
            try {
                object = new Properties();
                inputStream = ValidationRuleReader.class.getResourceAsStream(RESOURCE_NAME);
                ((Properties)object).load(inputStream);
                for (Object object2 : ((Properties)object).keySet()) {
                    String string = (String)object2;
                    String string2 = ((Properties)object).getProperty(string);
                    try {
                        String[] stringArray = string2.split(",");
                        int n = stringArray != null ? stringArray.length : 0;
                        Class<?> clazz = Class.forName(string);
                        ArrayList<IValidationRule> arrayList = new ArrayList<IValidationRule>();
                        int n2 = 0;
                        while (n2 < n) {
                            String string3;
                            String string4 = string3 = stringArray[n2] != null ? stringArray[n2].trim() : "";
                            if (string3.length() > 0) {
                                Class<?> clazz2 = Class.forName(string3);
                                IValidationRule iValidationRule = (IValidationRule)clazz2.newInstance();
                                arrayList.add(iValidationRule);
                            }
                            ++n2;
                        }
                        hashMap.put(clazz, arrayList);
                    }
                    catch (Exception exception) {
                        bl = true;
                        String string5 = "Failed to read and load the validation rules for entity: " + string;
                        logger.error((Object)string5, (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                String string = "Failed to load the configuration of the Validation Rules.";
                throw new ValidationRuleConfiguratonException(string, hashMap, exception);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.warn((Object)"Failure when closing the stream.", (Throwable)iOException);
            }
        }
        if (bl) {
            object = "Failed to load some of the configuration of the Validation Rules.";
            throw new ValidationRuleConfiguratonException((String)object, hashMap);
        }
        return hashMap;
    }
}

