/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.message;

import com.tandbergtv.watchpoint.studio.application.ApplicationProperties;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagePropertiesRule
implements IValidationRule<Message> {
    private static final String MESSAGE_UID_REGEX = "^(\\p{Alnum}{6})((\\.(\\p{Alnum}{1,3}))?)$";

    @Override
    public List<ValidationMessage> validateRule(Message message) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        this.validateParentResourceType(message, arrayList);
        this.validateMessageName(message, arrayList);
        this.validateMessageUID(message, arrayList);
        this.validateMessageProtocol(message, arrayList);
        this.validateMessageDescription(message, arrayList);
        return arrayList;
    }

    private void validateParentResourceType(Message message, List<ValidationMessage> list) {
        ResourceType resourceType = message.getResourceType();
        if (resourceType == null) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_RESOURCE_TYPE_NULL;
            list.add(new ValidationMessage(message, ValidationMessageType.Error, validationMessageCode));
        }
    }

    private void validateMessageName(Message message, List<ValidationMessage> list) {
        String string = message.getName();
        if (string == null || string.trim().length() == 0) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_NAME_BLANK;
            list.add(new ValidationMessage(message, ValidationMessageType.Error, validationMessageCode));
        } else if (string.length() > 50) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_NAME_TOO_LONG;
            list.add(new ValidationMessage(message, ValidationMessageType.Error, validationMessageCode));
        }
    }

    private void validateMessageUID(Message message, List<ValidationMessage> list) {
        if (message.isUIDGenerationRequired() || message.getResourceType() == null) {
            return;
        }
        ResourceType resourceType = message.getResourceType();
        String string = message.getUid();
        if (string == null || string.trim().length() == 0) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_UID_BLANK;
            list.add(new ValidationMessage(message, ValidationMessageType.Error, validationMessageCode));
        } else if (!Pattern.matches(MESSAGE_UID_REGEX, string)) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_UID_INVALID;
            list.add(new ValidationMessage(message, ValidationMessageType.Error, validationMessageCode));
        } else {
            ValidationMessageCode validationMessageCode;
            ApplicationProperties applicationProperties = ApplicationProperties.getInstance();
            String string2 = string.substring(0, 2);
            String string3 = string.substring(2, 4);
            String string4 = resourceType.getSystemId();
            String string5 = applicationProperties.getProperty("WFS.ResourceType.SystemId");
            if (message.isIncoming() && !string2.equals(string4)) {
                validationMessageCode = ValidationMessageCode.INCOMING_MESSAGE_UID_SOURCE_INVALID;
                list.add(new ValidationMessage(message, ValidationMessageType.Error, validationMessageCode));
            }
            if (message.isIncoming() && !string3.equals(string5)) {
                validationMessageCode = ValidationMessageCode.INCOMING_MESSAGE_UID_DESTINATION_INVALID;
                list.add(new ValidationMessage(message, ValidationMessageType.Error, validationMessageCode));
            }
            if (!message.isIncoming() && !string2.equals(string5)) {
                validationMessageCode = ValidationMessageCode.OUTGOING_MESSAGE_UID_SOURCE_INVALID;
                list.add(new ValidationMessage(message, ValidationMessageType.Error, validationMessageCode));
            }
            if (!message.isIncoming() && !string3.equals(string4)) {
                validationMessageCode = ValidationMessageCode.OUTGOING_MESSAGE_UID_DESTINATION_INVALID;
                list.add(new ValidationMessage(message, ValidationMessageType.Error, validationMessageCode));
            }
        }
    }

    private void validateMessageProtocol(Message message, List<ValidationMessage> list) {
        String string = message.getProtocol();
        if (string != null && string.length() > 256) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_PROTOCOL_TOO_LONG;
            list.add(new ValidationMessage(message, ValidationMessageType.Error, validationMessageCode));
        }
    }

    private void validateMessageDescription(Message message, List<ValidationMessage> list) {
        String string = message.getDescription();
        if (string != null && string.length() > 256) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_DESCRIPTION_TOO_LONG;
            list.add(new ValidationMessage(message, ValidationMessageType.Error, validationMessageCode));
        }
    }
}

