/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodedefinition;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesRule;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.gd.jpdl.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperStateVariablesRule
extends NodeVariablesRule<NodeDefinition> {
    @Override
    protected List<Variable> getVariables(NodeDefinition nodeDefinition) {
        List<WPVariable> list;
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        if (nodeDefinition.getNodeType() == NodeDefinitionType.SuperState && (list = nodeDefinition.getVariables()) != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    @Override
    protected boolean isValidatingBlankNames(NodeDefinition nodeDefinition) {
        return false;
    }

    @Override
    protected boolean isValidatingNameBlank(NodeDefinition nodeDefinition) {
        return false;
    }

    @Override
    protected boolean isValidatingNameValue(NodeDefinition nodeDefinition) {
        return false;
    }

    @Override
    protected boolean isValidatingMappedNameBlank(NodeDefinition nodeDefinition) {
        return false;
    }

    @Override
    protected ValidationMessageCode getBlankMappedNamesCode(NodeDefinition nodeDefinition) {
        return ValidationMessageCode.SUPERSTATE_VARIABLES_BLANK_MAPPED_NAMES;
    }

    @Override
    protected ValidationMessageCode getMappedNameInvalidCode(NodeDefinition nodeDefinition) {
        return ValidationMessageCode.VARIABLE_MAPPED_NAME_INVALID_IN_SUPERSTATE;
    }

    @Override
    protected ValidationMessageCode getTypeBlankCode(NodeDefinition nodeDefinition) {
        return ValidationMessageCode.VARIABLE_TYPE_BLANK_IN_SUPERSTATE;
    }

    @Override
    protected ValidationMessageCode getTypeInvalidCode(NodeDefinition nodeDefinition) {
        return ValidationMessageCode.VARIABLE_TYPE_INVALID_IN_SUPERSTATE;
    }

    @Override
    protected void validateVariables(NodeDefinition nodeDefinition, List<Variable> list, List<ValidationMessage> list2) {
        super.validateVariables(nodeDefinition, list, list2);
        this.validateNamesNotConfigured(nodeDefinition, list, list2);
    }

    private void validateNamesNotConfigured(NodeDefinition nodeDefinition, List<Variable> list, List<ValidationMessage> list2) {
        if (list != null) {
            boolean bl = false;
            for (Variable validationMessageCode : list) {
                String string = validationMessageCode.getName();
                if (string == null || string.trim().length() <= 0) continue;
                bl = true;
                break;
            }
            if (bl) {
                ValidationMessageCode validationMessageCode = ValidationMessageCode.SUPERSTATE_VARIABLES_NAME_DEFINED;
                list2.add(new ValidationMessage(nodeDefinition, ValidationMessageType.Error, validationMessageCode));
            }
        }
    }
}

