/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.model.ContainerNode;
import com.tandbergtv.watchpoint.studio.validation.model.ContainerVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeVariablesMappingRule
implements IValidationRule<ContainerNode> {
    @Override
    public List<ValidationMessage> validateRule(ContainerNode containerNode) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        List<ContainerVariable> list = containerNode.getContainerVariables();
        List<Variable> list2 = this.getVariables(containerNode.getNode());
        HashMap<Variable, ContainerVariable> hashMap = new HashMap<Variable, ContainerVariable>();
        if (list2 != null) {
            for (Variable variable : list2) {
                String string = variable.getName();
                ContainerVariable containerVariable = this.findContainerVariable(string, list);
                hashMap.put(variable, containerVariable);
            }
        }
        this.validateMissingMapping(containerNode, hashMap, arrayList);
        this.validateInvalidMapping(containerNode, hashMap, arrayList);
        this.validateMappingTypes(containerNode, hashMap, arrayList);
        return arrayList;
    }

    protected abstract List<Variable> getVariables(NodeElement var1);

    protected void validateMissingMapping(ContainerNode containerNode, Map<Variable, ContainerVariable> map, List<ValidationMessage> list) {
        NodeElement nodeElement = containerNode.getNode();
        for (Variable variable : map.keySet()) {
            String string = variable.getName();
            if (!this.isBlank(string)) continue;
            ValidationMessageCode validationMessageCode = this.getMappingMissingCode(containerNode);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(variable.getMappedName());
            list.add(new ValidationMessage(nodeElement, ValidationMessageType.Error, validationMessageCode, arrayList));
        }
    }

    protected void validateInvalidMapping(ContainerNode containerNode, Map<Variable, ContainerVariable> map, List<ValidationMessage> list) {
        NodeElement nodeElement = containerNode.getNode();
        for (Variable variable : map.keySet()) {
            String string = variable.getName();
            if (this.isBlank(string) || map.get(variable) != null) continue;
            ValidationMessageCode validationMessageCode = this.getMappingInvalidCode(containerNode);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(variable.getMappedName());
            arrayList.add(variable.getName());
            list.add(new ValidationMessage(nodeElement, ValidationMessageType.Error, validationMessageCode, arrayList));
        }
    }

    protected void validateMappingTypes(ContainerNode containerNode, Map<Variable, ContainerVariable> map, List<ValidationMessage> list) {
        NodeElement nodeElement = containerNode.getNode();
        for (Variable variable : map.keySet()) {
            String string;
            ContainerVariable containerVariable = map.get(variable);
            String string2 = variable instanceof WPVariable ? ((WPVariable)variable).getType() : null;
            String string3 = string = containerVariable != null ? containerVariable.getType() : null;
            if (this.isBlank(string2) || this.isBlank(string) || string2.equals(string)) continue;
            ValidationMessageCode validationMessageCode = this.getMappingTypeMismatchCode(containerNode);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(variable.getMappedName());
            arrayList.add(string2);
            arrayList.add(string);
            list.add(new ValidationMessage(nodeElement, ValidationMessageType.Error, validationMessageCode, arrayList));
        }
    }

    protected ValidationMessageCode getMappingMissingCode(ContainerNode containerNode) {
        ValidationMessageCode validationMessageCode = null;
        if (containerNode.isTemplateContainer()) {
            validationMessageCode = ValidationMessageCode.NODE_VARIABLE_NOT_MAPPED_IN_TEMPLATE;
        } else if (containerNode.isNodeDefinitionContainer()) {
            validationMessageCode = ValidationMessageCode.NODE_VARIABLE_NOT_MAPPED_IN_NODE_DEFINITION;
        }
        return validationMessageCode;
    }

    protected ValidationMessageCode getMappingInvalidCode(ContainerNode containerNode) {
        ValidationMessageCode validationMessageCode = null;
        if (containerNode.isTemplateContainer()) {
            validationMessageCode = ValidationMessageCode.NODE_VARIABLE_MAPPING_INVALID_IN_TEMPLATE;
        } else if (containerNode.isNodeDefinitionContainer()) {
            validationMessageCode = ValidationMessageCode.NODE_VARIABLE_MAPPING_INVALID_IN_NODE_DEFINITION;
        }
        return validationMessageCode;
    }

    protected ValidationMessageCode getMappingTypeMismatchCode(ContainerNode containerNode) {
        ValidationMessageCode validationMessageCode = null;
        if (containerNode.isTemplateContainer()) {
            validationMessageCode = ValidationMessageCode.NODE_VARIABLE_TYPE_MISMATCH_IN_TEMPLATE;
        } else if (containerNode.isNodeDefinitionContainer()) {
            validationMessageCode = ValidationMessageCode.NODE_VARIABLE_TYPE_MISMATCH_IN_NODE_DEFINITION;
        }
        return validationMessageCode;
    }

    private boolean isBlank(String string) {
        return string == null || string.trim().length() == 0;
    }

    private ContainerVariable findContainerVariable(String string, List<ContainerVariable> list) {
        if (this.isBlank(string) || list == null) {
            return null;
        }
        for (ContainerVariable containerVariable : list) {
            if (!string.equals(containerVariable.getName())) continue;
            return containerVariable;
        }
        return null;
    }
}

