/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.nodedefinition;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageContainer;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.util.DecisionExprValidationUtil;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.nodedefinition.IRequiredVariableFinder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.gd.jpdl.model.Condition;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateRequiredVariableFinder
implements IRequiredVariableFinder {
    @Override
    public Set<String> getRequiredVariableNames(NodeDefinition nodeDefinition) {
        HashSet<String> hashSet = new HashSet<String>();
        if (nodeDefinition.getNodeType() == NodeDefinitionType.SingleNode) {
            this.getRequiredVariableNames(nodeDefinition, hashSet, false);
        } else if (nodeDefinition.getNodeType() == NodeDefinitionType.SuperState) {
            NodeElementContainer nodeElementContainer = (NodeElementContainer)nodeDefinition.getNode();
            if (nodeElementContainer == null) {
                return hashSet;
            }
            NodeElement[] nodeElementArray = nodeElementContainer.getNodeElements();
            if (nodeElementArray != null) {
                NodeElement[] nodeElementArray2 = nodeElementArray;
                int n = nodeElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NodeDefinition nodeDefinition2;
                    NodeElement nodeElement = nodeElementArray2[n2];
                    if (nodeElement instanceof NodeDefinition) {
                        nodeDefinition2 = (NodeDefinition)nodeElement;
                        this.getRequiredVariableNames(nodeDefinition2, hashSet, true);
                    } else if (nodeElement instanceof Decision) {
                        nodeDefinition2 = (Decision)nodeElement;
                        this.getRequiredVariableNames((Decision)nodeDefinition2, hashSet);
                    }
                    ++n2;
                }
            }
        }
        return hashSet;
    }

    private void getRequiredVariableNames(NodeDefinition nodeDefinition, Set<String> set, boolean bl) {
        Map<String, String> map;
        String string;
        IMessageContainer iMessageContainer = (IMessageContainer)nodeDefinition.getNode();
        if (iMessageContainer == null) {
            return;
        }
        List<WPVariable> list = iMessageContainer.getOutgoingVariables();
        if (list != null) {
            for (WPVariable object2 : list) {
                String string2 = string = bl ? object2.getName() : object2.getMappedName();
                if (string == null || string.trim().length() <= 0) continue;
                set.add(string);
            }
        }
        if ((map = iMessageContainer.getCompositeKeys()) != null) {
            Object object3 = null;
            object3 = bl ? map.values() : (Collection)map.keySet();
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (string == null || string.trim().length() <= 0) continue;
                set.add(string);
            }
        }
    }

    private void getRequiredVariableNames(Decision decision, Set<String> set) {
        this.getRequiredVariableNames(decision.getExpression(), set);
        Transition[] transitionArray = decision.getTransitions();
        if (transitionArray != null) {
            Transition[] transitionArray2 = transitionArray;
            int n = transitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Transition transition = transitionArray2[n2];
                Condition condition = transition.getCondition();
                String string = condition != null ? condition.getExpression() : null;
                this.getRequiredVariableNames(string, set);
                ++n2;
            }
        }
    }

    private void getRequiredVariableNames(String string, Set<String> set) {
        Map<Integer, String> map;
        if (string != null && string.trim().length() > 0 && (map = DecisionExprValidationUtil.getOperands(string)) != null) {
            set.addAll(map.values());
        }
    }
}

