/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeNamesUniqueRule<NEC extends NodeElementContainer>
implements IValidationRule<NEC> {
    @Override
    public List<ValidationMessage> validateRule(NEC NEC) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        HashMap<String, Set<NodeElement>> hashMap = new HashMap<String, Set<NodeElement>>();
        NodeElement[] nodeElementArray = NEC.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement nodeElement = nodeElementArray[n2];
            String string = nodeElement.getName();
            if (string != null && string.trim().length() != 0) {
                HashSet<NodeElement> hashSet = (HashSet<NodeElement>)hashMap.get(string);
                if (hashSet == null) {
                    hashSet = new HashSet<NodeElement>();
                    hashMap.put(string, hashSet);
                }
                hashSet.add(nodeElement);
            }
            ++n2;
        }
        this.validateDuplicateNodeNames(NEC, hashMap, arrayList);
        return arrayList;
    }

    protected void validateDuplicateNodeNames(NEC NEC, Map<String, Set<NodeElement>> map, List<ValidationMessage> list) {
        if (map == null) {
            return;
        }
        for (String string : map.keySet()) {
            Set<NodeElement> set = map.get(string);
            if (set == null || set.size() <= 1) continue;
            ValidationMessageCode validationMessageCode = this.getDuplicateNodeNameValidationCode();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            list.add(new ValidationMessage(NEC, ValidationMessageType.Error, validationMessageCode, arrayList));
        }
    }

    protected abstract ValidationMessageCode getDuplicateNodeNameValidationCode();
}

