/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.graph;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.graph.WatchPointGraphUtils;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.EndState;
import org.jbpm.gd.jpdl.model.Fork;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.StartState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphNodeDegreeRule
implements IValidationRule<DirectedSparseGraph> {
    @Override
    public List<ValidationMessage> validateRule(DirectedSparseGraph directedSparseGraph) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        Set set = directedSparseGraph.getVertices();
        for (Vertex vertex : set) {
            this.validateNodeInDegree(vertex, arrayList);
            this.validateNodeOutDegree(vertex, arrayList);
        }
        return arrayList;
    }

    protected void validateNodeInDegree(Vertex vertex, List<ValidationMessage> list) {
        NodeElement nodeElement = WatchPointGraphUtils.getWTVertexElement(vertex);
        int n = vertex.inDegree();
        if (nodeElement instanceof StartState) {
            if (n != 0) {
                ValidationMessageCode validationMessageCode = ValidationMessageCode.INVALID_START_NODE_IN_DEGREE;
                list.add(new ValidationMessage(nodeElement, ValidationMessageType.Error, validationMessageCode));
            }
        } else if (n < 1) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.INVALID_NODE_IN_DEGREE;
            list.add(new ValidationMessage(nodeElement, ValidationMessageType.Error, validationMessageCode));
        }
    }

    protected void validateNodeOutDegree(Vertex vertex, List<ValidationMessage> list) {
        NodeElement nodeElement = WatchPointGraphUtils.getWTVertexElement(vertex);
        int n = vertex.outDegree();
        if (nodeElement instanceof EndState) {
            if (n != 0) {
                ValidationMessageCode validationMessageCode = ValidationMessageCode.INVALID_END_NODE_OUT_DEGREE;
                list.add(new ValidationMessage(nodeElement, ValidationMessageType.Error, validationMessageCode));
            }
        } else if (nodeElement instanceof Decision) {
            if (n < 2) {
                ValidationMessageCode validationMessageCode = ValidationMessageCode.INVALID_DECISION_NODE_OUT_DEGREE;
                list.add(new ValidationMessage(nodeElement, ValidationMessageType.Error, validationMessageCode));
            }
        } else if (nodeElement instanceof Fork) {
            if (n < 2) {
                ValidationMessageCode validationMessageCode = ValidationMessageCode.INVALID_FORK_NODE_OUT_DEGREE;
                list.add(new ValidationMessage(nodeElement, ValidationMessageType.Error, validationMessageCode));
            }
        } else if (n == 0) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.NODE_OUT_DEGREE_LOW;
            list.add(new ValidationMessage(nodeElement, ValidationMessageType.Error, validationMessageCode));
        } else if (n > 1) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.NODE_OUT_DEGREE_HIGH;
            list.add(new ValidationMessage(nodeElement, ValidationMessageType.Error, validationMessageCode));
        }
    }
}

