/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.resourcegroup;

import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RGBasicPropertiesRule
implements IValidationRule<ResourceGroup> {
    @Override
    public List<ValidationMessage> validateRule(ResourceGroup resourceGroup) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        this.validateNotNullAndNotBlank(resourceGroup, resourceGroup.getName(), ValidationMessageCode.RESOURCEGROUP_NAME_BLANK, arrayList);
        this.validateTextMaxLength(resourceGroup.getName(), 50, resourceGroup, ValidationMessageCode.RESOURCEGROUP_NAME_TOO_LARGE, arrayList);
        ResourceType resourceType = resourceGroup.getResourceType();
        if (resourceType == null || resourceType.getId() == -1L) {
            arrayList.add(new ValidationMessage(resourceGroup, ValidationMessageType.Error, ValidationMessageCode.RESOURCEGROUP_RESOURCETYPE_NOTSET));
        }
        this.validateTextMaxLength(resourceGroup.getFunctionalType(), 256, resourceGroup, ValidationMessageCode.RESOURCEGROUP_FUNTYPE_TOO_LARGE, arrayList);
        this.validateTextMaxLength(resourceGroup.getAllocationStrategyClassName(), 256, resourceGroup, ValidationMessageCode.RESOURCEGROUP_ALLOCSTRAT_TOO_LARGE, arrayList);
        this.validateTextMaxLength(resourceGroup.getImageFileName(), 150, resourceGroup, ValidationMessageCode.RESOURCEGROUP_IMAGEFILENAME_TOO_LARGE, arrayList);
        if (resourceGroup.getProtectionKey() == null) {
            arrayList.add(new ValidationMessage(resourceGroup, ValidationMessageType.Error, ValidationMessageCode.RESOURCEGROUP_PROTKEY_BLANK));
        } else if (resourceGroup.getProtectionKey().getId() == -1L) {
            this.validateNotNullAndNotBlank(resourceGroup, resourceGroup.getProtectionKey().getName(), ValidationMessageCode.RESOURCEGROUP_PROTKEY_BLANK, arrayList);
            this.validateTextMaxLength(resourceGroup.getProtectionKey().getName(), 50, resourceGroup, ValidationMessageCode.RESOURCEGROUP_PROTKEY_TOO_LARGE, arrayList);
        }
        return arrayList;
    }

    private void validateTextMaxLength(String string, int n, ResourceGroup resourceGroup, ValidationMessageCode validationMessageCode, List<ValidationMessage> list) {
        if (string != null && string.length() > n) {
            list.add(new ValidationMessage(resourceGroup, ValidationMessageType.Error, validationMessageCode));
        }
    }

    private void validateNotNullAndNotBlank(ResourceGroup resourceGroup, String string, ValidationMessageCode validationMessageCode, List<ValidationMessage> list) {
        if (this.isNullOrBlank(string)) {
            list.add(new ValidationMessage(resourceGroup, ValidationMessageType.Error, validationMessageCode));
        }
    }

    private boolean isNullOrBlank(String string) {
        return string == null || string.trim().length() == 0;
    }
}

