/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.resourcetype;

import com.tandbergtv.watchpoint.studio.dto.AdaptorType;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptorPropertiesRule
implements IValidationRule<ResourceType> {
    @Override
    public List<ValidationMessage> validateRule(ResourceType resourceType) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        this.validateAdaptorType(resourceType, arrayList);
        this.validateCustomAdaptorProperties(resourceType, arrayList);
        this.validateDefaultAdaptorProperties(resourceType, arrayList);
        return arrayList;
    }

    private void validateAdaptorType(ResourceType resourceType, List<ValidationMessage> list) {
        int n;
        AdaptorType adaptorType = resourceType.getAdaptorType();
        Set<Message> set = resourceType.getMessages();
        int n2 = n = set == null ? 0 : set.size();
        if (adaptorType == null) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_ADAPTOR_TYPE_BLANK;
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, validationMessageCode));
        } else if (adaptorType == AdaptorType.NONE && n > 0) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_ADAPTOR_TYPE_INVALID;
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, validationMessageCode));
        }
    }

    private void validateCustomAdaptorProperties(ResourceType resourceType, List<ValidationMessage> list) {
        if (resourceType.getAdaptorType() != AdaptorType.CUSTOM) {
            return;
        }
        String string = resourceType.getAdaptorClassName();
        if (string == null || string.trim().length() == 0) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_CUSTOM_ADAPTOR_CLASSNAME_BLANK;
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, validationMessageCode));
        } else if (string.length() > 256) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_CUSTOM_ADAPTOR_CLASSNAME_TOO_LONG;
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, validationMessageCode));
        }
    }

    private void validateDefaultAdaptorProperties(ResourceType resourceType, List<ValidationMessage> list) {
        if (resourceType.getAdaptorType() != AdaptorType.DEFAULT) {
            return;
        }
        String string = resourceType.getMessageIdentificationClassName();
        if (string != null && string.length() > 256) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_IDENTIFIER_TOO_LONG;
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, validationMessageCode));
        }
    }
}

