/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.template.graph;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.graph.ForkPathLabeler;
import com.tandbergtv.watchpoint.studio.validation.graph.GraphFactory;
import com.tandbergtv.watchpoint.studio.validation.graph.IWatchPointGraph;
import com.tandbergtv.watchpoint.studio.validation.graph.WatchPointDecorator;
import com.tandbergtv.watchpoint.studio.validation.graph.WatchPointGraphUtils;
import com.tandbergtv.watchpoint.studio.validation.graph.WorkflowTemplateGraph;
import edu.uci.ics.jung.algorithms.connectivity.BFSDistanceLabeler;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateForkJoinValidationRule
implements IValidationRule<WorkflowTemplateGraph> {
    private static final int MAX_ALLOWED_FORK_NEST_LEVEL = 1;
    private static final String FORK_VALID_KEY = "fork.isValid";

    @Override
    public List<ValidationMessage> validateRule(WorkflowTemplateGraph workflowTemplateGraph) {
        Vertex vertex2;
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        WorkflowTemplateGraph workflowTemplateGraph2 = (WorkflowTemplateGraph)workflowTemplateGraph.copy();
        ForkPathLabeler forkPathLabeler = new ForkPathLabeler();
        forkPathLabeler.labelForkPaths(workflowTemplateGraph2);
        WatchPointDecorator<String, Boolean> watchPointDecorator = new WatchPointDecorator<String, Boolean>(FORK_VALID_KEY, UserData.SHARED);
        this.validateForkJoinCount(forkPathLabeler, arrayList);
        Set<Vertex> set = forkPathLabeler.getForkVertices();
        for (Vertex vertex2 : set) {
            watchPointDecorator.setValue(true, (UserDataContainer)vertex2);
            this.validateForkNestLevel(vertex2, forkPathLabeler, arrayList, watchPointDecorator);
            this.validateForkToSingleJoin(vertex2, forkPathLabeler, arrayList, watchPointDecorator);
        }
        vertex2 = forkPathLabeler.getJoinVertices();
        for (Vertex vertex3 : vertex2) {
            this.validateJoinFromSingleFork(vertex3, forkPathLabeler, arrayList, watchPointDecorator);
        }
        for (Vertex vertex3 : set) {
            if (!watchPointDecorator.getValue((UserDataContainer)vertex3).booleanValue()) continue;
            Vertex vertex4 = this.getJoinVertex(vertex3, forkPathLabeler);
            Set<Vertex> set2 = this.getForkGraphVertices(vertex3, forkPathLabeler);
            this.validateForkJoinReachability(vertex3, vertex4, set2, forkPathLabeler, arrayList, watchPointDecorator);
            if (!watchPointDecorator.getValue((UserDataContainer)vertex3).booleanValue()) continue;
            this.validateForkSubgraphDisjoint(vertex3, vertex4, set2, forkPathLabeler, arrayList, watchPointDecorator);
            if (!watchPointDecorator.getValue((UserDataContainer)vertex3).booleanValue()) continue;
            this.validateForkTransitionsDisjoint(vertex3, forkPathLabeler, arrayList, watchPointDecorator);
        }
        return arrayList;
    }

    private void validateForkJoinCount(ForkPathLabeler forkPathLabeler, List<ValidationMessage> list) {
        int n;
        int n2 = forkPathLabeler.getForkVertices().size();
        if (n2 != (n = forkPathLabeler.getJoinVertices().size())) {
            Object object = WatchPointGraphUtils.getElement((UserDataContainer)forkPathLabeler.getGraph());
            ValidationMessageCode validationMessageCode = ValidationMessageCode.TEMPLATE_FORK_JOIN_UNEQUAL;
            list.add(new ValidationMessage(object, ValidationMessageType.Error, validationMessageCode));
        }
    }

    private void validateForkNestLevel(Vertex vertex, ForkPathLabeler forkPathLabeler, List<ValidationMessage> list, WatchPointDecorator<String, Boolean> watchPointDecorator) {
        int n = forkPathLabeler.getForkNestLevel(vertex);
        if (n > 1) {
            Object object = WatchPointGraphUtils.getElement((UserDataContainer)vertex);
            ValidationMessageCode validationMessageCode = ValidationMessageCode.INVALID_FORK_NEST_LEVEL;
            list.add(new ValidationMessage(object, ValidationMessageType.Error, validationMessageCode));
            watchPointDecorator.setValue(false, (UserDataContainer)vertex);
        }
    }

    private void validateForkToSingleJoin(Vertex vertex, ForkPathLabeler forkPathLabeler, List<ValidationMessage> list, WatchPointDecorator<String, Boolean> watchPointDecorator) {
        int n;
        Set<Vertex> set = forkPathLabeler.getJoinVertices(vertex);
        int n2 = n = set != null ? set.size() : 0;
        if (n != 1) {
            Object object = WatchPointGraphUtils.getElement((UserDataContainer)vertex);
            ValidationMessageCode validationMessageCode = n == 0 ? ValidationMessageCode.FORK_MISSING_JOIN_PAIR : ValidationMessageCode.FORK_MAPPED_TO_MANY_JOINS;
            list.add(new ValidationMessage(object, ValidationMessageType.Error, validationMessageCode));
            watchPointDecorator.setValue(false, (UserDataContainer)vertex);
        } else {
            for (Object e : vertex.getOutEdges()) {
                if (forkPathLabeler.getJoinVertices((Edge)e).size() != 0) continue;
                Object object = WatchPointGraphUtils.getElement((UserDataContainer)vertex);
                ValidationMessageCode validationMessageCode = ValidationMessageCode.FORK_TRANSITION_MISSING_JOIN_PAIR;
                list.add(new ValidationMessage(object, ValidationMessageType.Error, validationMessageCode));
                watchPointDecorator.setValue(false, (UserDataContainer)vertex);
                break;
            }
        }
    }

    private void validateJoinFromSingleFork(Vertex vertex, ForkPathLabeler forkPathLabeler, List<ValidationMessage> list, WatchPointDecorator<String, Boolean> watchPointDecorator) {
        int n;
        Set<Vertex> set = forkPathLabeler.getForkVertices(vertex);
        int n2 = n = set != null ? set.size() : 0;
        if (n != 1) {
            Object object = WatchPointGraphUtils.getElement((UserDataContainer)vertex);
            ValidationMessageCode validationMessageCode = n == 0 ? ValidationMessageCode.JOIN_MISSING_FORK_PAIR : ValidationMessageCode.JOIN_MAPPED_TO_MANY_FORKS;
            list.add(new ValidationMessage(object, ValidationMessageType.Error, validationMessageCode));
            if (n > 1) {
                for (Vertex vertex2 : set) {
                    watchPointDecorator.setValue(false, (UserDataContainer)vertex2);
                }
            }
        }
    }

    private void validateForkJoinReachability(Vertex vertex, Vertex vertex2, Set<Vertex> set, ForkPathLabeler forkPathLabeler, List<ValidationMessage> list, WatchPointDecorator<String, Boolean> watchPointDecorator) {
        Object object;
        Object object22;
        IWatchPointGraph iWatchPointGraph = forkPathLabeler.getGraph();
        IWatchPointGraph iWatchPointGraph2 = GraphFactory.createFactory().createReverseGraph(iWatchPointGraph);
        for (Object object22 : iWatchPointGraph.getVertices()) {
            object = (Vertex)object22;
            if (set.contains(object)) continue;
            Vertex vertex3 = (Vertex)object.getEqualVertex((ArchetypeGraph)iWatchPointGraph2);
            iWatchPointGraph2.removeVertex(vertex3);
        }
        object22 = new BFSDistanceLabeler("fork.subgraph.distance");
        object22.labelDistances((Graph)iWatchPointGraph2, (Vertex)vertex2.getEqualVertex((ArchetypeGraph)iWatchPointGraph2));
        if (object22.getUnivistedVertices().size() > 0) {
            Object object3 = WatchPointGraphUtils.getElement((UserDataContainer)vertex);
            object = ValidationMessageCode.FORK_PATH_MISSING_JOIN;
            list.add(new ValidationMessage(object3, ValidationMessageType.Error, (ValidationMessageCode)((Object)object)));
            watchPointDecorator.setValue(false, (UserDataContainer)vertex);
        }
    }

    private void validateForkSubgraphDisjoint(Vertex vertex, Vertex vertex2, Set<Vertex> set, ForkPathLabeler forkPathLabeler, List<ValidationMessage> list, WatchPointDecorator<String, Boolean> watchPointDecorator) {
        boolean bl = true;
        for (Vertex vertex3 : set) {
            boolean bl2 = vertex3.equals(vertex);
            boolean bl3 = vertex3.equals(vertex2);
            for (Object e : vertex3.getPredecessors()) {
                ValidationMessageCode validationMessageCode;
                Object object;
                Vertex vertex4 = (Vertex)e;
                boolean bl4 = set.contains(vertex4);
                if (bl2) {
                    if (!bl4 || vertex4.equals(vertex2)) continue;
                    object = WatchPointGraphUtils.getElement((UserDataContainer)vertex);
                    validationMessageCode = ValidationMessageCode.FORK_REACHED_FROM_FORK_SUBGRAPH;
                    list.add(new ValidationMessage(object, ValidationMessageType.Error, validationMessageCode));
                    bl = false;
                    break;
                }
                if (bl3) {
                    if (vertex4.equals(vertex)) {
                        object = WatchPointGraphUtils.getElement((UserDataContainer)vertex);
                        validationMessageCode = ValidationMessageCode.FORK_JOIN_PATH_EMPTY;
                        list.add(new ValidationMessage(object, ValidationMessageType.Error, validationMessageCode));
                        bl = false;
                        break;
                    }
                    if (bl4) continue;
                    object = WatchPointGraphUtils.getElement((UserDataContainer)vertex2);
                    validationMessageCode = ValidationMessageCode.JOIN_REACHED_OUTSIDE_FORK_SUBGRAPH;
                    list.add(new ValidationMessage(object, ValidationMessageType.Error, validationMessageCode));
                    bl = false;
                    break;
                }
                if (bl4) continue;
                object = WatchPointGraphUtils.getElement((UserDataContainer)vertex);
                validationMessageCode = ValidationMessageCode.FORK_SUBGRAPH_REACHED_OUTSIDE_FORK_SUBGRAPH;
                list.add(new ValidationMessage(object, ValidationMessageType.Error, validationMessageCode));
                bl = false;
                break;
            }
            if (bl) continue;
            watchPointDecorator.setValue(false, (UserDataContainer)vertex);
            break;
        }
    }

    private void validateForkTransitionsDisjoint(Vertex vertex, ForkPathLabeler forkPathLabeler, List<ValidationMessage> list, WatchPointDecorator<String, Boolean> watchPointDecorator) {
        HashSet<Vertex> hashSet = new HashSet<Vertex>();
        boolean bl = true;
        for (Object e : vertex.getOutEdges()) {
            Edge edge = (Edge)e;
            Set<Vertex> set = forkPathLabeler.getReachableVertices(edge);
            if (hashSet.size() == 0) {
                hashSet.addAll(set);
            } else {
                for (Vertex vertex2 : set) {
                    if (hashSet.contains(vertex2)) {
                        Object object = WatchPointGraphUtils.getElement((UserDataContainer)vertex);
                        ValidationMessageCode validationMessageCode = ValidationMessageCode.FORK_TRANSITIONS_OVERLAP_NODES;
                        list.add(new ValidationMessage(object, ValidationMessageType.Error, validationMessageCode));
                        bl = false;
                        break;
                    }
                    hashSet.add(vertex2);
                }
            }
            if (bl) continue;
            watchPointDecorator.setValue(false, (UserDataContainer)vertex);
            break;
        }
    }

    private Vertex getJoinVertex(Vertex vertex, ForkPathLabeler forkPathLabeler) {
        Vertex vertex2 = null;
        Set<Vertex> set = forkPathLabeler.getJoinVertices(vertex);
        if (set != null && set.size() > 0) {
            vertex2 = set.iterator().next();
        }
        return vertex2;
    }

    private Set<Vertex> getForkGraphVertices(Vertex vertex, ForkPathLabeler forkPathLabeler) {
        HashSet<Vertex> hashSet = new HashSet<Vertex>();
        hashSet.add(vertex);
        hashSet.addAll(forkPathLabeler.getJoinVertices(vertex));
        hashSet.addAll(forkPathLabeler.getReachableVertices(vertex));
        return hashSet;
    }
}

