/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Hyperedge;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.Hypervertex;
import edu.uci.ics.jung.graph.impl.AbstractArchetypeEdge;
import edu.uci.ics.jung.graph.impl.AbstractHypervertex;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractHyperedge
extends AbstractArchetypeEdge
implements Hyperedge {
    private static int nextGlobalEdgeID = 0;

    public AbstractHyperedge() {
        this.id = nextGlobalEdgeID++;
        this.initialize();
    }

    protected void initialize() {
        super.initialize();
    }

    public boolean connectVertex(Hypervertex hv1) {
        ArchetypeGraph g = this.getGraph();
        if (g == null) {
            throw new IllegalArgumentException("Orphaned hyperedges may not be connected to (or disconnected from) vertices");
        }
        if (g != hv1.getGraph()) {
            throw new IllegalArgumentException("Hypervertex " + hv1 + " is either orphaned" + "or an element of a graph other than " + g);
        }
        if (hv1.isIncident(this)) {
            return false;
        }
        if (hv1 instanceof AbstractHypervertex) {
            AbstractHypervertex av = (AbstractHypervertex)hv1;
            av.getEdges_internal().add(this);
        }
        this.getVertices_internal().add(hv1);
        return true;
    }

    public boolean disconnectVertex(Hypervertex hv1) {
        ArchetypeGraph g = this.getGraph();
        if (g == null) {
            throw new IllegalArgumentException("Orphaned hyperedges may not be connected to (or disconnected from) vertices");
        }
        if (g != hv1.getGraph()) {
            throw new IllegalArgumentException("Hypervertex " + hv1 + " is either orphaned" + "or an element of a graph other than " + g);
        }
        if (!hv1.isIncident(this)) {
            return false;
        }
        if (hv1 instanceof AbstractHypervertex) {
            AbstractHypervertex av = (AbstractHypervertex)hv1;
            av.getEdges_internal().remove(this);
        }
        this.getVertices_internal().remove(hv1);
        return true;
    }

    public ArchetypeEdge copy(ArchetypeGraph newGraph) {
        Hyperedge e = (Hyperedge)super.copy(newGraph);
        ((Hypergraph)newGraph).addEdge(e);
        Iterator iter = this.getVertices_internal().iterator();
        while (iter.hasNext()) {
            Hypervertex v = (Hypervertex)iter.next();
            e.connectVertex((Hypervertex)v.getEqualVertex(newGraph));
        }
        return e;
    }

    public Set getIncidentVertices() {
        return Collections.unmodifiableSet(new HashSet(this.getVertices_internal()));
    }

    public String toString() {
        String label = "HE" + this.id + "(";
        Iterator iter = this.getVertices_internal().iterator();
        while (iter.hasNext()) {
            Hypervertex v = (Hypervertex)iter.next();
            label = label + v.toString();
            if (!iter.hasNext()) continue;
            label = label + ",";
        }
        return label + ")";
    }

    protected abstract Collection getVertices_internal();
}

