/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalLensGraphMouse;
import edu.uci.ics.jung.visualization.transform.AbstractLensSupport;
import edu.uci.ics.jung.visualization.transform.HyperbolicTransformer;
import edu.uci.ics.jung.visualization.transform.LensSupport;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableAffineTransformer;
import java.awt.Dimension;

public class LayoutLensSupport
extends AbstractLensSupport
implements LensSupport {
    public LayoutLensSupport(VisualizationViewer vv) {
        this(vv, new HyperbolicTransformer(vv, vv.getLayoutTransformer()), new ModalLensGraphMouse());
    }

    public LayoutLensSupport(VisualizationViewer vv, LensTransformer lensTransformer, ModalGraphMouse lensGraphMouse) {
        super(vv, lensGraphMouse);
        this.lensTransformer = lensTransformer;
        Dimension d = vv.getSize();
        if (d.width <= 0 || d.height <= 0) {
            d = vv.getPreferredSize();
        }
        lensTransformer.setViewRadius(d.width / 5);
    }

    public void activate() {
        if (this.lens == null) {
            this.lens = new AbstractLensSupport.Lens(this.lensTransformer);
        }
        if (this.lensControls == null) {
            this.lensControls = new AbstractLensSupport.LensControls(this.lensTransformer);
        }
        this.vv.setLayoutTransformer(this.lensTransformer);
        this.vv.setViewTransformer(new MutableAffineTransformer());
        this.vv.addPreRenderPaintable(this.lens);
        this.vv.addPostRenderPaintable(this.lensControls);
        this.vv.setGraphMouse(this.lensGraphMouse);
        this.vv.setToolTipText("<html><center>Mouse-Drag the Lens center to move it<p>Mouse-Drag the Lens edge to resize it<p>Ctrl+MouseWheel to change magnification</center></html>");
        this.vv.repaint();
    }

    public void deactivate() {
        if (this.savedViewTransformer != null) {
            this.vv.setViewTransformer(this.savedViewTransformer);
        }
        if (this.lensTransformer != null) {
            this.vv.removePreRenderPaintable(this.lens);
            this.vv.removePostRenderPaintable(this.lensControls);
            this.vv.setLayoutTransformer(this.lensTransformer.getDelegate());
        }
        this.vv.setToolTipText(this.defaultToolTipText);
        this.vv.setGraphMouse(this.graphMouse);
        this.vv.repaint();
    }
}

