/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.jbpm.gd.common.command.AbstractEdgeDeleteCommand;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NodeContainer;
import org.jbpm.gd.jpdl.Logger;

public abstract class AbstractNodeDeleteCommand
extends Command {
    protected Node node;
    protected NodeContainer parent;
    private ArrayList edgeDeleteCommands;
    private ArrayList nodeDeleteCommands;

    public void setNode(Node node) {
        this.node = node;
        this.parent = node.getContainer();
    }

    public void execute() {
        if (this.edgeDeleteCommands == null) {
            this.constructEdgeDeleteCommands();
        }
        if (this.nodeDeleteCommands == null) {
            this.constructNodeDeleteCommands();
        }
        this.executeCommands(this.edgeDeleteCommands);
        this.executeCommands(this.nodeDeleteCommands);
        this.doRemove();
    }

    public void undo() {
        this.doAdd();
        this.undoCommands(this.nodeDeleteCommands);
        this.undoCommands(this.edgeDeleteCommands);
    }

    private void constructNodeDeleteCommands() {
        this.nodeDeleteCommands = new ArrayList();
        if (this.node instanceof NodeContainer) {
            List nodes = ((NodeContainer)((Object)this.node)).getNodes();
            int i = 0;
            while (i < nodes.size()) {
                try {
                    AbstractNodeDeleteCommand command = (AbstractNodeDeleteCommand)((Object)((Object)((Object)this)).getClass().newInstance());
                    command.setNode((Node)nodes.get(i));
                    this.nodeDeleteCommands.add(command);
                }
                catch (IllegalAccessException e) {
                    Logger.logError("problem while creating NodeDeleteCommand", e);
                }
                catch (InstantiationException e) {
                    Logger.logError("problem while creating NodeDeleteCommand", e);
                }
                ++i;
            }
        }
    }

    private void addEdgeDeleteCommand(Edge edge) {
        AbstractEdgeDeleteCommand command = this.createEdgeDeleteCommand();
        command.setEdge(edge);
        this.edgeDeleteCommands.add(command);
    }

    private void addEdgeDeleteCommands(List list) {
        int i = 0;
        while (i < list.size()) {
            this.addEdgeDeleteCommand((Edge)list.get(i));
            ++i;
        }
    }

    private void constructEdgeDeleteCommands() {
        this.edgeDeleteCommands = new ArrayList();
        this.addEdgeDeleteCommands(this.node.getArrivingEdges());
        this.addEdgeDeleteCommands(this.node.getLeavingEdges());
    }

    private void executeCommands(List commands) {
        int i = 0;
        while (i < commands.size()) {
            ((Command)commands.get(i)).execute();
            ++i;
        }
    }

    private void undoCommands(List commands) {
        int i = commands.size();
        while (i > 0) {
            ((Command)commands.get(i - 1)).undo();
            --i;
        }
    }

    protected abstract AbstractEdgeDeleteCommand createEdgeDeleteCommand();

    protected abstract void doAdd();

    protected abstract void doRemove();
}

