/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.notation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.jpdl.Logger;

public class NotationElementFactory {
    private static Map NOTATION_ELEMENT_REGISTRY;
    private Map notationRegistry = new HashMap();

    private static Map getNotationElementRegistry() {
        if (NOTATION_ELEMENT_REGISTRY == null) {
            NotationElementFactory.initializeNotationElementRegistry();
        }
        return NOTATION_ELEMENT_REGISTRY;
    }

    private static void initializeNotationElementRegistry() {
        NOTATION_ELEMENT_REGISTRY = new HashMap();
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.jbpm.gd.jpdl.notationElements");
        int i = 0;
        while (i < configurationElements.length) {
            IConfigurationElement element = configurationElements[i];
            if (element.getName().equals("notationElement")) {
                String key = String.valueOf(element.getNamespaceIdentifier()) + "." + element.getAttribute("id");
                NOTATION_ELEMENT_REGISTRY.put(key, element);
            }
            ++i;
        }
    }

    public AbstractNotationElement create(String elementType) {
        AbstractNotationElement result = null;
        IConfigurationElement element = (IConfigurationElement)NotationElementFactory.getNotationElementRegistry().get(elementType);
        if (element != null) {
            try {
                result = (AbstractNotationElement)element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                Logger.logError("Problem while instantiating notation element for " + elementType, e);
            }
        }
        if (result != null) {
            result.setFactory(this);
        }
        return result;
    }

    void register(AbstractNotationElement notationElement) {
        this.notationRegistry.put(notationElement.getSemanticElement(), notationElement);
    }

    void unregister(AbstractNotationElement notationElement) {
        this.notationRegistry.remove(notationElement.getSemanticElement());
    }

    public AbstractNotationElement getRegisteredNotationElementFor(Object semanticElement) {
        return (AbstractNotationElement)this.notationRegistry.get(semanticElement);
    }
}

