/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.part;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Text;
import org.jbpm.gd.common.figure.NodeFigure;
import org.jbpm.gd.common.model.NamedElement;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NotationElement;
import org.jbpm.gd.common.part.AbstractNodeGraphicalEditPart;
import org.jbpm.gd.common.policy.DirectEditPolicy;
import org.jbpm.gd.common.util.CellEditorLocator;

public abstract class NodeGraphicalEditPart
extends AbstractNodeGraphicalEditPart
implements NodeEditPart {
    private DirectEditManager manager;

    public NodeGraphicalEditPart(NotationElement notationElement) {
        super(notationElement);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPolicy());
    }

    public void refreshVisuals() {
        this.getNodeFigure().setName(((NamedElement)this.getSemanticElement()).getName());
        Rectangle constraint = null;
        constraint = ((Node)this.getNotationElement()).getConstraint() != null ? new Rectangle(((Node)this.getNotationElement()).getConstraint()) : new Rectangle(new Point(0, 0), new Dimension(-1, -1));
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
    }

    private NodeFigure getNodeFigure() {
        return (NodeFigure)this.getFigure();
    }

    private void performDirectEdit() {
        if (this.getNodeFigure().getNameLabel() == null) {
            return;
        }
        if (this.manager == null) {
            this.initializeManager();
        }
        this.manager.show();
    }

    private void initializeManager() {
        CellEditorLocator locator = new CellEditorLocator(this.getNodeFigure().getNameLabel());
        this.manager = new DirectEditManager((GraphicalEditPart)this, TextCellEditor.class, locator){

            protected void initCellEditor() {
                Text text = (Text)this.getCellEditor().getControl();
                String name = ((NamedElement)NodeGraphicalEditPart.this.getSemanticElement()).getName();
                this.getCellEditor().setValue((Object)name);
                text.selectAll();
            }
        };
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }
}

