/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.deployment;

import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Tree;

public class IncludeInDeploymentTreeViewer
extends CheckboxTreeViewer {
    public IncludeInDeploymentTreeViewer(Tree tree) {
        super(tree);
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IncludeInDeploymentTreeViewer.this.handleCheckStateChanged(event);
            }
        });
    }

    private void handleCheckStateChanged(CheckStateChangedEvent event) {
        this.updateChecks(event.getElement(), event.getChecked());
    }

    public boolean setChecked(Object element, boolean state) {
        boolean result = super.setChecked(element, state);
        if (result) {
            this.updateChecks(element, state);
        }
        return result;
    }

    public void setCheckedElements(Object[] elements) {
        super.setCheckedElements(elements);
        int i = 0;
        while (i < elements.length) {
            this.updateChecks(elements[i], true);
            ++i;
        }
    }

    private void updateChecks(Object object, boolean state) {
        this.updateChecksForChildren(object, state);
        this.updateChecksForParents(object, state);
    }

    private void updateChecksForChildren(Object object, boolean state) {
        this.setGrayed(object, false);
        Object[] children = ((ITreeContentProvider)this.getContentProvider()).getChildren(object);
        int i = 0;
        while (i < children.length) {
            if (this.getChecked(children[i]) != state) {
                super.setChecked(children[i], state);
                this.updateChecksForChildren(children[i], state);
            }
            ++i;
        }
    }

    private void updateChecksForParents(Object object, boolean state) {
        ITreeContentProvider provider = (ITreeContentProvider)this.getContentProvider();
        Object child = object;
        Object parent = provider.getParent(child);
        boolean change = true;
        while (parent != null && change) {
            Object[] siblings = provider.getChildren(parent);
            int numberChecked = 0;
            boolean grayed = false;
            change = false;
            int i = 0;
            while (i < siblings.length) {
                if (this.getChecked(siblings[i])) {
                    ++numberChecked;
                }
                if (this.getGrayed(siblings[i])) {
                    grayed = true;
                }
                ++i;
            }
            if (numberChecked == 0) {
                if (this.getChecked(parent) || this.getGrayed(parent)) {
                    change = true;
                }
                this.setGrayChecked(parent, false);
            } else if (numberChecked == siblings.length) {
                if (!this.getChecked(parent) || this.getGrayed(parent) != grayed) {
                    change = true;
                }
                this.setGrayed(parent, false);
                this.setChecked(parent, true);
            } else {
                if (!this.getChecked(parent) || !this.getGrayed(parent)) {
                    change = true;
                }
                this.setGrayChecked(parent, true);
            }
            child = parent;
            parent = provider.getParent(child);
        }
    }
}

