/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.model;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.gd.common.model.AbstractNamedElement;
import org.jbpm.gd.jpdl.model.DescribableElement;
import org.jbpm.gd.jpdl.model.Description;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.ExceptionHandler;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Transition;

public class AbstractNode
extends AbstractNamedElement
implements NodeElement,
DescribableElement {
    private List events = new ArrayList();
    private List exceptionHandlers = new ArrayList();
    private List transitions = new ArrayList();
    private Description description;

    public void setDescription(Description newDescription) {
        Description oldDescription = this.description;
        this.description = newDescription;
        this.firePropertyChange("description", oldDescription, newDescription);
    }

    public Description getDescription() {
        return this.description;
    }

    public void addEvent(Event event) {
        this.events.add(event);
        this.firePropertyChange("eventAdd", null, event);
    }

    public void removeEvent(Event event) {
        this.events.remove(event);
        this.firePropertyChange("eventRemove", event, null);
    }

    public Event[] getEvents() {
        return this.events.toArray(new Event[this.events.size()]);
    }

    public void addExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandlers.add(exceptionHandler);
        this.firePropertyChange("exceptionHandlerAdd", null, exceptionHandler);
    }

    public void removeExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandlers.remove(exceptionHandler);
        this.firePropertyChange("exceptionHandlerRemove", exceptionHandler, null);
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.exceptionHandlers.toArray(new ExceptionHandler[this.exceptionHandlers.size()]);
    }

    public void addTransition(Transition transition) {
        this.transitions.add(transition);
        this.firePropertyChange("transitionAdd", null, transition);
    }

    public void removeTransition(Transition transition) {
        this.transitions.remove(transition);
        this.firePropertyChange("transitionRemove", transition, null);
    }

    public Transition[] getTransitions() {
        return this.transitions.toArray(new Transition[this.transitions.size()]);
    }

    public boolean isPossibleChildOf(NodeElementContainer nodeElementContainer) {
        return true;
    }

    public void initializeName(NodeElementContainer nodeElementContainer) {
        int runner = 1;
        String prefix = this.getNamePrefix();
        while (true) {
            String candidate;
            if (nodeElementContainer.getNodeElementByName(candidate = String.valueOf(prefix) + runner) == null) {
                this.setName(candidate);
                return;
            }
            ++runner;
        }
    }
}

