/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.jpdl.dialog.ChooseDelegationClassDialog;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.properties.DelegationConfigurationComposite;

public class ActionDetailsConfigurationComposite
implements SelectionListener,
FocusListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private CCombo actionTypeCombo;
    private Composite handlerComposite;
    private Composite expressionComposite;
    private Label expressionLabel;
    private Text expressionText;
    private DelegationConfigurationComposite delegationConfigurationComposite;
    private Action action;
    private String selectedActionType = "<Choose>";

    public static ActionDetailsConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        ActionDetailsConfigurationComposite result = new ActionDetailsConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    private ActionDetailsConfigurationComposite() {
    }

    public void setAction(Action action) {
        if (this.action == action) {
            return;
        }
        this.unhookListeners();
        this.clearControls();
        this.action = action;
        if (action != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    public Action getAction() {
        return this.action;
    }

    private void hookListeners() {
        this.actionTypeCombo.addSelectionListener((SelectionListener)this);
        this.expressionText.addSelectionListener((SelectionListener)this);
        this.expressionText.addFocusListener((FocusListener)this);
    }

    private void unhookListeners() {
        this.actionTypeCombo.removeSelectionListener((SelectionListener)this);
        this.expressionText.removeSelectionListener((SelectionListener)this);
        this.expressionText.removeFocusListener((FocusListener)this);
    }

    private void clearControls() {
        this.actionTypeCombo.setText("<Choose>");
        this.expressionText.setText("");
        this.delegationConfigurationComposite.setDelegation(null);
        this.handlerComposite.setVisible(false);
        this.expressionComposite.setVisible(false);
    }

    private void updateControls() {
        String expression = this.action.getExpression();
        this.expressionText.setText(expression == null ? "" : expression);
        this.delegationConfigurationComposite.setDelegation(this.action);
        if (this.action.getClassName() != null) {
            this.actionTypeCombo.setText("Handler");
        } else if (expression != null) {
            this.actionTypeCombo.setText("Expression");
        } else {
            this.actionTypeCombo.setText("<Choose>");
        }
        this.handlerComposite.setVisible("Handler".equals(this.actionTypeCombo.getText()));
        this.expressionComposite.setVisible("Expression".equals(this.actionTypeCombo.getText()));
    }

    private void create() {
        this.createTypeCombo();
        this.createHandlerComposite();
        this.createExpressionComposite();
        this.initializeLayouts();
    }

    private void createTypeCombo() {
        this.actionTypeCombo = this.widgetFactory.createCCombo(this.parent);
        this.actionTypeCombo.setItems(new String[]{"<Choose>", "Expression", "Handler"});
        this.actionTypeCombo.setEditable(false);
        this.actionTypeCombo.setText("<Choose Type>");
        this.actionTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionDetailsConfigurationComposite.this.handleActionTypeComboSelected();
            }
        });
    }

    private void createHandlerComposite() {
        this.handlerComposite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.handlerComposite.setVisible(false);
        this.delegationConfigurationComposite = DelegationConfigurationComposite.create(this.widgetFactory, this.handlerComposite, this.createChooseActionHandlerDialog());
    }

    private ChooseDelegationClassDialog createChooseActionHandlerDialog() {
        return new ChooseDelegationClassDialog(this.parent.getShell(), "org.jbpm.graph.def.ActionHandler", "Choose Action Handler", "Choose an action handler from the list");
    }

    private void createExpressionComposite() {
        this.expressionComposite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.expressionComposite.setVisible(false);
        this.expressionLabel = this.widgetFactory.createLabel(this.expressionComposite, "Expression");
        this.expressionText = this.widgetFactory.createText(this.expressionComposite, "", 514);
    }

    private void initializeLayouts() {
        this.actionTypeCombo.setLayoutData((Object)this.createActionTypeComboLayoutData());
        this.handlerComposite.setLayoutData((Object)this.createActionTypeCompositeLayoutData());
        this.expressionComposite.setLayoutData((Object)this.createActionTypeCompositeLayoutData());
        this.expressionLabel.setLayoutData((Object)this.createExpressionLabelLayoutData());
        this.expressionText.setLayoutData((Object)this.createExpressionTextLayoutData());
    }

    private FormData createExpressionLabelLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 2);
        result.left = new FormAttachment(0, 0);
        return result;
    }

    private FormData createExpressionTextLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 0);
        result.left = new FormAttachment((Control)this.expressionLabel, 0);
        result.right = new FormAttachment(100, -5);
        result.bottom = new FormAttachment(100, 0);
        return result;
    }

    private FormData createActionTypeComboLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 0);
        result.top = new FormAttachment(0, 0);
        return result;
    }

    private FormData createActionTypeCompositeLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment((Control)this.actionTypeCombo, 0);
        result.top = new FormAttachment(0, 0);
        result.bottom = new FormAttachment(100, 0);
        result.right = new FormAttachment(100, 0);
        result.height = 120;
        return result;
    }

    private void updateExpressionText() {
        this.action.setExpression(this.expressionText.getText());
    }

    private void updateControlVisibility() {
        this.handlerComposite.setVisible("Handler".equals(this.actionTypeCombo.getText()));
        this.expressionComposite.setVisible("Expression".equals(this.actionTypeCombo.getText()));
    }

    private void handleActionTypeComboSelected() {
        String selection = this.actionTypeCombo.getText();
        if (selection.equals(this.selectedActionType)) {
            return;
        }
        this.selectedActionType = selection;
        this.updateControlVisibility();
        if (this.action != null) {
            this.removeExpressionAndHandlerInfo();
            this.updateExpressionAndHandlerInfo();
        }
    }

    private void updateExpressionAndHandlerInfo() {
        if ("Expression".equals(this.selectedActionType)) {
            this.action.setExpression(this.expressionText.getText());
            this.removeHandlerInfo();
        } else if ("Handler".equals(this.selectedActionType)) {
            this.delegationConfigurationComposite.setDelegation(this.action);
            this.action.setClassName("");
            this.action.setExpression(null);
        } else {
            this.removeHandlerInfo();
            this.action.setExpression(null);
        }
    }

    private void removeHandlerInfo() {
        this.action.setClassName(null);
        this.action.setConfigInfo(null);
        this.action.setConfigType(null);
        GenericElement[] configElements = this.action.getGenericElements();
        int i = 0;
        while (i < configElements.length) {
            this.action.removeGenericElement(configElements[i]);
            ++i;
        }
        this.delegationConfigurationComposite.setDelegation(null);
    }

    private void removeExpressionAndHandlerInfo() {
        this.action.setExpression(null);
        this.action.setClassName(null);
        this.action.setConfigInfo(null);
        this.action.setConfigType(null);
        GenericElement[] configElements = this.action.getGenericElements();
        int i = 0;
        while (i < configElements.length) {
            this.action.removeGenericElement(configElements[i]);
            ++i;
        }
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.expressionText) {
            this.updateExpressionText();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.actionTypeCombo) {
            this.handleActionTypeComboSelected();
        }
    }
}

