/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.wizard;

import java.io.File;
import java.net.MalformedURLException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jbpm.gd.jpdl.wizard.NewProcessProjectDetailsWizardPage;

public class ConfigureRuntimePage
extends WizardPage {
    private static final String ENTER_NAME_MSG = "Choose a name for the JBoss jBPM Runtime, e.g. 'JBoss jBPM 3.1.1'";
    private static final String ENTER_LOCATION_MSG = "Enter or search a location for the JBoss jBPM Runtime";
    private static final String CONTINUE_MSG = "Press next to continue the project creation";
    private static final String UNEXISTING_LOCATION_MSG = "This location does not exist";
    private static final String INVALID_LOCATION_MSG = "This location does not contain a valid JBoss jBPM runtime, please retry";
    Text nameText;
    Text locationText;
    Text versionText;

    public ConfigureRuntimePage() {
        super("Configure JBoss jBPM Runtime");
        this.setTitle("Configure JBoss jBPM Runtime");
        this.setMessage(ENTER_NAME_MSG);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createClientArea(parent);
        this.createLocateJbpmRuntimeGroup(composite);
        this.createSpace(composite);
        this.createDownloadJbpmRuntimeLink(composite);
        this.setControl((Control)composite);
    }

    private void update() {
        this.updateMessage();
        this.updateVersion();
        this.updatePages();
    }

    private void updatePages() {
        this.setPageComplete(!this.isNameEmpty() && !this.isLocationEmpty() && !this.isVersionEmpty());
        if (!this.isNameEmpty()) {
            NewProcessProjectDetailsWizardPage page = (NewProcessProjectDetailsWizardPage)this.getNextPage();
            page.combo.removeAll();
            page.combo.add(this.nameText.getText());
            page.combo.select(0);
        }
    }

    private void createSpace(Composite composite) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1808));
    }

    private void createDownloadJbpmRuntimeLink(Composite composite) {
        Link link = new Link(composite, 0);
        link.setText("<a>Download the JBoss jBPM package if you have none available yet.</a>");
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000000;
        gridData.verticalIndent = 5;
        link.setLayoutData((Object)gridData);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"http://www.jboss.com/products/jbpm/downloads");
            }
        });
    }

    private void createLocateJbpmRuntimeGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText("Locate a JBoss jBPM Runtime");
        group.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(768);
        gridData.verticalIndent = 5;
        group.setLayoutData((Object)gridData);
        this.createJbpmRuntimeNameField((Composite)group);
        this.createJbpmRuntimeLocationField((Composite)group);
        this.createJbpmRuntimeVersionField((Composite)group);
    }

    private void createJbpmRuntimeVersionField(Composite composite) {
        Label versionLabel = new Label(composite, 0);
        versionLabel.setText("Version :");
        this.versionText = new Text(composite, 2048);
        this.versionText.setEditable(false);
        this.versionText.setLayoutData((Object)new GridData(768));
    }

    private void createJbpmRuntimeNameField(Composite composite) {
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Name :");
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigureRuntimePage.this.update();
            }
        });
        new Label(composite, 0);
    }

    private void createJbpmRuntimeLocationField(Composite composite) {
        Label locationLabel = new Label(composite, 0);
        locationLabel.setText("Location :");
        this.locationText = new Text(composite, 2048);
        this.locationText.setLayoutData((Object)new GridData(768));
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigureRuntimePage.this.update();
            }
        });
        Button locationButton = new Button(composite, 8);
        locationButton.setText("Browse...");
        locationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureRuntimePage.this.searchLocation();
            }
        });
    }

    private void searchLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        String result = dialog.open();
        if (result != null) {
            this.locationText.setText(result);
        }
    }

    private Composite createClientArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void updateMessage() {
        this.setErrorMessage(null);
        if (this.isNameEmpty() && this.isLocationEmpty()) {
            this.setMessage(ENTER_NAME_MSG);
        } else if (this.isLocationEmpty()) {
            this.setMessage(ENTER_LOCATION_MSG);
        } else if (!this.isLocationExisting()) {
            this.setErrorMessage(UNEXISTING_LOCATION_MSG);
        } else if (!this.isValidJbpmInstallation()) {
            this.setErrorMessage(INVALID_LOCATION_MSG);
        } else if (this.isNameEmpty()) {
            this.setMessage(ENTER_NAME_MSG);
        } else {
            this.setMessage(CONTINUE_MSG);
        }
    }

    private void updateVersion() {
        String version = this.getVersion();
        if (version != null) {
            this.versionText.setText(version);
        }
    }

    private String getVersion() {
        String result = null;
        if (!this.isLocationEmpty() && this.isLocationExisting() && this.isValidJbpmInstallation()) {
            File versionInfoFile = this.getJbpmVersionInfoFile();
            if (versionInfoFile == null) {
                return result;
            }
            try {
                Document document = new SAXReader().read(versionInfoFile);
                result = document.getRootElement().attribute("name").getValue();
            }
            catch (DocumentException documentException) {
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return result;
    }

    private boolean isNameEmpty() {
        String text = this.nameText.getText();
        return text == null || "".equals(text);
    }

    private boolean isLocationEmpty() {
        String text = this.locationText.getText();
        return text == null || "".equals(text);
    }

    private boolean isVersionEmpty() {
        String text = this.versionText.getText();
        return text == null || "".equals(text);
    }

    private boolean isLocationExisting() {
        return new Path(this.locationText.getText()).toFile().exists();
    }

    private boolean isValidJbpmInstallation() {
        return this.getJbpmVersionInfoFile().exists();
    }

    private File getJbpmVersionInfoFile() {
        return new Path(this.locationText.getText()).append("/src/resources/gpd/version.info.xml").toFile();
    }
}

