/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.Description;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.ExceptionHandler;
import org.jbpm.gd.jpdl.model.Join;
import org.jbpm.gd.jpdl.model.Timer;
import org.jbpm.gd.jpdl.model.Transition;

public class JoinDomAdapter
extends XmlAdapter {
    private static final String[] CHILD_ELEMENTS = new String[]{"description", "event", "exception-handler", "timer", "transition"};
    private static HashMap NODE_TYPES = null;

    protected String[] getChildElements() {
        return CHILD_ELEMENTS;
    }

    protected Map getNodeTypes() {
        if (NODE_TYPES == null) {
            NODE_TYPES = new HashMap();
            NODE_TYPES.put("description", "description");
            NODE_TYPES.put("event", "event");
            NODE_TYPES.put("exception-handler", "exception-handler");
            NODE_TYPES.put("timer", "timer");
            NODE_TYPES.put("transition", "transition");
        }
        return NODE_TYPES;
    }

    protected String getDefaultValue(String attributeName) {
        if ("async".equals(attributeName)) {
            return "false";
        }
        return super.getDefaultValue(attributeName);
    }

    protected void initialize() {
        super.initialize();
        Join join = (Join)this.getSemanticElement();
        if (join != null) {
            this.setAttribute("name", join.getName());
            this.setAttribute("async", join.getAsync());
            this.addElements(join.getEvents());
            this.addElements(join.getExceptionHandlers());
            this.addElements(join.getTimers());
            this.addElements(join.getTransitions());
        }
    }

    public void initialize(SemanticElement jpdlElement) {
        super.initialize(jpdlElement);
        Join join = (Join)jpdlElement;
        join.setAsync(this.getAttribute("async"));
        join.setName(this.getAttribute("name"));
        join.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("eventAdd".equals(evt.getPropertyName())) {
            this.addElement((Event)evt.getNewValue());
        } else if ("eventRemove".equals(evt.getPropertyName())) {
            this.removeElement((Event)evt.getOldValue());
        } else if ("exceptionHandlerAdd".equals(evt.getPropertyName())) {
            this.addElement((ExceptionHandler)evt.getNewValue());
        } else if ("exceptionHandlerRemove".equals(evt.getPropertyName())) {
            this.removeElement((ExceptionHandler)evt.getOldValue());
        } else if ("timerAdd".equals(evt.getPropertyName())) {
            this.addElement((Timer)evt.getNewValue());
        } else if ("timerRemove".equals(evt.getPropertyName())) {
            this.removeElement((Timer)evt.getOldValue());
        } else if ("transitionAdd".equals(evt.getPropertyName())) {
            this.addElement((Transition)evt.getNewValue());
        } else if ("transitionRemove".equals(evt.getPropertyName())) {
            this.removeElement((Transition)evt.getOldValue());
        } else if ("description".equals(evt.getPropertyName())) {
            this.setElement("description", (SemanticElement)evt.getOldValue(), (Description)evt.getNewValue());
        } else if ("async".equals(evt.getPropertyName())) {
            this.setAttribute("async", (String)evt.getNewValue());
        } else if ("name".equals(evt.getPropertyName())) {
            this.setAttribute("name", (String)evt.getNewValue());
        }
    }

    protected void doModelUpdate(String name, String newValue) {
        Join join = (Join)this.getSemanticElement();
        if ("name".equals(name)) {
            join.setName(newValue);
        } else if ("async".equals(name)) {
            join.setAsync(newValue);
        }
    }

    protected void doModelAdd(XmlAdapter child) {
        String type = child.getElementType();
        SemanticElement jpdlElement = this.createSemanticElementFor(child);
        child.initialize(jpdlElement);
        Join join = (Join)this.getSemanticElement();
        if ("event".equals(type)) {
            join.addEvent((Event)jpdlElement);
        } else if ("exception-handler".equals(type)) {
            join.addExceptionHandler((ExceptionHandler)jpdlElement);
        } else if ("timer".equals(type)) {
            join.addTimer((Timer)jpdlElement);
        } else if ("transition".equals(type)) {
            join.addTransition((Transition)jpdlElement);
        } else if ("description".equals(this.getNodeType(type))) {
            join.setDescription((Description)jpdlElement);
        }
    }

    protected void doModelRemove(XmlAdapter child) {
        String type = child.getElementType();
        Join join = (Join)this.getSemanticElement();
        if ("event".equals(type)) {
            join.removeEvent((Event)child.getSemanticElement());
        } else if ("exception-handler".equals(type)) {
            join.removeExceptionHandler((ExceptionHandler)child.getSemanticElement());
        } else if ("timer".equals(type)) {
            join.removeTimer((Timer)child.getSemanticElement());
        } else if ("transition".equals(type)) {
            join.removeTransition((Transition)child.getSemanticElement());
        } else if ("description".equals(this.getNodeType(type))) {
            join.setDescription(null);
        }
    }
}

