/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.etf;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.jacorb.orb.etf.ConnectionBase;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.ETF.BufferHolder;

public abstract class StreamConnectionBase
extends ConnectionBase {
    protected InputStream in_stream = null;
    protected OutputStream out_stream = null;

    protected StreamConnectionBase() {
    }

    protected StreamConnectionBase(StreamConnectionBase streamConnectionBase) {
        super(streamConnectionBase);
        this.in_stream = streamConnectionBase.in_stream;
        this.out_stream = streamConnectionBase.out_stream;
    }

    public void read(BufferHolder bufferHolder, int n, int n2, int n3, long l) {
        int n4;
        for (int i = 0; i < n2; i += n4) {
            n4 = 0;
            try {
                n4 = this.in_stream.read(bufferHolder.value, n + i, n2 - i);
            }
            catch (InterruptedIOException interruptedIOException) {
                int n5 = this.getTimeout();
                if (n5 != 0) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Socket timeout (timeout period: " + n5 + ")");
                    }
                    throw new TIMEOUT();
                }
                throw new TRANSIENT("Interrupted I/O: " + interruptedIOException);
            }
            catch (IOException iOException) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Transport to " + this.connection_info + ": stream closed " + iOException.getMessage());
                }
                throw this.to_COMM_FAILURE(iOException);
            }
            if (n4 >= 0) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Transport to " + this.connection_info + ": stream closed on read  < 0");
            }
            throw new COMM_FAILURE("read() did not return any data");
        }
    }

    public void write(boolean bl, boolean bl2, byte[] byArray, int n, int n2, long l) {
        try {
            this.out_stream.write(byArray, n, n2);
            if (this.b_out != null) {
                this.b_out.write(byArray, n, n2);
            }
        }
        catch (IOException iOException) {
            throw this.to_COMM_FAILURE(iOException);
        }
    }

    public void flush() {
        try {
            if (this.b_out != null) {
                byte[] byArray = this.b_out.toByteArray();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("sendMessages(): " + ObjectUtil.bufToString(byArray, 0, byArray.length));
                }
                this.b_out.reset();
            }
            this.out_stream.flush();
        }
        catch (IOException iOException) {
            throw this.to_COMM_FAILURE(iOException);
        }
    }

    public boolean is_data_available() {
        try {
            return this.in_stream.available() > 0;
        }
        catch (IOException iOException) {
            throw this.to_COMM_FAILURE(iOException);
        }
    }
}

