/*
==============================================================
Database name:  WFS   
Schema Name:    WFS
Version: @version $Id: createWFS.sql,v 1.8 2007/09/25 16:51:55 cscherlacher Exp $                                 
DBMS name:      ORACLE Version 10.1 or 10.2                       
Script purpose: Create the WFS user and all its
		corresponding objects: sequences
		tables and constraints			
Created by:     Larry Roberts 12/14/2006

Updated by:     Chris Scherlacher 3/1/2007	                            

NOTE:		Must be logged on as sys user    
==============================================================
*/

CREATE OR REPLACE PROCEDURE createWFS IS
  /*  
          Created By:  	Larry Roberts 12/14/2006
          Create Reason: 	Create WFS tables, sequences,triggers,views,etc
                          To create all objects in another schema beside WFS change 
                          WFS to another schema name prior to compiling and 
                          executing this procedure
          Note:		When run, this procedure will log any error message into the 
                          install_table and exit.
          Updated By:     Chris Scherlacher 8/15/2007
          Update Reason:  Updated create procedure for the WP 2.5 changes
  */
  
          wk_database_path	varchar2(100);
          wk_message		varchar2(500);
          wk_count		number := 0;
  
  BEGIN
          wk_message := '';
  
  /* 
  ------------------------------------
      CREATE USERS
  ------------------------------------
  */
  
    -- Drop the install_table
    BEGIN
    
      EXECUTE IMMEDIATE 'Drop table install_table';
      
    EXCEPTION
      WHEN OTHERS
        THEN
          NULL;
          
    END;
    
    -- Create the install_table
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE TABLE install_table (install_message varchar2(500))';
      
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:  
            Unable to create the SYS.INSTALL_TABLE.'')';
            
    END;
  
      -- Verify the WFS user does not exist
    BEGIN
    
      SELECT count(*)
      INTO wk_count
      FROM all_users
      WHERE username = 'WFS';
      
    END;
    
    IF wk_count <> 0 THEN
    
      wk_message := 'ERROR';
      EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:  
            The WFS user already exists.'')';
  
      GOTO bypass_install;
     
    END IF; 
  
    /* ------ DATAREADERROLE Role ----- */
  
    --- Create the DATAREADERROLE
  
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE ROLE DATAREADERROLE NOT IDENTIFIED';
      
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:  
            Unable to create the DATAREADERFOLE.'')';
        GOTO bypass_install; 
        
    END;
  
    BEGIN
    
      EXECUTE IMMEDIATE 'GRANT CONNECT TO DATAREADERROLE';
      
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
            Unable to grant CONNECT to the DATAREADERROLE role.'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
    
      EXECUTE IMMEDIATE 'GRANT CREATE SESSION TO DATAREADERROLE';
      
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to grant SESSION to the DATAREADERROLE.'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
    
      EXECUTE IMMEDIATE 'GRANT SELECT ANY TABLE TO DATAREADERROLE';
      
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to grant SELECT ANY TABLE to the DATAREADERROLE'')';
        GOTO bypass_install;
        
    END;
  
    --- Create the DATAWRITERROLE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE ROLE DATAWRITERROLE NOT IDENTIFIED';
      
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create the DATAWRITERROLE role'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
    
      EXECUTE IMMEDIATE 'GRANT CONNECT TO DATAWRITERROLE';
      
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to grant CONNECT to the DATAWRITERROLE role'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
    
      EXECUTE IMMEDIATE 'GRANT CREATE SESSION TO DATAWRITERROLE';
      
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to grant SESSION to the DATAWRITERROLE role'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
    
      EXECUTE IMMEDIATE 'GRANT DELETE ANY TABLE TO DATAWRITERROLE';
      
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to grant DELETE ANY TABLE to the DATAWRITERROLE role'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
    
      EXECUTE IMMEDIATE 'GRANT INSERT ANY TABLE TO DATAWRITERROLE';
      
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to grant INSERT ANY TABLE to the DATAWRITERROLE role'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
    
      EXECUTE IMMEDIATE 'GRANT UPDATE ANY TABLE TO DATAWRITERROLE';
      
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to grant UPDATE ANY TABLE to the DATAWRITERROLE role'')';
        GOTO bypass_install;
        
      END;
  
    /* ----------- WFS User ----------- */
  
    BEGIN
    
      EXECUTE IMMEDIATE 'create user WFS identified by WFS 
                           default tablespace WFS_data
                           temporary tablespace WFS_temp
                           quota unlimited on WFS_data
                           quota unlimited on WFS_index';
                           
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create user WFS'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
    
          EXECUTE IMMEDIATE 'grant dba,resource, connect, create session to WFS';
          
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to grant dbs, resource, connect, and create session to the WFS user.'')';
        GOTO bypass_install;
        
    END;
  
    /* ---------- WFSDW User ---------- */
  
    BEGIN
    
      EXECUTE IMMEDIATE 'create user WFSDW identified by WFSDW 
                             default tablespace WFS_data
                           temporary tablespace WFS_temp';
                           
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create user WFSDW'')';
        GOTO bypass_install;
        
    END;
    
    BEGIN
    
      EXECUTE IMMEDIATE 'grant DataReaderRole, DataWriterRole to WFSDW';
      
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to grant DataReaderRole and DataWriterRole to the WFSDW user'')';
        GOTO bypass_install;
        
    END;
  
  /*
  -----------------------------------------
   CREATING ALL SEQUENCES 
  -----------------------------------------
  */
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.ALERTS_HIST_ID
                              INCREMENT BY 1
                              START WITH 1
                              NOMAXVALUE
                              NOMINVALUE
                              NOCYCLE
                              CACHE 20
                              ORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.ALERTS_HIST_ID'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_ACTION_SEQ
                              INCREMENT BY 1
                              START WITH 1
                              NOMAXVALUE
                              NOMINVALUE
                              NOCYCLE
                              CACHE 20
                              NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_ACTION_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_BYTEARRAY_SEQ
                              INCREMENT BY 1
                              START WITH 1
                              NOMAXVALUE
                              NOMINVALUE
                              NOCYCLE
                              CACHE 20
                              NOORDER';
  
      EXCEPTION 
        WHEN OTHERS THEN
        
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_BYTEARRAY_SEQ'')';
          GOTO bypass_install;
          
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_COMMENT_SEQ
                              INCREMENT BY 1
                              START WITH 1
                              NOMAXVALUE
                              NOMINVALUE
                              NOCYCLE
                              CACHE 20
                              NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_COMMENT_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_DELEGATION_SEQ
                              INCREMENT BY 1
                              START WITH 1
                              NOMAXVALUE
                              NOMINVALUE
                              NOCYCLE
                              CACHE 20
                              NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_DELEGATION_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_EVENT_SEQ
                              INCREMENT BY 1
                              START WITH 1
                              NOMAXVALUE
                              NOMINVALUE
                              NOCYCLE
                              CACHE 20
                              NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_EVENT_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_EXCEPTIONHANDLER_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_EXCEPTIONHANDLER_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_ID_GROUP_SEQ
                  INCREMENT BY 1
                  START WITH 1
                  NOMAXVALUE
                  NOMINVALUE
                  NOCYCLE
                  CACHE 20
                  NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_ID_GROUP_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_ID_MEMBERSHIP_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_ID_MEMBERSHIP_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_ID_USER_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_ID_USER_SEQ'')';
        GOTO bypass_install;
        
    END;
  
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_LOG_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_LOG_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_MESSAGE_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_MESSAGE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_MODULEDEFINITION_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_MODULEDEFINITION_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_MODULEINSTANCE_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_MODULEINSTANCE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_NODE_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_NODE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_POOLEDACTOR_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_POOLEDACTOR_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_PROCESSDEFINITION_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_PROCESSDEFINITION_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_PROCESSINSTANCE_SEQ
                      INCREMENT BY 1
                      START WITH 3
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_PROCESSINSTANCE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_RUNTIMEACTION_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_RUNTIMEACTION_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_SWIMLANEINSTANCE_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_SWIMLANEINSTANCE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_SWIMLANE_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_SWIMLANE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_TASKCONTROLLER_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_TASKCONTROLLER_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_TASKINSTANCE_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_TASKINSTANCE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_TASK_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_TASK_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_TIMER_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_TIMER_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_TOKENVARIABLEMAP_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_TOKENVARIABLEMAP_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_TOKEN_SEQ
                      INCREMENT BY 1
                      START WITH 3
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_TOKEN_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_TRANSITION_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_TRANSITION_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_VARIABLEACCESS_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_VARIABLEACCESS_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.JBPM_VARIABLEINSTANCE_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.JBPM_VARIABLEINSTANCE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_ACCESSLEVEL_SEQ
                      INCREMENT BY 1
                      START WITH 3
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_ACCESSLEVEL_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_ACTION_SEQ
                      INCREMENT BY 1
                      START WITH 88
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_ACTION_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_BIGROLEPERMISSION_SEQ
                      INCREMENT BY 1
                      START WITH 442
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_BIGROLEPERMISSION_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_CONNECTIONTYPE_SEQ
                      INCREMENT BY 1
                      START WITH 4
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_CONNECTIONTYPE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_DATATYPE_SEQ
                      INCREMENT BY 1
                      START WITH 8
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_DATATYPE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_MENUITEM_SEQ
                      INCREMENT BY 1
                      START WITH 43
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_MENUITEM_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_MESSAGELOG_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_MESSAGELOG_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_MODULE_SEQ
                      INCREMENT BY 1
                      START WITH 9
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_MODULE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_MONITOREDDRIVEHISTORY_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_MONITOREDDRIVEHISTORY_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_MONITOREDDRIVESTATUS_SEQ
                      INCREMENT BY 1
                      START WITH 3
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_MONITOREDDRIVESTATUS_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_MONITOREDDRIVE_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_MONITOREDDRIVE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_PERMISSION_SEQ
                      INCREMENT BY 1
                      START WITH 25
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_PERMISSION_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_PROCESSDEFINITIONTYPE_SEQ
                      INCREMENT BY 1
                      START WITH 4
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_PROCESSDEFINITIONTYPE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_PROCESSINSTANCENOTE_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_PROCESSINSTANCENOTE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_PROCESSINSTANCETYPE_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_PROCESSINSTANCETYPE_SE'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_PROCESSPRIORITY_SEQ
                      INCREMENT BY 1
                      START WITH 5
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_PROCESSPRIORITY_SE'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_PROCESSSTATUS_SEQ
                      INCREMENT BY 1
                      START WITH 8
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_PROCESSSTATUS_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_RESOURCEGROUPQUEUEITEM_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_RESOURCEGROUPQUEUEITEM_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_RESOURCEGROUP_SEQ
                      INCREMENT BY 1
                      START WITH 115
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_RESOURCEGROUP_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_RESOURCESTATUS_SEQ
                      INCREMENT BY 1
                      START WITH 7
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_RESOURCESTATUS_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_RESOURCETYPE_SEQ
                      INCREMENT BY 1
                      START WITH 34
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_RESOURCETYPE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_RESOURCEUSAGEHISTORY_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_RESOURCEUSAGEHISTORY_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_RESOURCE_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_RESOURCE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_STRATEGYCLASSTYPE_SEQ
                      INCREMENT BY 1
                      START WITH 4
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_STRATEGYCLASSTYPE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_STRATEGYCLASS_SEQ
                      INCREMENT BY 1
                      START WITH 10
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_STRATEGYCLASS_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_TOKENTYPE_SEQ
                      INCREMENT BY 1
                      START WITH 1
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_TOKENTYPE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE SEQUENCE WFS.TTV_VARIABLEACCESSTYPE_SEQ
                      INCREMENT BY 1
                      START WITH 3
                      NOMAXVALUE
                      NOMINVALUE
                      NOCYCLE
                      CACHE 20
                      NOORDER';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create sequence to WFS.TTV_VARIABLEACCESSTYPE_SEQ'')';
        GOTO bypass_install;
        
    END;
  
  /*
  -----------------------------------------
   CREATING ALL TABLES AND PRIMARY KEYS
  -----------------------------------------
  */

    -- creating table SYSTEM_SETTINGS
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.SYSTEM_SETTINGS (
          SETTING_TYPE  VARCHAR2(25), 
          SETTING_VALUE VARCHAR2(1024)
          ) 
            TABLESPACE WFS_DATA'; 
    
    EXCEPTION
      WHEN OTHERS THEN
        
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database object:
             Unable to create table SYSTEM_SETTINGS'')';
        GOTO bypass_install;
        
    END;
 
    -- creating table ALERTS
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.ALERTS ( 
          IDENTIFIER  	VARCHAR2(32) NOT NULL,
          ALERT_NAME  	VARCHAR2(64) NOT NULL,
          THRESH_COUNT	NUMBER NULL,
          THRESH_SECS 	NUMBER NULL,
          FREQ_COUNT  	NUMBER NULL,
          FREQ_SECS   	NUMBER NULL,
          TYPE        	VARCHAR2(16) NULL 
          )
                  TABLESPACE WFS_DATA';
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table ALERTS'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on ALERTS
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.ALERTS
          ADD ( CONSTRAINT PK_ALERTS
          PRIMARY KEY (IDENTIFIER)
      NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX)';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for ALERTS'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table ALERTS_HIST
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.ALERTS_HIST ( 
          HIST_KEY  	NUMBER NOT NULL,
          TIME_KEY  	DATE NULL,
          IDENTIFIER	VARCHAR2(32) NOT NULL,
          ALERT_NAME	VARCHAR2(64) NULL,
          ALERT_TYPE	VARCHAR2(64) NULL,
          MSG       	VARCHAR2(1024) NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table ALERTS_HIST'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on ALERTS_HIST
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.ALERTS_HIST
          ADD ( CONSTRAINT PK_ALERTS_HIST
          PRIMARY KEY (HIST_KEY)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for ALERTS_HIST'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table ALERT_ACTIONS
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.ALERT_ACTIONS ( 
          IDENTIFIER 	VARCHAR2(32) NOT NULL,
          ACTION_TYPE	NUMBER NULL,
          DETAIL     	VARCHAR2(64) NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
           Unable to create table ALERT_ACTIONS'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table ALERT_ACTIONS_HIST
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.ALERT_ACTIONS_HIST
                  (
                  HIST_KEY     NUMERIC(19,0)           NOT NULL,
                  ACTION_TYPE  NUMERIC(19,0),
                  DETAIL       VARCHAR2(64)
                  )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table ALERT_ACTIONS_HIST'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table ALERT_NAMES
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.ALERT_NAMES
                  (
                  ALERT_NAME  VARCHAR2(64)                 NOT NULL,
                  PATTERN     VARCHAR2(64)                 NOT NULL
                  )
                  TABLESPACE WFS_DATA';
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table ALERT_NAMES'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on ALERT_NAMES
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.ALERT_NAMES
          ADD ( CONSTRAINT PK_ALERT_NAMES
          PRIMARY KEY (ALERT_NAME)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for ALERT_NAMES'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating BIGROLE table
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.BIGROLE ( 
          BIGROLE    	VARCHAR2(32) NOT NULL,
          DESCRIPTION	VARCHAR2(128) NULL,
          CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
      TABLESPACE WFS_DATA';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create BIGROLE table'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating BIGROLE Primary Key
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.BIGROLE
          ADD ( CONSTRAINT PK_BIGROLE
          PRIMARY KEY (BIGROLE)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create BIGROLE Primary Key'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating BIGROLE_ROLE Table
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.BIGROLE_ROLE ( 
          BIGROLE   	VARCHAR2(32) NOT NULL,
          ROLE      	VARCHAR2(32) NOT NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
      TABLESPACE WFS_DATA';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create BIGROLE_ROLE table'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating BIGROLE_ROLE Primary Key
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.BIGROLE_ROLE
          ADD ( CONSTRAINT PK_BIGROLE_ROLE
          PRIMARY KEY (BIGROLE, ROLE)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create BIGROLE_ROLE Primary Key'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_ACTION
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_ACTION ( 
          ID_                   	NUMBER(19,0) NOT NULL,
          CLASS                 	CHAR(1) NOT NULL,
          NAME_                 	VARCHAR2(255) NULL,
          ISPROPAGATIONALLOWED_ 	NUMBER NULL,
          ACTIONEXPRESSION_     	VARCHAR2(255) NULL,
          ISASYNC_              	NUMBER NULL,
          REFERENCEDACTION_     	NUMBER(19,0) NULL,
          ACTIONDELEGATION_     	NUMBER(19,0) NULL,
          EVENT_                	NUMBER(19,0) NULL,
          PROCESSDEFINITION_    	NUMBER(19,0) NULL,
          TIMERNAME_            	VARCHAR2(255) NULL,
          DUEDATE_              	VARCHAR2(255) NULL,
          REPEAT_               	VARCHAR2(255) NULL,
          TRANSITIONNAME_       	VARCHAR2(255) NULL,
          TIMERACTION_          	NUMBER(19,0) NULL,
          EXPRESSION_           	VARCHAR2(4000) NULL,
          EVENTINDEX_           	NUMBER NULL,
          EXCEPTIONHANDLER_     	NUMBER(19,0) NULL,
          EXCEPTIONHANDLERINDEX_	NUMBER NULL,
          CREATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_ACTION'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_ACTION
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_ACTION
          ADD ( CONSTRAINT PK_JBPM_ACTION
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_ACTION'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_BYTEARRAY
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_BYTEARRAY ( 
          ID_            	NUMBER(19,0) NOT NULL,
          NAME_          	VARCHAR2(255) NULL,
          FILEDEFINITION_	NUMBER(19,0) NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_BYTEARRAY'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_BYTEARRAY
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_BYTEARRAY
          ADD ( CONSTRAINT PK_JBPM_BYTEARRAY
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_BYTEARRAY'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_BYTEBLOCK
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_BYTEBLOCK ( 
          PROCESSFILE_	NUMBER(19,0) NOT NULL,
          BYTES_      	RAW(1024) NULL,
          INDEX_      	NUMBER NOT NULL,
          CREATEDATE  	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE  	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_BYTEBLOCK'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_BYTEBLOCK
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_BYTEBLOCK
          ADD ( CONSTRAINT PK_JBPM_BYTEBLOCK
          PRIMARY KEY (PROCESSFILE_, INDEX_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_BYTEBLOCK'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_COMMENT
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_COMMENT ( 
          ID_               	NUMBER(19,0) NOT NULL,
          VERSION_          	NUMBER NOT NULL,
          ACTORID_          	VARCHAR2(255) NULL,
          TIME_             	TIMESTAMP(6) NULL,
          MESSAGE_          	VARCHAR2(4000) NULL,
          TOKEN_            	NUMBER(19,0) NULL,
          TASKINSTANCE_     	NUMBER(19,0) NULL,
          TOKENINDEX_       	NUMBER NULL,
          TASKINSTANCEINDEX_	NUMBER NULL,
          CREATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_COMMENT'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_COMMENT
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_COMMENT
          ADD ( CONSTRAINT PK_JBPM_COMMENT
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_COMMENT'')';
        GOTO bypass_install;
        
    END;
    
    -- Creating index IDX_JBPM_COMMENT_01
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_COMMENT_01
                            ON WFS.JBPM_COMMENT(TOKEN_)
                            TABLESPACE WFS_INDEX';
                            
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create index IDX_JBPM_COMMENT_01'')';
        GOTO bypass_install;
        
    END;

    -- Creating index IDX_JBPM_COMMENT_02
    BEGIN

      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_COMMENT_02
                           ON WFS.JBPM_COMMENT (TASKINSTANCE_)
                           TABLESPACE WFS_INDEX';

    EXCEPTION
      WHEN OTHERS THEN

        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create index IDX_JBPM_COMMENT_02'')';
        GOTO bypass_install;

    END;
  
    -- creating table JBPM_DECISIONCONDITIONS
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_DECISIONCONDITIONS ( 
          DECISION_      	NUMBER(19,0) NOT NULL,
          TRANSITIONNAME_	VARCHAR2(255) NULL,
          EXPRESSION_    	VARCHAR2(255) NULL,
          INDEX_         	NUMBER NOT NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_DECISIONCONDITIONS'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_DECISIONCONDITIONS
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_DECISIONCONDITIONS
          ADD ( CONSTRAINT PK_JBPM_DECISIONCONDITIONS
          PRIMARY KEY (DECISION_, INDEX_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
      wk_message := 'ERROR';
      EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_DECISIONCONDITIONS'')';
      GOTO bypass_install;
      
    END;
  
    -- creating table JBPM_DELEGATION
    BEGIN
    
    EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_DELEGATION ( 
          ID_               	NUMBER(19,0) NOT NULL,
          CLASSNAME_        	VARCHAR2(4000) NULL,
          CONFIGURATION_    	VARCHAR2(4000) NULL,
          CONFIGTYPE_       	VARCHAR2(255) NULL,
          PROCESSDEFINITION_	NUMBER(19,0) NULL,
          CREATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_DELEGATION'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_DELEGATION
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_DELEGATION
          ADD ( CONSTRAINT PK_JBPM_DELEGATION
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_DELEGATION'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_EVENT
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_EVENT ( 
          ID_               	NUMBER(19,0) NOT NULL,
          EVENTTYPE_        	VARCHAR2(255) NULL,
          TYPE_             	CHAR(1) NULL,
          GRAPHELEMENT_     	NUMBER(19,0) NULL,
          PROCESSDEFINITION_	NUMBER(19,0) NULL,
          NODE_             	NUMBER(19,0) NULL,
          TRANSITION_       	NUMBER(19,0) NULL,
          TASK_             	NUMBER(19,0) NULL,
          CREATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_EVENT'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_EVENT
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_EVENT
          ADD ( CONSTRAINT PK_JBPM_EVENT
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_EVENT'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_EXCEPTIONHANDLER
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_EXCEPTIONHANDLER ( 
          ID_                	NUMBER(19,0) NOT NULL,
          EXCEPTIONCLASSNAME_	VARCHAR2(4000) NULL,
          TYPE_              	CHAR(1) NULL,
          GRAPHELEMENT_      	NUMBER(19,0) NULL,
          PROCESSDEFINITION_ 	NUMBER(19,0) NULL,
          GRAPHELEMENTINDEX_ 	NUMBER NULL,
          NODE_              	NUMBER(19,0) NULL,
          TRANSITION_        	NUMBER(19,0) NULL,
          TASK_              	NUMBER(19,0) NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_EXCEPTIONHANDLER'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_EXCEPTIONHANDLER
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_EXCEPTIONHANDLER
          ADD ( CONSTRAINT PK_JBPM_EXCEPTIONHANDLER
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_EXCEPTIONHANDLER'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_ID_GROUP
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_ID_GROUP ( 
          ID_       	NUMBER(19,0) NOT NULL,
          CLASS_    	CHAR(1) NOT NULL,
          NAME_     	VARCHAR2(255) NULL,
          TYPE_     	VARCHAR2(255) NULL,
          PARENT_   	NUMBER(19,0) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_ID_GROUP'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_ID_GROUP
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_ID_GROUP
          ADD ( CONSTRAINT PK_JBPM_ID_GROUP
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_ID_GROUP'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_ID_MEMBERSHIP
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_ID_MEMBERSHIP ( 
          ID_       	NUMBER(19,0) NOT NULL,
          CLASS_    	CHAR(1) NOT NULL,
          NAME_     	VARCHAR2(255) NULL,
          ROLE_     	VARCHAR2(255) NULL,
          USER_     	NUMBER(19,0) NULL,
          GROUP_    	NUMBER(19,0) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_ID_MEMBERSHIP'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_ID_MEMBERSHIP
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_ID_MEMBERSHIP
          ADD ( CONSTRAINT PK_JBPM_ID_MEMBERSHIP
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_ID_MEMBERSHIP'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_ID_PERMISSIONS
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_ID_PERMISSIONS ( 
          ENTITY_   	NUMBER(19,0) NOT NULL,
          CLASS_    	VARCHAR2(255) NULL,
          NAME_     	VARCHAR2(255) NULL,
          ACTION_   	VARCHAR2(255) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_ID_PERMISSIONS'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_ID_USER
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_ID_USER ( 
          ID_       	NUMBER(19,0) NOT NULL,
          CLASS_    	CHAR(1) NOT NULL,
          NAME_     	VARCHAR2(255) NULL,
          EMAIL_    	VARCHAR2(255) NULL,
          PASSWORD_ 	VARCHAR2(255) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
  
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_ID_USER'')';
        GOTO bypass_install;
         
    END;
  
    -- Creating Primary Key on JBPM_ID_USER
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_ID_USER
          ADD ( CONSTRAINT PK_JBPM_ID_USER
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_ID_USER'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_LOG
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_LOG ( 
          ID_                   	NUMBER(19,0) NOT NULL,
          CLASS_                	CHAR(1) NOT NULL,
          INDEX_                	NUMBER NULL,
          DATE_                 	TIMESTAMP(6) NULL,
          TOKEN_                	NUMBER(19,0) NULL,
          PARENT_               	NUMBER(19,0) NULL,
          MESSAGE_              	VARCHAR2(4000) NULL,
          EXCEPTION_            	VARCHAR2(4000) NULL,
          ACTION_               	NUMBER(19,0) NULL,
          NODE_                 	NUMBER(19,0) NULL,
          ENTER_                	TIMESTAMP(6) NULL,
          LEAVE_                	TIMESTAMP(6) NULL,
          DURATION_             	NUMBER(19,0) NULL,
          TRANSITION_           	NUMBER(19,0) NULL,
          CHILD_                	NUMBER(19,0) NULL,
          SOURCENODE_           	NUMBER(19,0) NULL,
          DESTINATIONNODE_      	NUMBER(19,0) NULL,
          VARIABLEINSTANCE_     	NUMBER(19,0) NULL,
          OLDBYTEARRAY_         	NUMBER(19,0) NULL,
          NEWBYTEARRAY_         	NUMBER(19,0) NULL,
          OLDDATEVALUE_         	TIMESTAMP(6) NULL,
          NEWDATEVALUE_         	TIMESTAMP(6) NULL,
          OLDDOUBLEVALUE_       	FLOAT NULL,
          NEWDOUBLEVALUE_       	FLOAT NULL,
          OLDLONGIDCLASS_       	VARCHAR2(255) NULL,
          OLDLONGIDVALUE_       	NUMBER(19,0) NULL,
          NEWLONGIDCLASS_       	VARCHAR2(255) NULL,
          NEWLONGIDVALUE_       	NUMBER(19,0) NULL,
          OLDSTRINGIDCLASS_     	VARCHAR2(255) NULL,
          OLDSTRINGIDVALUE_     	VARCHAR2(255) NULL,
          NEWSTRINGIDCLASS_     	VARCHAR2(255) NULL,
          NEWSTRINGIDVALUE_     	VARCHAR2(255) NULL,
          OLDLONGVALUE_         	NUMBER(19,0) NULL,
          NEWLONGVALUE_         	NUMBER(19,0) NULL,
          OLDSTRINGVALUE_       	VARCHAR2(4000) NULL,
          NEWSTRINGVALUE_       	VARCHAR2(4000) NULL,
          TASKINSTANCE_         	NUMBER(19,0) NULL,
          TASKACTORID_          	VARCHAR2(255) NULL,
          TASKOLDACTORID_       	VARCHAR2(255) NULL,
          SWIMLANEINSTANCE_     	NUMBER(19,0) NULL,
          CREATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          RESOURCEGROUPID       	NUMBER NULL,
          RESOURCEID            	NUMBER NULL,
          OPERATIONALSTATUSID   	NUMBER NULL,
          ADMINISTRATIVESTATUSID	NUMBER NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_LOG'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_LOG
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_LOG
          ADD ( CONSTRAINT PK_JBPM_LOG
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_LOG'')';
        GOTO bypass_install;
        
    END;

    -- Create index IDX_JBPM_LOG_01
    BEGIN

      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_LOG_01 
                           ON WFS.JBPM_LOG (CLASS_, NODE_, TOKEN_)
                           TABLESPACE WFS_INDEX';

    EXCEPTION
      WHEN OTHERS THEN

        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
          (''error in installing of application database objects:
            Unable to create index IDX_JBPM_LOG_01 on JBPM_LOG table'')';
        GOTO bypass_install;

    END;
  
    -- creating table JBPM_MESSAGE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_MESSAGE ( 
          ID_            	NUMBER(19,0) NOT NULL,
          CLASS_         	CHAR(1) NOT NULL,
          DESTINATION_   	VARCHAR2(255) NULL,
          EXCEPTION_     	VARCHAR2(255) NULL,
          ISSUSPENDED_   	NUMBER NULL,
          TOKEN_         	NUMBER(19,0) NULL,
          TEXT_          	VARCHAR2(255) NULL,
          ACTION_        	NUMBER(19,0) NULL,
          NODE_          	NUMBER(19,0) NULL,
          TRANSITIONNAME_	VARCHAR2(255) NULL,
          TASKINSTANCE_  	NUMBER(19,0) NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_MESSAGE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_MESSAGE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_MESSAGE
          ADD ( CONSTRAINT PK_JBPM_MESSAGE
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_MESSAGE'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_MODULEDEFINITION
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_MODULEDEFINITION ( 
          ID_               	NUMBER(19,0) NOT NULL,
          CLASS_            	CHAR(1) NOT NULL,
          NAME_             	VARCHAR2(4000) NULL,
          PROCESSDEFINITION_	NUMBER(19,0) NULL,
          STARTTASK_        	NUMBER(19,0) NULL,
          CREATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_MODULEDEFINITION'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_MODULEDEFINITION
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_MODULEDEFINITION
          ADD ( CONSTRAINT PK_JBPM_MODULEDEFINITION
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
      wk_message := 'ERROR';
      EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_MODULEDEFINITION'')';
      GOTO bypass_install;
      
    END;
  
    -- creating table JBPM_MODULEINSTANCE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_MODULEINSTANCE ( 
          ID_                	NUMBER(19,0) NOT NULL,
          CLASS_             	CHAR(1) NOT NULL,
          PROCESSINSTANCE_   	NUMBER(19,0) NULL,
          TASKMGMTDEFINITION_	NUMBER(19,0) NULL,
          NAME_              	VARCHAR2(255) NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_MODULEINSTANCE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_MODULEINSTANCE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_MODULEINSTANCE
          ADD ( CONSTRAINT PK_JBPM_MODULEINSTANCE
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_MODULEINSTANCE'')';
        GOTO bypass_install;
        
    END;
    
    -- Creating index IDX_JBPM_MODULEINSTANCE_01
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_MODULEINSTANCE_01
                            ON WFS.JBPM_MODULEINSTANCE(PROCESSINSTANCE_)
                            TABLESPACE WFS_INDEX';
                            
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create index IDX_JBPM_MODULEINSTANCE_01'')';
        GOTO bypass_install;
        
    END;
    
    -- creating table JBPM_NODE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_NODE ( 
          ID_                  	NUMBER(19,0) NOT NULL,
          CLASS_               	CHAR(1) NOT NULL,
          NAME_                	VARCHAR2(255) NULL,
          PROCESSDEFINITION_   	NUMBER(19,0) NULL,
          ISASYNC_             	NUMBER NULL,
          ACTION_              	NUMBER(19,0) NULL,
          SUPERSTATE_          	NUMBER(19,0) NULL,
          SUBPROCESSDEFINITION_	NUMBER(19,0) NULL,
          DECISIONEXPRESSION_  	VARCHAR2(255) NULL,
          DECISIONDELEGATION   	NUMBER(19,0) NULL,
          SIGNAL_              	NUMBER NULL,
          CREATETASKS_         	NUMBER NULL,
          ENDTASKS_            	NUMBER NULL,
          NODECOLLECTIONINDEX_ 	NUMBER NULL,
          RESOURCEGROUPID      	NUMBER NULL,
          DURATION             	VARCHAR2(500) NULL,
          CREATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          DURATIONDESCRIPTION  	VARCHAR2(500) NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_NODE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_NODE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_NODE
          ADD ( CONSTRAINT PK_JBPM_NODE
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_NODE'')';
        GOTO bypass_install;
        
    END;
    
    -- Creating Index IDX_JBPM_NODE_01
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_NODE_01
                            ON WFS.JBPM_NODE(PROCESSDEFINITION_)
                            TABLESPACE WFS_INDEX';
                            
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create index IDX_JBPM_NODE_01'')';
        GOTO bypass_install;
        
    END;
    
    -- creating table JBPM_POOLEDACTOR
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_POOLEDACTOR ( 
          ID_              	NUMBER(19,0) NOT NULL,
          ACTORID_         	VARCHAR2(255) NULL,
          SWIMLANEINSTANCE_	NUMBER(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_POOLEDACTOR'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_POOLEDACTOR
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_POOLEDACTOR
          ADD ( CONSTRAINT PK_JBPM_POOLEDACTOR
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_POOLEDACTOR'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating index IX_JBPM_POOLEDACTOR_1
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_PLDACTR_ACTID
          ON WFS.JBPM_POOLEDACTOR(ACTORID_)
                                  tablespace WFS_INDEX';
                                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create index IX_JBPM_POOLEDACTOR_1'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_PROCESSDEFINITION
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_PROCESSDEFINITION ( 
          ID_                    	NUMBER(19,0) NOT NULL,
          NAME_                  	VARCHAR2(255) NULL,
          VERSION_               	NUMBER NULL,
          ISTERMINATIONIMPLICIT_ 	NUMBER NULL,
          STARTSTATE_            	NUMBER(19,0) NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          PROCESSDEFINITIONTYPEID	NUMBER DEFAULT (1) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_PROCESSDEFINITION'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_PROCESSDEFINITION
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_PROCESSDEFINITION
          ADD ( CONSTRAINT PK_JBPM_PROCESSDEFINITION
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
      wk_message := 'ERROR';
      EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_PROCESSDEFINITION'')';
      GOTO bypass_install;
      
    END;

    -- Creating index IDX_JBPM_PROCESSDEFINITION_01
    BEGIN

      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_PROCESSDEFINITION_01 
                           ON WFS.JBPM_PROCESSDEFINITION (NAME_)
                           TABLESPACE WFS_INDEX';

    EXCEPTION
      WHEN OTHERS THEN

       wk_message := 'ERROR';
       EXECUTE IMMEDIATE 'INSERT INTO install_table values
          (''error in installing of application database objects:
            Unable to create index IDX_JBPM_PROCESSDEFINITION_01 on JBPM_PROCESSDEFINITION table.'')';
       GOTO bypass_install;

    END;

    -- Create index IDX_JBPM_PROCESSDEFINITION_02
   BEGIN

     EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_PROCESSDEFINITION_02
                          ON WFS.JBPM_PROCESSDEFINITION(PROCESSDEFINITIONTYPEID)
                          TABLESPACE WFS_INDEX';

   EXCEPTION
     WHEN OTHERS THEN

       wk_message := 'ERROR';
       EXECUTE IMMEDIATE 'INSERT INTO install_table values
          (''error in installing of application database objects:
            Unable to create index IDX_JBPM_PROCESSDEFINITION_02 on JPBM_PROCESSDEFINITION table.'')';
       GOTO bypass_install;

   END;
 
    -- creating table JBPM_PROCESSINSTANCE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_PROCESSINSTANCE ( 
          ID_                          	NUMBER(19,0) NOT NULL,
          VERSION_                     	NUMBER NOT NULL,
          START_                       	TIMESTAMP(6) NULL,
          END_                         	TIMESTAMP(6) NULL,
          ISSUSPENDED_                 	NUMBER NULL,
          PROCESSDEFINITION_           	NUMBER(19,0) NULL,
          ROOTTOKEN_                   	NUMBER(19,0) NULL,
          SUPERPROCESSTOKEN_           	NUMBER(19,0) NULL,
          ADMINISTRATIVEPROCESSSTATUSID	NUMBER NOT NULL,
          OPERATIONALPROCESSSTATUSID   	NUMBER NOT NULL,
          PROCESSINSTANCETYPEID        	NUMBER NOT NULL,
          CREATEDATE                   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE                   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          PROCESSPRIORITYID            	NUMBER NULL,
          ISACTIVE                     	NUMBER(1,0) DEFAULT (1) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_PROCESSINSTANCE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_PROCESSINSTANCE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_PROCESSINSTANCE
          ADD ( CONSTRAINT PK_JBPM_PROCESSINSTANCE
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX)';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_PROCESSINSTANCE'')';
        GOTO bypass_install;
        
    END;
    
    -- Creating index IDX_JBPM_PROCESSINSTANCE_01
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_PROCESSINSTANCE_01
                            ON WFS.JBPM_PROCESSINSTANCE(PROCESSDEFINITION_)
                            TABLESPACE WFS_INDEX';
                            
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create index IDX_JBPM_PROCESSINSTANCE_01'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_RUNTIMEACTION
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_RUNTIMEACTION ( 
          ID_                  	NUMBER(19,0) NOT NULL,
          VERSION_             	NUMBER NOT NULL,
          EVENTTYPE_           	VARCHAR2(255) NULL,
          TYPE_                	CHAR(1) NULL,
          GRAPHELEMENT_        	NUMBER(19,0) NULL,
          PROCESSINSTANCE_     	NUMBER(19,0) NULL,
          ACTION_              	NUMBER(19,0) NULL,
          PROCESSINSTANCEINDEX_	NUMBER NULL,
          CREATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_RUNTIMEACTION'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_RUNTIMEACTION
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_RUNTIMEACTION
          ADD ( CONSTRAINT PK_JBPM_RUNTIMEACTION
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_RUNTIMEACTION'')';
        GOTO bypass_install;
        
    END;
    
    -- Creating index IDX_RUNTIMEACTION_01
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_RUNTIMEACTION_01
                            ON WFS.JBPM_RUNTIMEACTION(PROCESSINSTANCE_)
                            TABLESPACE WFS_INDEX';
                            
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create index IDX_RUNTIMEACTION_01'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_SWIMLANE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_SWIMLANE ( 
          ID_                    	NUMBER(19,0) NOT NULL,
          NAME_                  	VARCHAR2(255) NULL,
          ACTORIDEXPRESSION_     	VARCHAR2(255) NULL,
          POOLEDACTORSEXPRESSION_	VARCHAR2(255) NULL,
          ASSIGNMENTDELEGATION_  	NUMBER(19,0) NULL,
          TASKMGMTDEFINITION_    	NUMBER(19,0) NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_SWIMLANE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_SWIMLANE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_SWIMLANE
          ADD ( CONSTRAINT PK_JBPM_SWIMLANE
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_SWIMLANE'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_SWIMLANEINSTANCE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_SWIMLANEINSTANCE ( 
          ID_              	NUMBER(19,0) NOT NULL,
          NAME_            	VARCHAR2(255) NULL,
          ACTORID_         	VARCHAR2(255) NULL,
          SWIMLANE_        	NUMBER(19,0) NULL,
          TASKMGMTINSTANCE_	NUMBER(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_SWIMLANEINSTANCE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_SWIMLANEINSTANCE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_SWIMLANEINSTANCE
          ADD ( CONSTRAINT PK_JBPM_SWIMLANEINSTANCE
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX)';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_SWIMLANEINSTANCE'')';
        GOTO bypass_install;
        
    END;
    
    -- Creating Index IDX_JBPM_SWIMLANEINSTANCE_01
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_SWIMLANEINSTANCE_01
                            ON WFS.JBPM_SWIMLANEINSTANCE(TASKMGMTINSTANCE_)
                            TABLESPACE WFS_INDEX';
                            
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create index IDX_JBPM_SWIMLANEINSTANCE_01'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_TASK
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_TASK ( 
          ID_                    	NUMBER(19,0) NOT NULL,
          NAME_                  	VARCHAR2(255) NULL,
          PROCESSDEFINITION_     	NUMBER(19,0) NULL,
          DESCRIPTION_           	VARCHAR2(4000) NULL,
          ISBLOCKING_            	NUMBER NULL,
          ISSIGNALLING_          	NUMBER NULL,
          DUEDATE_               	VARCHAR2(255) NULL,
          ACTORIDEXPRESSION_     	VARCHAR2(255) NULL,
          POOLEDACTORSEXPRESSION_	VARCHAR2(255) NULL,
          TASKMGMTDEFINITION_    	NUMBER(19,0) NULL,
          TASKNODE_              	NUMBER(19,0) NULL,
          STARTSTATE_            	NUMBER(19,0) NULL,
          ASSIGNMENTDELEGATION_  	NUMBER(19,0) NULL,
          SWIMLANE_              	NUMBER(19,0) NULL,
          TASKCONTROLLER_        	NUMBER(19,0) NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_TASK'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_TASK
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_TASK
          ADD ( CONSTRAINT PK_JBPM_TASK
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_TASK'')';
        GOTO bypass_install;
        
    END;
    
    -- Creating index IDX_JBPM_TASK_01
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_TASK_01
                            ON WFS.JBPM_TASK(TASKNODE_)
                            TABLESPACE WFS_INDEX';
                          
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERRROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create index IDX_JBPM_TASK_01'')';
        GOTO bypass_install;
        
    END;
    
    -- Creating index IDX_JBPM_TASK_02
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_TASK_02
                            ON WFS.JBPM_TASK(STARTSTATE_)
                            TABLESPACE WFS_INDEX';
                            
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create index IDX_JBPM_TASK_02'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_TASKACTORPOOL
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_TASKACTORPOOL ( 
          TASKINSTANCE_	NUMBER(19,0) NOT NULL,
          POOLEDACTOR_ 	NUMBER(19,0) NOT NULL,
          CREATEDATE   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_TASKACTORPOOL'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_TASKACTORPOOL
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_TASKACTORPOOL
          ADD ( CONSTRAINT PK_JBPM_TASKACTORPOOL
          PRIMARY KEY (TASKINSTANCE_, POOLEDACTOR_)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_TASKACTORPOOL'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_TASKCONTROLLER
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_TASKCONTROLLER ( 
          ID_                      	NUMBER(19,0) NOT NULL,
          TASKCONTROLLERDELEGATION_	NUMBER(19,0) NULL,
          CREATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_TASKCONTROLLER'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_TASKCONTROLLER
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_TASKCONTROLLER
          ADD ( CONSTRAINT PK_JBPM_TASKCONTROLLER
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_TASKCONTROLLER'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_TASKINSTANCE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_TASKINSTANCE ( 
          ID_              	NUMBER(19,0) NOT NULL,
          CLASS_           	CHAR(1) NOT NULL,
          NAME_            	VARCHAR2(255) NULL,
          DESCRIPTION_     	VARCHAR2(4000) NULL,
          ACTORID_         	VARCHAR2(255) NULL,
          CREATE_          	TIMESTAMP(6) NULL,
          START_           	TIMESTAMP(6) NULL,
          END_             	TIMESTAMP(6) NULL,
          DUEDATE_         	TIMESTAMP(6) NULL,
          PRIORITY_        	NUMBER NULL,
          ISCANCELLED_     	NUMBER NULL,
          ISSUSPENDED_     	NUMBER NULL,
          ISOPEN_          	NUMBER NULL,
          ISSIGNALLING_    	NUMBER NULL,
          ISBLOCKING_      	NUMBER NULL,
          TASK_            	NUMBER(19,0) NULL,
          TOKEN_           	NUMBER(19,0) NULL,
          SWIMLANINSTANCE_ 	NUMBER(19,0) NULL,
          TASKMGMTINSTANCE_	NUMBER(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_TASKINSTANCE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_TASKINSTANCE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_TASKINSTANCE
          ADD ( CONSTRAINT PK_JBPM_TASKINSTANCE
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_TASKINSTANCE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating index IX_JBPM_TASKINSTANCE_1
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IX_JBPM_TASKINSTANCE_1
          ON WFS.JBPM_TASKINSTANCE(ACTORID_)
      tablespace WFS_INDEX';
      
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create index IX_JBPM_TASKINSTANCE_1'')';
        GOTO bypass_install;
        
    END;
    
    -- Creating index IDX_JBPM_TASKINSTANCE_02
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_TASKINSTANCE_02
                            ON WFS.JBPM_TASKINSTANCE(TASKMGMTINSTANCE_)
                            TABLESPACE WFS_INDEX';
                            
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create index IDX_JBPM_TASKINSTANCE_02'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_TIMER
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_TIMER ( 
          ID_              	NUMBER(19,0) NOT NULL,
          NAME_            	VARCHAR2(255) NULL,
          DUEDATE_         	TIMESTAMP(6) NULL,
          REPEAT_          	VARCHAR2(255) NULL,
          TRANSITIONNAME_  	VARCHAR2(255) NULL,
          EXCEPTION_       	VARCHAR2(4000) NULL,
          ISSUSPENDED_     	NUMBER NULL,
          ACTION_          	NUMBER(19,0) NULL,
          TOKEN_           	NUMBER(19,0) NULL,
          PROCESSINSTANCE_ 	NUMBER(19,0) NULL,
          TASKINSTANCE_    	NUMBER(19,0) NULL,
          GRAPHELEMENTTYPE_	VARCHAR2(255) NULL,
          GRAPHELEMENT_    	NUMBER(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_TIMER'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_TIMER
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_TIMER
          ADD ( CONSTRAINT PK_JBPM_TIMER
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_TIMER'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_TOKEN
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_TOKEN ( 
          ID_                      	NUMBER(19,0) NOT NULL,
          VERSION_                 	NUMBER NOT NULL,
          NAME_                    	VARCHAR2(255) NULL,
          START_                   	TIMESTAMP(6) NULL,
          END_                     	TIMESTAMP(6) NULL,
          NODEENTER_               	TIMESTAMP(6) NULL,
          NEXTLOGINDEX_            	NUMBER NULL,
          ISABLETOREACTIVATEPARENT_	NUMBER NULL,
          ISTERMINATIONIMPLICIT_   	NUMBER NULL,
          ISSUSPENDED_             	NUMBER NULL,
          NODE_                    	NUMBER(19,0) NULL,
          PROCESSINSTANCE_         	NUMBER(19,0) NULL,
          PARENT_                  	NUMBER(19,0) NULL,
          SUBPROCESSINSTANCE_      	NUMBER(19,0) NULL,
          TOKENTYPEID              	NUMBER NOT NULL,
          OPERATIONALSTATUS      	NUMBER(19,0) NULL,
           ADMINISTRATIVESTATUS   	NUMBER(19,0) NULL,
          CREATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_TOKEN'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_TOKEN
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_TOKEN
          ADD ( CONSTRAINT PK_JBPM_TOKEN
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_TOKEN'')';
        GOTO bypass_install;
        
    END;
    
    -- Creating Index IDX_JBPM_TOKEN_01
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_TOKEN_01
                            ON WFS.JBPM_TOKEN(PARENT_)
                            TABLESPACE WFS_INDEX';
                            
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create index IDX_JBPM_TOKEN_01'')';
        GOTO bypass_install;
        
    END;
    
    -- Creating Index IDX_JBPM_TOKEN_02
    BEGIN 
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_TOKEN_02
                            ON WFS.JBPM_TOKEN(NODE_)
                            TABLESPACE WFS_INDEX';
                            
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create index IDX_JBPM_TOKEN_02'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_TOKENVARIABLEMAP
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_TOKENVARIABLEMAP ( 
          ID_             	NUMBER(19,0) NOT NULL,
          TOKEN_          	NUMBER(19,0) NULL,
          CONTEXTINSTANCE_	NUMBER(19,0) NULL,
          CREATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_TOKENVARIABLEMAP'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_TOKENVARIABLEMAP
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_TOKENVARIABLEMAP
          ADD ( CONSTRAINT PK_JBPM_TOKENVARIABLEMAP
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_TOKENVARIABLEMAP'')';
        GOTO bypass_install;
        
    END;
    
    -- Creating index IDX_JBPM_TOKENVARIABLEMAP_01
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_TOKENVARIABLEMAP_01
                            ON WFS.JBPM_TOKENVARIABLEMAP(CONTEXTINSTANCE_)
                            TABLESPACE WFS_INDEX';
                            
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create index IDX_JBPM_TOKENVARIABLEMAP_01'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_TRANSITION
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_TRANSITION ( 
          ID_               	NUMBER(19,0) NOT NULL,
          NAME_             	VARCHAR2(255) NULL,
          PROCESSDEFINITION_	NUMBER(19,0) NULL,
          FROM_             	NUMBER(19,0) NULL,
          TO_               	NUMBER(19,0) NULL,
          FROMINDEX_        	NUMBER NULL,
          TRANSITIONTYPEID		NUMBER DEFAULT(2) NOT NULL, 
          CREATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_TRANSITION'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_TRANSITION
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_TRANSITION
          ADD ( CONSTRAINT PK_JBPM_TRANSITION
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_TRANSITION'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_VARIABLEACCESS
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_VARIABLEACCESS ( 
          ID_                 	NUMBER(19,0) NOT NULL,
          VARIABLENAME_       	VARCHAR2(255) NULL,
          ACCESS_             	VARCHAR2(255) NULL,
          MAPPEDNAME_         	VARCHAR2(255) NULL,
          PROCESSSTATE_       	NUMBER(19,0) NULL,
          TASKCONTROLLER_     	NUMBER(19,0) NULL,
          INDEX_              	NUMBER NULL,
          SCRIPT_             	NUMBER(19,0) NULL,
          DATATYPEID          	NUMBER DEFAULT (2) NOT NULL,
          CREATEDATE          	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE          	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          VARIABLEACCESSTYPEID	NUMBER DEFAULT (2) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_VARIABLEACCESS'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_VARIABLEACCESS
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_VARIABLEACCESS
          ADD ( CONSTRAINT PK_JBPM_VARIABLEACCESS
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX 
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_VARIABLEACCESS'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table JBPM_VARIABLEINSTANCE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.JBPM_VARIABLEINSTANCE ( 
          ID_              	NUMBER(19,0) NOT NULL,
          CLASS_           	CHAR(1) NOT NULL,
          NAME_            	VARCHAR2(255) NULL,
          CONVERTER_       	CHAR(1) NULL,
          TOKEN_           	NUMBER(19,0) NULL,
          TOKENVARIABLEMAP_	NUMBER(19,0) NULL,
          PROCESSINSTANCE_ 	NUMBER(19,0) NULL,
          BYTEARRAYVALUE_  	NUMBER(19,0) NULL,
          DATEVALUE_       	TIMESTAMP(6) NULL,
          DOUBLEVALUE_     	FLOAT NULL,
          LONGIDCLASS_     	VARCHAR2(255) NULL,
          LONGVALUE_       	NUMBER(19,0) NULL,
          STRINGIDCLASS_   	VARCHAR2(255) NULL,
          STRINGVALUE_     	VARCHAR2(1024) NULL,
          TASKINSTANCE_    	NUMBER(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table JBPM_VARIABLEINSTANCE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on JBPM_VARIABLEINSTANCE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_VARIABLEINSTANCE
          ADD ( CONSTRAINT PK_JBPM_VARIABLEINSTANCE
          PRIMARY KEY (ID_)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for JBPM_VARIABLEINSTANCE'')';
        GOTO bypass_install;
        
    END;
    
    -- Create Index IDX_JBPM_VARIABLEINSTANCE_01 on JBPM_VARIABLEINSTANCE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_VARIABLEINSTANCE_01
                           ON WFS.JBPM_VARIABLEINSTANCE (NAME_, STRINGVALUE_)
                           TABLESPACE WFS_INDEX';
                            
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to index IDX_JBPM_VARIABLEINSTANCE_01 on JBPM_VARIABLEINSTANCE'')';
        GOTO bypass_install;
        
    END;
    
    -- Create Index IDX_JBPM_VARIABLEINSTANCE_02 on JBPM_VARIABLEINSTANCE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_VARIABLEINSTANCE_02 
                           ON WFS.JBPM_VARIABLEINSTANCE (PROCESSINSTANCE_, NAME_, STRINGVALUE_, TOKENVARIABLEMAP_, CLASS_)
                            TABLESPACE WFS_INDEX';
                            
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to index IDX_JBPM_VARIABLEINSTANCE_02 on JBPM_VARIABLEINSTANCE'')';
        GOTO bypass_install;
        
    END;
    
    -- Create Index IDX_JBPM_VARIABLEINSTANCE_03 on JBPM_VARIABLEINSTANCE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_VARIABLEINSTANCE_03
                            ON WFS.JBPM_VARIABLEINSTANCE(TASKINSTANCE_)
                            TABLESPACE WFS_INDEX';
                            
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to index IDX_JBPM_VARIABLEINSTANCE_03 on JBPM_VARIABLEINSTANCE'')';
        GOTO bypass_install;
        
    END;
    
    -- Create Index IDX_JBPM_VARIABLEINSTANCE_04 on JBPM_VARIABLEINSTANCE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_JBPM_VARIABLEINSTANCE_04
                            ON WFS.JBPM_VARIABLEINSTANCE(TOKENVARIABLEMAP_)
                            TABLESPACE WFS_INDEX';
                            
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create index IDX_JBPM_VARIABLEINSTANCE_04 on JBPM_VARIABLEINSTANCE'')';
        GOTO bypass_install;
        
    END;
    
    -- Creating Table SYSTEM_RELEASE
    BEGIN
    
      EXECUTE IMMEDIATE 'create table WFS.SYSTEM_RELEASE  
                  (
                  SETTING_TYPE        	VARCHAR(50)  	 	not null,
                  SETTING_VALUE        	VARCHAR(1024)
                  )
          tablespace WFS_data
          nologging
          CACHE';
          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table SYSTEM_RELEASE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on SYSTEM_RELEASE
    BEGIN
    
      EXECUTE IMMEDIATE 'alter table WFS.SYSTEM_RELEASE
                          add constraint PK_SYSTEM_RELEASE primary key (SETTING_TYPE)
                          using index    
                          tablespace WFS_index    
                          nologging';
                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for SYSTEM_RELEASE'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_ACCESSLEVEL
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_ACCESSLEVEL ( 
          ACCESSLEVELID	NUMBER NOT NULL,
          NAME         	VARCHAR2(50) NOT NULL,
          CREATEDATE   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_ACCESSLEVEL'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_ACCESSLEVEL
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_ACCESSLEVEL
          ADD ( CONSTRAINT PK_TTV_ACCESSLEVEL
          PRIMARY KEY (ACCESSLEVELID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_ACCESSLEVEL'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_ACTION
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_ACTION ( 
          ACTIONID    	NUMBER NOT NULL,
          NAME        	VARCHAR2(50) NOT NULL,
          PERMISSIONID	NUMBER NOT NULL,
          PATH        	VARCHAR2(2000) NOT NULL,
          CREATEDATE  	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE  	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_ACTION'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_ACTION
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_ACTION
          ADD ( CONSTRAINT PK_TTV_ACTION
          PRIMARY KEY (ACTIONID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_ACTION'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_BIGROLEPERMISSION
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_BIGROLEPERMISSION ( 
          BIGROLEPERMISSIONID	NUMBER NOT NULL,
          PERMISSIONID       	NUMBER NOT NULL,
          BIGROLE            	VARCHAR2(32) NOT NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_BIGROLEPERMISSION'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_BIGROLEPERMISSION
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_BIGROLEPERMISSION
          ADD ( CONSTRAINT PK_TTV_BIGROLEPERMISSION
          PRIMARY KEY (BIGROLEPERMISSIONID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX 
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_BIGROLEPERMISSION'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_CONNECTIONTYPE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_CONNECTIONTYPE ( 
          CONNECTIONTYPEID	NUMBER NOT NULL,
          NAME            	VARCHAR2(30) NOT NULL,
          CREATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_CONNECTIONTYPE'')';
        GOTO bypass_install;
        
    END;
    
    -- Creating Primary Key on TTV_CONNECTIONTYPE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_CONNECTIONTYPE
          ADD ( CONSTRAINT PK_TTV_CONNECTIONTYPE
          PRIMARY KEY (CONNECTIONTYPEID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_CONNECTIONTYPE'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_DATATYPE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_DATATYPE ( 
          DATATYPEID  	NUMBER NOT NULL,
          DATATYPENAME	VARCHAR2(30) NOT NULL,
          CREATEDATE  	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE  	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_DATATYPE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_DATATYPE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_DATATYPE
          ADD ( CONSTRAINT PK_TTV_DATATYPE
          PRIMARY KEY (DATATYPEID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX 
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_DATATYPE'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_MENUITEM
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_MENUITEM ( 
          MENUITEMID  	NUMBER NOT NULL,
          NAME        	VARCHAR2(50) NOT NULL,
          PERMISSIONID	NUMBER NOT NULL,
          CREATEDATE  	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE  	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_MENUITEM'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_MENUITEM
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_MENUITEM
          ADD ( CONSTRAINT PK_TTV_MENUITEM
          PRIMARY KEY (MENUITEMID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
      wk_message := 'ERROR';
      EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_MENUITEM'')';
      GOTO bypass_install;
      
    END;
  
    -- creating table TTV_MESSAGELOG
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_MESSAGELOG ( 
          MESSAGELOGID   	NUMBER(19,0) NOT NULL,
          LOGID          	NUMBER(19,0) NOT NULL,
          TYPE           	VARCHAR2(16) NOT NULL,
          MESSAGEUID     	VARCHAR2(16) NOT NULL,
          NAME           	VARCHAR2(64) NULL,
          ISINCOMING     	NUMBER(1,0) NOT NULL,
          MESSAGE        	VARCHAR2(4000) NOT NULL,
          RESOURCEID     	NUMBER NULL,
          MESSAGEDATETIME	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_MESSAGELOG'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_MESSAGELOG
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_MESSAGELOG
          ADD ( CONSTRAINT PK_TTV_MESSAGELOG
          PRIMARY KEY (MESSAGELOGID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX 
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_MESSAGELOG'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_MODULE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_MODULE ( 
          MODULEID  	NUMBER NOT NULL,
          NAME      	VARCHAR2(50) NOT NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_MODULE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_MODULE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_MODULE
          ADD ( CONSTRAINT PK_TTV_MODULE
          PRIMARY KEY (MODULEID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX 
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_MODULE'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_MONITOREDDRIVE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_MONITOREDDRIVE (
          MONITOREDDRIVEID       	NUMBER NOT NULL,
          NAME                   	VARCHAR2(500) NOT NULL,
          DESCRIPTION            	VARCHAR2(500) DEFAULT ('''') NOT NULL,
          PATH                   	VARCHAR2(1000) NOT NULL,
          RESOURCEID             	NUMBER NULL,
          INTERNALDRIVEID        	NUMBER NOT NULL,
          TOTALCAPACITY          	NUMBER(19,0) NOT NULL,
          WARNINGTHRESHOLDPERCENT	NUMBER NOT NULL,
          ERRORTHRESHOLDPERCENT  	NUMBER NOT NULL,
          CURRENTBYTESUSED       	NUMBER(19,0) DEFAULT (0) NULL,
          CURRENTDRIVESTATUSID   	NUMBER DEFAULT (0) NOT NULL,
          LASTSAMPLEDATETIME     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_MONITOREDDRIVE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_MONITOREDDRIVE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_MONITOREDDRIVE
          ADD ( CONSTRAINT PK_TTV_MONITOREDDRIVE
          PRIMARY KEY (MONITOREDDRIVEID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX 
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_MONITOREDDRIVE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating index IX_TTV_MONITOREDDRIVE_1
    BEGIN
    
      EXECUTE IMMEDIATE 'create index WFS.IX_TTV_MONITOREDDRIVE_1 ON
                                  WFS.TTV_MONITOREDDRIVE (RESOURCEID,INTERNALDRIVEID)
                                  tablespace WFS_INDEX';
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create index IX_TTV_MONITOREDDRIVE_1'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_MONITOREDDRIVEHISTORY
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_MONITOREDDRIVEHISTORY ( 
          MONITOREDDRIVEHISTORYID	NUMBER(19,0) NOT NULL,
          MONITOREDDRIVEID       	NUMBER NOT NULL,
          CURRENTBYTESUSED       	NUMBER(19,0) NOT NULL,
          TOTALCAPACITY          	NUMBER(19,0) NOT NULL,
          WARNINGTHRESHOLDPERCENT	NUMBER NOT NULL,
          ERRORTHRESHOLDPERCENT  	NUMBER NOT NULL,
          CURRENTDRIVESTATUSID   	NUMBER NOT NULL,
          SAMPLEDATETIME         	TIMESTAMP(6) NOT NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_MONITOREDDRIVEHISTORY'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_MONITOREDDRIVEHISTORY
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_MONITOREDDRIVEHISTORY
          ADD ( CONSTRAINT PK_TTV_MONITOREDDRIVEHISTORY
          PRIMARY KEY (MONITOREDDRIVEHISTORYID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_MONITOREDDRIVEHISTORY'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_MONITOREDDRIVESTATUS
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_MONITOREDDRIVESTATUS ( 
          MONITOREDDRIVESTATUSID	NUMBER NOT NULL,
          NAME                  	VARCHAR2(50) NOT NULL,
          CREATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_MONITOREDDRIVESTATUS'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_MONITOREDDRIVESTATUS
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_MONITOREDDRIVESTATUS
          ADD ( CONSTRAINT PK_TTV_MONITOREDDRIVESTATUS
          PRIMARY KEY (MONITOREDDRIVESTATUSID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX 
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_MONITOREDDRIVESTATUS'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_PERMISSION
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_PERMISSION ( 
          PERMISSIONID	NUMBER NOT NULL,
          NAME        	VARCHAR2(50) NOT NULL,
          SECTIONNAME 	VARCHAR2(50) NULL,
          MODULEID    	NUMBER NOT NULL,
          CREATEDATE  	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE  	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_PERMISSION'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_PERMISSION
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_PERMISSION
          ADD ( CONSTRAINT PK_TTV_PERMISSION
          PRIMARY KEY (PERMISSIONID)
          NOT DEFERRABLE INITIALLY IMMEDIATE
      USING INDEX 
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_PERMISSION'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_PROCDEFACCESSLEVEL
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_PROCDEFACCESSLEVEL ( 
          PROCESSDEFINITIONID	NUMBER(19,0) NOT NULL,
          ACCESSLEVELID      	NUMBER NOT NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_PROCDEFACCESSLEVEL'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_PROCDEFACCESSLEVEL
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_PROCDEFACCESSLEVEL
          ADD ( CONSTRAINT PK_TTV_PROCDEFACCESSLEVEL
          PRIMARY KEY (PROCESSDEFINITIONID, ACCESSLEVELID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_PROCDEFACCESSLEVEL'')';
        GOTO bypass_install;
        
    END;
   
    -- creating table TTV_PROCESSDEFINITIONTYPE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_PROCESSDEFINITIONTYPE ( 
          PROCESSDEFINITIONTYPEID	NUMBER NOT NULL,
          NAME                   	VARCHAR2(50) NOT NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_PROCESSDEFINITIONTYPE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_PROCESSDEFINITIONTYPE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_PROCESSDEFINITIONTYPE
          ADD ( CONSTRAINT PK_TTV_PROCESSDEFINITIONTYPE
          PRIMARY KEY (PROCESSDEFINITIONTYPEID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_PROCESSDEFINITIONTYPE'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_PROCESSINSTANCENOTE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_PROCESSINSTANCENOTE ( 
          PROCESSINSTANCENOTEID	NUMBER NOT NULL,
          PROCESSINSTANCEID    	NUMBER NOT NULL,
          NOTE                 	VARCHAR2(4000) NOT NULL,
          CREATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_PROCESSINSTANCENOTE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_PROCESSINSTANCENOTE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_PROCESSINSTANCENOTE
          ADD ( CONSTRAINT PK_TTV_PROCESSINSTANCENOTE
          PRIMARY KEY (PROCESSINSTANCENOTEID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_PROCESSINSTANCENOTE'')';
        GOTO bypass_install;
        
    END;
    
    -- Creating Index IDX_TTV_PROCESSINSTANCENOTE_01
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE INDEX WFS.IDX_TTV_PROCESSINSTANCENOTE_01
                            ON WFS.TTV_PROCESSINSTANCENOTE(PROCESSINSTANCEID)
                            TABLESPACE WFS_INDEX';
  
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create index IDX_TTV_PROCESSINSTANCENOTE_01'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_PROCESSINSTANCETYPE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_PROCESSINSTANCETYPE ( 
          PROCESSINSTANCETYPEID	NUMBER NOT NULL,
          NAME                 	VARCHAR2(50) NOT NULL,
          CREATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_PROCESSINSTANCETYPE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_PROCESSINSTANCETYPE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_PROCESSINSTANCETYPE
          ADD ( CONSTRAINT PK_TTV_PROCESSINSTANCETYPE
          PRIMARY KEY (PROCESSINSTANCETYPEID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_PROCESSINSTANCETYPE'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_PROCESSPRIORITY
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_PROCESSPRIORITY ( 
          PROCESSPRIORITYID	NUMBER NOT NULL,
          NAME             	VARCHAR2(50) NOT NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_PROCESSPRIORITY'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_PROCESSPRIORITY
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_PROCESSPRIORITY
          ADD ( CONSTRAINT PK_TTV_PROCESSPRIORITY
          PRIMARY KEY (PROCESSPRIORITYID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_PROCESSPRIORITY'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_PROCESSSTATUS
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_PROCESSSTATUS ( 
          PROCESSSTATUSID	NUMBER NOT NULL,
          NAME           	VARCHAR2(50) NOT NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_PROCESSSTATUS'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_PROCESSSTATUS
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_PROCESSSTATUS
          ADD ( CONSTRAINT PK_TTV_PROCESSSTATUS
          PRIMARY KEY (PROCESSSTATUSID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX 
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_PROCESSSTATUS'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_RESOURCE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_RESOURCE ( 
          RESOURCEID                    	NUMBER NOT NULL,
          NAME                          	VARCHAR2(50) NOT NULL,
          CONNECTIONSTRING              	VARCHAR2(255) NOT NULL,
          RESOURCETYPEID                	NUMBER NOT NULL,
          MAXCONCURRENTUSERS            	NUMBER NOT NULL,
          ADMINISTRATIVERESOURCESTATUSID	NUMBER NOT NULL,
          OPERATIONALRESOURCESTATUSID   	NUMBER NOT NULL,
          HEARTBEATCONNECTIONSTRING     	VARCHAR2(255) NULL,
          HEARTBEATFREQUENCY            	NUMBER NULL,
          ISACTIVE                      	NUMBER(1,0) NOT NULL,
          FUNCTIONALTYPE 			VARCHAR2(1024) NULL,
          CREATEDATE                    	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE                    	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          USER_NAME                     	VARCHAR2(96) NULL 
          )
                  TABLESPACE WFS_DATA';
          
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_RESOURCE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_RESOURCE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_RESOURCE
          ADD ( CONSTRAINT PK_TTV_RESOURCE
          PRIMARY KEY (RESOURCEID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_RESOURCE'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_RESOURCEGROUP
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_RESOURCEGROUP ( 
          RESOURCEGROUPID          	NUMBER NOT NULL,
          NAME                     	VARCHAR2(50) NOT NULL,
          RESOURCETYPEID           	NUMBER NOT NULL,
          ISINTERNALLYACQUIRED     	NUMBER(1,0) NOT NULL,
          ALLOCATIONSTRATEGYCLASSID	NUMBER NULL,
          ACCESSLEVELID            	NUMBER DEFAULT (0) NOT NULL, 
          FUNCTIONALTYPE 		        VARCHAR2(1024)  NULL,
          ISVISIBLE      		        NUMBER(1) DEFAULT(0) NOT NULL,  
          IMAGEPATH      		        VARCHAR2(4000)  NULL,
          CREATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_RESOURCEGROUP'')';
        GOTO bypass_install;
        
    END;
   
    -- Creating Primary Key on TTV_RESOURCEGROUP
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_RESOURCEGROUP
          ADD ( CONSTRAINT PK_TTV_RESOURCEGROUP
          PRIMARY KEY (RESOURCEGROUPID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX 
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_RESOURCEGROUP'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_RESOURCEGROUPMEMBERSHIP
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_RESOURCEGROUPMEMBERSHIP ( 
          RESOURCEID     	NUMBER NOT NULL,
          RESOURCEGROUPID	NUMBER NOT NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_RESOURCEGROUPMEMBERSHIP'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_RESOURCEGROUP
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_RESOURCEGROUPMEMBERSHIP
          ADD ( CONSTRAINT PK_TTV_RESOURCEGROUPMEMBERSHIP
          PRIMARY KEY (RESOURCEID, RESOURCEGROUPID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
  
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_RESOURCEGROUPMEMBERSHIP'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_RESOURCEGROUPQUEUEITEM
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_RESOURCEGROUPQUEUEITEM ( 
          RESOURCEGROUPQUEUEITEMID	NUMBER NOT NULL,
          RESOURCEGROUPID         	NUMBER NOT NULL,
          QUEUEORDER              	NUMBER NOT NULL,
          TOKENID                 	NUMBER(19,0) NOT NULL,
          CREATEDATE              	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE              	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA'
                  ;
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_RESOURCEGROUPQUEUEITEM'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_RESOURCEGROUPQUEUEITEM
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_RESOURCEGROUPQUEUEITEM
          ADD ( CONSTRAINT PK_TTV_RESOURCEGROUPQUEUEITEM
          PRIMARY KEY (RESOURCEGROUPQUEUEITEMID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_RESOURCEGROUPQUEUEITEM'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_RESOURCESTATUS
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_RESOURCESTATUS ( 
          RESOURCESTATUSID	NUMBER NOT NULL,
          NAME            	VARCHAR2(50) NOT NULL,
          CREATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_RESOURCESTATUS'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_RESOURCESTATUS
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_RESOURCESTATUS
          ADD ( CONSTRAINT PK_TTV_RESOURCESTATUS
          PRIMARY KEY (RESOURCESTATUSID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_RESOURCESTATUS'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_RESOURCETYPE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_RESOURCETYPE ( 
          RESOURCETYPEID               	NUMBER NOT NULL,
          NAME                         	VARCHAR2(50) NOT NULL,
          RESOURCECONNECTIONTYPEID     	NUMBER NOT NULL,
          INITIALIZATIONSTRATEGYCLASSID	NUMBER NULL,
          HEARTBEATSTRATEGYCLASSID     	NUMBER NULL,
          HEARTBEATCONNECTIONTYPEID    	NUMBER NULL,
          SYSTEMID       			VARCHAR2(4000)  NULL,
          CREATEDATE                   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE                   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_RESOURCETYPE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_RESOURCETYPE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_RESOURCETYPE
          ADD ( CONSTRAINT PK_TTV_RESOURCETYPE
          PRIMARY KEY (RESOURCETYPEID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_RESOURCETYPE'')';
        GOTO bypass_install;
        
    END;
    
    -- Create Unique index on the SYSTEMID column of the TTV_RESOURCETYPE table.
    
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE UNIQUE INDEX WFS.IDX_TTV_RESOURCETYPE_UK
                            ON WFS.TTV_RESOURCETYPE(SYSTEMID)
                            TABLESPACE WFS_INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 
                            STORAGE( INITIAL 65536 MINEXTENTS 1 MAXEXTENTS 2147483645 )
                            PARALLEL( DEGREE 1 )
                            LOGGING';
                            
    EXCEPTION
      WHEN OTHERS THEN
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects: 
             Unable to create a Unique index on SYSTEMID.TTV_RESOURCETYPE'')';
        GOTO bypass_install;
        
    END;
       
    -- creating table TTV_RESOURCEUSAGEHISTORY
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_RESOURCEUSAGEHISTORY ( 
          RESOURCEUSAGEHISTORYID	NUMBER NOT NULL,
          RESOURCEID            	NUMBER NOT NULL,
          PROCESSINSTANCEID     	NUMBER(19,0) NOT NULL,
          NODEID                	NUMBER(19,0) NOT NULL,
          STARTDATETIME         	TIMESTAMP(6) NOT NULL,
          ENDDATETIME           	TIMESTAMP(6) NOT NULL,
          CREATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          RESOURCEGROUPID       	NUMBER NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects: 
             Unable to create table TTV_RESOURCEUSAGEHISTORY'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_RESOURCEUSAGEHISTORY
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_RESOURCEUSAGEHISTORY
          ADD ( CONSTRAINT PK_TTV_RESOURCEUSAGEHISTORY
          PRIMARY KEY (RESOURCEUSAGEHISTORYID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_RESOURCEUSAGEHISTORY'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_STRATEGYCLASS
    BEGIN
  
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_STRATEGYCLASS ( 
          STRATEGYCLASSID    	NUMBER NOT NULL,
          NAME               	VARCHAR2(50) NOT NULL,
          DESCRIPTION        	VARCHAR2(500) NOT NULL,
          CLASSNAME          	VARCHAR2(4000) NULL,
          STRATEGYCLASSTYPEID	NUMBER NOT NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_STRATEGYCLASS'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_STRATEGYCLASS
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_STRATEGYCLASS
          ADD ( CONSTRAINT PK_TTV_STRATEGYCLASS
          PRIMARY KEY (STRATEGYCLASSID)
          NOT DEFERRABLE INITIALLY IMMEDIATE  
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_STRATEGYCLASS'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_STRATEGYCLASSTYPE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_STRATEGYCLASSTYPE ( 
          STRATEGYCLASSTYPEID	NUMBER NOT NULL,
          NAME               	VARCHAR2(50) NOT NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_STRATEGYCLASSTYPE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_STRATEGYCLASSTYPE
      BEGIN
      
        EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_STRATEGYCLASSTYPE
          ADD ( CONSTRAINT PK_TTV_STRATEGYCLASSTYPE
          PRIMARY KEY (STRATEGYCLASSTYPEID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
       
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_STRATEGYCLASSTYPE'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_TOKENRESOURCE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_TOKENRESOURCE ( 
          TOKENID                   	NUMBER(19,0) NOT NULL,
          RESOURCEID                	NUMBER NOT NULL,
          RESOURCEUSAGESTARTDATETIME	TIMESTAMP(6) NOT NULL,
          CREATEDATE                	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE                	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          RESOURCEGROUPID           	NUMBER NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_TOKENRESOURCE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_TOKENRESOURCE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_TOKENRESOURCE
          ADD ( CONSTRAINT PK_TTV_TOKENRESOURCE
          PRIMARY KEY (TOKENID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_TOKENRESOURCE'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_TOKENTYPE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_TOKENTYPE ( 
          TOKENTYPEID	NUMBER NOT NULL,
          NAME       	VARCHAR2(50) NULL,
          CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
       EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_TOKENTYPE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_TOKENTYPE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_TOKENTYPE
          ADD ( CONSTRAINT PK_TTV_TOKENTYPE
          PRIMARY KEY (TOKENTYPEID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_TOKENTYPE'')';
        GOTO bypass_install;
        
    END;
  
    -- creating table TTV_VARIABLEACCESSTYPE
    BEGIN
    
      EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_VARIABLEACCESSTYPE ( 
          VARIABLEACCESSTYPEID	NUMBER NOT NULL,
          NAME                	VARCHAR2(50) NOT NULL,
          CREATEDATE          	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE          	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
                  TABLESPACE WFS_DATA';
                  
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_VARIABLEACCESSTYPE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Primary Key on TTV_VARIABLEACCESSTYPE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_VARIABLEACCESSTYPE
          ADD ( CONSTRAINT PK_TTV_VARIABLEACCESSTYPE
          PRIMARY KEY (VARIABLEACCESSTYPEID)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create Primary Key for TTV_VARIABLEACCESSTYPE'')';
        GOTO bypass_install;
        
    END;
  
  -- Creating table UI_PROPERTIES
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TABLE WFS.UI_PROPERTIES ( 
          NAME      	VARCHAR2(254) NOT NULL,
          VALUE     	VARCHAR2(254) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
      TABLESPACE WFS_DATA';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table UI_PROPERTIES'')';
              GOTO bypass_install;
      END;
  
  -- Creating table USER_REALM
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TABLE WFS.USERS_REALM ( 
          USER_NAME             	VARCHAR2(32) NOT NULL,
          USER_PASS             	VARCHAR2(64) NOT NULL,
          PASSWORD_MODIFIED_DATE	TIMESTAMP(6) NOT NULL,
          STATUS                	NUMBER NOT NULL,
          CREATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
      TABLESPACE WFS_DATA';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table USERS_REALM'')';
              GOTO bypass_install;
      END;
  
  -- Creating Primary Key on USERS_REALM
  
      BEGIN
      
          EXECUTE IMMEDIATE 'ALTER TABLE WFS.USERS_REALM
          ADD ( CONSTRAINT PK_USERS_REALM
          PRIMARY KEY (USER_NAME)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to Primary Key on USERS_REALM'')';
              GOTO bypass_install;
      END;
  
  -- Creating table USER_BIGROLE
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TABLE WFS.USER_BIGROLE ( 
          USER_NAME 	VARCHAR2(32) NOT NULL,
          BIGROLE   	VARCHAR2(32) NOT NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )
      TABLESPACE WFS_DATA';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create USER_BIGROLE table'')';
              GOTO bypass_install;
      END;
  
  -- Create Primary Key for USER_BIGROLE
  
      BEGIN
      
          EXECUTE IMMEDIATE 'ALTER TABLE WFS.USER_BIGROLE
          ADD ( CONSTRAINT PK_USER_BIGROLE
          PRIMARY KEY (USER_NAME, BIGROLE)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create primary key for USER_BIGROLE'')';
              GOTO bypass_install;
      END;
  
  -- Create table USER_DATA
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TABLE WFS.USER_DATA ( 
          USER_NAME 	VARCHAR2(32) NOT NULL,
          FIRSTNAME 	VARCHAR2(20) NULL,
          LASTNAME  	VARCHAR2(20) NULL,
          EMAIL     	VARCHAR2(50) NULL,
          PHONE     	VARCHAR2(20) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          EMPLOYEEID	VARCHAR2(50) NULL,
          DEPARTMENT	VARCHAR2(50) NULL,
          LOCATION  	VARCHAR2(50) NULL,
          EXTENSION 	VARCHAR2(50) NULL 
          )
      TABLESPACE WFS_DATA';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table USER_DATA'')';
              GOTO bypass_install;
      END;
  
  -- Create Primary Key for USER_DATA
  
      BEGIN
  
          EXECUTE IMMEDIATE 'ALTER TABLE WFS.USER_DATA
          ADD ( CONSTRAINT PK_USER_DATA
          PRIMARY KEY (USER_NAME)
          NOT DEFERRABLE INITIALLY IMMEDIATE 
      USING INDEX
      TABLESPACE WFS_INDEX )';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create primary key for USER_DATA'')';
              GOTO bypass_install;
      END;
      
      -- Create table TTV_SELECTOR
  
      BEGIN
      
        EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_SELECTOR ( 
                                SELECTIONKEY		VARCHAR2(4000) 	NOT NULL,
                               PROCESSDEFINITIONID NUMBER(19,0)   	NULL,
                               CREATEDATE          DATE		NOT NULL,
                               UPDATEDATE          DATE   		NOT NULL
                              )
                              TABLESPACE WFS_DATA';
                            
      EXCEPTION
        WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_SELECTOR'')';
          GOTO bypass_install;
          
      END;
      
      -- Create Primary Key for TTV_SELECTOR
      
      BEGIN
      
        EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_SELECTOR
                               ADD ( CONSTRAINT PK_TTV_SELECTOR
                                    PRIMARY KEY (SELECTIONKEY)
                                    NOT DEFERRABLE INITIALLY IMMEDIATE
                                    USING INDEX
                                    TABLESPACE WFS_INDEX )';
                                    
      EXCEPTION
        WHEN OTHERS THEN 
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create primary key for TTV_SELECTOR'')';
          GOTO bypass_install;
          
      END;
      
      -- Create table TTV_TRANSITIONTYPE
      BEGIN
      
        EXECUTE IMMEDIATE 'CREATE TABLE WFS.TTV_TRANSITIONTYPE (
                               TRANSITIONTYPEID    NUMBER NOT NULL,
                               NAME        VARCHAR2(50) NULL,
                               CREATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                               UPDATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL
                              )
                              TABLESPACE WFS_DATA';
                              
      EXCEPTION
        WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create table TTV_TRANSITIONTYPE'')';
          GOTO bypass_install;
          
      END;
      
      -- Create Primary Key for TTV_TRANSITIONTYPE
      BEGIN
      
        EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_TRANSITIONTYPE
                               ADD (CONSTRAINT PK_TTV_TRANSITIONTYPE
                               PRIMARY KEY (TRANSITIONTYPEID)
                               NOT DEFERRABLE INITIALLY IMMEDIATE
                               USING INDEX
                               TABLESPACE WFS_INDEX )';
                               
      EXCEPTION
        WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create primary key on TTV_TRANSITIONTYPE'')';
          
      END;
      
  /*
  -----------------------------------------
   CREATING ALL VIEWS
  -----------------------------------------
  */
  
  -- Create view USER_INFO
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE VIEW WFS.USER_INFO ( USER_NAME, FIRST_NAME, LAST_NAME, EMAIL, PHONE, USER_ROLE )
                              AS
                              SELECT	ud.USER_NAME,
                                      ud.FIRSTNAME,
                                      ud.LASTNAME,
                                      ud.EMAIL,
                                      ud.PHONE,
                                      ubr.BIGROLE
                              FROM 	WFS.USER_DATA ud,
                                      WFS.USER_BIGROLE ubr 
                              WHERE	ud.USER_NAME = ubr.USER_NAME';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create view USER_INFO'')';
              GOTO bypass_install;
      END;
  
  --Creating View USER_ROLE
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE VIEW WFS.USER_ROLE ( USER_NAME, ROLE )
                              AS
                              SELECT	DISTINCT urb.user_name,
                                  brr.role 
                              FROM	WFS.user_bigRole urb,
                                  WFS.bigRole_role brr
                              WHERE	brr.bigRole = urb.bigRole';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create view USER_ROLE'')';
              GOTO bypass_install;
      END;
  
  -- Creating View VDW_NODE
          BEGIN
          EXECUTE IMMEDIATE 'CREATE VIEW WFS.VDW_NODE ( NODEID, NODECLASS, NODENAME, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NODEINDEX, TASKID, TASKNAME, ISSTARTNODE, RESOURCEGROUPID, RESOURCEGROUPNAME, RESOURCETYPEID, RESOURCETYPENAME, TASKCONTROLLERID, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT  n.ID_ NodeId,
                                  DECODE (n.CLASS_,       ''D'', ''DECISION'',
                                                      ''E'', ''END'',
                                                      ''R'', ''START'',
                                                      ''Y'', ''MANUAL'',
                                                      ''Z'', ''AUTOMATED'',
                                                      ''UNKNOWN'') NodeClass,
                                  n.NAME_ NodeName,
                                  n.PROCESSDEFINITION_ ProcessDefinitionId,
                                  d.NAME_ ProcessDefinitionName,
                                  n.NODECOLLECTIONINDEX_ NodeIndex,
                                  t.ID_ TaskId,
                                  t.NAME_ TaskName,
                                  DECODE (NVL (STARTSTATE_, -1), -1, 0, 1) IsStartNode,
                                  n.ResourceGroupId,
                                  NVL (g.Name, ''[N/A]'') ResourceGroupName,
                                  g.ResourceTypeId,
                                  NVL (ty.Name, ''[N/A]'') ResourceTypeName,
                                  TASKCONTROLLER_ TaskControllerId,
                                  d.ProcessDefinitionTypeId,
                                  dt.Name ProcessDefinitionTypeName,
                                  n.CreateDate,
                                  n.UpdateDate
                          FROM    WFS.JBPM_NODE n
                          JOIN    WFS.JBPM_PROCESSDEFINITION d
                          ON (    d.ID_ = n.PROCESSDEFINITION_)
                          JOIN    WFS.TTV_ProcessDefinitionType dt
                          ON (    dt.ProcessDefinitionTypeId = d.ProcessDefinitionTypeId)
                          LEFT JOIN WFS.TTV_ResourceGroup g
                          ON (    g.ResourceGroupId = n.ResourceGroupId)
                          LEFT JOIN WFS.TTV_ResourceType ty
                          ON (    ty.ResourceTypeId = g.ResourceTypeId)
                          LEFT JOIN WFS.JBPM_TASK t
                          ON (    t.TASKNODE_ = n.ID_
                          OR              t.STARTSTATE_ = n.ID_)';
          EXCEPTION
             WHEN OTHERS THEN
             wk_message := 'ERROR';
             EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create view VDW_NODE'')';
             GOTO bypass_install;
          END;
  
  -- Creating View VDW_PROCESSINSTANCE
          BEGIN
          EXECUTE IMMEDIATE 'CREATE VIEW WFS.VDW_PROCESSINSTANCE ( PROCESSINSTANCEID, LOCALSTARTDATE, LOCALENDDATE, ISSUSPENDED, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, ADMINSTATUSID, ADMINSTATUS, OPERSTATUSID, OPERSTATUS, PRIORITYID, PRIORITY, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT  I.ID_ PROCESSINSTANCEID,
                                  START_ LOCALSTARTDATE,
                                  END_ LOCALENDDATE,
                                  ISSUSPENDED_ ISSUSPENDED,
                                  PROCESSDEFINITION_ PROCESSDEFINITIONID,
                                  NAME_ PROCESSDEFINITIONNAME,
                                  ADMINISTRATIVEPROCESSSTATUSID ADMINSTATUSID,
                                  ADS.NAME ADMINSTATUS,
                                  OPERATIONALPROCESSSTATUSID OPERSTATUSID,
                                  OPS.NAME OPERSTATUS,
                                  I.PROCESSPRIORITYID PRIORITYID,
                                  NVL (P.NAME, ''[N/A]'') PRIORITY,
                                  d.ProcessDefinitionTypeId,
                                  dt.Name ProcessDefinitionTypeName,
                                  I.CREATEDATE,
                                  I.UPDATEDATE
                          FROM    WFS.JBPM_PROCESSINSTANCE I
                          JOIN    WFS.JBPM_PROCESSDEFINITION D
                          ON (    D.ID_ = PROCESSDEFINITION_)
                          JOIN    WFS.TTV_ProcessDefinitionType dt
                          ON (    dt.ProcessDefinitionTypeId = d.ProcessDefinitionTypeId)
                          LEFT JOIN WFS.TTV_PROCESSPRIORITY P
                          ON (    P.PROCESSPRIORITYID = I.PROCESSPRIORITYID)
                          JOIN    WFS.TTV_PROCESSSTATUS ADS
                          ON (    ADS.PROCESSSTATUSID = ADMINISTRATIVEPROCESSSTATUSID)
                          JOIN    WFS.TTV_PROCESSSTATUS OPS
                          ON (    OPS.PROCESSSTATUSID = OPERATIONALPROCESSSTATUSID)';
          EXCEPTION
             WHEN OTHERS THEN
             wk_message := 'ERROR';
             EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create view VDW_PROCESSINSTANCE'')';
             GOTO bypass_install;
          END;
  
  -- Creating View VDW_LOG
          BEGIN
          EXECUTE IMMEDIATE 'CREATE OR REPLACE VIEW WFS.VDW_LOG
                          AS 
                  SELECT	l.ID_ LogId,
                          l.CLASS_ LogClass,
                          DECODE (l.CLASS_,''N'', ''NODE'',
                                          ''7'', ''MESSAGE'',
                                          ''8'', ''USAGE'',
                                          ''9'', ''QUEUE'',							
                                          ''UNKNOWN'') LogClassName,
                          l.DATE_ LocalDate,
                          n.ProcessDefinitionId,
                          n.ProcessDefinitionName,
                          p.ProcessInstanceId,
                          p.ProcessDefinitionTypeId,
                          l.NODE_ NodeId,
                          n.NodeClass,
                          n.NodeName,
                          n.NodeIndex,
                          n.IsStartNode,
                          l.ENTER_ LocalEnterDate,
                          l.LEAVE_ LocalLeaveDate,
                          l.DURATION_ Duration,
                          l.ResourceGroupId,
                          NVL (g.Name, ''[N/A]'') ResourceGroupName,
                          g.ResourceTypeId,
                          NVL (ty.Name, ''[N/A]'') ResourceTypeName,
                          l.ResourceId,
                          NVL (r.Name, ''[N/A]'') ResourceName,
                          AdministrativeStatusId	AdminStatusId,
                          ads.Name AdminStatus,
                          OperationalStatusId	OperStatusId,
                          ops.Name OperStatus,
                          INDEX_,
                          l.TOKEN_ TokenId,
                          l.CreateDate,
                          l.UpdateDate
                    FROM	WFS.JBPM_LOG l
                          JOIN	WFS.vDW_NODE n
                          ON (	n.NodeId = l.NODE_)
                          JOIN	WFS.JBPM_TOKEN t
                          ON (	t.ID_ = l.TOKEN_)
                          JOIN	WFS.vDW_ProcessInstance p
                          ON (	p.ProcessInstanceId = t.PROCESSINSTANCE_)
                          LEFT JOIN WFS.TTV_ResourceGroup g
                          ON (	g.ResourceGroupId = l.ResourceGroupId)
                          LEFT JOIN WFS.TTV_ResourceType ty
                          ON (	ty.ResourceTypeId = g.ResourceTypeId)
                          LEFT JOIN WFS.TTV_Resource r
                          ON (	r.ResourceId = l.ResourceId)
                          LEFT JOIN WFS.TTV_ProcessStatus ads
                          ON (	ads.ProcessStatusId = l.AdministrativeStatusId)
                          LEFT JOIN WFS.TTV_ProcessStatus ops
                          ON (	ops.ProcessStatusId = l.OperationalStatusId)';
          EXCEPTION
             WHEN OTHERS THEN
             wk_message := 'ERROR';
             EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create view VDW_LOG'')';
             GOTO bypass_install;
          END;
  
  -- Creating View VDW_TASKINSTANCE
          BEGIN
          EXECUTE IMMEDIATE 'CREATE VIEW WFS.VDW_TASKINSTANCE ( TASKINSTANCEID, TASKINSTANCENAME, LOCALCREATEDATE, LOCALENDDATE, ISCANCELLED, ISSUSPENDED, ISOPEN, TASKID, NODEID, NODECLASS, NODENAME, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NODEINDEX, TASKNAME, ISSTARTNODE, TASKCONTROLLERID, TOKENID, PROCESSINSTANCEID, CURRENTADMINSTATUSID, CURRENTADMINSTATUS, CURRENTOPERSTATUSID, CURRENTOPERSTATUS, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT	i.ID_ TaskInstanceId,
                                  i.NAME_ TaskInstanceName,
                                  i.CREATE_ LocalCreateDate,
                                  i.END_ LocalEndDate,
                                  i.ISCANCELLED_ IsCancelled,
                                  i.ISSUSPENDED_ IsSuspended,
                                  i.ISOPEN_ IsOpen,
                                  i.TASK_ TaskId,
                                  n.NodeId,
                                  n.NodeClass,
                                  n.NodeName,
                                  n.ProcessDefinitionId,
                                  n.ProcessDefinitionName,
                                  n.NodeIndex,
                                  n.TaskName,
                                  n.IsStartNode,
                                  n.TaskControllerId,
                                  i.TOKEN_ TokenId,
                                  p.ProcessInstanceId,
                                  p.AdminStatusId CurrentAdminStatusId,
                                  p.AdminStatus CurrentAdminStatus,
                                  p.OperStatusId CurrentOperStatusId,
                                  p.OperStatus CurrentOperStatus,
                                  n.ProcessDefinitionTypeId,
                                  n.ProcessDefinitionTypeName,
                                  i.CREATEDATE,
                                  i.UPDATEDATE
                          FROM	WFS.JBPM_TASKINSTANCE i
                          JOIN	WFS.vDW_NODE n
                          ON (	n.TaskId = i.TASK_)
                          JOIN	WFS.JBPM_TOKEN t
                          ON (	t.ID_ = i.TOKEN_)
                          JOIN	WFS.vDW_ProcessInstance p
                          ON (	p.ProcessInstanceId = t.PROCESSINSTANCE_)';
          EXCEPTION
             WHEN OTHERS THEN
             wk_message := 'ERROR';
             EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create view VDW_TASKINSTANCE'')';
             GOTO bypass_install;
          END;
  
  -- Creating View VDW_VARIABLEACCESS
          BEGIN
          EXECUTE IMMEDIATE 'CREATE VIEW WFS.VDW_VARIABLEACCESS ( VARIABLEACCESSID, VARIABLENAME, ACCESSTYPE, MAPPEDNAME, TASKCONTROLLERID, VARIABLEINDEX, DATATYPEID, DATATYPENAME, NODEID, NODENAME, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NODEINDEX, TASKNAME, ISSTARTNODE, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT	v.ID_ VariableAccessId,
                                  VARIABLENAME_ VariableName,
                                  ACCESS_ AccessType,
                                  MAPPEDNAME_ MappedName,
                                  TASKCONTROLLER_ TaskControllerId,
                                  Index_ VariableIndex,
                                  v.DataTypeId,
                                  t.DataTypeName,
                                  NodeId,
                                  NodeName,
                                  ProcessDefinitionId,
                                  ProcessDefinitionName,
                                  NodeIndex,
                                  TaskName,
                                  IsStartNode,
                                  n.ProcessDefinitionTypeId,
                                  n.ProcessDefinitionTypeName,
                                  v.CreateDate,
                                  v.UpdateDate
                          FROM	WFS.JBPM_VARIABLEACCESS v
                          JOIN	WFS.TTV_DATATYPE t
                          ON (	t.DataTypeId = v.DataTypeId)
                          JOIN	WFS.vDW_Node n
                          ON (	n.TaskControllerId = v.TASKCONTROLLER_)';
          EXCEPTION
             WHEN OTHERS THEN
             wk_message := 'ERROR';
             EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create view VDW_VARIABLEACCESS'')';
             GOTO bypass_install;
          END;
  
  -- Creating View VDW_VARIABLEINSTANCE
          BEGIN
          EXECUTE IMMEDIATE 'CREATE VIEW WFS.VDW_VARIABLEINSTANCE ( VARIABLEINSTANCEID, CLASSCODE, CLASSNAME, VARIABLEINSTANCENAME, TOKENID, ISGLOBALVARIABLE, PROCESSINSTANCEID, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NUMERICVALUE, STRINGVALUE, LONGVALUE_, STRINGVALUE_, DOUBLEVALUE_, TOKENVARIABLEMAP_, TASKINSTANCEID, TASKINSTANCENAME, TASKID, NODEID, NODECLASS, NODENAME, NODEINDEX, TASKNAME, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT	i.ID_	VariableInstanceId,
                                  i.CLASS_ ClassCode,
                                  DECODE (i.CLASS_, ''N'', ''NULL'', ''S'', ''STRING'', ''L'', ''LONG'', ''[UNKNOWN]'') ClassName,
                                  i.NAME_ VariableInstanceName,
                                  i.TOKEN_ TokenId,
                                  DECODE (NVL (i.TOKENVARIABLEMAP_, -1), -1, 0, 1) IsGlobalVariable,
                                  i.PROCESSINSTANCE_ ProcessInstanceId,
                                  p.ProcessDefinitionId,
                                  p.ProcessDefinitionName,
                                  DECODE (i.CLASS_, ''L'', NVL (i.LONGVALUE_, i.DOUBLEVALUE_), NULL) NumericValue,
                                  DECODE (i.CLASS_, ''L'', NULL, i.STRINGVALUE_) StringValue,
                                  i.LONGVALUE_,
                                  i.STRINGVALUE_,
                                  i.DOUBLEVALUE_,
                                  i.TOKENVARIABLEMAP_,
                                  i.TASKINSTANCE_ TaskInstanceId,
                                  t.TaskInstanceName,
                                  t.TaskId,
                                  t.NodeId,
                                  t.NodeClass,
                                  t.NodeName,
                                  t.NodeIndex,
                                  t.TaskName,
                                  p.ProcessDefinitionTypeId,
                                  p.ProcessDefinitionTypeName,
                                  i.CREATEDATE,
                                  i.UPDATEDATE
                          FROM	WFS.JBPM_VARIABLEINSTANCE i
                          JOIN	WFS.vDW_ProcessInstance p
                          ON (	p.ProcessInstanceId = i.PROCESSINSTANCE_)
                          LEFT JOIN WFS.vDW_TaskInstance t
                          ON (	t.TaskInstanceId = i.TASKINSTANCE_)';
          EXCEPTION
             WHEN OTHERS THEN
             wk_message := 'ERROR';
             EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create view VDW_VARIABLEINSTANCE'')';
             GOTO bypass_install;
          END;
  
  /*
  -----------------------------------------
   CREATING TRIGGERS ON TABLES
  -----------------------------------------
  */
  
  -- Create Trigger TRG_BIGROLE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_BIGROLE_UPD
                              BEFORE UPDATE
                              ON WFS.bigrole
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION 
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_BIGROLE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_BIGROLE_ROLE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_BIGROLE_ROLE_UPD
                              BEFORE UPDATE
                              ON WFS.bigrole_role
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_BIGROLE_ROLE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_ACTION_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_ACTION_SEQ
                              BEFORE INSERT ON WFS.JBPM_ACTION
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_ACTION_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_ACTION_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_ACTION_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_ACTION_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_ACTION
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_ACTION_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_BYTEARRAY_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_BYTEARRAY_SEQ
                              BEFORE INSERT ON WFS.JBPM_BYTEARRAY
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_BYTEARRAY_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_BYTEARRAY_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_BYTEARRAY_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_BYTEARRAY_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_BYTEARRAY
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_BYTEARRAY_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_BYTEBLOCK_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_BYTEBLOCK_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_BYTEBLOCK
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_BYTEBLOCK_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_COMMENT_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_COMMENT_SEQ
                              BEFORE INSERT ON WFS.JBPM_COMMENT
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_COMMENT_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_COMMENT_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_COMMENT_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_COMMENT_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_COMMENT
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_COMMENT_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_DECISIONCONDITION_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_DECISIONCONDITION_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_DECISIONCONDITIONS
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_DECISIONCONDITION_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_DELEGATION_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_DELEGATION_SEQ
                              BEFORE INSERT ON WFS.JBPM_DELEGATION
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_DELEGATION_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_DELEGATION_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_DELEGATION_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_DELEGATION_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_DELEGATION
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_DELEGATION_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_EVENT_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_EVENT_SEQ
                              BEFORE INSERT ON WFS.JBPM_EVENT
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_EVENT_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_EVENT_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_EVENT_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_EVENT_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_EVENT
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_EVENT_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_EXCEPTIONHANDLER_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_EXCEPTIONHANDLER_SEQ
                              BEFORE INSERT ON WFS.JBPM_EXCEPTIONHANDLER
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_EXCEPTIONHANDLER_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_EXCEPTIONHANDLER_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_EXCEPTIONHANDLER_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_EXCEPTIONHANDLER_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_EXCEPTIONHANDLER
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_EXCEPTIONHANDLER_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_ID_GROUP_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_ID_GROUP_SEQ
                              BEFORE INSERT ON WFS.JBPM_ID_GROUP
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_ID_GROUP_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_ID_GROUP_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_ID_GROUP_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_ID_GROUP_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_ID_GROUP
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_ID_GROUP_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_ID_MEMBERSHIP_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_ID_MEMBERSHIP_SEQ
                              BEFORE INSERT ON WFS.JBPM_ID_MEMBERSHIP
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_ID_MEMBERSHIP_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_ID_MEMBERSHIP_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_ID_MEMBERSHIP_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_ID_MEMBERSHIP_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_ID_MEMBERSHIP
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_ID_MEMBERSHIP_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_ID_PERMISSIONS_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_ID_PERMISSIONS_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_ID_PERMISSIONS
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_ID_PERMISSION_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_ID_USER_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_ID_USER_SEQ
                              BEFORE INSERT ON WFS.JBPM_ID_USER
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_ID_USER_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_ID_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_ID_USER_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_ID_USER_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_ID_USER
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_ID_PERMISSION_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_LOG_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_LOG_SEQ
                              BEFORE INSERT ON WFS.JBPM_LOG
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_LOG_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_LOG_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_LOG_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_LOG_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_LOG
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_LOG_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_MESSAGE_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_MESSAGE_SEQ
                              BEFORE INSERT ON WFS.JBPM_MESSAGE
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_MESSAGE_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_MESSAGE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_MESSAGE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_MESSAGE_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_MESSAGE
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_MESSAGE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_MODULEDEFINITION_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_MODULEDEFINITION_SEQ
                              BEFORE INSERT ON WFS.JBPM_MODULEDEFINITION
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_MODULEDEFINITION_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_MODULEDEFINITION_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_MODULEDEFINITION_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_MODULEDEFINITION_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_MODULEDEFINITION
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_MODULEDEFINITION_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_MODULEINSTANCE_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_MODULEINSTANCE_SEQ
                              BEFORE INSERT ON WFS.JBPM_MODULEINSTANCE
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_MODULEINSTANCE_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_MODULEINSTANCE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_MODULE_INSTANCE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_MODULEINSTANCE_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_MODULEINSTANCE
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_MODULEINSTANCE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_NODE_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_NODE_SEQ
                              BEFORE INSERT ON WFS.JBPM_NODE
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_NODE_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_NODE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_NODE_UPD
  
      BEGIN
          
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_NODE_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_NODE
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_NODE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_POOLEDACTOR_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_POOLEDACTOR_SEQ
                              BEFORE INSERT ON WFS.JBPM_POOLEDACTOR
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_POOLEDACTOR_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_POOLEDACTOR_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_POOLEDACTOR_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_POOLEDACTOR_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_POOLEDACTOR
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_POOLEDACTOR_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_PROCESSDEFINITION_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_PROCESSDEFINITION_SEQ
                              BEFORE INSERT ON WFS.JBPM_PROCESSDEFINITION
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_PROCESSDEFINITION_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_PROCESSDEFINITION_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_PROCESSDEFINITION_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_PROCESSDEFINITION_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_PROCESSDEFINITION
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_PROCESSDEFINITION_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_PROCESSINSTANCE_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_PROCESSINSTANCE_SEQ
                              BEFORE INSERT ON WFS.JBPM_PROCESSINSTANCE
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_PROCESSINSTANCE_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_PROCESSINSTANCE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_PROCESSINSTANCE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_PROCESSINSTANCE_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_PROCESSINSTANCE
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_PROCESSINSTANCE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_RUNTIMEACTION_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_RUNTIMEACTION_SEQ
                              BEFORE INSERT ON WFS.JBPM_RUNTIMEACTION
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_RUNTIMEACTION_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_RUNTIMEACTION_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_RUNTIMEACTION_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_RUNTIMEACTION_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_RUNTIMEACTION
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_RUNTIMEACTION_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_SWIMLANE_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_SWIMLANE_SEQ
                              BEFORE INSERT ON WFS.JBPM_SWIMLANE
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_SWIMLANE_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_SWIMLANE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_SWIMLANE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_SWIMLANE_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_SWIMLANE
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_SWIMLANE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_SWIMLANEINSTANCE_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_SWIMLANEINSTANCE_SEQ
                              BEFORE INSERT ON WFS.JBPM_SWIMLANEINSTANCE
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_SWIMLANEINSTANCE_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_SWIMELANEINSTANCE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_SWIMLANEINSTANCE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_SWIMLANEINSTANCE_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_SWIMLANEINSTANCE
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_SWIMLANEINSTANCE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_TASK_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_TASK_SEQ
                              BEFORE INSERT ON WFS.JBPM_TASK
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_TASK_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_TASK_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_TASK_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_TASK_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_TASK
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_TASK_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_TASKACTORPOOL_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_TASKACTORPOOL_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_TASKACTORPOOL
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_TASKACTORPOOL_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_TASKCONTROLLER_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_TASKCONTROLLER_SEQ
                              BEFORE INSERT ON WFS.JBPM_TASKCONTROLLER
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_TASKCONTROLLER_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_TASKCONTROLLER_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_TASKCONTROLLER_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_TASKCONTROLLER_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_TASKCONTROLLER
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_TASKCONTROLLER_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_TASKINSTANCE
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_TASKINSTANCE
                              BEFORE INSERT ON WFS.JBPM_TASKINSTANCE
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_TASKINSTANCE_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_TASKINSTANCE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_TASKINSTANCE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_TASKINSTANCE_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_TASKINSTANCE
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_TASKINSTANCE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_TIMER_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_TIMER_SEQ
                              BEFORE INSERT ON WFS.JBPM_TIMER
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_TIMER_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_TIMER_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_TIMER_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_TIMER_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_TIMER
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_TIMER_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_TOKEN_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_TOKEN_SEQ
                              BEFORE INSERT ON WFS.JBPM_TOKEN
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_TOKEN_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_TOKEN_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_TOKEN_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_TOKEN_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_TOKEN
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_TOKEN_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_TOKENVARIABLEMAP_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_TOKENVARIABLEMAP_SEQ
                              BEFORE INSERT ON WFS.JBPM_TOKENVARIABLEMAP
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_TOKENVARIABLEMAP_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_TOKENVARIABLEMAP_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_TOKENVARIABLEMAP_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_TOKENVARIABLEMAP_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_TOKENVARIABLEMAP
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_TOKENVARIABLEMAP_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_TRANSITION_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_TRANSITION_SEQ
                              BEFORE INSERT ON WFS.JBPM_TRANSITION
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_TRANSITION_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_TRANSITION_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_TRANSITION_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_TRANSITION_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_TRANSITION
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_TRANSITION_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_VARIABLEACCESS_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_VARIABLEACCESS_SEQ
                              BEFORE INSERT ON WFS.JBPM_VARIABLEACCESS
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ID_ IS NULL THEN
                                      SELECT WFS.JBPM_VARIABLEACCESS_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_VARIABLEACCESS_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_VARIABLEACCESS_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_JBPM_VARIABLEACCESS_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_VARIABLEACCESS
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_VARIABLEACCESS_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_VARIABLEINSTANCE_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE OR REPLACE TRIGGER WFS.TRG_JBPM_VARIABLEINSTANCE_SEQ
                               BEFORE INSERT ON WFS.JBPM_VARIABLEINSTANCE
                               FOR EACH ROW
                               BEGIN

                                 IF :NEW.ID_ IS NULL THEN
                                   SELECT WFS.JBPM_VARIABLEINSTANCE_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                                 END IF;

                                 IF :NEW.STRINGVALUE_ IS NULL THEN
                                   SELECT '' '' INTO :NEW.STRINGVALUE_ FROM DUAL;
                                 END IF;

                               END;';

      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_VARIABLEINSTANCE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_JBPM_VARIABLEINSTANCE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE OR REPLACE TRIGGER WFS.TRG_JBPM_VARIABLEINSTANCE_UPD
                               BEFORE UPDATE ON WFS.JBPM_VARIABLEINSTANCE
                               FOR EACH ROW
                               BEGIN

                                 SELECT SYSTIMESTAMP
                                 INTO :NEW.UpdateDate
                                 FROM DUAL;

                                 IF :NEW.STRINGVALUE_ IS NULL THEN
                                   SELECT '' ''
                                   INTO :NEW.STRINGVALUE_
                                   FROM DUAL;
                                 END IF;

                               END;';

      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_JBPM_VARIABLEINSTANCE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_ACCESSLEVEL_SEQ
  
      BEGIN
          
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_ACCESSLEVEL_SEQ
                              BEFORE INSERT ON WFS.TTV_AccessLevel
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.AccessLevelId IS NULL THEN
                                      SELECT WFS.TTV_AccessLevel_SEQ.NEXTVAL INTO :NEW.AccessLevelId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_ACCESSLEVEL_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_ACCESSLEVEL_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_ACCESSLEVEL_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_AccessLevel
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_ACCESSLEVEL_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_ACTION_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_ACTION_SEQ
                              BEFORE INSERT ON WFS.TTV_Action
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ActionId IS NULL THEN
                                      SELECT WFS.TTV_Action_SEQ.NEXTVAL INTO :NEW.ActionId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_ACTION_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_ACTION_UPD
  
      BEGIN
          
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_ACTION_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_Action
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_ACTION_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_BIGROLEPERMISSION_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_BIGROLEPERMISSION_SEQ
                              BEFORE INSERT ON WFS.TTV_BigRolePermission
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.BigRolePermissionId IS NULL THEN
                                      SELECT WFS.TTV_BigRolePermission_SEQ.NEXTVAL INTO :NEW.BigRolePermissionId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_BIGROLEPERMISSION_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_CONNECTIONTYPE_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_CONNECTIONTYPE_SEQ
                              BEFORE INSERT ON WFS.TTV_ConnectionType
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ConnectionTypeId IS NULL THEN
                                      SELECT WFS.TTV_ConnectionType_SEQ.NEXTVAL INTO :NEW.ConnectionTypeId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_CONNECTIONTYPE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_CONNECTIONTYPE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_CONNECTIONTYPE_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_ConnectionType
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_CONNECTIONTYPE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_DATATYPE_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_DATATYPE_SEQ
                              BEFORE INSERT ON WFS.TTV_DataType
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.DataTypeId IS NULL THEN
                                      SELECT WFS.TTV_DataType_SEQ.NEXTVAL INTO :NEW.DataTypeId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_DATATYPE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_DATATYPE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_DATATYPE_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_DataType
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_DATATYPE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_MENUITEM_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_MENUITEM_SEQ
                              BEFORE INSERT ON WFS.TTV_MenuItem
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.MenuItemId IS NULL THEN
                                      SELECT WFS.TTV_MenuItem_SEQ.NEXTVAL INTO :NEW.MenuItemId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_MENUITEM_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_MENUITEM_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_MENUITEM_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_MenuItem
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_MENUITEM_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_MESSAGELOG_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_MESSAGELOG_SEQ
                              BEFORE INSERT ON WFS.TTV_MessageLog
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.MessageLogId IS NULL THEN
                                      SELECT WFS.TTV_MessageLog_SEQ.NEXTVAL INTO :NEW.MessageLogId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_MESSAGELOG_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_MESSAGELOG_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_MESSAGELOG_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_MessageLog
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_MESSAGELOG_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_MODULE_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_MODULE_SEQ
                              BEFORE INSERT ON WFS.TTV_Module
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ModuleId IS NULL THEN
                                      SELECT WFS.TTV_Module_SEQ.NEXTVAL INTO :NEW.ModuleId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_MODULE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_MODULE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_MODULE_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_Module
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_MODULE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_MONITOREDDRIVE_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_MONITOREDDRIVE_SEQ
                              BEFORE INSERT ON WFS.TTV_MonitoredDrive
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.MonitoredDriveId IS NULL THEN
                                      SELECT WFS.TTV_MonitoredDrive_SEQ.NEXTVAL INTO :NEW.MonitoredDriveId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_MONITOREDDRIVE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_MONITOREDDRIVE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_MONITOREDDRIVE_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_MonitoredDrive
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_MONITOREDDRIVE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_MONDRIVEHISTORY_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_MONDRIVEHISTORY_SEQ
                              BEFORE INSERT ON WFS.TTV_MonitoredDriveHistory
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.MonitoredDriveHistoryId IS NULL THEN
                                      SELECT WFS.TTV_MonitoredDriveHistory_SEQ.NEXTVAL INTO :NEW.MonitoredDriveHistoryId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_MONDRIVEHISTORY_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_MONDRIVESTATUS_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_MONDRIVESTATUS_SEQ
                              BEFORE INSERT ON WFS.TTV_MonitoredDriveStatus
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.MonitoredDriveStatusId IS NULL THEN
                                      SELECT WFS.TTV_MonitoredDriveStatus_SEQ.NEXTVAL INTO :NEW.MonitoredDriveStatusId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_MONDRIVESTATUS_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_MONDRIVESTATUS_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_MONDRIVESTATUS_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_MonitoredDriveStatus
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_MONDRIVESTATUS_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_PERMISSION_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_PERMISSION_SEQ
                              BEFORE INSERT ON WFS.TTV_Permission
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.PermissionId IS NULL THEN
                                      SELECT WFS.TTV_Permission_SEQ.NEXTVAL INTO :NEW.PermissionId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_PERMISSION_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger
      
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_PERMISSION_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_Permission
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_PERMISSION_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_PROCESSDEFTYPE_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_PROCESSDEFTYPE_SEQ
                              BEFORE INSERT ON WFS.TTV_ProcessDefinitionType
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ProcessDefinitionTypeId IS NULL THEN
                                      SELECT WFS.TTV_ProcessDefinitionType_SEQ.NEXTVAL INTO :NEW.ProcessDefinitionTypeId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_PROCESSDEFTYPE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_PROCESSDEFTYPE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_PROCESSDEFTYPE_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_ProcessDefinitionType
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_PROCESSDEFTYPE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_PROCESSINSTNOTE_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_PROCESSINSTNOTE_SEQ
                              BEFORE INSERT ON WFS.TTV_ProcessInstanceNote
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ProcessInstanceNoteId IS NULL THEN
                                      SELECT WFS.TTV_ProcessInstanceNote_SEQ.NEXTVAL INTO :NEW.ProcessInstanceNoteId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_PROCESSINSTNOTE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_PROCESSINSTNOTE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_PROCESSINSTNOTE_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_ProcessInstanceNote
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_PROCESSINSTNOTE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_PROCESSINSTANCETYP_SEQ
  
      BEGIN
          
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_PROCESSINSTANCETYP_SEQ
                              BEFORE INSERT ON WFS.TTV_ProcessInstanceType
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ProcessInstanceTypeId IS NULL THEN
                                      SELECT WFS.TTV_ProcessInstanceType_SEQ.NEXTVAL INTO :NEW.ProcessInstanceTypeId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_PROCESSINSTANCETYP_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_PROCESSINSTANCETYP_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_PROCESSINSTANCETYP_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_ProcessInstanceType
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_PROCESSINSTANCETYP_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_PROCESSPRIORITY_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_PROCESSPRIORITY_SEQ
                              BEFORE INSERT ON WFS.TTV_ProcessPriority
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ProcessPriorityId IS NULL THEN
                                      SELECT WFS.TTV_ProcessPriority_SEQ.NEXTVAL INTO :NEW.ProcessPriorityId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_PROCESSPRIORITY_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_PROCESSPRIORITY_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_PROCESSPRIORITY_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_ProcessPriority
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_PROCESSPRIORITY'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_PROCESSSTATUS_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_PROCESSSTATUS_SEQ
                              BEFORE INSERT ON WFS.TTV_ProcessStatus
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ProcessStatusId IS NULL THEN
                                      SELECT WFS.TTV_ProcessStatus_SEQ.NEXTVAL INTO :NEW.ProcessStatusId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_PROCESSSTATUS_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_PROCESSSTATUS_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_PROCESSSTATUS_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_ProcessStatus
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_PROCESSSTATUS_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_RESOURCE_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_RESOURCE_SEQ
                              BEFORE INSERT ON WFS.TTV_Resource
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ResourceId IS NULL THEN
                                      SELECT WFS.TTV_Resource_SEQ.NEXTVAL INTO :NEW.ResourceId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_RESOURCE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_RESOURCE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_RESOURCE_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_Resource
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_RESOURCE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_RESOURCEGROUP_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_RESOURCEGROUP_SEQ
                              BEFORE INSERT ON WFS.TTV_ResourceGroup
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ResourceGroupId IS NULL THEN
                                      SELECT WFS.TTV_ResourceGroup_SEQ.NEXTVAL INTO :NEW.ResourceGroupId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_RESOURCEGROUP_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_RESOURCEGROUP_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_RESOURCEGROUP_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_ResourceGroup
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_RESOURCEGROUP_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_RESOURCEGROUPMEMB_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_RESOURCEGROUPMEMB_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_ResourceGroupMembership
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_RESOURCEGROUPMEMB_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_RESOURCEGROUPQUEUE_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_RESOURCEGROUPQUEUE_SEQ
                              BEFORE INSERT ON WFS.TTV_ResourceGroupQueueItem
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ResourceGroupQueueItemId IS NULL THEN
                                      SELECT WFS.TTV_ResourceGroupQueueItem_SEQ.NEXTVAL INTO :NEW.ResourceGroupQueueItemId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_RESOURCEGROUPQUEUE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger   TRG_TTV_RESOURCEGROUPQUEUE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_RESOURCEGROUPQUEUE_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_ResourceGroupQueueItem
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_RESOURCEGROUPQUEUE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_RESOURCESTATUS_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_RESOURCESTATUS_SEQ
                              BEFORE INSERT ON WFS.TTV_ResourceStatus
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ResourceStatusId IS NULL THEN
                                      SELECT WFS.TTV_ResourceStatus_SEQ.NEXTVAL INTO :NEW.ResourceStatusId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_RESOURCESTATUS_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_RESOURCESTATUS_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_RESOURCESTATUS_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_ResourceStatus
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_RESOURCESTATUS_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_RESOURCETYPE_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_RESOURCETYPE_SEQ
                              BEFORE INSERT ON WFS.TTV_ResourceType
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ResourceTypeId IS NULL THEN
                                      SELECT WFS.TTV_ResourceType_SEQ.NEXTVAL INTO :NEW.ResourceTypeId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_RESOURCETYPE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_RESOURCETYPE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_RESOURCETYPE_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_ResourceType
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_RESOURCETYPE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_RESOURCEUSAGEHISTO_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_RESOURCEUSAGEHISTO_SEQ
                              BEFORE INSERT ON WFS.TTV_ResourceUsageHistory
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.ResourceUsageHistoryId IS NULL THEN
                                      SELECT WFS.TTV_ResourceUsageHistory_SEQ.NEXTVAL INTO :NEW.ResourceUsageHistoryId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_RESOURCEUSAGEHISTO_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_STRATEGYCLASS_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_STRATEGYCLASS_SEQ
                              BEFORE INSERT ON WFS.TTV_StrategyClass
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.StrategyClassId IS NULL THEN
                                      SELECT WFS.TTV_StrategyClass_SEQ.NEXTVAL INTO :NEW.StrategyClassId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_STRATEGYCLASS_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_STRATEGYCLASS_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_STRATEGYCLASS_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_StrategyClass
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_STRATEGYCLASS_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_STRATEGYCLASSTYPE_SEQ
  
      BEGIN
          
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_STRATEGYCLASSTYPE_SEQ
                              BEFORE INSERT ON WFS.TTV_StrategyClassType
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.StrategyClassTypeId IS NULL THEN
                                      SELECT WFS.TTV_StrategyClassType_SEQ.NEXTVAL INTO :NEW.StrategyClassTypeId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_STRATEBYCLASSTYPE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_STRATEGYCLASSTYPE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_STRATEGYCLASSTYPE_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_StrategyClassType
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_STRATEBYCLASSTYPE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_TOKENRESOURCE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_TOKENRESOURCE_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_TokenResource
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_TOKENRESOURCE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_TOKENTYPE_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_TOKENTYPE_SEQ
                              BEFORE INSERT ON WFS.TTV_TokenType
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.TokenTypeId IS NULL THEN
                                      SELECT WFS.TTV_TokenType_SEQ.NEXTVAL INTO :NEW.TokenTypeId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_TOKEN_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_TOKENTYPE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_TOKENTYPE_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_TokenType
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_TOKENTYPE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_VARACCESSTYPE_SEQ
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_VARACCESSTYPE_SEQ
                              BEFORE INSERT ON WFS.TTV_VariableAccessType
                              FOR EACH ROW
                              BEGIN
                                  IF :NEW.VariableAccessTypeId IS NULL THEN
                                      SELECT WFS.TTV_VariableAccessType_SEQ.NEXTVAL INTO :NEW.VariableAccessTypeId FROM DUAL;
                                  END IF;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_VARACCESSTYPE_SEQ'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_TTV_VARACCESSTYPE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_TTV_VARACCESSTYPE_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_VariableAccessType
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_VARACCESSTYPE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_USERS_REALM_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_USERS_REALM_UPD
                              BEFORE UPDATE
                              ON WFS.users_realm
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_USERS_REALM_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_USER_BIGROLE_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_USER_BIGROLE_UPD
                              BEFORE UPDATE
                              ON WFS.user_bigrole
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_USER_BIDROLE_UPD'')';
              GOTO bypass_install;
      END;
  
  -- Create Trigger TRG_USER_DATA_UPD
  
      BEGIN
  
          EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_USER_DATA_UPD
                              BEFORE UPDATE
                              ON WFS.user_data
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_USER_DATA_UPD'')';
              GOTO bypass_install;
      END;
      
      -- Create Trigger TRG_TTV_SELECTOR_SEQ
      
      BEGIN
      
        EXECUTE IMMEDIATE 'CREATE OR REPLACE TRIGGER WFS.TRG_TTV_SELECTOR_SEQ
                              BEFORE INSERT ON WFS.TTV_SELECTOR
                              FOR EACH ROW
                              BEGIN
                                  
                                  :NEW.CreateDate := sysdate;
                                  :NEW.UpdateDate := sysdate;
  
                              END;';
                              
      EXCEPTION
        WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_SELECTOR_SEQ'')';
          GOTO bypass_install;
          
      END;
      
      -- Create Trigger TRG_TTV_SELECTOR_UPD   
      
      BEGIN
      
        EXECUTE IMMEDIATE 'CREATE OR REPLACE TRIGGER WFS.TRG_TTV_SELECTOR_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_SELECTOR
                              FOR EACH ROW
                              BEGIN
                                  :NEW.UpdateDate := sysdate;
                              END;';
                             
      EXCEPTION
        WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_SELECTOR_UPD'')';
          GOTO bypass_install;
          
      END;
      
      -- Create Trigger TRG_TRANSITIONTYPE_UPD
      BEGIN
      
        EXECUTE IMMEDIATE 'CREATE OR REPLACE TRIGGER WFS.TRG_TTV_TRANSITIONTYPE_UPD
                               BEFORE UPDATE
                               ON WFS.TTV_TRANSITIONTYPE
                               FOR EACH ROW
                                DECLARE updatedate      date;
                                BEGIN
                                  SELECT  SYSTIMESTAMP
                                  INTO    updatedate
                                  FROM    DUAL;
                                  :NEW.UpdateDate := updatedate;
                                END;';
                                
      EXCEPTION
        WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_TRANSITIONTYPE_UPD'')';
          GOTO bypass_install;
          
      END;
  
  /*
  -----------------------------------------
   COMPILE PACKAGES AND PROCEDURES
  -----------------------------------------
  */
  
  -- Create Procedure SP_REINITIALIZESEQUENCE
      BEGIN
          EXECUTE IMMEDIATE 'CREATE OR REPLACE PROCEDURE WFS.SP_REINITIALIZESEQUENCE 
                              (tablename IN varchar2 , idcolumn IN varchar2 )
                              IS
                                  sequencename    varchar2 (100);
                                  maxsequence     INTEGER;
                                  sql_max         varchar2 (500);
                                  sql_createseq   varchar2 (500);
                                  sql_dropseq     varchar2 (500);
                                  varcount        INTEGER;
  
                              BEGIN
  
                                  -- DBMS_OUTPUT.PUT_LINE(''Working on: '' || tablename);
  
                                  sequencename := ''WFS.'' || tablename || ''_seq'';
  
                                  -- DBMS_OUTPUT.PUT_LINE(''Sequence:'' || sequencename);
  
                                  sql_max  := ''SELECT MAX('';
                                  sql_max  := sql_max || idcolumn;
                                  sql_max   := sql_max || '') FROM '' || tablename; 
  
                                  EXECUTE IMMEDIATE sql_max INTO varcount; 
  
                                  -- DBMS_OUTPUT.PUT_LINE(''Current Sequence Number:'');
  
                                  varcount := NVL(varcount,0) + 1;
                                  -- DBMS_OUTPUT.PUT_LINE (varcount);
  
                                  -- Drop the sequence
                                  sql_dropseq  := ''DROP SEQUENCE '' || sequencename;
                                  -- DBMS_OUTPUT.PUT_LINE (sql_dropseq);
                                  BEGIN
                                  EXECUTE IMMEDIATE sql_dropseq;
  
                                      EXCEPTION
                                         WHEN OTHERS THEN
                                              null;
                                 END;
  
                                  -- Recreate the sequence
                                  sql_createseq   := ''CREATE SEQUENCE '' || sequencename;
                                  sql_createseq   := sql_createseq || '' START WITH '' || varcount;
                                  sql_createseq   := sql_createseq || '' INCREMENT BY 1'';
  
                                  -- DBMS_OUTPUT.PUT_LINE (sql_createseq);
  
                                  BEGIN
                                  EXECUTE IMMEDIATE sql_createseq;
  
                                   EXCEPTION
                                   WHEN OTHERS THEN
                                    null;
  
                                  END;
  
                                  DBMS_OUTPUT.PUT_LINE(''Sequence '' || sequencename || '' updated to '' || varcount);
  
                                  END;';
  
          EXCEPTION 
             WHEN OTHERS THEN
             wk_message := 'ERROR';
             EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create SP_REINITIALIZESEQUENCE Procedure'')';
             GOTO bypass_install;
          END;
          
          
  
  /*
  -----------------------------------------
   INSERTING DEFAULT DATA INTO TABLES
  -----------------------------------------
  */
  
    -- Inserting default SYSTEM_RELEASE data
    BEGIN
    
      EXECUTE IMMEDIATE 'INSERT INTO WFS.SYSTEM_RELEASE VALUES 
                  (''RELEASE'',''2.5.0.0'')';
                  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into SYSTEM_RELEASE'')';
        GOTO bypass_install;
        
    END;
  
  -- Inserting default TTV_CONNECTIONTYPE data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_CONNECTIONTYPE(CONNECTIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''URL'', TO_DATE(''15/06/2006 09:18:25 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 09:19:23 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_CONNECTIONTYPE(CONNECTIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''IP Address[:Port]'', TO_DATE(''15/06/2006 09:18:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 09:19:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_CONNECTIONTYPE(CONNECTIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''Email'', TO_DATE(''15/06/2006 09:18:41 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 09:18:41 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
    EXCEPTION
      WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_CONNECTIONTYPE'')';
              GOTO bypass_install;
    END;
  
  -- Inserting default TTV_STRATEGYCLASSTYPE data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASSTYPE(STRATEGYCLASSTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Resource Initialization Strategy'', TO_DATE(''15/06/2006 05:39:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:39:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASSTYPE(STRATEGYCLASSTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''Resource HeartBeat Strategy'', TO_DATE(''15/06/2006 05:39:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:39:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASSTYPE(STRATEGYCLASSTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''Resource Allocation Strategy'', TO_DATE(''15/06/2006 05:39:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:39:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_STRATEGYCLASSTYPE'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default BIGROLE data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.BIGROLE(BIGROLE, DESCRIPTION, CREATEDATE, UPDATEDATE)
    VALUES(''Admin'', ''Default System Administrator'', TO_DATE(''18/06/2006 12:27:03 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/09/2006 05:29:21 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into BIGROLE'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default TTV_MODULE data 
      BEGIN
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MODULE(MODULEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Home'', TO_DATE(''12/08/2006 12:05:13 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''12/08/2006 12:05:13 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MODULE(MODULEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''Work Order Management'', TO_DATE(''12/08/2006 12:05:28 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''12/08/2006 12:05:40 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MODULE(MODULEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''Resource Management'', TO_DATE(''12/08/2006 12:05:55 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''12/08/2006 12:05:55 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MODULE(MODULEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(4, ''User Management'', TO_DATE(''12/08/2006 01:13:38 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''12/08/2006 01:13:38 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MODULE(MODULEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(5, ''Role Management'', TO_DATE(''12/08/2006 01:13:48 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''12/08/2006 01:13:48 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MODULE(MODULEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(6, ''User Tasks'', TO_DATE(''12/08/2006 01:14:01 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''18/08/2006 07:24:38 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
          
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MODULE(MODULEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(7, ''Monitoring'', TO_DATE(''12/08/2006 01:14:10 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''18/08/2006 07:24:43 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
            EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MODULE(MODULEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(8, ''Reporting'', TO_DATE(''17/08/2006 11:12:39 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''18/08/2006 07:24:22 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
              EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MODULE(MODULEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(9, ''Plugins'', TO_DATE(''15/08/2007 12:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/08/2007 12:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_MODULE'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default BIDROLE_ROLE data 
      BEGIN 
          EXECUTE IMMEDIATE 'INSERT INTO WFS.BIGROLE_ROLE(BIGROLE, ROLE, CREATEDATE, UPDATEDATE)
    VALUES(''Admin'', ''View Roles'', TO_DATE(''11/09/2006 05:53:55 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/09/2006 05:53:55 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.BIGROLE_ROLE(BIGROLE, ROLE, CREATEDATE, UPDATEDATE)
    VALUES(''Admin'', ''Modify Roles'', TO_DATE(''11/09/2006 05:53:55 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/09/2006 05:53:55 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.BIGROLE_ROLE(BIGROLE, ROLE, CREATEDATE, UPDATEDATE)
    VALUES(''Admin'', ''Create Roles'', TO_DATE(''11/09/2006 05:53:55 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/09/2006 05:53:55 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.BIGROLE_ROLE(BIGROLE, ROLE, CREATEDATE, UPDATEDATE)
    VALUES(''Admin'', ''Delete Roles'', TO_DATE(''11/09/2006 05:53:55 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/09/2006 05:53:55 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.BIGROLE_ROLE(BIGROLE, ROLE, CREATEDATE, UPDATEDATE)
    VALUES(''Admin'', ''View Users'', TO_DATE(''11/09/2006 05:53:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/09/2006 05:53:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.BIGROLE_ROLE(BIGROLE, ROLE, CREATEDATE, UPDATEDATE)
    VALUES(''Admin'', ''Modify Users'', TO_DATE(''11/09/2006 05:53:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/09/2006 05:53:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.BIGROLE_ROLE(BIGROLE, ROLE, CREATEDATE, UPDATEDATE)
    VALUES(''Admin'', ''Create Users'', TO_DATE(''11/09/2006 05:53:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/09/2006 05:53:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.BIGROLE_ROLE(BIGROLE, ROLE, CREATEDATE, UPDATEDATE)
    VALUES(''Admin'', ''Delete Users'', TO_DATE(''11/09/2006 05:53:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/09/2006 05:53:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.BIGROLE_ROLE(BIGROLE, ROLE, CREATEDATE, UPDATEDATE)
    VALUES(''Admin'', ''View Settings'', TO_DATE(''11/09/2006 05:53:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/09/2006 05:53:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.BIGROLE_ROLE(BIGROLE, ROLE, CREATEDATE, UPDATEDATE)
    VALUES(''Admin'', ''Modify Settings'', TO_DATE(''11/09/2006 05:53:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/09/2006 05:53:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.BIGROLE_ROLE(BIGROLE, ROLE, CREATEDATE, UPDATEDATE)
    VALUES(''Admin'', ''Base Role'', TO_DATE(''11/09/2006 05:53:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/09/2006 05:53:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into BIGROLE_ROLE'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default USER_DATA data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.USER_DATA(USER_NAME, FIRSTNAME, LASTNAME, EMAIL, PHONE, CREATEDATE, UPDATEDATE, EMPLOYEEID, DEPARTMENT, LOCATION, EXTENSION)
    VALUES(''admin'', ''Super'', ''User'', ''admin@n2bb.com'', NULL, TO_DATE(''18/06/2006 12:27:03 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''18/06/2006 12:27:03 AM'',''DD/MM/YYYY HH12:MI:SS PM''), NULL, NULL, NULL, NULL)';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into USER_DATA'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default USER_BIGROLE data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.USER_BIGROLE(USER_NAME, BIGROLE, CREATEDATE, UPDATEDATE)
    VALUES(''admin'', ''Admin'', TO_DATE(''18/06/2006 12:27:03 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''18/06/2006 12:27:03 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into USER_BIGROLE'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default USERS_REALM data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.USERS_REALM(USER_NAME, USER_PASS, PASSWORD_MODIFIED_DATE, STATUS, CREATEDATE, UPDATEDATE)
    VALUES(''admin'', ''d033e22ae348aeb5660fc2140aec35850c4da997'', TO_DATE(''17/06/2006 05:27:03 PM'',''DD/MM/YYYY HH12:MI:SS PM''), 1, TO_DATE(''18/06/2006 12:27:03 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''18/06/2006 12:27:03 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into USERS_REALM'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default TTV_PROCESSPRIORITY data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSPRIORITY(PROCESSPRIORITYID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(0, ''LOWEST'', TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSPRIORITY(PROCESSPRIORITYID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''LOW'', TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSPRIORITY(PROCESSPRIORITYID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''NORMAL'', TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSPRIORITY(PROCESSPRIORITYID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''HIGH'', TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSPRIORITY(PROCESSPRIORITYID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(4, ''HIGHEST'', TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_PROCESSPRIORITY'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default TTV_PROCESSSTATUS data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(0, ''CREATED'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''RUNNING'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''ERROR'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''PAUSED'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(4, ''QUEUED'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(5, ''CANCELLED'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(6, ''STOPPED'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(7, ''BUSY'', TO_DATE(''21/06/2006 06:16:19 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/06/2006 06:16:19 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID,NAME,CREATEDATE,UPDATEDATE)
    VALUES(8, ''BRANCH'', sysdate, sysdate)';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_PROCESSSTATUS'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default PROCESSINSTANCETYPE data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSINSTANCETYPE(PROCESSINSTANCETYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Standard JBPM ProcessInstance'', TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSINSTANCETYPE(PROCESSINSTANCETYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''TTV ProcessInstance'', TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_PROCESSINSTANCETYPE'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default TTV_TOKENTYPE data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_TOKENTYPE(TOKENTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Standard JBPM Token'', TO_DATE(''15/06/2006 05:39:36 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:39:36 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_TOKENTYPE(TOKENTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''TTV Token'', TO_DATE(''15/06/2006 05:39:36 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:39:36 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_TOKENTYPE'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default TTV_ACCESSLEVEL data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACCESSLEVEL(ACCESSLEVELID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(0, ''NON-ADULT'', TO_DATE(''11/08/2006 06:27:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/08/2006 06:27:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACCESSLEVEL(ACCESSLEVELID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''ADULT'', TO_DATE(''11/08/2006 06:27:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/08/2006 06:27:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACCESSLEVEL(ACCESSLEVELID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''COMMON'', TO_DATE(''11/09/2006 11:12:51 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/09/2006 11:12:51 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_ACCESSLEVEL'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default TTV_VARIABLEACCESSTYPE data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_VARIABLEACCESSTYPE(VARIABLEACCESSTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Standard JBPM VariableAccess'', TO_DATE(''14/09/2006 09:34:00 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''14/09/2006 09:34:51 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_VARIABLEACCESSTYPE(VARIABLEACCESSTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''TTV VariableAccess'', TO_DATE(''14/09/2006 09:34:00 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''14/09/2006 09:34:51 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_VARIABLEACCESSTYPE'')';
              GOTO bypass_install;
      END;
  
      BEGIN
  
                  -- Reinitialize the TTV_VariableAccessType Sequence
          EXECUTE IMMEDIATE 'BEGIN WFS.SP_REINITIALIZESEQUENCE (''TTV_VariableAccessType'', ''VariableAccessTypeId''); END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Problem calling SP_REINITIALIZESEQUENCE for TTV_VariableAccessType'')';
          GOTO bypass_install;
      END;
  
  -- Inserting default TTV_MONITOREDDRIVESTATUS data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MONITOREDDRIVESTATUS(MONITOREDDRIVESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(0, ''OK'', TO_DATE(''27/09/2006 11:07:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''27/09/2006 11:07:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MONITOREDDRIVESTATUS(MONITOREDDRIVESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''WARNING'', TO_DATE(''27/09/2006 11:07:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''27/09/2006 11:07:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MONITOREDDRIVESTATUS(MONITOREDDRIVESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''ERROR'', TO_DATE(''27/09/2006 11:07:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''27/09/2006 11:07:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_MONITOREDDRIVESTATUS'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default TTV_DATATYPE data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''int'', TO_DATE(''05/06/2006 11:09:26 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''05/06/2006 11:09:26 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''string'', TO_DATE(''05/06/2006 11:09:42 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''05/06/2006 11:09:42 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''boolean'', TO_DATE(''05/06/2006 11:09:45 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''05/06/2006 11:09:45 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(4, ''date'', TO_DATE(''19/08/2006 02:37:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/08/2006 02:37:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(5, ''file'', TO_DATE(''19/08/2006 02:37:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/08/2006 02:37:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(6, ''destination'', TO_DATE(''19/08/2006 02:37:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/08/2006 02:37:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(7, ''duration'', TO_DATE(''30/09/2006 03:57:41 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/09/2006 03:57:41 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(8, ''url'', TO_DATE(''15/08/2007 12:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/08/2007 12:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_DATATYPE'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default ALERTS data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Duplicate Parameters'', ''Duplicate Parameters For Workorder Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Resource Initialization Failure'', ''Resource Initialization Failure Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Protection Key Mismatch'', ''Protection Key Mismatch Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Saving Workorder Failed'', ''Workorder Save Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Workorder Failed'', ''Workorder Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Resource Failed'', ''Resource Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Workorder Creation Failed'', ''Create Workorder Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Monitoring System Down'', ''Monitoring System Down Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Duplicate Request For Workorder'', ''Duplicate Request For Workorder Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Database Operation Failed'', ''Database Operation Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE) 
    VALUES (''Invalid Template License'', ''Invalid License for Templates Pattern'', 1,	3600, 1, 3600, ''LOG'')';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into ALERTS'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default ALERT_ACTIONS
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Duplicate Request For Workorder'', 1, ''3'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Resource Initialization Failure'', 1, ''7'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Protection Key Mismatch'', 1, ''5'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Workorder Creation Failed'', 1, ''9'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Workorder Failed'', 1, ''10'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Resource Failed'', 1, ''6'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Database Operation Failed'', 1, ''1'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Duplicate Parameters'', 1, ''2'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Monitoring System Down'', 1, ''4'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Saving Workorder Failed'', 1, ''8'')';

          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL) 
    VALUES (''Invalid Template License'', 1, ''11'')';


  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into ALERT_ACTIONS'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default ALERT_NAMES data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Workorder Failed Pattern'', ''.*execution has failed.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Duplicate Parameters For Workorder Pattern'', ''.*Workorder with same parameters already created in the past.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Monitoring System Down Pattern'', ''.*the Alert System is down.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Create Workorder Failed Pattern'', ''.*Failed to instantiate Work Order.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Duplicate Request For Workorder Pattern'', ''.*with same parameters already received in the past.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Resource Failed Pattern'', ''.*Failure Event for Resource.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Resource Initialization Failure Pattern'', ''.*Initialization Error.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Workorder Save Failed Pattern'', ''.*Failed to save the process.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Database Operation Failed Pattern'', ''.*SQLException.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Protection Key Mismatch Pattern'', ''.*mismatching protection keys.*'')';

	  EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN) 
    VALUES(''Invalid License for Templates Pattern'', ''.*License unavailable for template.*'')';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into ALERT_NAMES'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default TTV_PROCESSDEFINITIONTYPE
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSDEFINITIONTYPE(PROCESSDEFINITIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Standard JBPM ProcessDefinition'', TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSDEFINITIONTYPE(PROCESSDEFINITIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''TTV ProcessDefinition'', TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSDEFINITIONTYPE(PROCESSDEFINITIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''TTV Invisible ProcessDefinition'', TO_DATE(''03/10/2006 07:52:36 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''03/10/2006 07:52:36 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_PROCESSDEFINITIONTYPE'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default TTV_PERMISSION data 
      BEGIN
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Dashboard'', ''DEFAULT'', 1, TO_DATE(''12/08/2006 02:13:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''18/08/2006 09:35:13 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(2, ''View'', ''View Work Orders'', 2, TO_DATE(''12/08/2006 02:13:21 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''12/08/2006 02:13:21 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(3, ''Create'', ''Create Work Orders'', 2, TO_DATE(''12/08/2006 02:13:43 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''12/08/2006 02:13:43 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(4, ''Modify'', ''Update Work Orders'', 2, TO_DATE(''12/08/2006 02:33:50 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''12/08/2006 02:33:50 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(5, ''Delete'', ''Delete Work Orders'', 2, TO_DATE(''12/08/2006 03:08:35 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''12/08/2006 03:08:35 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(6, ''View'', ''View Resources'', 3, TO_DATE(''14/08/2006 10:24:23 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''14/08/2006 10:24:23 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(7, ''Create'', ''Create Resources'', 3, TO_DATE(''14/08/2006 10:24:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''14/08/2006 10:24:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(8, ''Modify'', ''Update Resources'', 3, TO_DATE(''14/08/2006 10:24:57 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''14/08/2006 10:24:57 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(9, ''Delete'', ''Delete Resources'', 3, TO_DATE(''14/08/2006 10:25:16 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''14/08/2006 10:25:16 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(10, ''View'', ''View User List'', 4, TO_DATE(''18/08/2006 06:43:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''18/08/2006 06:43:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(11, ''Create'', ''Create User'', 4, TO_DATE(''18/08/2006 06:43:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''18/08/2006 06:43:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(12, ''Modify'', ''Update User'', 4, TO_DATE(''18/08/2006 06:43:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''18/08/2006 06:44:05 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(13, ''Delete'', ''Delete User'', 4, TO_DATE(''18/08/2006 06:43:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''18/08/2006 06:43:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(14, ''View'', ''View Roles'', 5, TO_DATE(''18/08/2006 06:45:27 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''18/08/2006 06:45:27 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(15, ''Create'', ''Create Role'', 5, TO_DATE(''18/08/2006 06:45:27 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''18/08/2006 06:45:27 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(16, ''Modify'', ''Update Role'', 5, TO_DATE(''18/08/2006 06:45:27 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''18/08/2006 06:45:27 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(17, ''Delete'', ''Delete Role'', 5, TO_DATE(''18/08/2006 06:45:27 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''18/08/2006 06:45:27 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(18, ''Perform Task'', ''Perform Task'', 6, TO_DATE(''18/08/2006 09:36:39 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''18/08/2006 09:36:39 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(19, ''Perform Other''''s Tasks'', ''Perform Tasks'', 6, TO_DATE(''18/08/2006 09:36:39 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''18/08/2006 09:36:39 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(20, ''View'', ''View Alerts'', 7, TO_DATE(''29/08/2006 06:08:31 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''29/08/2006 06:08:31 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(21, ''Create'', ''Create Alerts'', 7, TO_DATE(''29/08/2006 06:08:55 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''29/08/2006 06:08:55 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(22, ''Modify'', ''Modify Alerts'', 7, TO_DATE(''29/08/2006 06:09:23 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''29/08/2006 06:09:23 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(23, ''Delete'', ''Delete Alerts'', 7, TO_DATE(''29/08/2006 08:36:02 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''29/08/2006 08:36:02 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(24, ''View'', ''View Report'', 8, TO_DATE(''20/10/2006 08:36:02 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''20/10/2006 08:36:02 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
            EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PERMISSION(PERMISSIONID, NAME, SECTIONNAME, MODULEID, CREATEDATE, UPDATEDATE)
    VALUES(25, ''View'', ''Plugins'', 9, TO_DATE(''15/08/2007 12:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/08/2007 12:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_PERMISSION'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default TTV_MENUITEM data 
      BEGIN
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(1, ''TabbedHome'', 1, TO_DATE(''12/08/2006 02:32:21 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''12/08/2006 02:32:21 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(2, ''TabbedWorkOrders'', 2, TO_DATE(''12/08/2006 02:32:33 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''12/08/2006 02:32:33 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(3, ''TabbedWorkOrderSearch'', 2, TO_DATE(''12/08/2006 02:33:11 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''12/08/2006 02:33:11 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(4, ''TabbedWorkOrdersCreate'', 3, TO_DATE(''12/08/2006 02:33:30 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''12/08/2006 02:33:30 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(5, ''TabbedWorkOrdersPauseAllResumeAll'', 4, TO_DATE(''12/08/2006 02:34:37 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''12/08/2006 02:34:37 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(6, ''TabbedResources'', 6, TO_DATE(''14/08/2006 10:58:31 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''14/08/2006 10:58:31 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(7, ''TabbedList'', 6, TO_DATE(''14/08/2006 10:59:08 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''14/08/2006 10:59:08 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(8, ''TabbedCreate'', 7, TO_DATE(''15/08/2006 11:31:48 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/08/2006 11:31:48 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(9, ''TabbedModify'', 7, TO_DATE(''15/08/2006 11:31:48 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/08/2006 11:31:48 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(10, ''TabbedUsers'', 10, TO_DATE(''25/08/2006 07:41:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''25/08/2006 07:41:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(11, ''TabbedUsersView'', 10, TO_DATE(''25/08/2006 07:44:07 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''25/08/2006 07:44:07 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(12, ''TabbedUsersCreate'', 11, TO_DATE(''25/08/2006 07:45:04 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''25/08/2006 07:45:04 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(13, ''TabbedUsersModify'', 12, TO_DATE(''25/08/2006 07:45:32 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''25/08/2006 07:45:32 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(14, ''TabbedRoles'', 14, TO_DATE(''25/08/2006 07:50:19 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''25/08/2006 07:50:19 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(15, ''TabbedRolesView'', 14, TO_DATE(''25/08/2006 07:50:53 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''25/08/2006 07:50:53 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(16, ''TabbedRolesCreate'', 15, TO_DATE(''25/08/2006 07:51:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''25/08/2006 07:51:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(17, ''TabbedRolesModify'', 16, TO_DATE(''25/08/2006 07:51:47 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''25/08/2006 07:51:47 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(18, ''TabbedAlertList'', 20, TO_DATE(''29/08/2006 06:12:11 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''29/08/2006 06:12:11 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(19, ''TabbedAlertsCreate'', 21, TO_DATE(''29/08/2006 06:35:58 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''29/08/2006 06:35:58 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(20, ''TabbedAlertPatternList'', 20, TO_DATE(''29/08/2006 06:38:55 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''29/08/2006 06:38:55 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(21, ''TabbedQueue'', 6, TO_DATE(''25/08/2006 05:42:12 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''25/08/2006 05:42:12 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(22, ''TabbedAlertPatternCreate'', 21, TO_DATE(''29/08/2006 06:39:18 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''29/08/2006 06:39:18 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(23, ''TabbedAlertHistory'', 20, TO_DATE(''29/08/2006 06:39:43 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''29/08/2006 06:39:43 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(24, ''TabbedMonitoring'', 20, TO_DATE(''29/08/2006 07:15:35 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''29/08/2006 07:15:35 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(25, ''TabbedAlertsModify'', 22, TO_DATE(''29/08/2006 08:39:01 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''29/08/2006 08:39:01 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(26, ''TabbedAlertPatternModify'', 22, TO_DATE(''29/08/2006 09:04:17 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''29/08/2006 09:04:17 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(27, ''TabbedWorkOrdersTemplateDetails'', 2, TO_DATE(''03/10/2006 07:12:48 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''03/10/2006 07:12:48 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(28, ''TabbedUserTasks'', 18, TO_DATE(''03/10/2006 07:12:48 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''03/10/2006 07:12:48 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(29, ''TabbedUserTasksList'', 19, TO_DATE(''03/10/2006 07:12:48 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''03/10/2006 07:12:48 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(30, ''TabbedRepositoryBrowsing'', 20, TO_DATE(''14/10/2006 01:19:39 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''14/10/2006 01:19:39 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(41, ''TabbedReporting'', 24, TO_DATE(''14/10/2006 01:19:39 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''14/10/2006 01:19:39 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(42, ''TabbedReportingList'', 24, TO_DATE(''14/10/2006 01:19:39 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''14/10/2006 01:19:39 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MENUITEM(MENUITEMID, NAME, PERMISSIONID, CREATEDATE, UPDATEDATE)
    VALUES(43, ''TabbedPlugins'', 25, TO_DATE(''15/08/2007 12:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/08/2007 12:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';  
    
          EXECUTE IMMEDIATE 'insert into WFS.TTV_MENUITEM (MENUITEMID, NAME, PERMISSIONID)
    values (44, ''TabbedResourceTypePlugins'',(select PERMISSIONID from WFS.TTV_PERMISSION where NAME = ''View'' and SECTIONNAME = ''Plugins''))';
    
          EXECUTE IMMEDIATE 'insert into WFS.TTV_MENUITEM (MENUITEMID, NAME, PERMISSIONID)
    values (45,''TabbedResourceGroupPlugins'',(select PERMISSIONID from WFS.TTV_PERMISSION where NAME = ''View'' and SECTIONNAME = ''Plugins''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_MENUITEM'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default TTV_ACTION data 
      BEGIN
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(1, ''View Dashboard'', 1, ''dashboardview.do?method=getDashBoard'', TO_DATE(''12/08/2006 02:14:22 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 08:44:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(2, ''List Work Orders'', 2, ''workOrderDetailsAction.do?method=getWorkOrdersBySearch'', TO_DATE(''12/08/2006 02:14:44 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 08:44:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(3, ''List Work Orders by Status'', 2, ''workOrderSearch.do?method=getWorkOrderSearchPage'', TO_DATE(''12/08/2006 02:15:11 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 08:44:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(4, ''Create Work Order'', 3, ''wfsprocess.do?method=createWorkOrder'', TO_DATE(''12/08/2006 02:15:33 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 08:44:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(5, ''Pause Work Order'', 4, ''workorderview.do?method=pauseWorkOrder'', TO_DATE(''12/08/2006 02:35:23 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 08:44:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(6, ''Resume Work Order'', 4, ''workorderview.do?method=resumeWorkOrder'', TO_DATE(''12/08/2006 02:36:02 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 08:44:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(7, ''Cancel Work Order'', 4, ''workorderview.do?method=cancelWorkOrder'', TO_DATE(''12/08/2006 02:36:30 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 08:44:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(8, ''Change Work Order Priority'', 4, ''workorderview.do?method=saveWorkOrder'', TO_DATE(''12/08/2006 02:36:46 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 08:44:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(9, ''Pause All Work Orders'', 4, ''pauseResumeAction.do?method=pauseAllWorkOrder'', TO_DATE(''12/08/2006 02:37:14 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 08:44:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(10, ''Resume All Work Orders'', 4, ''pauseResumeAction.do?method=resumeAllWorkOrder'', TO_DATE(''12/08/2006 02:37:27 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 08:44:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(11, ''Delete Work Order'', 5, ''workorderview.do?method=deleteWorkOrder'', TO_DATE(''17/08/2006 11:25:38 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 08:44:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(12, ''Dashboard Internal'', 1, ''setPermissions.do'', TO_DATE(''19/08/2006 02:27:02 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 08:44:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(13, ''View Work Order'', 2, ''workorderview.do?method=getWorkOrder'', TO_DATE(''19/08/2006 03:23:52 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 08:44:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(14, ''Create Work Order Page'', 3, ''wfsprocess.do?method=createWorkOrderSetup'', TO_DATE(''19/08/2006 03:24:55 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 08:44:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(15, ''Pause and Resume All Login'', 4, ''pauseResumeAction.do?method=goToLogin'', TO_DATE(''19/08/2006 03:30:18 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 08:44:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(16, ''View Work Order Steps'', 2, ''workOrderTask.do?method=getWorkOrderTask'', TO_DATE(''19/08/2006 03:36:02 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 08:44:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(17, ''Search Work Orders Page'', 2, ''workOrderSearch.do?method=getWorkOrderSearchPage'', TO_DATE(''19/08/2006 04:16:35 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''22/08/2006 01:24:42 AM'',''DD/MM/YYYY HH12:MI:SS PM''))'; 
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(18, ''Resume Selected Work Orders'', 4, ''workOrderDetailsAction.do?method=resumeSelectedWorkOrders'', TO_DATE(''19/08/2006 04:18:13 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 08:44:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))'; 
  
         EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(19, ''Pause Selected Work Orders'', 4, ''workOrderDetailsAction.do?method=pauseSelectedWorkOrders'', TO_DATE(''19/08/2006 04:18:13 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 08:44:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(20, ''View Resources'', 6, ''resourcesListManagement.do?method=getResourcesList'', TO_DATE(''21/08/2006 09:14:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 09:14:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(21, ''View Resource'', 6, ''resourceManagement.do?method=getResourceDetails'', TO_DATE(''21/08/2006 09:14:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 09:14:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(22, ''View Resource Type'', 7, ''resourceManagement.do?method=getResourceTypeDetails'', TO_DATE(''21/08/2006 09:14:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''27/09/2006 09:04:28 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(23, ''Take Resource Offline'', 8, ''resourceManagement.do?method=setResourceOffline'', TO_DATE(''21/08/2006 09:14:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 09:14:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(24, ''Update Resource'', 8, ''resourceManagement.do?method=updateResource'', TO_DATE(''21/08/2006 09:14:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 05:38:24 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(26, ''Set Resources Offline'', 8, ''resourceManagement.do?method=setMultipleResourceOffline'', TO_DATE(''21/08/2006 09:14:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 09:14:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(27, ''Create Resource'', 7, ''resourceManagement.do?method=createResource'', TO_DATE(''21/08/2006 09:14:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 09:14:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(28, ''Delete Resource'', 9, ''resourceManagement.do?method=deleteResource'', TO_DATE(''21/08/2006 09:14:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 09:14:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(29, ''Delete Resources'', 9, ''resourceManagement.do?method=deleteResources'', TO_DATE(''21/08/2006 09:14:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/08/2006 09:14:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(30, ''View Template List'', 2, ''wfsprocess.do?method=selectTemplate'', TO_DATE(''22/08/2006 01:22:33 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''22/08/2006 01:22:33 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(31, ''Search Work Orders'', 2, ''workOrderSearch.do?method=getWorkOrdersBySearch'', TO_DATE(''22/08/2006 01:24:42 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''22/08/2006 01:24:42 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(32, ''View Resource Group'', 6, ''resourceGroupQueueManagement.do?method=getResourceGroupQueue'', TO_DATE(''25/08/2006 05:42:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''25/08/2006 05:42:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
         EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(33, ''View Alerts'', 20, ''checkAlertServerStatus.do?method=toListAlerts'', TO_DATE(''31/08/2006 01:18:40 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 12:42:09 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(34, ''Create Alert'', 21, ''checkAlertServerStatus.do?method=toCreateAlert'', TO_DATE(''31/08/2006 01:19:30 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 12:47:06 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
         EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(35, ''Modify Alert'', 22, ''checkAlertServerStatus.do?method=toEditAlert'', TO_DATE(''31/08/2006 01:20:26 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 12:48:24 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(36, ''Delete Alert'', 23, ''checkAlertServerStatus.do?method=toModifyAlerts'', TO_DATE(''31/08/2006 01:23:17 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 12:49:41 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(37, ''View Alert Patterns'', 20, ''checkAlertServerStatus.do?method=toListAlertPatterns'', TO_DATE(''31/08/2006 01:24:13 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 12:56:03 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(38, ''Create Alert Pattern'', 21, ''checkAlertServerStatus.do?method=toCreateAlertPattern'', TO_DATE(''31/08/2006 01:25:18 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 01:01:39 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(39, ''Modify Alert Pattern'', 23, ''checkAlertServerStatus.do?method=toEditAlertPattern'', TO_DATE(''31/08/2006 01:27:39 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 01:02:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(40, ''Delete Alert Pattern'', 23, ''checkAlertServerStatus.do?method=toModifyAlertPatterns'', TO_DATE(''31/08/2006 01:28:28 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 01:03:22 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(41, ''View Alert History'', 20, ''checkAlertServerStatus.do?method=toListAlertHistory'', TO_DATE(''31/08/2006 01:29:19 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 01:07:07 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(42, ''View Detailed History'', 20, ''checkAlertServerStatus.do?method=toAlertHistoryDetail'', TO_DATE(''31/08/2006 01:30:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 01:11:11 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(43, ''Save Alerts'', 21, ''checkAlertServerStatus.do?method=toSaveCreatedAlert'', TO_DATE(''31/08/2006 01:30:59 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 12:53:08 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(44, ''Save Alert Patterns'', 21, ''checkAlertServerStatus.do?method=toSaveCreatedAlertPattern'', TO_DATE(''31/08/2006 01:31:32 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 01:05:25 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(45, ''View Other User Tasks'', 19, ''userTasksAction.do?method=getUserTasks'', TO_DATE(''31/08/2006 10:59:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''31/08/2006 10:59:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(46, ''Perform User Task'', 18, ''wfstask.do?method=saveAndCloseTask'', TO_DATE(''31/08/2006 11:00:08 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''31/08/2006 11:00:08 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(47, ''View User Task'', 18, ''wfstask.do?method=selectTaskInstance'', TO_DATE(''31/08/2006 11:00:30 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''31/08/2006 11:00:30 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(48, ''View User Tasks'', 18, ''userTasksAction.do?method=getUserTasks'', TO_DATE(''31/08/2006 11:00:50 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''31/08/2006 11:00:50 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(49, ''Resource Queue Move To Top'', 8, ''resourceGroupQueueManagement.do?method=moveToTop'', TO_DATE(''31/08/2006 11:25:05 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''31/08/2006 11:25:05 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(50, ''Resource Queue Move To Bottom'', 8, ''resourceGroupQueueManagement.do?method=moveToBottom'', TO_DATE(''31/08/2006 11:25:58 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''31/08/2006 11:25:58 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
           EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(51, ''Resource Queue Move To Up'', 8, ''resourceGroupQueueManagement.do?method=moveUp'', TO_DATE(''31/08/2006 11:26:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''31/08/2006 11:26:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(52, ''Resource Queue Move To Down'', 8, ''resourceGroupQueueManagement.do?method=moveDown'', TO_DATE(''31/08/2006 11:27:19 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''31/08/2006 11:27:19 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(53, ''View Roles'', 14, ''listRoles.do'', TO_DATE(''01/09/2006 01:06:57 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''01/09/2006 01:06:57 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(54, ''View Role Details'', 14, ''editRole.do'', TO_DATE(''01/09/2006 01:08:39 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''01/09/2006 01:08:39 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(55, ''Create Role'', 15, ''addRole.do'', TO_DATE(''01/09/2006 01:18:59 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''01/09/2006 01:19:59 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(56, ''Save Role'', 15, ''saveRole.do?method=create'', TO_DATE(''01/09/2006 01:21:07 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''01/09/2006 01:21:07 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(57, ''Update Role'', 16, ''saveRole.do?method=update'', TO_DATE(''01/09/2006 01:22:38 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''01/09/2006 01:22:38 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(58, ''Delete Roles'', 17, ''modifyRoles.do'', TO_DATE(''01/09/2006 01:24:09 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''01/09/2006 01:24:09 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(59, ''View Users'', 10, ''listUsers.do'', TO_DATE(''01/09/2006 01:25:38 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''01/09/2006 01:25:38 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(60, ''View User Details'', 10, ''editUser.do'', TO_DATE(''01/09/2006 01:26:38 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''01/09/2006 01:26:38 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(61, ''Create User'', 11, ''addUser.do'', TO_DATE(''01/09/2006 01:28:16 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''01/09/2006 01:28:16 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(62, ''Save User'', 11, ''saveUser.do?method=create'', TO_DATE(''01/09/2006 01:29:16 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''01/09/2006 01:29:16 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(63, ''Update User'', 12, ''saveUser.do?method=update'', TO_DATE(''01/09/2006 01:30:06 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''01/09/2006 01:30:06 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(64, ''Users status change'', 12, ''modifyUsers.do?method=changeStatus'', TO_DATE(''01/09/2006 01:31:38 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''01/09/2006 01:33:01 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(65, ''Delete Users'', 13, ''modifyUsers.do?method=delete'', TO_DATE(''01/09/2006 01:33:01 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''01/09/2006 01:33:01 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
           EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(66, ''Save Alerts'', 22, ''checkAlertServerStatus.do?method=toSaveModifiedAlert'', TO_DATE(''01/09/2006 04:39:12 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 01:54:55 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(67, ''Save Alert Patterns'', 22, ''checkAlertServerStatus.do?method=toSaveModifiedAlertPattern'', TO_DATE(''01/09/2006 04:40:01 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 01:06:10 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(68, ''View Template Details'', 2, ''viewtemplate.do'', TO_DATE(''27/09/2006 10:15:00 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''27/09/2006 10:15:00 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(69, ''Restart Selected Work Orders'', 4, ''workOrderDetailsAction.do?method=restartSelectedWorkOrders'', TO_DATE(''27/09/2006 10:18:01 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''27/09/2006 10:48:33 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(70, ''Retry Selected  Work Orders'', 4, ''workOrderDetailsAction.do?method=retrySelectedWorkOrders'', TO_DATE(''27/09/2006 10:19:35 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''27/09/2006 10:48:49 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(71, ''Cancel Selected Work Orders'', 4, ''workOrderDetailsAction.do?method=cancelSelectedWorkOrders'', TO_DATE(''27/09/2006 10:22:28 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''27/09/2006 10:22:28 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(72, ''Delete Selected Work Orders'', 5, ''workOrderDetailsAction.do?method=deleteSelectedWorkOrders'', TO_DATE(''27/09/2006 10:43:37 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''27/09/2006 10:43:37 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(73, ''Restart Work Order'', 4, ''workorderview.do?method=restartWorkOrder'', TO_DATE(''27/09/2006 10:48:15 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''27/09/2006 10:48:15 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(74, ''View Work Order Task Details'', 2, ''workOrderTaskDetails.do?method=getWorkOrderTaskDetails'', TO_DATE(''27/09/2006 11:57:04 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''27/09/2006 11:57:04 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(75, ''Alert System Down'', 20, ''checkAlertServerStatus.do?method=toSystemDown'', TO_DATE(''28/09/2006 01:14:52 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 01:14:52 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(76, ''Report Alerts'', 20, ''checkAlertServerStatus.do?method=toReportAlerts'', TO_DATE(''28/09/2006 01:18:44 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 01:19:58 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(77, ''Report Alert Patterns'', 20, ''checkAlertServerStatus.do?method=toReportAlertPatterns'', TO_DATE(''28/09/2006 01:19:58 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 01:19:58 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(78, ''Filter Alert History'', 20, ''checkAlertServerStatus.do?method=toFilterAlertHistory'', TO_DATE(''28/09/2006 01:20:45 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 01:20:45 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(79, ''Report Alert History'', 20, ''checkAlertServerStatus.do?method=toReportAlertsHistory'', TO_DATE(''28/09/2006 01:21:20 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 01:21:20 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(80, ''View Alerts'', 20, ''listAlertPatterns.do'', TO_DATE(''28/09/2006 02:00:41 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 02:00:41 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(81, ''Retry Work Order'', 4, ''workorderview.do?method=retryWorkOrder'', TO_DATE(''28/09/2006 02:07:48 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 02:07:48 AM'',''DD/MM/YYYY HH12:MI:SS PM''))'; 
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(82, ''Bring Resources Online'', 8, ''resourceManagement.do?method=bringMultipleResourcesOnline'', TO_DATE(''28/09/2006 05:37:14 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 05:37:14 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(83, ''Bring Resource Online'', 8, ''resourceManagement.do?method=bringResourceOnline'', TO_DATE(''28/09/2006 05:37:14 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/09/2006 05:37:14 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(84, ''Save User Task'', 18, ''wfstask.do?method=saveTask'', TO_DATE(''29/09/2006 06:25:42 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''29/09/2006 06:25:42 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(85, ''Report Users'', 10, ''modifyUsers.do'', TO_DATE(''29/09/2006 09:50:15 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''29/09/2006 09:50:15 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(86, ''Repository Browser'', 20, ''repositoryBrowsing.do?method=getRepository'', TO_DATE(''20/10/2006 01:50:15 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''20/10/2006 09:50:15 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(87, ''View Report'', 24, ''reports.do?method=getReportsList'', TO_DATE(''20/10/2006 01:50:15 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''20/10/2006 09:50:15 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACTION(ACTIONID, NAME, PERMISSIONID, PATH, CREATEDATE, UPDATEDATE)
    VALUES(91, ''Update Resource Group Queue UI Visiblity'', 8, ''resourceGroupQueueManagement.do?method=updateUIVisibility'', TO_DATE(''15/08/2007 12:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/08/2007 12:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'insert into WFS.TTV_ACTION (ACTIONID, NAME, PERMISSIONID, PATH)
    values(92, ''View Resource Type Plugins'',(select PERMISSIONID from WFS.TTV_PERMISSION where NAME = ''View'' and SECTIONNAME = ''Plugins''),''plugins.do?method=getResourceTypePlugins'')';
    
          EXECUTE IMMEDIATE 'insert into WFS.TTV_ACTION (ACTIONID, NAME, PERMISSIONID, PATH)
    values(93, ''Sort Resource Type Plugins'',(select PERMISSIONID from WFS.TTV_PERMISSION where NAME = ''View'' and SECTIONNAME = ''Plugins''),''plugins.do?method=sortResourceTypePlugins'')';
    
          EXECUTE IMMEDIATE 'insert into WFS.TTV_ACTION (ACTIONID, NAME, PERMISSIONID, PATH)
    values(94, ''View Resource Group Plugins'',(select PERMISSIONID from WFS.TTV_PERMISSION where NAME = ''View'' and SECTIONNAME = ''Plugins''),''plugins.do?method=getResourceGroupPlugins'')';
    
          EXECUTE IMMEDIATE 'insert into WFS.TTV_ACTION (ACTIONID, NAME, PERMISSIONID, PATH)
    values(95, ''Sort Resource Group Plugins'',(select PERMISSIONID from WFS.TTV_PERMISSION where NAME = ''View'' and SECTIONNAME = ''Plugins''),''plugins.do?method=sortResourceGroupPlugins'')';
    
          EXECUTE IMMEDIATE 'insert into WFS.TTV_ACTION (ACTIONID, NAME, PERMISSIONID, PATH)
    values(96,''Image Fetcher'',(select PERMISSIONID from WFS.TTV_PERMISSION where NAME = ''View'' and SECTIONNAME = ''View Work Orders''),''imageFetcher.do'')';
       
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_ACTION'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default TTV_BIGROLEPERMISSION data 
      BEGIN
  
         EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(1, 1, ''Admin'', TO_DATE(''12/08/2006 02:46:17 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(2, 2, ''Admin'', TO_DATE(''12/08/2006 02:46:58 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(3, 3, ''Admin'', TO_DATE(''12/08/2006 02:46:58 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(4, 4, ''Admin'', TO_DATE(''12/08/2006 02:46:58 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
         EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(5, 5, ''Admin'', TO_DATE(''12/08/2006 04:41:44 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(6, 6, ''Admin'', TO_DATE(''14/08/2006 11:00:01 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(7, 7, ''Admin'', TO_DATE(''14/08/2006 11:00:14 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(8, 8, ''Admin'', TO_DATE(''21/08/2006 09:39:54 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(9, 9, ''Admin'', TO_DATE(''21/08/2006 09:39:54 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(10, 10, ''Admin'', TO_DATE(''25/08/2006 07:54:21 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(11, 11, ''Admin'', TO_DATE(''25/08/2006 07:55:23 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(12, 12, ''Admin'', TO_DATE(''25/08/2006 07:55:29 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
            EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(13, 13, ''Admin'', TO_DATE(''25/08/2006 07:55:35 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(14, 14, ''Admin'', TO_DATE(''25/08/2006 07:55:41 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(15, 15, ''Admin'', TO_DATE(''25/08/2006 07:55:53 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(16, 16, ''Admin'', TO_DATE(''25/08/2006 07:56:00 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(17, 17, ''Admin'', TO_DATE(''25/08/2006 07:56:07 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
           EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(25, 25, ''Admin'', TO_DATE(''15/08/2007 12:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
            EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(300, 18, ''Admin'', TO_DATE(''29/08/2006 01:47:46 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(301, 19, ''Admin'', TO_DATE(''29/08/2006 01:48:08 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(302, 20, ''Admin'', TO_DATE(''29/08/2006 06:46:23 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(303, 21, ''Admin'', TO_DATE(''29/08/2006 06:46:39 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(305, 22, ''Admin'', TO_DATE(''29/08/2006 06:48:15 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(319, 23, ''Admin'', TO_DATE(''30/08/2006 10:26:35 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_BIGROLEPERMISSION(BIGROLEPERMISSIONID, PERMISSIONID, BIGROLE, CREATEDATE)
    VALUES(441, 24, ''Admin'', TO_DATE(''20/10/2006 10:26:35 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_BIGROLEPERMISSION'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default TTV_RESOURCESTATUSID data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Initializing'', TO_DATE(''20/06/2006 01:14:40 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''20/06/2006 01:15:08 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''Online'', TO_DATE(''20/06/2006 01:14:45 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''20/06/2006 01:15:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''Offline'', TO_DATE(''20/06/2006 01:14:54 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''20/06/2006 01:14:54 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(4, ''Initialization Error'', TO_DATE(''20/06/2006 01:15:14 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''23/06/2006 04:12:45 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(5, ''HeartBeat Error'', TO_DATE(''23/06/2006 04:12:50 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''23/06/2006 04:12:50 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS (RESOURCESTATUSID, NAME)
    VALUES (6, ''Error'')';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS (RESOURCESTATUSID, NAME)
    VALUES (7, ''Inactive'')';
    
            EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS (RESOURCESTATUSID, NAME)
    VALUES (8, ''Invalid'')';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_RESOURCESTATUS'')';
              GOTO bypass_install;
      END;
  
  -- Inserting default TTV_STRATEGYCLASS data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(1, ''XPort Initialization'', ''Initializes the XPort Subsystem'', ''com.tandbergtv.workflow.resourcemanager.mgmt.initialization.XPortInitializationStrategy'', 1, 
           TO_DATE(''15/06/2006 05:39:01 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/07/2006 01:46:37 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(2, ''VTPS Ping HeartBeat'', ''Sends periodic Ping messages to the VTPS Subsystem'', ''com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.VTPSHeartBeatStrategy'', 2, 
           TO_DATE(''15/06/2006 05:39:01 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/07/2006 01:47:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(3, ''Default Resource Allocation'', ''Allocates resources within the Resource Group'', ''com.tandbergtv.workflow.resourcemanager.mgmt.allocation.DefaultResourceAllocationStrategy'', 3, 
           TO_DATE(''15/06/2006 05:39:01 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/07/2006 01:47:29 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(5, ''Round Robin Resource Allocation'', ''Allocates resources within the Resource Group using Round Robin'', ''com.tandbergtv.workflow.resourcemanager.mgmt.allocation.RoundRobinResourceAllocationStrategy'', 3, 
           TO_DATE(''12/07/2006 11:49:07 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/07/2006 01:48:02 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
           EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(6, ''Anystream Transcode Initialization'', ''Initializes the Anystream Subsystem'', ''com.tandbergtv.workflow.resourcemanager.mgmt.initialization.AnystreamInitializationStrategy'', 1, 
           TO_DATE(''12/09/2006 11:05:31 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''22/09/2006 07:30:17 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
           EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(7, ''Webservice HeartBeat'', ''HeartBeats for any subsystem that interfaces with a Webservice'', ''com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.WebserviceHeartBeatStrategy'', 2, 
           TO_DATE(''22/09/2006 07:29:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''22/09/2006 07:29:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
           EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(8, ''XPort HeartBeat'', ''HeartBeats for XPort producer'', ''com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.XPortHeartBeatStrategy'', 2, 
           TO_DATE(''29/11/2006 07:29:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''22/09/2006 07:29:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
           EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(9, ''Anystream Heartbeat'', ''Heartbeats for Anystream Agility Transcoder'', ''com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.AnystreamHeartBeatStrategy'', 2, 
           TO_DATE(''29/11/2006 07:29:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''22/09/2006 07:29:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_STRATEGYCLASS'')';
              GOTO bypass_install;
      END;
  
      -- Insert Default TTV_TRANSITIONTYPE   
      BEGIN
      
        EXECUTE IMMEDIATE 'Insert Into WFS.TTV_TRANSITIONTYPE(TRANSITIONTYPEID, NAME,CREATEDATE,UPDATEDATE)
          Values(1,''JBPM Standard Transition'',systimestamp,systimestamp)';
  
        EXECUTE IMMEDIATE 'Insert into WFS.TTV_TRANSITIONTYPE(TRANSITIONTYPEID, NAME,CREATEDATE,UPDATEDATE)
          Values(2,''TTV Transition'',systimestamp,systimestamp)';
          
      EXCEPTION
        WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to insert data into TTV_TRANSITIONTYPE'')';
          GOTO bypass_install;
          
      END;
      
      -- Inserting into table 'SYSTEM_SETTINGS'
      BEGIN
      
        EXECUTE IMMEDIATE 'INSERT INTO wfs.SYSTEM_SETTINGS values (''RELEASE'',''2.5'')';
        
      EXCEPTION 
        WHEN OTHERS THEN
        
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
             (''error inserting SYSTEM_SETTINGS data'')';
          GOTO bypass_install;
               
      END;
      
  /*
  -----------------------------------------
   CREATING FOREIGN KEY ON ALL TABLES
  -----------------------------------------
  */
  
    -- Creating Foreign Key on ALERTS
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.ALERTS ADD (
                                      CONSTRAINT ALERTS#ALERT_NAMES
                                          FOREIGN KEY (ALERT_NAME) 
                                          REFERENCES WFS.ALERT_NAMES (ALERT_NAME))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for ALERTS'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on ALERT_ACTIONS
    BEGIN
    
          EXECUTE IMMEDIATE 'ALTER TABLE WFS.ALERT_ACTIONS ADD (
                                      CONSTRAINT ALERT_ACTIONS#ALERTS 
                                          FOREIGN KEY (IDENTIFIER) 
                                          REFERENCES WFS.ALERTS (IDENTIFIER))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for ALERT_ACTIONS'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on ALERT_ACTIONS_HIST
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.ALERT_ACTIONS_HIST ADD (
                                  CONSTRAINT ALERT_ACTIONS_HIST#ALERTS_HIST 
                                          FOREIGN KEY (HIST_KEY) 
                                          REFERENCES WFS.ALERTS_HIST (HIST_KEY))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for ALERT_ACTIONS_HIST'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on BIGROLE_ROLE
    BEGIN
  
          EXECUTE IMMEDIATE 'ALTER TABLE WFS.BIGROLE_ROLE
          ADD ( CONSTRAINT FK_BIGROLE_ROLE_BIGROLE
          FOREIGN KEY(BIGROLE)
          REFERENCES WFS.BIGROLE(BIGROLE))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for BIGROLE_ROLE'')';
              GOTO bypass_install;
              
       END;    
  
    -- Creating Foreign Key on JBPM_ACTION
    BEGIN
    
          EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_ACTION ADD (
                                  CONSTRAINT JBPM_ACTION#JBPM_ACTION1
                                          FOREIGN KEY (TIMERACTION_) 
                                          REFERENCES WFS.JBPM_ACTION (ID_),
                                  CONSTRAINT JBPM_ACTION#JBPM_ACTION2 
                                          FOREIGN KEY (REFERENCEDACTION_) 
                                          REFERENCES WFS.JBPM_ACTION (ID_),
                                  CONSTRAINT JBPM_ACTION#JBPM_PDEFINITION 
                                          FOREIGN KEY (PROCESSDEFINITION_) 
                                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_),
                                  CONSTRAINT JBPM_ACTION#JBPM_EHANDLER 
                                          FOREIGN KEY (EXCEPTIONHANDLER_) 
                                          REFERENCES WFS.JBPM_EXCEPTIONHANDLER (ID_),
                                  CONSTRAINT JBPM_ACTION#JBPM_EVENT 
                                          FOREIGN KEY (EVENT_) 
                                          REFERENCES WFS.JBPM_EVENT (ID_),
                                  CONSTRAINT JBPM_ACTION#JBPM_DELEGATION 
                                          FOREIGN KEY (ACTIONDELEGATION_) 
                                          REFERENCES WFS.JBPM_DELEGATION (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_ACTION'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_BYTEARRAY
    BEGIN
          
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_BYTEARRAY ADD (
                                  CONSTRAINT JBPM_BYTEARRAY#JBPM_MDEFINITN
                                          FOREIGN KEY (FILEDEFINITION_)
                                          REFERENCES WFS.JBPM_MODULEDEFINITION (ID_))';
  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_BYTEARRAY'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_BYTEBLOCK
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_BYTEBLOCK ADD (
                                  CONSTRAINT JBPM_BYTEBLOCK#JBPM_BYTEARRAY 
                                          FOREIGN KEY (PROCESSFILE_) 
                                          REFERENCES WFS.JBPM_BYTEARRAY (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_BYTEBLOCK'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_COMMENT
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_COMMENT ADD (
                                  CONSTRAINT JBPM_COMMENT#JBPM_TASKINSTANCE 
                                          FOREIGN KEY (TASKINSTANCE_) 
                                          REFERENCES WFS.JBPM_TASKINSTANCE (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_COMMENT'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_DELEGATION
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_DELEGATION ADD (
                                  CONSTRAINT JBPM_DELEGATION#JBPM_PDEF 
                                          FOREIGN KEY (PROCESSDEFINITION_) 
                                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_DELEGATION'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_EVENT
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_EVENT ADD (
                                  CONSTRAINT JBPM_EVENT#JBPM_TRANSITION 
                                          FOREIGN KEY (TRANSITION_) 
                                          REFERENCES WFS.JBPM_TRANSITION (ID_),
                                  CONSTRAINT JBPM_EVENT#JBPM_TASK 
                                          FOREIGN KEY (TASK_) 
                                          REFERENCES WFS.JBPM_TASK (ID_),
                                  CONSTRAINT JBPM_EVENT#JBPM_PDEFINITION 
                                          FOREIGN KEY (PROCESSDEFINITION_) 
                                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_EVENT'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_ID_GROUP
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_ID_GROUP ADD (
                                  CONSTRAINT JBPM_ID_GROUP#JBPM_ID_GROUP 
                                          FOREIGN KEY (PARENT_)
                                          REFERENCES WFS.JBPM_ID_GROUP (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_ID_GROUP'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_ID_MEMBERSHIP
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_ID_MEMBERSHIP ADD (
                                  CONSTRAINT JBPM_ID_MEMBERSHIP#JBPM_ID_USR 
                                          FOREIGN KEY (USER_) 
                                          REFERENCES WFS.JBPM_ID_USER (ID_),
                                  CONSTRAINT JBPM_ID_MEMBERSHIP#JBPM_ID_GRP
                                          FOREIGN KEY (GROUP_) 
                                          REFERENCES WFS.JBPM_ID_GROUP (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_ID_MEMBERSHIP'')';
        GOTO bypass_install;
  
    END;
  
    -- Creating Foreign Key on JBPM_LOG
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_LOG ADD (
                                  CONSTRAINT JBPM_LOG#TTV_PSTATUS1 
                                          FOREIGN KEY (ADMINISTRATIVESTATUSID) 
                                          REFERENCES WFS.TTV_PROCESSSTATUS (PROCESSSTATUSID),
                                  CONSTRAINT JBPM_LOG#TTV_PSTATUS2 
                                          FOREIGN KEY (OPERATIONALSTATUSID) 
                                          REFERENCES WFS.TTV_PROCESSSTATUS (PROCESSSTATUSID),
                                  CONSTRAINT JBPM_LOG#TTV_RESOURCE 
                                          FOREIGN KEY (RESOURCEID) 
                                          REFERENCES WFS.TTV_RESOURCE (RESOURCEID),
                                  CONSTRAINT JBPM_LOG#TTV_RESOURCEGROUP 
                                          FOREIGN KEY (RESOURCEGROUPID) 
                                          REFERENCES WFS.TTV_RESOURCEGROUP (RESOURCEGROUPID),
                                  CONSTRAINT JBPM_LOG#JBPM_VARIABLEINSTANCE 
                                          FOREIGN KEY (VARIABLEINSTANCE_) 
                                          REFERENCES WFS.JBPM_VARIABLEINSTANCE (ID_),
                                  CONSTRAINT JBPM_LOG#JBPM_TRANSITION 
                                          FOREIGN KEY (TRANSITION_) 
                                          REFERENCES WFS.JBPM_TRANSITION (ID_),
                                  CONSTRAINT JBPM_LOG#JBPM_TASKINSTANCE 
                                          FOREIGN KEY (TASKINSTANCE_) 
                                          REFERENCES WFS.JBPM_TASKINSTANCE (ID_),
                                  CONSTRAINT JBPM_LOG#JBPM_SWIMLANEINSTANCE 
                                          FOREIGN KEY (SWIMLANEINSTANCE_) 
                                          REFERENCES WFS.JBPM_SWIMLANEINSTANCE (ID_),
                                  CONSTRAINT JBPM_LOG#JBPM_LOG1 
                                          FOREIGN KEY (PARENT_) 
                                          REFERENCES WFS.JBPM_LOG (ID_),
                                  CONSTRAINT JBPM_LOG#JBPM_BYTEARRAY1 
                                          FOREIGN KEY (OLDBYTEARRAY_) 
                                          REFERENCES WFS.JBPM_BYTEARRAY (ID_),
                                  CONSTRAINT JBPM_LOG#JBPM_BYTEARRAY2 
                                          FOREIGN KEY (NEWBYTEARRAY_) 
                                          REFERENCES WFS.JBPM_BYTEARRAY (ID_),
                                  CONSTRAINT JBPM_LOG#JBPM_ACTION 
                                          FOREIGN KEY (ACTION_) 
                                          REFERENCES WFS.JBPM_ACTION (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_LOG'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_MESSAGE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_MESSAGE ADD (
                                  CONSTRAINT JBPM_MESSAGE#JBPM_TASKINSTANCE 
                                          FOREIGN KEY (TASKINSTANCE_) 
                                          REFERENCES WFS.JBPM_TASKINSTANCE (ID_),
                                  CONSTRAINT JBPM_MESSAGE#JBPM_ACTION 
                                          FOREIGN KEY (ACTION_) 
                                          REFERENCES WFS.JBPM_ACTION (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_MESSAGE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_MODULEDEFINITION
    BEGIN
     
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_MODULEDEFINITION ADD (
                                  CONSTRAINT JBPM_MDEFINITION#JBPM_TASK 
                                          FOREIGN KEY (STARTTASK_) 
                                          REFERENCES WFS.JBPM_TASK (ID_),
                                  CONSTRAINT JBPM_MDEFINITION#JBPM_PDEF  
                                          FOREIGN KEY (PROCESSDEFINITION_) 
                                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_MODULEDEFINITION'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_MODULEINSTANCE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_MODULEINSTANCE ADD (
                                  CONSTRAINT JBPM_MINSTANCE#JBPM_MDEF
                                          FOREIGN KEY (TASKMGMTDEFINITION_) 
                                          REFERENCES WFS.JBPM_MODULEDEFINITION (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_MODULEINSTANCE'')';
        GOTO bypass_install;
        
    END;
  
  
    -- Creating Foreign Key on JBPM_NODE
    BEGIN
    
          EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_NODE ADD (
                                  CONSTRAINT JBPM_NODE#JBPM_PDEFINITION1 
                                          FOREIGN KEY (SUBPROCESSDEFINITION_) 
                                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_),
                                  CONSTRAINT JBPM_NODE#JBPM_NODE 
                                          FOREIGN KEY (SUPERSTATE_) 
                                          REFERENCES WFS.JBPM_NODE (ID_),
                                  CONSTRAINT JBPM_NODE#JBPM_PDEFINITION2 
                                          FOREIGN KEY (PROCESSDEFINITION_) 
                                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_),
                                  CONSTRAINT JBPM_NODE#JBPM_ACTION 
                                          FOREIGN KEY (ACTION_) 
                                          REFERENCES WFS.JBPM_ACTION (ID_),
                                  CONSTRAINT JBPM_NODE#TTV_RESOURCEGROUP 
                                          FOREIGN KEY (RESOURCEGROUPID) 
                                          REFERENCES WFS.TTV_RESOURCEGROUP (RESOURCEGROUPID),
                                  CONSTRAINT JBPM_NODE#JBPM_DELEGATION 
                                          FOREIGN KEY (DECISIONDELEGATION) 
                                          REFERENCES WFS.JBPM_DELEGATION (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_NODE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_POOLEDACTOR
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_POOLEDACTOR ADD (
                                  CONSTRAINT JBPM_POOLACTR#JBPM_SLINSTANCE 
                                          FOREIGN KEY (SWIMLANEINSTANCE_) 
                                          REFERENCES WFS.JBPM_SWIMLANEINSTANCE (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_POOLEDACTOR'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_PROCESSDEFINITION
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_PROCESSDEFINITION ADD (
                                  CONSTRAINT JBPM_PDEFINITION#TTV_PDEFTYPE 
                                          FOREIGN KEY (PROCESSDEFINITIONTYPEID) 
                                          REFERENCES WFS.TTV_PROCESSDEFINITIONTYPE (PROCESSDEFINITIONTYPEID))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_PROCESSDEFINITION'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_PROCESSINSTANCE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_PROCESSINSTANCE ADD (
                                  CONSTRAINT JBPM_PINSTANCE#TTV_PPRIORITY
                                          FOREIGN KEY (PROCESSPRIORITYID) 
                                          REFERENCES WFS.TTV_PROCESSPRIORITY (PROCESSPRIORITYID),
                                  CONSTRAINT JBPM_PINSTANCE#JBPM_TOKEN1 
                                          FOREIGN KEY (SUPERPROCESSTOKEN_) 
                                          REFERENCES WFS.JBPM_TOKEN (ID_),
                                  CONSTRAINT JBPM_PINSTANCE#JBPM_TOKEN2 
                                          FOREIGN KEY (ROOTTOKEN_) 
                                          REFERENCES WFS.JBPM_TOKEN (ID_),
                                  CONSTRAINT JBPM_PINSTANCE#JBPM_PDEF 
                                          FOREIGN KEY (PROCESSDEFINITION_) 
                                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_),
                                  CONSTRAINT JBPM_PINSTANCE#TTV_PSTATUS1 
                                          FOREIGN KEY (OPERATIONALPROCESSSTATUSID) 
                                          REFERENCES WFS.TTV_PROCESSSTATUS (PROCESSSTATUSID),
                                  CONSTRAINT JBPM_PINSTANCE#TTV_PSTATUS2 
                                          FOREIGN KEY (ADMINISTRATIVEPROCESSSTATUSID) 
                                          REFERENCES WFS.TTV_PROCESSSTATUS (PROCESSSTATUSID),
                                  CONSTRAINT JBPM_PINSTANCE#TTV_PINSTTYPE 
                                          FOREIGN KEY (PROCESSINSTANCETYPEID) 
                                          REFERENCES WFS.TTV_PROCESSINSTANCETYPE (PROCESSINSTANCETYPEID))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_PROCESSINSTANCE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_RUNTIMEACTION
    BEGIN
    
          EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_RUNTIMEACTION ADD (
                                  CONSTRAINT JBPM_RUNTIMEACTION#JBPM_ACTION 
                                          FOREIGN KEY (ACTION_) 
                                          REFERENCES WFS.JBPM_ACTION (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_RUNTIMEACTION'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_SWIMLANE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_SWIMLANE ADD (
                                  CONSTRAINT JBPM_SWIMLANE#JBPM_MDEFINITION 
                                          FOREIGN KEY (TASKMGMTDEFINITION_) 
                                          REFERENCES WFS.JBPM_MODULEDEFINITION (ID_),
                                  CONSTRAINT JBPM_SWIMLANE#JBPM_DELEGATION
                                          FOREIGN KEY (ASSIGNMENTDELEGATION_) 
                                          REFERENCES WFS.JBPM_DELEGATION (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_SWIMLANE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_SWIMLANEINSTANCE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_SWIMLANEINSTANCE ADD (
                                  CONSTRAINT JBPM_SLINSTANCE#JBPM_MINSTANCE 
                                          FOREIGN KEY (TASKMGMTINSTANCE_) 
                                          REFERENCES WFS.JBPM_MODULEINSTANCE (ID_),
                                  CONSTRAINT JBPM_SLINSTANCE#JBPM_SWIMLANE  
                                          FOREIGN KEY (SWIMLANE_) 
                                          REFERENCES WFS.JBPM_SWIMLANE (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_SWIMLANEINSTANCE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_TASK
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_TASK ADD (
                                  CONSTRAINT JBPM_TASK#JBPM_TASKCONTROLLER 
                                          FOREIGN KEY (TASKCONTROLLER_) 
                                          REFERENCES WFS.JBPM_TASKCONTROLLER (ID_),
                                  CONSTRAINT JBPM_TASK#JBPM_MDEFINITION 
                                          FOREIGN KEY (TASKMGMTDEFINITION_) 
                                          REFERENCES WFS.JBPM_MODULEDEFINITION (ID_),
                                  CONSTRAINT JBPM_TASK#JBPM_SWIMLANE 
                                          FOREIGN KEY (SWIMLANE_) 
                                          REFERENCES WFS.JBPM_SWIMLANE (ID_),
                                  CONSTRAINT JBPM_TASK#JBPM_PDEFINITION 
                                          FOREIGN KEY (PROCESSDEFINITION_) 
                                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_),
                                  CONSTRAINT JBPM_TASK#JBPM_DELEGATION 
                                          FOREIGN KEY (ASSIGNMENTDELEGATION_) 
                                          REFERENCES WFS.JBPM_DELEGATION (ID_))';
                                          
    EXCEPTION
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_TASK'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_TASKACTORPOOL
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_TASKACTORPOOL ADD (
                                  CONSTRAINT JBPM_TACTRPOOL#JBPM_POOLEDACTR 
                                          FOREIGN KEY (POOLEDACTOR_) 
                                          REFERENCES WFS.JBPM_POOLEDACTOR (ID_),
                                  CONSTRAINT JBPM_TACTRPOOL##JBPM_TINSTANCE 
                                          FOREIGN KEY (TASKINSTANCE_) 
                                          REFERENCES WFS.JBPM_TASKINSTANCE (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_TASKACTORPOOL'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_TASKCONTROLLER
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_TASKCONTROLLER ADD (
                                  CONSTRAINT JBPM_TCONTROLR#JBPM_DELEGATION 
                                          FOREIGN KEY (TASKCONTROLLERDELEGATION_) 
                                          REFERENCES WFS.JBPM_DELEGATION (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
  
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_TASKCONTROLLER'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_TASKINSTANCE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_TASKINSTANCE ADD (
                                  CONSTRAINT JBPM_TINSTANCE#JBPM_MINSTANCE 
                                          FOREIGN KEY (TASKMGMTINSTANCE_) 
                                          REFERENCES WFS.JBPM_MODULEINSTANCE (ID_),
                                  CONSTRAINT JBPM_TINSTANCE#JBPM_TASK 
                                          FOREIGN KEY (TASK_) 
                                          REFERENCES WFS.JBPM_TASK (ID_),
                                  CONSTRAINT JBPM_TINSTANCE#JBPM_SLINSTANCE 
                                          FOREIGN KEY (SWIMLANINSTANCE_) 
                                          REFERENCES WFS.JBPM_SWIMLANEINSTANCE (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_TASKINSTANCE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on JBPM_TIMER
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_TIMER ADD (
                                  CONSTRAINT JBPM_TIMER#JBPM_TINSTANCE 
                                          FOREIGN KEY (TASKINSTANCE_) 
                                          REFERENCES WFS.JBPM_TASKINSTANCE (ID_),
                                  CONSTRAINT JBPM_TIMER#JBPM_ACTION
                                          FOREIGN KEY (ACTION_) 
                                          REFERENCES WFS.JBPM_ACTION (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_TIMER'')';
        GOTO bypass_install;
        
    END;
  
  -- Creating Foreign Key on JBPM_TOKEN
  
      BEGIN
  
          EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_TOKEN ADD ( 
                  CONSTRAINT FK_TOKEN_SUBPI
                      FOREIGN KEY(SUBPROCESSINSTANCE_)
                      REFERENCES WFS.JBPM_PROCESSINSTANCE(ID_),
                  CONSTRAINT FK_TOKEN_PROCINST
                      FOREIGN KEY(PROCESSINSTANCE_)
                      REFERENCES WFS.JBPM_PROCESSINSTANCE(ID_),
                  CONSTRAINT FK_TOKEN_PARENT
                      FOREIGN KEY(PARENT_)
                      REFERENCES WFS.JBPM_TOKEN(ID_),
                  CONSTRAINT FK_TOKEN_NODE
                      FOREIGN KEY(NODE_)
                      REFERENCES WFS.JBPM_NODE(ID_),
                  CONSTRAINT FK_JBPM_TOKEN_TTV_TOKENTYPE
                      FOREIGN KEY(TOKENTYPEID)
                      REFERENCES WFS.TTV_TOKENTYPE(TOKENTYPEID),
                 Constraint FK_TOKEN#PROCESSSTATUS_OPER
                      Foreign Key(OPERATIONALSTATUS)
                      References WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID),
                  Constraint FK_TOKEN#PROCESSSTATUS_ADMIN
                      Foreign Key(ADMINISTRATIVESTATUS)
                      References WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID))';
  
          EXCEPTION
             WHEN OTHERS THEN
             wk_message := 'ERROR';
             EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_TOKEN'')';
             GOTO bypass_install;
          END;
  
  
  -- Create Foreign Key on JBPM_TOKENVARIABLEMAP
  
      BEGIN
  
          EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_TOKENVARIABLEMAP ADD ( 
                  CONSTRAINT FK_TKVARMAP_CTXT
                      FOREIGN KEY(CONTEXTINSTANCE_)
                      REFERENCES WFS.JBPM_MODULEINSTANCE(ID_))';
  
          EXCEPTION 
             WHEN OTHERS THEN
             wk_message := 'ERROR';
             EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_TOKENVARIABLEMAP'')';
             GOTO bypass_install;
      END; 
  
  -- Creating Foreign Key on JBPM_TRANSITION
          BEGIN
          EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_TRANSITION ADD (
                                  CONSTRAINT JBPM_TRANSITION#JBPM_PDEF 
                                          FOREIGN KEY (PROCESSDEFINITION_) 
                                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_))';
          EXCEPTION 
             WHEN OTHERS THEN
             wk_message := 'ERROR';
             EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for JBPM_TRANSITION'')';
             GOTO bypass_install;
          END;
  
  -- Creating Foreign Key on JBPM_VARIABLEACCESS
  
      BEGIN
  
          EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_VARIABLEACCESS ADD ( 
                      CONSTRAINT FK_VARACC_TSKCTRL
                          FOREIGN KEY(TASKCONTROLLER_)
                          REFERENCES WFS.JBPM_TASKCONTROLLER(ID_),
                      CONSTRAINT FK_VARACC_SCRIPT
                          FOREIGN KEY(SCRIPT_)
                          REFERENCES WFS.JBPM_ACTION(ID_),
                      CONSTRAINT FK_JBPM_VARIABLEACCESS_VATYPE
                          FOREIGN KEY(VARIABLEACCESSTYPEID)
                          REFERENCES WFS.TTV_VARIABLEACCESSTYPE(VARIABLEACCESSTYPEID),
                      CONSTRAINT FK_JBPM_VARIABLEACCESS_TYPE
                          FOREIGN KEY(DATATYPEID)
                          REFERENCES WFS.TTV_DATATYPE(DATATYPEID))';
  
       EXCEPTION 
          WHEN OTHERS THEN
             wk_message := 'ERROR';
             EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign keys for JBPM_VARIABLEACCESS'')';
                  GOTO bypass_install;
       END;
  
  -- Creating Foreign Key on JBPM_VARIABLEINSTANCE
  
      BEGIN
  
          EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_VARIABLEINSTANCE ADD ( 
                      CONSTRAINT FK_VAR_TSKINST
                          FOREIGN KEY(TASKINSTANCE_)
                          REFERENCES WFS.JBPM_TASKINSTANCE(ID_),
                      CONSTRAINT FK_VARINST_TKVARMP
                          FOREIGN KEY(TOKENVARIABLEMAP_)
                          REFERENCES WFS.JBPM_TOKENVARIABLEMAP(ID_),
                      CONSTRAINT FK_BYTEINST_ARRAY
                          FOREIGN KEY(BYTEARRAYVALUE_)
                          REFERENCES WFS.JBPM_BYTEARRAY(ID_))';
  
       EXCEPTION
          WHEN OTHERS THEN
              wk_message := 'ERROR';
              EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign keys for JBPM_VARIABLEINSTANCE'')';
                  GOTO bypass_install;
  
       END;
  
    -- Creating Foreign Key on TTV_ACTION
    BEGIN
  
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_ACTION ADD (
                                  CONSTRAINT TTV_ACTION#TTV_PERMISSION
                                          FOREIGN KEY (PERMISSIONID) 
                                          REFERENCES WFS.TTV_PERMISSION (PERMISSIONID))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for TTV_ACTION'')';
        GOTO bypass_install;
        
    END;
  
  -- Creating Foreign Key on TTV_BIGROLEPERMISSION
  
      BEGIN
  
          EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_BIGROLEPERMISSION ADD ( 
                      CONSTRAINT FK_TTV_BIGROLEPERMISSION_ROLE
                          FOREIGN KEY(BIGROLE)
                          REFERENCES WFS.BIGROLE(BIGROLE),
                      CONSTRAINT FK_TTV_BIGROLEPERMISSION_PERM
                          FOREIGN KEY(PERMISSIONID)
                          REFERENCES WFS.TTV_PERMISSION(PERMISSIONID))';
  
      EXCEPTION
          WHEN OTHERS THEN
              wk_message := 'ERROR';
              EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Key for TTV_BIGROLEPERMISSION'')';
                  GOTO bypass_install;
      END;
  
    -- Creating Foreign Key on TTV_MENUITEM
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_MENUITEM ADD (
                                  CONSTRAINT TTV_MENUITEM#TTV_PERMISSION
                                          FOREIGN KEY (PERMISSIONID) 
                                          REFERENCES WFS.TTV_PERMISSION (PERMISSIONID))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for TTV_MENUITEM'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on TTV_MESSAGELOG
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_MESSAGELOG ADD (
                                  CONSTRAINT TTV_MESSAGELOG#TTV_RESOURCE
                                          FOREIGN KEY (RESOURCEID) 
                                          REFERENCES WFS.TTV_RESOURCE (RESOURCEID),
                                  CONSTRAINT TTV_MESSAGELOG#JBPM_LOG
                                          FOREIGN KEY (LOGID) 
                                          REFERENCES WFS.JBPM_LOG (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for TTV_MESSAGELOG'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on TTV_MONITOREDDRIVE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_MONITOREDDRIVE ADD (
                                  CONSTRAINT TTV_MDRIVE#TTV_MDRIVESTATUS
                                          FOREIGN KEY (CURRENTDRIVESTATUSID) 
                                          REFERENCES WFS.TTV_MONITOREDDRIVESTATUS (MONITOREDDRIVESTATUSID),
                                  CONSTRAINT TTV_MDRIVE#TTV_RESOURCE 
                                          FOREIGN KEY (RESOURCEID) 
                                          REFERENCES WFS.TTV_RESOURCE (RESOURCEID))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for TTV_MONITOREDDRIVE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on TTV_MONITOREDDRIVEHISTORY
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_MONITOREDDRIVEHISTORY ADD (
                                  CONSTRAINT TTV_MDRIVEHIST#TTV_MDRIVE
                                          FOREIGN KEY (MONITOREDDRIVEID) 
                                          REFERENCES WFS.TTV_MONITOREDDRIVE (MONITOREDDRIVEID))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for TTV_MONITOREDDRIVEHISTORY'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on TTV_PERMISSION
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_PERMISSION ADD (
                                  CONSTRAINT TTV_PERMISSION#TTV_MODULE 
                                          FOREIGN KEY (MODULEID) 
                                          REFERENCES WFS.TTV_MODULE (MODULEID))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for TTV_PERMISSION'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on TTV_PROCDEFACCESSLEVEL
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_PROCDEFACCESSLEVEL ADD (
                                  CONSTRAINT TTV_PROCDEFALEVEL#TTV_ALEVEL 
                                          FOREIGN KEY (ACCESSLEVELID) 
                                          REFERENCES WFS.TTV_ACCESSLEVEL (ACCESSLEVELID),
                                  CONSTRAINT TTV_PDEFALEVEL#JBPM_PDEF
                                          FOREIGN KEY (PROCESSDEFINITIONID) 
                                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for TTV_PROCDEFACCESSLEVEL'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on TTV_PROCESSINSTANCENOTE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_PROCESSINSTANCENOTE ADD (
                                  CONSTRAINT TTV_PINSTANCENOTE#JBPM_PINST
                                          FOREIGN KEY (PROCESSINSTANCEID) 
                                          REFERENCES WFS.JBPM_PROCESSINSTANCE (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for TTV_PROCESSINSTANCENOTE'')';
        GOTO bypass_install;
  
    END;
  
    -- Creating Foreign Key on TTV_RESOURCE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_RESOURCE ADD (
                                  CONSTRAINT TTV_RESOURCE#TTV_RTYPE 
                                          FOREIGN KEY (RESOURCETYPEID) 
                                          REFERENCES WFS.TTV_RESOURCETYPE (RESOURCETYPEID),
                                  CONSTRAINT TTV_RESOURCE#TTV_RSTATUS1 
                                          FOREIGN KEY (OPERATIONALRESOURCESTATUSID) 
                                          REFERENCES WFS.TTV_RESOURCESTATUS (RESOURCESTATUSID),
                                  CONSTRAINT TTV_RESOURCE#TTV_RSTATUS2
                                          FOREIGN KEY (ADMINISTRATIVERESOURCESTATUSID) 
                                          REFERENCES WFS.TTV_RESOURCESTATUS (RESOURCESTATUSID),
                  CONSTRAINT FK_TTV_RESOURCE_USERDATA
                      FOREIGN KEY(USER_NAME)
                      REFERENCES WFS.USER_DATA(USER_NAME))';
                      
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for TTV_RESOURCE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on TTV_RESOURCEGROUP
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_RESOURCEGROUP ADD (
                                  CONSTRAINT TTV_RESOURCEGROUP#TTV_ALEVEL 
                                          FOREIGN KEY (ACCESSLEVELID) 
                                          REFERENCES WFS.TTV_ACCESSLEVEL (ACCESSLEVELID),
                                  CONSTRAINT TTV_RESOURCEGROUP#TTV_SGYCLASS
                                          FOREIGN KEY (ALLOCATIONSTRATEGYCLASSID) 
                                          REFERENCES WFS.TTV_STRATEGYCLASS (STRATEGYCLASSID),
                                  CONSTRAINT TTV_RESOURCEGROUP#TTV_RTYPE
                                          FOREIGN KEY (RESOURCETYPEID) 
                                          REFERENCES WFS.TTV_RESOURCETYPE (RESOURCETYPEID))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
        
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for TTV_RESOURCEGROUP'')';
        GOTO bypass_install;
          
    END;
  
    -- Creating Foreign Key on TTV_RESOURCEGROUPMEMBERSHIP
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_RESOURCEGROUPMEMBERSHIP ADD (
                                  CONSTRAINT TTV_RGRPMBRSHIP#TTV_RGROUP 
                                          FOREIGN KEY (RESOURCEGROUPID) 
                                          REFERENCES WFS.TTV_RESOURCEGROUP (RESOURCEGROUPID),
                                  CONSTRAINT TTV_RGRPMBRSHIP#TTV_RESOURCE 
                                          FOREIGN KEY (RESOURCEID) 
                                          REFERENCES WFS.TTV_RESOURCE (RESOURCEID))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for TTV_RESOURCEGROUPMEMBERSHIP'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on TTV_RESOURCEGROUPQUEUEITEM
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_RESOURCEGROUPQUEUEITEM ADD (
                                  CONSTRAINT TTV_RGROUPQITEM#TTV_RGROUP 
                                          FOREIGN KEY (RESOURCEGROUPID) 
                                          REFERENCES WFS.TTV_RESOURCEGROUP (RESOURCEGROUPID),
                                  CONSTRAINT TTV_RGROUPQUEUEITEM#JBPM_TOKEN 
                                          FOREIGN KEY (TOKENID) 
                                          REFERENCES WFS.JBPM_TOKEN (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for TTV_RESOURCEGROUPQUEUEITEM'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on TTV_RESOURCETYPE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_RESOURCETYPE ADD (
                                  CONSTRAINT TTV_RESOURCETYPE#TTV_SGYCLASS1 
                                          FOREIGN KEY (INITIALIZATIONSTRATEGYCLASSID) 
                                          REFERENCES WFS.TTV_STRATEGYCLASS (STRATEGYCLASSID),
                                  CONSTRAINT TTV_RESOURCETYPE#TTV_SGYCLASS2
                                          FOREIGN KEY (HEARTBEATSTRATEGYCLASSID) 
                                          REFERENCES WFS.TTV_STRATEGYCLASS (STRATEGYCLASSID),
                                  CONSTRAINT TTV_RESOURCETYPE#TTV_CTYPE1
                                          FOREIGN KEY (HEARTBEATCONNECTIONTYPEID) 
                                          REFERENCES WFS.TTV_CONNECTIONTYPE (CONNECTIONTYPEID),
                                  CONSTRAINT TTV_RESOURCETYPE#TTV_CTYPE2 
                                          FOREIGN KEY (RESOURCECONNECTIONTYPEID) 
                                          REFERENCES WFS.TTV_CONNECTIONTYPE (CONNECTIONTYPEID))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for TTV_RESOURCETYPE'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on TTV_RESOURCEUSAGEHISTORY
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_RESOURCEUSAGEHISTORY ADD (
                                  CONSTRAINT TTV_RUSAGEHIST#TTV_RGROUP 
                                          FOREIGN KEY (RESOURCEGROUPID) 
                                          REFERENCES WFS.TTV_RESOURCEGROUP (RESOURCEGROUPID),
                                  CONSTRAINT TTV_RUSAGEHIST#TTV_RESOURCE
                                          FOREIGN KEY (RESOURCEID) 
                                          REFERENCES WFS.TTV_RESOURCE (RESOURCEID),
                                  CONSTRAINT TTV_RUSAGEHIST#JBPM_PINSTANCE 
                                          FOREIGN KEY (PROCESSINSTANCEID) 
                                          REFERENCES WFS.JBPM_PROCESSINSTANCE (ID_),
                                  CONSTRAINT TTV_RUSAGEHIST#JBPM_NODE
                                          FOREIGN KEY (NODEID) 
                                          REFERENCES WFS.JBPM_NODE (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for TTV_RESOURCEUSAGEHISTORY'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on TTV_STRATEGYCLASS
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_STRATEGYCLASS ADD (
                                  CONSTRAINT TTV_SGYCLASS#TTV_SGYCLASSTYPE 
                                          FOREIGN KEY (STRATEGYCLASSTYPEID) 
                                          REFERENCES WFS.TTV_STRATEGYCLASSTYPE (STRATEGYCLASSTYPEID))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for TTV_STRATEGYCLASS'')';
        GOTO bypass_install;
        
    END;
  
    -- Creating Foreign Key on TTV_TOKENRESOURCE
    BEGIN
    
      EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_TOKENRESOURCE ADD (
                                  CONSTRAINT TTV_TOKENRESOURCE#TTV_RGROUP 
                                          FOREIGN KEY (RESOURCEGROUPID) 
                                          REFERENCES WFS.TTV_RESOURCEGROUP (RESOURCEGROUPID),
                                  CONSTRAINT TTV_TOKENRESOURCE#TTV_RESOURCE 
                                          FOREIGN KEY (RESOURCEID) 
                                          REFERENCES WFS.TTV_RESOURCE (RESOURCEID),
                                  CONSTRAINT TTV_TOKENRESOURCE#JBPM_TOKEN 
                                          FOREIGN KEY (TOKENID) 
                                          REFERENCES WFS.JBPM_TOKEN (ID_))';
                                          
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
        EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for TTV_TOKENRESOURCE'')';
        GOTO bypass_install;
  
    END;
  
  -- Creating Foreign Key on USER_BIGROLE
  
      BEGIN
  
          EXECUTE IMMEDIATE 'ALTER TABLE WFS.USER_BIGROLE ADD ( 
                      CONSTRAINT FK_USER_BIGROLE_USERS_REALM
                          FOREIGN KEY(USER_NAME)
                          REFERENCES WFS.USERS_REALM(USER_NAME),
                      CONSTRAINT FK_USER_BIGROLE_BIGROLE
                          FOREIGN KEY(BIGROLE)
                          REFERENCES WFS.BIGROLE(BIGROLE))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for USER_BIGROLE'')';
              GOTO bypass_install;
      END;
  
  -- Creating Foreign Key on USER_DATA
  
      BEGIN
  
          EXECUTE IMMEDIATE 'ALTER TABLE WFS.USER_DATA ADD ( 
                      CONSTRAINT FK_USER_DATA_USERS_REALM
                          FOREIGN KEY(USER_NAME)
                          REFERENCES WFS.USERS_REALM(USER_NAME))';
      
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Keys for USER_DATA'')';
              GOTO bypass_install;
      END;
      
      -- Creating Foreign Key on TTV_SELECTOR
      
      BEGIN
      
        EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_SELECTOR
                              ADD ( CONSTRAINT TTV_SELECTOR#JBPM_PROCESSDEF
                              FOREIGN KEY(PROCESSDEFINITIONID)
                              REFERENCES WFS.JBPM_PROCESSDEFINITION("ID_")
                              ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE VALIDATE )';
                              
      EXCEPTION 
        WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign Key for TTV_SELECTOR'')';
          GOTO bypass_install;
          
      END;
      
      -- Create Foreign Key on JBPM_TRANSITION
      BEGIN
      
        EXECUTE IMMEDIATE 'ALTER TABLE WFS.JBPM_TRANSITION
                               ADD ( CONSTRAINT FK_JBPM_TRANS_TTV_TRANSTYPE
                               FOREIGN KEY(TRANSITIONTYPEID)
                               REFERENCES WFS.TTV_TRANSITIONTYPE(TRANSITIONTYPEID)
                               ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE VALIDATE )';
                               
      EXCEPTION
        WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create foreign key for JBPM_TRANSITION'')';
          GOTO bypass_install;
          
      END;
      
      
  
  /*
  ----------------------------------------
     ADD TABLE AND COLUMN COMMNETS
  ----------------------------------------
  */
  
  -- Adding Comment on the JBPM_PROCESSDEFINITION table
  
     BEGIN
  
           EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_PROCESSDEFINITION IS ''Stores general information about the process definition.
  Foreign Keys
  Node table - Start-state node in the process''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_PROCESSDEFINITION table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on the JBPM_NODE table
  
     BEGIN
  
       EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_NODE IS ''Stores definition information about a node in a process definition.
  Foreign Keys
  Process Definition table - The process definition that the node belongs to 
  Process Definition table - Specify that this node calls a sub process. The sub process would complete execution before the parent process leaves this node
  Action table - Specify an action class to be executed for the node
  Node table - Specify that this node belongs to a superstate. Multiple nodes can belong to a superstate
  Delegation table - Specify that a decision has been delegated to a class''';
  
        EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_NODE table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on the JBPM_TRANSITION table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_TRANSITION IS ''Stores definition information about a transition in a process definition. 
  Foreign Keys
  Process Definition table - Specify the definition that the transition belongs to
  Node table - Specify the node that starts the transition
  Node table - Specify the node that the transition ends on''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_TRANSITION table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on the JBPM_ACTION table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_ACTION IS ''Stores definition information about an action in a process definition.
  Foreign Keys 
  Process Definition table - Specify the definition that the action belongs to
  Event table - Specify the event that triggers the action
  Delegation table - Specify the action is delegated to
  ExceptionHandler? table - Specify the exception handler class for this action
  Action table - Specify the action is referenced by another action and
  Action table - Specify if there is a timer action''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_ACTION table'')';
              GOTO bypass_install;
      END;
      
  -- Adding comment on the JBPM_DELEGATION table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_DELEGATION IS ''Stores definition information about Java business classes that are specified in the process definition. 
  Foreign key
  Process Definition table - Specify the process definition that the delegation belongs to.''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_DELEGATION table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on the JBPM_EVENT table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_EVENT IS ''Stores definition information about an event that triggers an action in the process definition. 
  Foreign Keys Process Definition table - Specify the process definition that the event belongs to
  Node table - Specify the event belongs to a node
  Transition table - Specify the event belongs to a transition
  Task table - Specify the event belongs to a task''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_EVENT table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on the JBPM_EXCEPTIONHANDLER table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_EXCEPTIONHANDLER IS ''Stores definition information about an exception handler for an action.''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_EXEPTIONHANDLER table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on the JBPM_DECISIONCONDITIONS table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_DECISIONCONDITIONS IS ''Stores definition information about conditions specified in the process definition.''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_DECISIONCONDITIONS table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on the JBPM_TASK table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_TASK IS ''Stores definition information about tasks defined in the process definition. 
  Foreign Keys
  Process Definition table - Specify the process definition the task belongs to
  Module Definition table - Specify the TaskMgmtDefintion to be used for this task.
  Node table - Specify the node the task belongs to 
  Node table - Specify that this task belongs to the start-state of a process
  Delegation table - Specify the delegation of the task to a class
  Swimlane table - Specify the swimlane that the task uses for assignment
  Task Controller table - Specify the task assignment is delegated to a class''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_TASK table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on the JBPM_TASKCONTROLLER table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_TASKCONTROLLER IS ''Stores information that refers a task to a delegation class. 
  Foreign key
  Delegation table - Specify the class that is the controller for the task.''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_TASKCONTROLLER table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on the JBPM_VARIABLEACCESS table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_VARIABLEACCESS IS ''Stores information about the access levels for each variable associated to a particular node or task
  Foreign keys
  Node table - Specify the node that the variables belong to
  Task Controller table - Specify the task that the variables belong to
  Action table - Specify the action that the variables belong to''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_VARIABLEACCESS table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on the JBPM_SWIMLANE table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_SWIMLANE IS ''Stores information about the swimlanes defined in the process definition.
  Foreign Keys
  Delegation table - Specify the class that determines assignment for this swimlane
  Module Definition table - All of the swimlanes for a process definition belong to a TaskMgmtDefintion. This is specified in the Module Definition table.''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_SWIMLANE table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on the JBPM_MODULEDEFINITION table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_MODULEDEFINITION IS ''Stores information about modules used in the process definition
  Foreign Keys
  Process Definition table - Specify the process definition this module is used in
  Task table - Specify the task this module is used in''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_MODULEDEFINITION table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on the JBPM_ID_USER table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_ID_USER IS ''Stores information about users in jBPM''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_ID_USER table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on the JBPM_ID_GROUP table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_ID_GROUP IS ''Stores information about groups that users can belong to.
  Foreign Key
  ID Group - Parent/Child relationship between groups.''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_ID_GROUP table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on the JBPM_ID_MEMBERSHIP
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_ID_MEMBERSHIP IS ''Cross reference table storing information about role and which groups a user belongs to.
  Foreign Keys
  ID Users table - Specify the user that belongs to the membership.
  ID Group table - Specify the group the membership belongs to.''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_ID_MEMBERSHIP table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on the JBPM_ID_PERMISSIONS
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_ID_PERMISSIONS IS ''Defines permissions for a user''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_ID_PERMISSIONS table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on the JBPM_PROCESSINSTANCE
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_PROCESSINSTANCE IS ''Stores runtime information about an instance of a process. 
  Foreign keys
  Process Definition table - the process definition to be followed for this process instance execution 
  Token table - the root token that follows where the process execution is currently
  Token table - the super process token (if this process instance was called from another process instance)''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_PROCESSINSTANCE table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on the JBPM_TOKEN table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_TOKEN IS ''Stores information about the token representing execution location in the process instance
  Foreign keys
  Process Instance table - the process instance this token belongs to.
  Process Instance table - the sub process instance that the token belongs to.
  Node table - the node that the token points to as the current location of execution.
  Token table - parent/child relationship between tokens for a fork or sub process.''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_TOKEN table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on the JBPM_MESSAGE table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_MESSAGE IS ''Stores messages to create asynchronous processing of nodes.
  Foreign keys
  Token table - token the message belongs to
  Action table - action the message belongs to
  Node table - node the message belongs to
  Task Instance table - task instance the message belongs to''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_MESSAGE table'')';
              GOTO bypass_install;
      END;
  
  
  -- Adding comment on JBPM_TASKINSTANCE
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_TASKINSTANCE IS ''Stores runtime information about an instance of a task
  Foreign keys
  Task table - the task that defines the instance
  Token table - the token the task belongs to
  Swimlane Instance table - the swimlane instance used to determine who works this task instance
  Module Instance table - the instance of the module to manage the task''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_TASKINSTANCE table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment on JBPM_SWIMLANEINSTANCE 
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_SWIMLANEINSTANCE IS ''Stores runtime information about an instance of a swimlane
  Foreign keys
  Swimlane table - the swimlane that defines the instance
  Module Instance table - the instance of the module to manage the task''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_SWIMLANEINSTANCE table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment JBPM_POOLEDACTOR table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_POOLEDACTOR IS ''Stores a list of actors for a swimlane instance
  Foreign Key 
  Swimlane Instance table - the swimlane instance the actor belongs to''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_POOLEDACTOR table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment JBPM_TASKACTORPOOL table 
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_TASKACTORPOOL IS ''Cross reference table between Pooled Actor and Task Instance
  Foreign Keys
  Pooled Actor - Actors for a swimlane instance
  Task Instance - Task the pooled actor belongs to''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_TASKACTORPOOL table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment JBPM_COMMENT table 
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_COMMENT IS ''tores a comment message related to a token or task instance
  Foreign Keys
  Token table - the token the comment belongs to.
  Task Instance table - the task instance the comment belongs to.''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_COMMENT table'')';
              GOTO bypass_install;
      END;
  
  -- Adding comment to JBPM_TOKENVARIABLEMAP table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_TOKENVARIABLEMAP IS ''Cross reference table between token and module instances for context
  Foreign Keys
  Token table - the token representing the process execution
  Module Instance table - the context module instance for the token''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_TOKENVARIABLEMAP table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment to JBPM_MODULEINSTANCE table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_MODULEINSTANCE IS ''Stores runtime information about an instance of a module
  Foreign Keys
  Process Instance table - the process instance the module instance belongs to
  Module Definition table - the module definition that defines the module instance''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_MODULEINSTANCE table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on JBPM_RUNTIMEACTION table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_RUNTIMEACTION IS ''Stores information about actions that are created at runtime
  Foreign Keys
  Process Instance table - the process instance the action belongs to
  Action table - the action definition that defines the action instance''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_RUNTIMEACTION table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on JBPM_TIME table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_TIMER IS ''Stores information about instances of timers that are running
  Foreign Keys
  Action table - The action that the timer belongs to
  Token table - the token that the timer belongs to
  Process Instance table - the process instance the timer belongs to
  Task Instance table - the task instance the timer belongs to''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_TIMER table'')';
           GOTO bypass_install;
      END;
  
  
  -- Adding comment on JBPM_VARIABLEINSTANCE
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_VARIABLEINSTANCE IS ''Stores information about process variable instances
  Foreign Keys
  Token table - the token that the variables belong to
  Token Variable Map table - mapping to the module instance for the token
  Process Instance table - the process instance the variables belong to
  Byte Array table - the byte array stored for a serialized object process variable instance
  Task Instance table - the task instance the variables belong to''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_VARIABLEINSTANCE table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on JBPM_LOG table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_LOG IS ''Stores process logs created by jBPM or application code during process execution
  Foreign Keys
  Token table - the token that the logs belong to
  Token table - the child token that the logs belong to
  Log table - parent/child relationship between logs
  Transition table - the transition the logs belong to
  Node table - the source node the logs belong to
  Node table - the destination node the logs belong to
  Variable Instance table - the variable instance that is referred to in the log
  Byte Array table - the old value of the byte array
  Byte Array table - the new value of the byte array
  Task Instance table - The task instance that is referred to in the log
  Swim Lane Instance table - the swimlane instance that is referred to in the log''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_LOG table'')';
           GOTO bypass_install;
      END;
  
  
  -- Adding comment on JBPM_BYTEARRAY table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_BYTEARRAY IS ''Specifies the file definition module for a serialized process instance variable
  Foreign Key
  Module Definition table - Specify the file definition module''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_BYTEARRAY table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on JBPM_BYTEBLOCK table 
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_BYTEBLOCK IS ''Stores the serialized process instance variable
  Foreign Key
  Byte Array table - The byte array that the byte block belongs to''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_BYTEBLOCK table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on JBPM_BYTEBLOCK table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.JBPM_BYTEBLOCK IS ''Stores the serialized process instance variable
  Foreign Key
  Byte Array table - The byte array that the byte block belongs to''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the JBPM_BYTEBLOCK table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on the ALERTS table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.ALERTS IS ''List of alerts defined in the system''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the ALERTS table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on ALERTS_HIST table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.ALERTS_HIST IS ''Stores history for all the alerts occurred''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the ALERTS_HIST table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on ALERT_ACTIONS table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.ALERT_ACTIONS IS ''Stores action information for alerts defined. Current actions supported are email and snmp traps''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the ALERT_ACTIONS table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on ALERT_ACTIONS_HIST table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.ALERT_ACTIONS_HIST IS ''history for all the alert action taken''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the ALERT_ACTIONS_HIST table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on ALERT_NAMES table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.ALERT_NAMES IS ''Stores alert patterns''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the ALERT_NAMES table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on BIGROLE table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.BIGROLE IS ''Contains list of roles available in the system''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the BIGROLE table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on BIGROLE_ROLE table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.BIGROLE_ROLE IS ''This table is unused by the Watchpoint system''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the BIGROLE_ROLE table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_ACCESSLEVEL table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_ACCESSLEVEL IS ''Contains all the protection keys''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_ACCESSLEVEL table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_ACTION table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_ACTION IS ''An action corresponds to a HTTP POST request . it has a URL. This URL must be present in the action''''s PATH column or else the Struts mechanism will reject the request and redirect to HTTP 403''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_ACTION table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_BIGROLEPERMISSION table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_BIGROLEPERMISSION IS ''Mapping for role and permission is specified in this table''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_BIGROLEPERMISSION table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_CONNECTIONTYPE table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_CONNECTIONTYPE IS ''The different types of Connection String values supported by Resource Manager. Resource Type declares the Connection Type and it expects for Resource Connection String values and Resource Heartbeat Connection String values''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_CONNECTIONTYPE table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_DATATYPE table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_DATATYPE IS ''Contains list of data type supported for variables defined in the template''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_DATATYPE table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_MENUITEM table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_MENUITEM IS ''Contains menu items entry along with permissions for all the menus displayed in dashboard''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_MENUITEM table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_MESSAGELOG table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_MESSAGELOG IS ''Stores messages for each node''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_MESSAGELOG table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_MODULE table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_MODULE IS ''menu options available on dashboard''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_MODULE table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_MONITOREDDRIVE table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_MONITOREDDRIVE IS ''configuration information for san drives to be monitored''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_MONITOREDDRIVE table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_MONITOREDDRIVEHISTORY table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_MONITOREDDRIVEHISTORY  IS ''Stores history for each of the drives configured in TTV_MONITORDRIVE''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_MONITOREDDRIVEHISTORY table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_MONITOREDDRIVESTATUS table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_MONITOREDDRIVESTATUS IS ''Contains all possible status a drive can be in''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_MONITOREDDRIVESTATUS table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_PERMISSION table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_PERMISSION IS ''Contains permissions defined for each modules''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_PERMISSION table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_PROCDEFACCESSLEVEL table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_PROCDEFACCESSLEVEL IS ''Mapping information between process definitions and access levels (protection keys)''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_PROCDEFACCESSLEVEL table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_PROCESSDEFINITIONTYPE table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_PROCESSDEFINITIONTYPE IS ''Required as a result of sub-classing JBPM_PROCESSDEFINITION entity''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_PROCESSDEFINITIONTYPE table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_PROCESSINSTANCENOTE table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_PROCESSINSTANCENOTE IS ''Table to store notes attached to work orders while specifying reason for cancel, pause, e.t.c''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_PROCESSINSTANCENOTE table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_PROCESSINSTANCETYPE table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_PROCESSINSTANCETYPE IS ''Required as a result of sub-classing JBPM_PROCESSINSTANCE entity''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_PROCESSINSTANCETYPE table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_PROCESSPRIORITY table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_PROCESSPRIORITY IS ''Table contains the list of all possible Process Priorities available to the Workflow System.The process priority Ids assigned must be sorted from lowest priority to highest priority''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_PROCESSPRIORITY table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_PROCESSSTATUS table ALERTS
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_PROCESSSTATUS IS ''The different Work Order / Process Status values allowed for the Operational and Administrative Status of a Process''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_PROCESSSTATUS table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_RESOURCE table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_RESOURCE IS ''The Resources used by the Workflow System''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_RESOURCE table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_RESOURCEGROUP table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_RESOURCEGROUP IS ''The Resource Groups used by the Workflow System''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_RESOURCEGROUP table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment on TTV_RESOURCEGROUPMEMBERSHIP table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_RESOURCEGROUPMEMBERSHIP IS ''Table contains the many-to-many relationship between Resource Groups and Resources. The data shows the membership of each resource in a set of resource groups''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_RESOURCEGROUPMEMBERSHIP table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment to TTV_RESOURCEGROUPQUEITEM table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_RESOURCEGROUPQUEUEITEM IS ''Each Resource Group manages an ordered queue of Tokens. This table stores each of the queue items (with their order in the queue) for each resource group''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_RESOURCEGROUPQUEITEM table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment to TTV_RESOURCESTATUS table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_RESOURCESTATUS IS ''The different possible value for the Operational or Administrative Status of a Resource in the system''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_RESOURCESTATUS table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment to TTV_RESOURCETYPE table
  
      BEGIN
      
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_RESOURCETYPE IS ''The different Resource Types supported by the system''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_RESOURCETYPE table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment to TTV_RESOURCEUSAGEHISTORY table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_RESOURCEUSAGEHISTORY IS ''NOT USED - THIS TABLE IS NOT USED ANYMORE''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_RESOURCEUSAGEHISTORY table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment to TTV_STRATEGYCLASS table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_STRATEGYCLASS IS ''The Strategy class implementations used by the Resource Manager in different scenarios (heartbeat, initialization, allocation). Each Strategy class is also aware of its Strategy Class Type''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_STRATEGYCLASS table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment to TTV_STRATEGYCLASSTYPE table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_STRATEGYCLASSTYPE IS ''The different types of strategies that Resource Manager supports''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_STRATEGYCLASSTYPE table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment to TTV_TOKENRESOURCE table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_TOKENRESOURCE IS ''Maintains the relationship between tokens and the resource they use''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_TOKENRESOURCE table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment to TTV_TOKENTYPE table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_TOKENTYPE IS ''Required as a result of sub-classing JBPM_TOKEN entity''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_TOKENTYPE table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment to TTV_VARIABLEACCESSTYPE table ALERTS
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_VARIABLEACCESSTYPE IS ''Required as a result of sub-classing JBPM_VARIABLEACCESS entity''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_VARIABLEACCESSYTPE table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment to UI_PROPERTIES table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.UI_PROPERTIES IS ''UNUSED TABLE''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the UI_PROPERTIES table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment to USERS_REALM table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.USERS_REALM IS ''Stores user name and password''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_USERS_REALM table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment to USER_BIGROLE table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.USER_BIGROLE IS ''User to role join table. I think there''''s a simple N:1 relationship''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the USER_BIGROLE table'')';
           GOTO bypass_install;
      END;
  
  -- Adding comment to USER_DATA table
  
      BEGIN
  
          EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.USER_DATA IS ''Information about the user, stuff like phone number, dept, employee id etc''';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the USER_DATA table'')';
           GOTO bypass_install;
      END;
      
      -- Adding comment to TTV_TRANSITIONTYPE
      BEGIN
      
        EXECUTE IMMEDIATE 'COMMENT ON TABLE WFS.TTV_TRANSITIONTYPE IS ''Required as a result of sub-classing JBPM_TRANSITION entity''';
        
      EXCEPTION
        WHEN OTHERS THEN
          wk_message := 'ERROR';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to add comment on the TTV_TRANSITIONTYPE table'')';
          GOTO bypass_install;
          
      END;
  
  /*
  ----------------------------------------
     DROPPING ALL PUBLIC SYNONYMS
  ----------------------------------------
  */
  
  
  /*
  ----------------------------------------
     CREATING ALL PUBLIC SYNONYMS
  ----------------------------------------
  */
  
  /*
  ---------------------------------------------------
     GRANTING privileges to wfs_user_role
  ---------------------------------------------------
  */
  
          <<bypass_install>>
  
          COMMIT;
          
          IF wk_message = 'ERROR' THEN
          
             NULL;
             
          ELSE
          
             EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''Installation completed SUCCESSFULLY'')';
             
          END IF;
          
  END;
/
