#!/bin/ksh

# @version $Id: DataRefresh.ksh,v 1.3 2007/09/18 01:24:57 cscherlacher Exp $

##
## Data Refresh from production!!!
##

date

echo "Refreshing Database data with Production data........"
filetimestamp=$(date +%Y%m%d%H%M%S)
echo " "

export ORACLE_BASE=/home/oracle
export ORACLE_HOME=$ORACLE_BASE/products/10.2.0
export PATH=$ORACLE_HOME/bin:$PATH:$HOME/bin:/usr/bin:/bin:/usr/bin/X11/:/usr/local/bin:
export LD_LIBRARY_PATH=$ORACLE_HOME/lib
export ORACLE_SID=DW_T1

$ORACLE_HOME/bin/sqlplus /nolog << EOM
    connect wfsdw/wfsdw
    PROMPT Refreshing WPDW_D1 Database DIM and FACT Tables with Production Database Data. PLEASE WAIT!
    set termout on echo on serveroutput on
    spool /home/oracle/admin/$ORACLE_SID/DataRefresh/DRLog/DRLogNew$filetimestamp.log
    begin
	WFSDW.PKG_ADMIN.SPMD_LOADDATA;
   end;
   /
   spool off
   set echo off termout off serveroutput off
   exit
EOM

echo " "
echo "DW_T1 Data Refresh completed, please check the DataRefresh.log file......!"
echo " "

sed -e '1,4d' /home/oracle/admin/$ORACLE_SID/DataRefresh/DRLog/DRLogNew$filetimestamp.log > /home/oracle/admin/$ORACLE_SID/DataRefresh/DRLog/DRLog$filetimestamp.log 

echo $filetimestamp > /home/oracle/admin/$ORACLE_SID/DataRefresh/RecentRun.dat

date
