/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "hi" locale.
 */
public class LocalizedNamesImpl_hi extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AO",
        "AQ",
        "AZ",
        "AD",
        "AF",
        "VI",
        "AS",
        "AW",
        "AR",
        "SV",
        "DZ",
        "AL",
        "AC",
        "IM",
        "IS",
        "CI",
        "QO",
        "IE",
        "AM",
        "ID",
        "EC",
        "GQ",
        "IT",
        "ET",
        "IQ",
        "ER",
        "IL",
        "IR",
        "UZ",
        "KP",
        "AI",
        "AG",
        "AX",
        "EE",
        "OM",
        "AT",
        "AU",
        "KZ",
        "QA",
        "CA",
        "KH",
        "CG",
        "KI",
        "KG",
        "CK",
        "KW",
        "KE",
        "KY",
        "IC",
        "CV",
        "CM",
        "CD",
        "CC",
        "KM",
        "CO",
        "CR",
        "CU",
        "CX",
        "HR",
        "CP",
        "GM",
        "GN",
        "GW",
        "GU",
        "GY",
        "GA",
        "GT",
        "GL",
        "GR",
        "GD",
        "GP",
        "GG",
        "GH",
        "TD",
        "CL",
        "CN",
        "CZ",
        "JM",
        "DE",
        "JE",
        "JP",
        "ZM",
        "DJ",
        "GI",
        "ZW",
        "JO",
        "GE",
        "TO",
        "TG",
        "TA",
        "DG",
        "DK",
        "DM",
        "DO",
        "TZ",
        "TW",
        "TJ",
        "TN",
        "TM",
        "TR",
        "TC",
        "TV",
        "TK",
        "TT",
        "TH",
        "ZA",
        "KR",
        "GS",
        "NE",
        "NG",
        "NR",
        "NA",
        "NI",
        "AN",
        "NL",
        "NU",
        "NP",
        "NF",
        "MP",
        "NO",
        "NC",
        "NZ",
        "PA",
        "PR",
        "PW",
        "EH",
        "PK",
        "PG",
        "PY",
        "PN",
        "PT",
        "TL",
        "PE",
        "PL",
        "FO",
        "FJ",
        "FI",
        "PH",
        "FR",
        "PS",
        "FK",
        "GF",
        "TF",
        "PF",
        "BM",
        "BS",
        "BD",
        "BB",
        "BH",
        "BI",
        "BF",
        "BG",
        "BJ",
        "BY",
        "BZ",
        "BE",
        "BW",
        "BO",
        "BA",
        "BV",
        "BR",
        "VG",
        "IO",
        "GB",
        "BN",
        "IN",
        "BT",
        "MN",
        "MO",
        "MW",
        "MY",
        "FM",
        "MQ",
        "MH",
        "MV",
        "ML",
        "MT",
        "EG",
        "MX",
        "MG",
        "YT",
        "MK",
        "ME",
        "MZ",
        "MC",
        "MA",
        "MD",
        "MS",
        "MR",
        "MU",
        "MM",
        "YE",
        "UG",
        "UM",
        "UY",
        "UA",
        "EU",
        "RE",
        "RW",
        "RU",
        "RO",
        "LU",
        "LR",
        "LA",
        "LV",
        "LI",
        "LT",
        "LY",
        "LB",
        "LS",
        "VU",
        "WF",
        "VN",
        "VE",
        "VA",
        "LK",
        "AE",
        "US",
        "SA",
        "WS",
        "RS",
        "CS",
        "CY",
        "ST",
        "SG",
        "SL",
        "EA",
        "SY",
        "SZ",
        "SR",
        "SD",
        "KN",
        "PM",
        "BL",
        "MF",
        "LC",
        "VC",
        "SH",
        "CF",
        "SN",
        "SC",
        "SM",
        "SO",
        "SB",
        "ES",
        "SK",
        "SI",
        "SJ",
        "CH",
        "SE",
        "HU",
        "HM",
        "HK",
        "HT",
        "HN",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "दुनिया");
    namesMap.put("002", "अफ्रीका");
    namesMap.put("003", "उत्तर अमेरिका");
    namesMap.put("005", "दक्षिण अमेरिका");
    namesMap.put("009", "ओशिआनिया");
    namesMap.put("011", "पश्चिमी अफ्रीका");
    namesMap.put("013", "मध्य अमरीका");
    namesMap.put("014", "पूर्वी अफ्रीका");
    namesMap.put("015", "उत्तरी अफ्रीका");
    namesMap.put("017", "मध्य अफ्रीका");
    namesMap.put("018", "दक्षिणी अफ्रीका");
    namesMap.put("019", "अमेरीकास");
    namesMap.put("021", "उत्तरी अमेरिका");
    namesMap.put("029", "कैरिबियन");
    namesMap.put("030", "पूर्वी एशिया");
    namesMap.put("034", "दक्षिणी एशिया");
    namesMap.put("035", "दक्षिण-पूर्व एशिया");
    namesMap.put("039", "दक्षिणी यूरोप");
    namesMap.put("053", "ऑस्ट्रेलिया एवं न्यूजीलैंड");
    namesMap.put("054", "मेलानेशिया");
    namesMap.put("057", "माइक्रोनेशियन रीजन");
    namesMap.put("061", "पोलीनेशिया");
    namesMap.put("062", "दक्षिण-मध्य एशिया");
    namesMap.put("142", "एशिया");
    namesMap.put("143", "मध्य एशिया");
    namesMap.put("145", "पश्चिमी ऐशिया");
    namesMap.put("150", "यूरोप");
    namesMap.put("151", "पूर्वी यूरोप");
    namesMap.put("154", "उत्तरी यूरोप");
    namesMap.put("155", "पश्चिमी यूरोप्");
    namesMap.put("172", "कॉमनवेल्थ ऑफ इंडिपेंडेंट स्टेट्स");
    namesMap.put("200", "चेकोस्लवाकिया");
    namesMap.put("419", "लेटिन अमेरिका और कैरिबियन");
    namesMap.put("830", "चैनल द्वीपसमूह");
    namesMap.put("AC", "असेंशन आइलैंड");
    namesMap.put("AD", "अन्डोरा");
    namesMap.put("AE", "संयुक्त अरब अमीरात");
    namesMap.put("AF", "अफ़गानिस्तान");
    namesMap.put("AG", "एंटिगुआ और बरबुडा");
    namesMap.put("AI", "एंगुइला");
    namesMap.put("AL", "अल्बानिया");
    namesMap.put("AM", "आर्मेनिया");
    namesMap.put("AN", "नीदरलैंड्स एंटिलीज़");
    namesMap.put("AO", "अंगोला");
    namesMap.put("AQ", "अंटार्कटिका");
    namesMap.put("AR", "अर्जेन्टीना");
    namesMap.put("AS", "अमेरिकी समोआ");
    namesMap.put("AT", "ऑस्ट्रिया");
    namesMap.put("AU", "ऑस्ट्रेलिया");
    namesMap.put("AW", "अरूबा");
    namesMap.put("AX", "एलैंड द्वीपसमूह");
    namesMap.put("AZ", "अज़रबैजान");
    namesMap.put("BA", "बोस्निया और हर्ज़िगोविना");
    namesMap.put("BB", "बारबाडोस");
    namesMap.put("BD", "बांग्लादेश");
    namesMap.put("BE", "बेल्जियम");
    namesMap.put("BF", "बुर्किना फ़ासो");
    namesMap.put("BG", "बुल्गारिया");
    namesMap.put("BH", "बाहरेन");
    namesMap.put("BI", "बुरुंडी");
    namesMap.put("BJ", "बेनिन");
    namesMap.put("BL", "सेंट बार्थेलेमी");
    namesMap.put("BM", "बरमूडा");
    namesMap.put("BN", "ब्रुनेई");
    namesMap.put("BO", "बोलीविया");
    namesMap.put("BR", "ब्राजील");
    namesMap.put("BS", "बहामा");
    namesMap.put("BT", "भूटान");
    namesMap.put("BV", "बौवेत द्वीप");
    namesMap.put("BW", "बोत्स्वाना");
    namesMap.put("BY", "बेलारूस");
    namesMap.put("BZ", "बेलिज");
    namesMap.put("CA", "कनाडा");
    namesMap.put("CC", "कोकोस द्वीप");
    namesMap.put("CD", "कोंगो जनतांत्रिक गणतंत्र");
    namesMap.put("CF", "सेंट्रल अफ्रीकन रिपब्लिक");
    namesMap.put("CG", "कांगो");
    namesMap.put("CH", "स्विस");
    namesMap.put("CI", "आईवरी कोस्ट");
    namesMap.put("CK", "कुक द्वीपसमूह");
    namesMap.put("CL", "चिली");
    namesMap.put("CM", "कैमरून");
    namesMap.put("CN", "चीन");
    namesMap.put("CO", "कोलम्बिया");
    namesMap.put("CP", "क्लिपर्टन आइलैंड");
    namesMap.put("CR", "कोस्टारीका");
    namesMap.put("CS", "सर्बिया व मॉण्टेनेग्रो");
    namesMap.put("CU", "क्यूबा");
    namesMap.put("CV", "कैप वर्डे");
    namesMap.put("CX", "क्रिसमस द्वीप");
    namesMap.put("CY", "साइप्रस");
    namesMap.put("CZ", "चेक गणराज्य");
    namesMap.put("DE", "जर्मनी");
    namesMap.put("DG", "डिएगो गार्शिया");
    namesMap.put("DJ", "जिबूती");
    namesMap.put("DK", "डेनमार्क");
    namesMap.put("DM", "डोमिनिक");
    namesMap.put("DO", "डोमिनिकन गणराज्य");
    namesMap.put("DZ", "अल्जीरिया");
    namesMap.put("EA", "सियुटा और मेलिल्ला");
    namesMap.put("EC", "इक्वाडोर");
    namesMap.put("EE", "एस्टोनिया");
    namesMap.put("EG", "मिस्र");
    namesMap.put("EH", "पश्चिमी सहारा");
    namesMap.put("ER", "इरिट्रिया");
    namesMap.put("ES", "स्पेन");
    namesMap.put("ET", "इथियोपिया");
    namesMap.put("EU", "यूरोपीय संघ");
    namesMap.put("FI", "फिनलैंड");
    namesMap.put("FJ", "फिजी");
    namesMap.put("FK", "फ़ॉकलैंड द्वीप");
    namesMap.put("FM", "माइक्रोनेशिया");
    namesMap.put("FO", "फरोए द्वीप");
    namesMap.put("FR", "फ्रांस");
    namesMap.put("GA", "गैबॉन");
    namesMap.put("GB", "ब्रितन");
    namesMap.put("GD", "ग्रेनेडा");
    namesMap.put("GE", "जॉर्जिया");
    namesMap.put("GF", "फ़्रांसीसी गिआना");
    namesMap.put("GG", "ग्वेर्नसे");
    namesMap.put("GH", "घाना");
    namesMap.put("GI", "जिब्राल्टर");
    namesMap.put("GL", "ग्रीनलैण्ड");
    namesMap.put("GM", "गाम्बिया");
    namesMap.put("GN", "गिनी");
    namesMap.put("GP", "ग्वाडेलोप");
    namesMap.put("GQ", "इक्वेटोरियल गिनी");
    namesMap.put("GR", "ग्रीस");
    namesMap.put("GS", "दक्षिण जोर्जिया और दक्षिण सैंडविच द्वीपसमूह");
    namesMap.put("GT", "गोतेदाला");
    namesMap.put("GU", "गुआम");
    namesMap.put("GW", "गीनी-बिसाउ");
    namesMap.put("GY", "गुयाना");
    namesMap.put("HK", "हाँग काँग");
    namesMap.put("HM", "हर्ड द्वीप और मैकडोनॉल्ड द्वीप");
    namesMap.put("HN", "हाण्डूरस");
    namesMap.put("HR", "क्रोशिया");
    namesMap.put("HT", "हाइती");
    namesMap.put("HU", "हंगरी");
    namesMap.put("IC", "कैनेरी आइलैंड");
    namesMap.put("ID", "इंडोनेशिया");
    namesMap.put("IE", "आयरलैंड");
    namesMap.put("IL", "इसराइल");
    namesMap.put("IM", "आइल ऑफ मैन");
    namesMap.put("IN", "भारत");
    namesMap.put("IO", "ब्रिटिश हिंद महासागरीय क्षेत्र");
    namesMap.put("IQ", "इराक");
    namesMap.put("IR", "ईरान");
    namesMap.put("IS", "आइसलैंड");
    namesMap.put("IT", "इटली");
    namesMap.put("JE", "जर्सी");
    namesMap.put("JM", "जमाइका");
    namesMap.put("JO", "जोर्डन");
    namesMap.put("JP", "जापान");
    namesMap.put("KE", "केन्या");
    namesMap.put("KG", "किर्गिज़तान");
    namesMap.put("KH", "कम्बोडिया");
    namesMap.put("KI", "किरिबाती");
    namesMap.put("KM", "कोमोरोस");
    namesMap.put("KN", "सेंट किट्स और नेविस");
    namesMap.put("KP", "उत्तर कोरिया");
    namesMap.put("KR", "दक्षिण कोरिया");
    namesMap.put("KW", "कुवैत");
    namesMap.put("KY", "केमैन द्वीपसमूह");
    namesMap.put("KZ", "कजाखस्तान");
    namesMap.put("LA", "लाओस");
    namesMap.put("LB", "लेबनान");
    namesMap.put("LC", "सेंट लूसिया");
    namesMap.put("LI", "लिकटेंस्टीन");
    namesMap.put("LK", "श्रीलंका");
    namesMap.put("LR", "लाइबेरिया");
    namesMap.put("LS", "लेसोथो");
    namesMap.put("LT", "लिथुआनिया");
    namesMap.put("LU", "लक्समबर्ग");
    namesMap.put("LV", "लात्विया");
    namesMap.put("LY", "लीबिया");
    namesMap.put("MA", "मोरक्को");
    namesMap.put("MC", "मोनाको");
    namesMap.put("MD", "मोल्डाविया");
    namesMap.put("ME", "मोंटेनेग्रो");
    namesMap.put("MF", "सेंट मार्टिन");
    namesMap.put("MG", "मैडागास्कर");
    namesMap.put("MH", "मार्शल द्वीप");
    namesMap.put("MK", "मैसेडोनिया");
    namesMap.put("ML", "माली");
    namesMap.put("MM", "म्यानमार");
    namesMap.put("MN", "मंगोलिया");
    namesMap.put("MO", "मकाओ");
    namesMap.put("MP", "नॉर्दन मारियाना द्वीपसमूह");
    namesMap.put("MQ", "मार्टीनिक");
    namesMap.put("MR", "मॉरिटानिया");
    namesMap.put("MS", "मॉन्ट्सेराट");
    namesMap.put("MT", "माल्टा");
    namesMap.put("MU", "मॉरिशस");
    namesMap.put("MV", "मालदीव");
    namesMap.put("MW", "मलावी");
    namesMap.put("MX", "मेक्सिको");
    namesMap.put("MY", "मलेशिया");
    namesMap.put("MZ", "मोजाम्बिक");
    namesMap.put("NA", "नामीबिया");
    namesMap.put("NC", "न्यू कैलेडोनिया");
    namesMap.put("NE", "नाइजर");
    namesMap.put("NF", "नॉरफ़ॉक द्वीप");
    namesMap.put("NG", "नाइजीरिया");
    namesMap.put("NI", "निकारागुआ");
    namesMap.put("NL", "नीदरलैण्ड");
    namesMap.put("NO", "नॉर्वे");
    namesMap.put("NP", "नेपाल");
    namesMap.put("NR", "नाउरु");
    namesMap.put("NU", "नीयू");
    namesMap.put("NZ", "न्यूज़ीलैंड");
    namesMap.put("OM", "ओमान");
    namesMap.put("PA", "पनामा");
    namesMap.put("PE", "पेरू");
    namesMap.put("PF", "फ़्रांसीसी पॉलिनेशिया");
    namesMap.put("PG", "पापुआ न्यू गिनी");
    namesMap.put("PH", "फिलीपिंस");
    namesMap.put("PK", "पाकिस्तान");
    namesMap.put("PL", "पोलैंड");
    namesMap.put("PM", "सेंट पिएरे और मिक्वेलन");
    namesMap.put("PN", "पिटकैर्न");
    namesMap.put("PR", "पर्टो रीको");
    namesMap.put("PS", "फ़िलिस्तीन");
    namesMap.put("PT", "पुर्तगाल");
    namesMap.put("PW", "पलाऊ");
    namesMap.put("PY", "पारागुए");
    namesMap.put("QA", "कतर");
    namesMap.put("QO", "आउटलाइंग ओशिनिया");
    namesMap.put("RE", "रियूनियन");
    namesMap.put("RO", "रोमानिया");
    namesMap.put("RS", "सर्बिया");
    namesMap.put("RU", "रूस");
    namesMap.put("RW", "रूआण्डा");
    namesMap.put("SA", "सऊदी अरब");
    namesMap.put("SB", "सोलोमन द्वीप");
    namesMap.put("SC", "सेशेल्स");
    namesMap.put("SD", "सूडान");
    namesMap.put("SE", "स्वीडन");
    namesMap.put("SG", "सिंगापुर");
    namesMap.put("SH", "सेंट हेलेना");
    namesMap.put("SI", "स्लोवेनिया");
    namesMap.put("SJ", "स्वालबर्ड और जान मायेन");
    namesMap.put("SK", "स्लोवाकिया");
    namesMap.put("SL", "सियरालेओन");
    namesMap.put("SM", "सैन मेरीनो");
    namesMap.put("SN", "सेनेगल");
    namesMap.put("SO", "सोमालिया");
    namesMap.put("SR", "सुरिनाम");
    namesMap.put("ST", "साउ-तोम-प्रिंसिप");
    namesMap.put("SV", "अल साल्वाडोर");
    namesMap.put("SY", "सीरिया");
    namesMap.put("SZ", "सुआजीलैंड");
    namesMap.put("TA", "ट्रिस्टन दा कुन्हा");
    namesMap.put("TC", "तुर्क् और् कैकोज़ द्वीप");
    namesMap.put("TD", "चाड");
    namesMap.put("TF", "फ़्रांसीसी दक्षिणी क्षेत्र");
    namesMap.put("TG", "टोगो");
    namesMap.put("TH", "थाइलैंड");
    namesMap.put("TJ", "ताजिकिस्तान");
    namesMap.put("TK", "तोकेलाउ");
    namesMap.put("TL", "पूर्वी तिमोर");
    namesMap.put("TM", "तुर्कमेनिस्तान");
    namesMap.put("TN", "तुनिशिया");
    namesMap.put("TO", "टोंगा");
    namesMap.put("TR", "तुर्की");
    namesMap.put("TT", "त्रिनिडाड और टोबैगो");
    namesMap.put("TV", "तुवालु");
    namesMap.put("TW", "ताइवान");
    namesMap.put("TZ", "तंजा़निया");
    namesMap.put("UA", "यूक्रेन");
    namesMap.put("UG", "युगांडा");
    namesMap.put("UM", "युनाइटेड स्टेट्स माइनर आउटलाइंग द्वीपसमूह");
    namesMap.put("US", "संयुक्त राज्य अमेरिका");
    namesMap.put("UY", "युरूगुए");
    namesMap.put("UZ", "उजबेकिस्तान");
    namesMap.put("VA", "वैटिकन");
    namesMap.put("VC", "सेंट विनसेंट एंड ग्रेनाडाइन्स");
    namesMap.put("VE", "वेनेजुएला");
    namesMap.put("VG", "ब्रिटिश वर्जिन द्वीपसमूह");
    namesMap.put("VI", "अमेरिकी वर्जिन टापू");
    namesMap.put("VN", "वियतनाम");
    namesMap.put("VU", "वानुअतु");
    namesMap.put("WF", "वालिस और फ़्यूचूना");
    namesMap.put("WS", "समोआ");
    namesMap.put("YE", "यमन");
    namesMap.put("YT", "मैयट");
    namesMap.put("ZA", "दक्षिण अफ्रीका");
    namesMap.put("ZM", "जाम्बिया");
    namesMap.put("ZW", "जिम्बाब्वे");
    namesMap.put("ZZ", "अज्ञात या अवैध क्षेत्र");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "दुनिया",
        "002": "अफ्रीका",
        "003": "उत्तर अमेरिका",
        "005": "दक्षिण अमेरिका",
        "009": "ओशिआनिया",
        "011": "पश्चिमी अफ्रीका",
        "013": "मध्य अमरीका",
        "014": "पूर्वी अफ्रीका",
        "015": "उत्तरी अफ्रीका",
        "017": "मध्य अफ्रीका",
        "018": "दक्षिणी अफ्रीका",
        "019": "अमेरीकास",
        "021": "उत्तरी अमेरिका",
        "029": "कैरिबियन",
        "030": "पूर्वी एशिया",
        "034": "दक्षिणी एशिया",
        "035": "दक्षिण-पूर्व एशिया",
        "039": "दक्षिणी यूरोप",
        "053": "ऑस्ट्रेलिया एवं न्यूजीलैंड",
        "054": "मेलानेशिया",
        "057": "माइक्रोनेशियन रीजन",
        "061": "पोलीनेशिया",
        "062": "दक्षिण-मध्य एशिया",
        "142": "एशिया",
        "143": "मध्य एशिया",
        "145": "पश्चिमी ऐशिया",
        "150": "यूरोप",
        "151": "पूर्वी यूरोप",
        "154": "उत्तरी यूरोप",
        "155": "पश्चिमी यूरोप्",
        "172": "कॉमनवेल्थ ऑफ इंडिपेंडेंट स्टेट्स",
        "200": "चेकोस्लवाकिया",
        "419": "लेटिन अमेरिका और कैरिबियन",
        "830": "चैनल द्वीपसमूह",
        "AC": "असेंशन आइलैंड",
        "AD": "अन्डोरा",
        "AE": "संयुक्त अरब अमीरात",
        "AF": "अफ़गानिस्तान",
        "AG": "एंटिगुआ और बरबुडा",
        "AI": "एंगुइला",
        "AL": "अल्बानिया",
        "AM": "आर्मेनिया",
        "AN": "नीदरलैंड्स एंटिलीज़",
        "AO": "अंगोला",
        "AQ": "अंटार्कटिका",
        "AR": "अर्जेन्टीना",
        "AS": "अमेरिकी समोआ",
        "AT": "ऑस्ट्रिया",
        "AU": "ऑस्ट्रेलिया",
        "AW": "अरूबा",
        "AX": "एलैंड द्वीपसमूह",
        "AZ": "अज़रबैजान",
        "BA": "बोस्निया और हर्ज़िगोविना",
        "BB": "बारबाडोस",
        "BD": "बांग्लादेश",
        "BE": "बेल्जियम",
        "BF": "बुर्किना फ़ासो",
        "BG": "बुल्गारिया",
        "BH": "बाहरेन",
        "BI": "बुरुंडी",
        "BJ": "बेनिन",
        "BL": "सेंट बार्थेलेमी",
        "BM": "बरमूडा",
        "BN": "ब्रुनेई",
        "BO": "बोलीविया",
        "BR": "ब्राजील",
        "BS": "बहामा",
        "BT": "भूटान",
        "BV": "बौवेत द्वीप",
        "BW": "बोत्स्वाना",
        "BY": "बेलारूस",
        "BZ": "बेलिज",
        "CA": "कनाडा",
        "CC": "कोकोस द्वीप",
        "CD": "कोंगो जनतांत्रिक गणतंत्र",
        "CF": "सेंट्रल अफ्रीकन रिपब्लिक",
        "CG": "कांगो",
        "CH": "स्विस",
        "CI": "आईवरी कोस्ट",
        "CK": "कुक द्वीपसमूह",
        "CL": "चिली",
        "CM": "कैमरून",
        "CN": "चीन",
        "CO": "कोलम्बिया",
        "CP": "क्लिपर्टन आइलैंड",
        "CR": "कोस्टारीका",
        "CS": "सर्बिया व मॉण्टेनेग्रो",
        "CU": "क्यूबा",
        "CV": "कैप वर्डे",
        "CX": "क्रिसमस द्वीप",
        "CY": "साइप्रस",
        "CZ": "चेक गणराज्य",
        "DE": "जर्मनी",
        "DG": "डिएगो गार्शिया",
        "DJ": "जिबूती",
        "DK": "डेनमार्क",
        "DM": "डोमिनिक",
        "DO": "डोमिनिकन गणराज्य",
        "DZ": "अल्जीरिया",
        "EA": "सियुटा और मेलिल्ला",
        "EC": "इक्वाडोर",
        "EE": "एस्टोनिया",
        "EG": "मिस्र",
        "EH": "पश्चिमी सहारा",
        "ER": "इरिट्रिया",
        "ES": "स्पेन",
        "ET": "इथियोपिया",
        "EU": "यूरोपीय संघ",
        "FI": "फिनलैंड",
        "FJ": "फिजी",
        "FK": "फ़ॉकलैंड द्वीप",
        "FM": "माइक्रोनेशिया",
        "FO": "फरोए द्वीप",
        "FR": "फ्रांस",
        "GA": "गैबॉन",
        "GB": "ब्रितन",
        "GD": "ग्रेनेडा",
        "GE": "जॉर्जिया",
        "GF": "फ़्रांसीसी गिआना",
        "GG": "ग्वेर्नसे",
        "GH": "घाना",
        "GI": "जिब्राल्टर",
        "GL": "ग्रीनलैण्ड",
        "GM": "गाम्बिया",
        "GN": "गिनी",
        "GP": "ग्वाडेलोप",
        "GQ": "इक्वेटोरियल गिनी",
        "GR": "ग्रीस",
        "GS": "दक्षिण जोर्जिया और दक्षिण सैंडविच द्वीपसमूह",
        "GT": "गोतेदाला",
        "GU": "गुआम",
        "GW": "गीनी-बिसाउ",
        "GY": "गुयाना",
        "HK": "हाँग काँग",
        "HM": "हर्ड द्वीप और मैकडोनॉल्ड द्वीप",
        "HN": "हाण्डूरस",
        "HR": "क्रोशिया",
        "HT": "हाइती",
        "HU": "हंगरी",
        "IC": "कैनेरी आइलैंड",
        "ID": "इंडोनेशिया",
        "IE": "आयरलैंड",
        "IL": "इसराइल",
        "IM": "आइल ऑफ मैन",
        "IN": "भारत",
        "IO": "ब्रिटिश हिंद महासागरीय क्षेत्र",
        "IQ": "इराक",
        "IR": "ईरान",
        "IS": "आइसलैंड",
        "IT": "इटली",
        "JE": "जर्सी",
        "JM": "जमाइका",
        "JO": "जोर्डन",
        "JP": "जापान",
        "KE": "केन्या",
        "KG": "किर्गिज़तान",
        "KH": "कम्बोडिया",
        "KI": "किरिबाती",
        "KM": "कोमोरोस",
        "KN": "सेंट किट्स और नेविस",
        "KP": "उत्तर कोरिया",
        "KR": "दक्षिण कोरिया",
        "KW": "कुवैत",
        "KY": "केमैन द्वीपसमूह",
        "KZ": "कजाखस्तान",
        "LA": "लाओस",
        "LB": "लेबनान",
        "LC": "सेंट लूसिया",
        "LI": "लिकटेंस्टीन",
        "LK": "श्रीलंका",
        "LR": "लाइबेरिया",
        "LS": "लेसोथो",
        "LT": "लिथुआनिया",
        "LU": "लक्समबर्ग",
        "LV": "लात्विया",
        "LY": "लीबिया",
        "MA": "मोरक्को",
        "MC": "मोनाको",
        "MD": "मोल्डाविया",
        "ME": "मोंटेनेग्रो",
        "MF": "सेंट मार्टिन",
        "MG": "मैडागास्कर",
        "MH": "मार्शल द्वीप",
        "MK": "मैसेडोनिया",
        "ML": "माली",
        "MM": "म्यानमार",
        "MN": "मंगोलिया",
        "MO": "मकाओ",
        "MP": "नॉर्दन मारियाना द्वीपसमूह",
        "MQ": "मार्टीनिक",
        "MR": "मॉरिटानिया",
        "MS": "मॉन्ट्सेराट",
        "MT": "माल्टा",
        "MU": "मॉरिशस",
        "MV": "मालदीव",
        "MW": "मलावी",
        "MX": "मेक्सिको",
        "MY": "मलेशिया",
        "MZ": "मोजाम्बिक",
        "NA": "नामीबिया",
        "NC": "न्यू कैलेडोनिया",
        "NE": "नाइजर",
        "NF": "नॉरफ़ॉक द्वीप",
        "NG": "नाइजीरिया",
        "NI": "निकारागुआ",
        "NL": "नीदरलैण्ड",
        "NO": "नॉर्वे",
        "NP": "नेपाल",
        "NR": "नाउरु",
        "NU": "नीयू",
        "NZ": "न्यूज़ीलैंड",
        "OM": "ओमान",
        "PA": "पनामा",
        "PE": "पेरू",
        "PF": "फ़्रांसीसी पॉलिनेशिया",
        "PG": "पापुआ न्यू गिनी",
        "PH": "फिलीपिंस",
        "PK": "पाकिस्तान",
        "PL": "पोलैंड",
        "PM": "सेंट पिएरे और मिक्वेलन",
        "PN": "पिटकैर्न",
        "PR": "पर्टो रीको",
        "PS": "फ़िलिस्तीन",
        "PT": "पुर्तगाल",
        "PW": "पलाऊ",
        "PY": "पारागुए",
        "QA": "कतर",
        "QO": "आउटलाइंग ओशिनिया",
        "RE": "रियूनियन",
        "RO": "रोमानिया",
        "RS": "सर्बिया",
        "RU": "रूस",
        "RW": "रूआण्डा",
        "SA": "सऊदी अरब",
        "SB": "सोलोमन द्वीप",
        "SC": "सेशेल्स",
        "SD": "सूडान",
        "SE": "स्वीडन",
        "SG": "सिंगापुर",
        "SH": "सेंट हेलेना",
        "SI": "स्लोवेनिया",
        "SJ": "स्वालबर्ड और जान मायेन",
        "SK": "स्लोवाकिया",
        "SL": "सियरालेओन",
        "SM": "सैन मेरीनो",
        "SN": "सेनेगल",
        "SO": "सोमालिया",
        "SR": "सुरिनाम",
        "ST": "साउ-तोम-प्रिंसिप",
        "SV": "अल साल्वाडोर",
        "SY": "सीरिया",
        "SZ": "सुआजीलैंड",
        "TA": "ट्रिस्टन दा कुन्हा",
        "TC": "तुर्क् और् कैकोज़ द्वीप",
        "TD": "चाड",
        "TF": "फ़्रांसीसी दक्षिणी क्षेत्र",
        "TG": "टोगो",
        "TH": "थाइलैंड",
        "TJ": "ताजिकिस्तान",
        "TK": "तोकेलाउ",
        "TL": "पूर्वी तिमोर",
        "TM": "तुर्कमेनिस्तान",
        "TN": "तुनिशिया",
        "TO": "टोंगा",
        "TR": "तुर्की",
        "TT": "त्रिनिडाड और टोबैगो",
        "TV": "तुवालु",
        "TW": "ताइवान",
        "TZ": "तंजा़निया",
        "UA": "यूक्रेन",
        "UG": "युगांडा",
        "UM": "युनाइटेड स्टेट्स माइनर आउटलाइंग द्वीपसमूह",
        "US": "संयुक्त राज्य अमेरिका",
        "UY": "युरूगुए",
        "UZ": "उजबेकिस्तान",
        "VA": "वैटिकन",
        "VC": "सेंट विनसेंट एंड ग्रेनाडाइन्स",
        "VE": "वेनेजुएला",
        "VG": "ब्रिटिश वर्जिन द्वीपसमूह",
        "VI": "अमेरिकी वर्जिन टापू",
        "VN": "वियतनाम",
        "VU": "वानुअतु",
        "WF": "वालिस और फ़्यूचूना",
        "WS": "समोआ",
        "YE": "यमन",
        "YT": "मैयट",
        "ZA": "दक्षिण अफ्रीका",
        "ZM": "जाम्बिया",
        "ZW": "जिम्बाब्वे",
        "ZZ": "अज्ञात या अवैध क्षेत्र"
    };
  }-*/;
}
