/*
 * Created on May 23, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.ui.realm.client;

/**
 * Maintains the permission names
 * 
 * @author Vijay Silva
 */
public final class RealmComponentPermissions {

	/* Cannot instantiate */
	private RealmComponentPermissions() {
	}

	/**
	 * User View permission name
	 */
	public static final String USER_VIEW = "UserManagement_View";

	/**
	 * User Create permission name
	 */
	public static final String USER_CREATE = "UserManagement_Create";

	/**
	 * User Modify permission name
	 */
	public static final String USER_MODIFY = "UserManagement_Modify";

	/**
	 * User Delete permission name
	 */
	public static final String USER_DELETE = "UserManagement_Delete";

	/**
	 * Role View permission name
	 */
	public static final String ROLE_VIEW = "RoleManagement_View";

	/**
	 * Role Create permission name
	 */
	public static final String ROLE_CREATE = "RoleManagement_Create";

	/**
	 * Role Modify permission name
	 */
	public static final String ROLE_MODIFY = "RoleManagement_Modify";

	/**
	 * Role Delete permission name
	 */
	public static final String ROLE_DELETE = "RoleManagement_Delete";
}
