/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.util.Collection;
import java.util.Iterator;
import org.aspectj.ajdt.internal.compiler.ast.AjMethodDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AtAspectJAnnotationFactory;
import org.aspectj.ajdt.internal.compiler.ast.EclipseAttributeAdapter;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Parser;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.DeclareAnnotation;
import org.aspectj.weaver.patterns.DeclareErrorOrWarning;
import org.aspectj.weaver.patterns.DeclareParents;
import org.aspectj.weaver.patterns.DeclarePrecedence;
import org.aspectj.weaver.patterns.DeclareSoft;
import org.aspectj.weaver.patterns.FormalBinding;

public class DeclareDeclaration
extends AjMethodDeclaration {
    public Declare declareDecl;

    public DeclareDeclaration(CompilationResult result, Declare symbolicDeclare) {
        super(result);
        this.declareDecl = symbolicDeclare;
        if (this.declareDecl != null) {
            this.declarationSourceStart = this.sourceStart = this.declareDecl.getStart();
            this.declarationSourceEnd = this.sourceEnd = this.declareDecl.getEnd();
        }
        this.returnType = TypeReference.baseTypeReference(6, 0);
    }

    public void addAtAspectJAnnotations() {
        Annotation annotation = null;
        if (this.declareDecl instanceof DeclareAnnotation) {
            DeclareAnnotation da = (DeclareAnnotation)this.declareDecl;
            String patternString = da.getPatternAsString();
            String annString = da.getAnnotationString();
            String kind = da.getKind().toString();
            annotation = AtAspectJAnnotationFactory.createDeclareAnnAnnotation(patternString, annString, kind, this.declarationSourceStart);
        } else if (this.declareDecl instanceof DeclareErrorOrWarning) {
            DeclareErrorOrWarning dd = (DeclareErrorOrWarning)this.declareDecl;
            annotation = AtAspectJAnnotationFactory.createDeclareErrorOrWarningAnnotation(dd.getPointcut().toString(), dd.getMessage(), dd.isError(), this.declarationSourceStart);
        } else if (this.declareDecl instanceof DeclareParents) {
            DeclareParents dp = (DeclareParents)this.declareDecl;
            String childPattern = dp.getChild().toString();
            Collection parentPatterns = dp.getParents().getExactTypes();
            StringBuffer parents = new StringBuffer();
            Iterator iter = parentPatterns.iterator();
            while (iter.hasNext()) {
                UnresolvedType urt = (UnresolvedType)iter.next();
                parents.append(urt.getName());
                if (!iter.hasNext()) continue;
                parents.append(", ");
            }
            annotation = AtAspectJAnnotationFactory.createDeclareParentsAnnotation(childPattern, parents.toString(), dp.isExtends(), this.declarationSourceStart);
        } else if (this.declareDecl instanceof DeclarePrecedence) {
            DeclarePrecedence dp = (DeclarePrecedence)this.declareDecl;
            String precedenceList = dp.getPatterns().toString();
            annotation = AtAspectJAnnotationFactory.createDeclarePrecedenceAnnotation(precedenceList, this.declarationSourceStart);
        } else if (this.declareDecl instanceof DeclareSoft) {
            DeclareSoft ds = (DeclareSoft)this.declareDecl;
            annotation = AtAspectJAnnotationFactory.createDeclareSoftAnnotation(ds.getPointcut().toString(), ds.getException().getExactType().getName(), this.declarationSourceStart);
        }
        if (annotation != null) {
            AtAspectJAnnotationFactory.addAnnotation(this, annotation, this.scope);
        }
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        this.binding.modifiers |= 0x1000;
        classFile.extraAttributes.add(new EclipseAttributeAdapter(new AjAttribute.DeclareAttribute(this.declareDecl)));
        if (this.shouldDelegateCodeGeneration()) {
            super.generateCode(classScope, classFile);
        }
    }

    protected boolean shouldDelegateCodeGeneration() {
        return true;
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
    }

    public void resolveStatements(ClassScope upperScope) {
    }

    public Declare build(ClassScope classScope) {
        if (this.declareDecl == null) {
            return null;
        }
        EclipseScope scope = new EclipseScope(new FormalBinding[0], classScope);
        this.declareDecl.resolve(scope);
        return this.declareDecl;
    }

    public StringBuffer print(int tab, StringBuffer output) {
        ASTNode.printIndent(tab, output);
        if (this.declareDecl == null) {
            output.append("<declare>");
        } else {
            output.append(this.declareDecl.toString());
        }
        return output;
    }

    protected int generateInfoAttributes(ClassFile classFile) {
        return super.generateInfoAttributes(classFile, true);
    }

    public void postParse(TypeDeclaration typeDec) {
        String suffix;
        super.postParse(typeDec);
        int declareSequenceNumberInType = ((AspectDeclaration)typeDec).declareCounter++;
        StringBuffer sb = new StringBuffer();
        sb.append("ajc$declare");
        if (this.declareDecl != null && (suffix = this.declareDecl.getNameSuffix()).length() != 0) {
            sb.append("_");
            sb.append(suffix);
        }
        sb.append("_");
        sb.append(declareSequenceNumberInType);
        this.selector = sb.toString().toCharArray();
    }
}

