/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.patch.FileDiff;
import org.eclipse.compare.internal.patch.Hunk;
import org.eclipse.compare.internal.patch.HunkResult;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.Patcher;
import org.eclipse.compare.patch.IFilePatchResult;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class FileDiffResult
implements IFilePatchResult {
    private FileDiff fDiff;
    private boolean fMatches = false;
    private boolean fDiffProblem;
    private String fErrorMessage;
    private Map fHunkResults = new HashMap();
    private List fBeforeLines;
    private List fAfterLines;
    private final PatchConfiguration configuration;
    private String charset;

    public FileDiffResult(FileDiff diff, PatchConfiguration configuration) {
        this.fDiff = diff;
        this.configuration = configuration;
    }

    public PatchConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean canApplyHunk(Hunk hunk) {
        HunkResult result = this.getHunkResult(hunk);
        return result.isOK() && !this.fDiffProblem;
    }

    public void refresh(IStorage storage, IProgressMonitor monitor) {
        HunkResult result;
        Hunk hunk;
        int i;
        Hunk[] hunks;
        this.fMatches = false;
        this.fDiffProblem = false;
        boolean create = false;
        this.charset = Utilities.getCharset(storage);
        boolean exists = this.targetExists(storage);
        if (this.fDiff.getDiffType(this.getConfiguration().isReversed()) == 1) {
            if ((!exists || this.isEmpty(storage)) && this.canCreateTarget(storage)) {
                this.fMatches = true;
            } else {
                this.fDiffProblem = true;
                this.fErrorMessage = PatchMessages.PreviewPatchPage_FileExists_error;
            }
            create = true;
        } else if (exists) {
            this.fMatches = true;
        } else {
            this.fDiffProblem = true;
            this.fErrorMessage = PatchMessages.PreviewPatchPage_FileDoesNotExist_error;
        }
        if (this.fDiffProblem) {
            this.fBeforeLines = new ArrayList(this.getLines(storage, false));
            this.fAfterLines = this.fMatches ? new ArrayList() : this.fBeforeLines;
            hunks = this.fDiff.getHunks();
            i = 0;
            while (i < hunks.length) {
                hunk = hunks[i];
                result = this.getHunkResult(hunk);
                result.setMatches(false);
                ++i;
            }
        } else {
            this.patch(this.getLines(storage, create), monitor);
        }
        if (this.containsProblems() && this.fMatches) {
            this.fMatches = false;
            hunks = this.fDiff.getHunks();
            i = 0;
            while (i < hunks.length) {
                hunk = hunks[i];
                result = this.getHunkResult(hunk);
                if (result.isOK()) {
                    this.fMatches = true;
                    break;
                }
                ++i;
            }
        }
    }

    protected boolean canCreateTarget(IStorage storage) {
        return true;
    }

    protected boolean targetExists(IStorage storage) {
        return storage != null;
    }

    protected List getLines(IStorage storage, boolean create) {
        List lines = Patcher.load(storage, create);
        return lines;
    }

    protected boolean isEmpty(IStorage storage) {
        if (storage == null) {
            return true;
        }
        return Patcher.load(storage, false).isEmpty();
    }

    public void patch(List lines, IProgressMonitor monitor) {
        this.fBeforeLines = new ArrayList();
        this.fBeforeLines.addAll(lines);
        if (this.getConfiguration().getFuzz() != 0) {
            this.calculateFuzz(this.fBeforeLines, monitor);
        }
        int shift = 0;
        Hunk[] hunks = this.fDiff.getHunks();
        int i = 0;
        while (i < hunks.length) {
            Hunk hunk = hunks[i];
            HunkResult result = this.getHunkResult(hunk);
            result.setShift(shift);
            if (result.patch(lines)) {
                shift = result.getShift();
            }
            ++i;
        }
        this.fAfterLines = lines;
    }

    protected boolean getDiffProblem() {
        return this.fDiffProblem;
    }

    protected boolean containsProblems() {
        if (this.fDiffProblem) {
            return true;
        }
        Iterator iterator = this.fHunkResults.values().iterator();
        while (iterator.hasNext()) {
            HunkResult result = (HunkResult)iterator.next();
            if (result.isOK()) continue;
            return true;
        }
        return false;
    }

    public String getLabel() {
        String label = this.getTargetPath().toString();
        if (this.fDiffProblem) {
            return NLS.bind((String)PatchMessages.Diff_2Args, (Object[])new String[]{label, this.fErrorMessage});
        }
        return label;
    }

    public boolean hasMatches() {
        return this.fMatches;
    }

    public List getLines() {
        return this.fAfterLines;
    }

    public int calculateFuzz(List lines, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.fBeforeLines = new ArrayList(lines);
        if (this.fDiff.getDiffType(this.getConfiguration().isReversed()) == 1) {
            return -1;
        }
        int shift = 0;
        int highestFuzz = -1;
        String name = this.getTargetPath() != null ? this.getTargetPath().lastSegment() : "";
        Hunk[] hunks = this.fDiff.getHunks();
        int j = 0;
        while (j < hunks.length) {
            Hunk h = hunks[j];
            monitor.subTask(NLS.bind((String)PatchMessages.PreviewPatchPage_GuessFuzzProgress_format, (Object[])new String[]{name, Integer.toString(j + 1)}));
            HunkResult result = this.getHunkResult(h);
            result.setShift(shift);
            int fuzz = result.calculateFuzz(lines, monitor);
            shift = result.getShift();
            if (fuzz > highestFuzz) {
                highestFuzz = fuzz;
            }
            monitor.worked(1);
            ++j;
        }
        this.fAfterLines = lines;
        return highestFuzz;
    }

    public IPath getTargetPath() {
        return this.fDiff.getStrippedPath(this.getConfiguration().getPrefixSegmentStripCount(), this.getConfiguration().isReversed());
    }

    private HunkResult getHunkResult(Hunk hunk) {
        HunkResult result = (HunkResult)this.fHunkResults.get(hunk);
        if (result == null) {
            result = new HunkResult(this, hunk);
            this.fHunkResults.put(hunk, result);
        }
        return result;
    }

    List getFailedHunks() {
        ArrayList<Hunk> failedHunks = new ArrayList<Hunk>();
        Iterator iterator = this.fHunkResults.values().iterator();
        while (iterator.hasNext()) {
            HunkResult result = (HunkResult)iterator.next();
            if (result.isOK()) continue;
            failedHunks.add(result.getHunk());
        }
        return failedHunks;
    }

    private HunkResult[] getFailedHunkResults() {
        ArrayList<HunkResult> failedHunks = new ArrayList<HunkResult>();
        Iterator iterator = this.fHunkResults.values().iterator();
        while (iterator.hasNext()) {
            HunkResult result = (HunkResult)iterator.next();
            if (result.isOK()) continue;
            failedHunks.add(result);
        }
        return failedHunks.toArray(new HunkResult[failedHunks.size()]);
    }

    public FileDiff getDiff() {
        return this.fDiff;
    }

    List getBeforeLines() {
        return this.fBeforeLines;
    }

    List getAfterLines() {
        return this.fAfterLines;
    }

    public HunkResult[] getHunkResults() {
        return this.fHunkResults.values().toArray(new HunkResult[this.fHunkResults.size()]);
    }

    public InputStream getOriginalContents() {
        String contents = Patcher.createString(this.isPreserveLineDelimeters(), this.getBeforeLines());
        return FileDiffResult.asInputStream(contents, this.getCharset());
    }

    public InputStream getPatchedContents() {
        String contents = Patcher.createString(this.isPreserveLineDelimeters(), this.getLines());
        return FileDiffResult.asInputStream(contents, this.getCharset());
    }

    public String getCharset() {
        return this.charset;
    }

    protected boolean isPreserveLineDelimeters() {
        return false;
    }

    public IHunk[] getRejects() {
        return this.getFailedHunkResults();
    }

    public boolean hasRejects() {
        return this.getFailedHunkResults().length > 0;
    }

    public static InputStream asInputStream(String contents, String charSet) {
        byte[] bytes = null;
        if (charSet != null) {
            try {
                bytes = contents.getBytes(charSet);
            }
            catch (UnsupportedEncodingException e) {
                CompareUIPlugin.log(e);
            }
        }
        if (bytes == null) {
            bytes = contents.getBytes();
        }
        return new ByteArrayInputStream(bytes);
    }
}

