/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.ViewPaneRenderingMgr;
import org.eclipse.debug.internal.ui.views.memory.renderings.CreateRendering;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingSynchronizationService;
import org.eclipse.debug.ui.memory.IResettableMemoryRendering;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class RenderingViewPane
extends AbstractMemoryViewPane
implements IMemoryRenderingContainer {
    public static final String RENDERING_VIEW_PANE_ID = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".MemoryView.RenderingViewPane";
    private Hashtable fTabFolderForMemoryBlock = new Hashtable();
    private Hashtable fMemoryBlockFromTabFolder = new Hashtable();
    private ViewPaneRenderingMgr fRenderingMgr;
    private IMemoryRenderingSite fRenderingSite;
    private Set fAddedRenderings = new HashSet();
    private Set fAddedMemoryBlocks = new HashSet();
    private boolean fCanAddRendering = true;
    private boolean fCanRemoveRendering = true;
    private boolean fIsDisposed = false;

    public RenderingViewPane(IViewPart parent) {
        super(parent);
        if (parent instanceof IMemoryRenderingSite) {
            this.fRenderingSite = (IMemoryRenderingSite)parent;
        } else {
            DebugUIPlugin.logErrorMessage("Parent for the rendering view pane is invalid.");
        }
    }

    public void memoryBlocksAdded(final IMemoryBlock[] memoryBlocks) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (RenderingViewPane.this.isDisposed()) {
                    return;
                }
                if (memoryBlocks == null || memoryBlocks.length <= 0) {
                    return;
                }
                int i = 0;
                while (i < memoryBlocks.length) {
                    IMemoryBlock memory = memoryBlocks[i];
                    if (!RenderingViewPane.this.fTabFolderForMemoryBlock.containsKey(memory)) {
                        RenderingViewPane.this.createFolderForMemoryBlock(memory);
                    }
                    RenderingViewPane.this.fAddedMemoryBlocks.add(memory);
                    RenderingViewPane.this.updateToolBarActionsEnablement();
                    ++i;
                }
            }
        });
    }

    public void memoryBlocksRemoved(final IMemoryBlock[] memoryBlocks) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                int j = 0;
                while (j < memoryBlocks.length) {
                    IMemoryBlock mbRemoved = memoryBlocks[j];
                    if (RenderingViewPane.this.fTabFolderForMemoryBlock == null) {
                        return;
                    }
                    IMemoryRendering[] renderings = RenderingViewPane.this.fRenderingMgr.getRenderingsFromMemoryBlock(mbRemoved);
                    int k = 0;
                    while (k < renderings.length) {
                        RenderingViewPane.this.removeMemoryRendering(renderings[k]);
                        ++k;
                    }
                    CTabFolder tabFolder = (CTabFolder)RenderingViewPane.this.fTabFolderForMemoryBlock.get(mbRemoved);
                    if (tabFolder != null) {
                        RenderingViewPane.this.fTabFolderForMemoryBlock.remove(mbRemoved);
                        RenderingViewPane.this.fMemoryBlockFromTabFolder.remove(tabFolder);
                        IMemoryBlockRetrieval retrieve = MemoryViewUtil.getMemoryBlockRetrieval(mbRemoved);
                        if (retrieve != null && RenderingViewPane.this.fTabFolderForDebugView.contains(tabFolder)) {
                            RenderingViewPane.this.fTabFolderForDebugView.remove(retrieve);
                        }
                        if (!tabFolder.isDisposed()) {
                            CTabItem[] items = tabFolder.getItems();
                            int i = 0;
                            while (i < items.length) {
                                RenderingViewPane.this.disposeTab(items[i]);
                                ++i;
                            }
                            tabFolder.dispose();
                            if (tabFolder == RenderingViewPane.this.fStackLayout.topControl) {
                                ISelection selection = DebugUIPlugin.getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.MemoryView");
                                IMemoryBlock mbToSelect = RenderingViewPane.this.getMemoryBlock(selection);
                                if (mbToSelect != null) {
                                    if (mbToSelect != mbRemoved) {
                                        RenderingViewPane.this.handleMemoryBlockSelection(null, mbToSelect);
                                    } else if (MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(retrieve).length > 0) {
                                        mbToSelect = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(retrieve)[0];
                                        RenderingViewPane.this.handleMemoryBlockSelection(null, mbToSelect);
                                    } else {
                                        RenderingViewPane.this.emptyFolder();
                                    }
                                } else if (MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(retrieve).length > 0) {
                                    mbToSelect = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(retrieve)[0];
                                    RenderingViewPane.this.handleMemoryBlockSelection(null, mbToSelect);
                                } else {
                                    RenderingViewPane.this.emptyFolder();
                                }
                            }
                        }
                        RenderingViewPane.this.fAddedMemoryBlocks.remove(mbRemoved);
                        RenderingViewPane.this.updateToolBarActionsEnablement();
                    }
                    ++j;
                }
            }
        });
    }

    public void selectionChanged(final IWorkbenchPart part, final ISelection selection) {
        if (this.fIsDisposed) {
            return;
        }
        if (part == this) {
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        if (selection == AbstractMemoryViewPane.EMPTY) {
            return;
        }
        UIJob job = new UIJob("RenderingViewPane selectionChanged"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (RenderingViewPane.this.isDisposed()) {
                        return Status.OK_STATUS;
                    }
                    if (selection.isEmpty()) {
                        if (part.getSite().getId().equals("org.eclipse.debug.ui.MemoryView") && part == RenderingViewPane.this.getMemoryRenderingSite().getSite().getPart()) {
                            IMemoryViewTab lastViewTab = RenderingViewPane.this.getTopMemoryTab();
                            if (lastViewTab != null) {
                                lastViewTab.setEnabled(false);
                            }
                            RenderingViewPane.this.emptyFolder();
                        }
                        return Status.OK_STATUS;
                    }
                    IMemoryViewTab lastViewTab = RenderingViewPane.this.getTopMemoryTab();
                    if (!(selection instanceof IStructuredSelection)) {
                        return Status.OK_STATUS;
                    }
                    Object elem = ((IStructuredSelection)selection).getFirstElement();
                    if (elem instanceof IMemoryBlock && part == RenderingViewPane.this.getMemoryRenderingSite()) {
                        IMemoryBlock memBlock = (IMemoryBlock)elem;
                        if (RenderingViewPane.this.fTabFolderForMemoryBlock == null) {
                            if (lastViewTab != null) {
                                lastViewTab.setEnabled(false);
                            }
                            RenderingViewPane.this.emptyFolder();
                            return Status.OK_STATUS;
                        }
                        RenderingViewPane.this.handleMemoryBlockSelection(lastViewTab, memBlock);
                    }
                }
                catch (SWTException se) {
                    DebugUIPlugin.log(se);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void handleMemoryBlockSelection(IMemoryViewTab lastViewTab, IMemoryBlock memBlock) {
        IMemoryViewTab viewTab;
        IMemoryBlock currentBlk;
        CTabFolder currentFolder = (CTabFolder)this.fStackLayout.topControl;
        if (currentFolder != null && !currentFolder.isDisposed() && (currentBlk = (IMemoryBlock)this.fMemoryBlockFromTabFolder.get(currentFolder)) != null && currentBlk == memBlock) {
            return;
        }
        if (this.getTopMemoryTab() != null && this.getTopMemoryTab().getRendering().getMemoryBlock() == memBlock) {
            return;
        }
        if (this.fTabFolderForMemoryBlock.containsKey(memBlock)) {
            if (this.fStackLayout.topControl != (CTabFolder)this.fTabFolderForMemoryBlock.get(memBlock)) {
                this.setTabFolder((CTabFolder)this.fTabFolderForMemoryBlock.get(memBlock));
                this.fViewPaneCanvas.layout();
            }
        } else {
            CTabFolder folder = this.createTabFolder(this.fViewPaneCanvas);
            this.fTabFolderForMemoryBlock.put(memBlock, folder);
            this.fMemoryBlockFromTabFolder.put(folder, memBlock);
            this.setTabFolder((CTabFolder)this.fTabFolderForMemoryBlock.get(memBlock));
            this.fViewPaneCanvas.layout();
            this.fAddedMemoryBlocks.add(memBlock);
            this.newCreateRenderingForFolder(memBlock, folder);
        }
        IMemoryRendering[] renderings = this.fRenderingMgr.getRenderingsFromMemoryBlock(memBlock);
        CTabFolder toDisplay = (CTabFolder)this.fStackLayout.topControl;
        if (this.isRestoreViewTabs(toDisplay)) {
            this.restoreViewTabs(renderings);
        }
        IMemoryViewTab newViewTab = this.getTopMemoryTab();
        if (lastViewTab != null && lastViewTab != newViewTab) {
            lastViewTab.setEnabled(false);
        }
        if (newViewTab != null && !newViewTab.isEnabled() && this.fVisible) {
            newViewTab.setEnabled(this.fVisible);
        }
        if ((viewTab = this.getTopMemoryTab()) != null) {
            this.setRenderingSelection(viewTab.getRendering());
        }
        this.updateToolBarActionsEnablement();
    }

    private boolean isRestoreViewTabs(CTabFolder folder) {
        if (this.canAddRendering()) {
            return folder.getItemCount() == 1 && this.getTopMemoryTab().getRendering() instanceof CreateRendering;
        }
        return folder.getItemCount() == 0;
    }

    private int getIndexOfCreateRenderingTab(CTabFolder folder) {
        int i = 0;
        while (i < folder.getItemCount()) {
            if (folder.getItem(i).getData() instanceof MemoryViewTab && ((MemoryViewTab)folder.getItem(i).getData()).getRendering() instanceof CreateRendering) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void memoryBlockRenderingAdded(final IMemoryRendering rendering) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (RenderingViewPane.this.isDisposed()) {
                    return;
                }
                if (RenderingViewPane.this.fAddedRenderings.contains(rendering)) {
                    return;
                }
                IMemoryBlock memoryblk = rendering.getMemoryBlock();
                CTabFolder tabFolder = (CTabFolder)RenderingViewPane.this.fTabFolderForMemoryBlock.get(memoryblk);
                if (tabFolder == null) {
                    tabFolder = RenderingViewPane.this.createFolderForMemoryBlock(memoryblk);
                }
                if (tabFolder == RenderingViewPane.this.fStackLayout.topControl && RenderingViewPane.this.getTopMemoryTab() != null) {
                    RenderingViewPane.this.deactivateRendering(RenderingViewPane.this.getTopMemoryTab());
                    RenderingViewPane.this.getTopMemoryTab().setEnabled(false);
                }
                RenderingViewPane.this.fAddedRenderings.add(rendering);
                int index = RenderingViewPane.this.getIndexOfCreateRenderingTab(tabFolder);
                if (index < 0) {
                    index = 0;
                }
                CTabItem tab = RenderingViewPane.this.createTab(tabFolder, index);
                MemoryViewTab viewTab = new MemoryViewTab(tab, rendering, RenderingViewPane.this.getInstance());
                tabFolder.setSelection(tabFolder.indexOf(tab));
                if (tabFolder == RenderingViewPane.this.fStackLayout.topControl) {
                    RenderingViewPane.this.setRenderingSelection(viewTab.getRendering());
                    IMemoryViewTab top = RenderingViewPane.this.getTopMemoryTab();
                    if (top != null) {
                        top.setEnabled(RenderingViewPane.this.fVisible);
                    }
                } else {
                    RenderingViewPane.this.deactivateRendering(viewTab);
                    viewTab.setEnabled(false);
                }
                RenderingViewPane.this.updateToolBarActionsEnablement();
            }
        });
    }

    public void memoryBlockRenderingRemoved(final IMemoryRendering rendering) {
        final IMemoryBlock memory = rendering.getMemoryBlock();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IMemoryViewTab top;
                if (!RenderingViewPane.this.fAddedRenderings.contains(rendering)) {
                    return;
                }
                RenderingViewPane.this.fAddedRenderings.remove(rendering);
                CTabFolder tabFolder = (CTabFolder)RenderingViewPane.this.fStackLayout.topControl;
                if (tabFolder.isDisposed()) {
                    return;
                }
                CTabItem[] tabs = tabFolder.getItems();
                boolean foundTab = false;
                int i = 0;
                while (i < tabs.length) {
                    IMemoryViewTab viewTab = (IMemoryViewTab)tabs[i].getData();
                    if (!tabs[i].isDisposed() && viewTab.getRendering().getMemoryBlock() == memory && viewTab.getRendering() == rendering) {
                        foundTab = true;
                        RenderingViewPane.this.disposeTab(tabs[i]);
                        break;
                    }
                    ++i;
                }
                if (!foundTab) {
                    Enumeration enumeration = RenderingViewPane.this.fTabFolderForMemoryBlock.elements();
                    block1: while (enumeration.hasMoreElements()) {
                        CTabFolder otherTabFolder = (CTabFolder)enumeration.nextElement();
                        tabs = otherTabFolder.getItems();
                        IMemoryViewTab viewTab = null;
                        int i2 = 0;
                        while (i2 < tabs.length) {
                            viewTab = (IMemoryViewTab)tabs[i2].getData();
                            if (viewTab.getRendering().getMemoryBlock() == memory && viewTab.getRendering() == rendering) {
                                foundTab = true;
                                RenderingViewPane.this.disposeTab(tabs[i2]);
                                continue block1;
                            }
                            ++i2;
                        }
                    }
                }
                if ((top = RenderingViewPane.this.getTopMemoryTab()) != null) {
                    RenderingViewPane.this.setRenderingSelection(top.getRendering());
                }
                RenderingViewPane.this.updateToolBarActionsEnablement();
            }
        });
    }

    protected void setRenderingSelection(IMemoryRendering rendering) {
        if (rendering != null) {
            this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)rendering));
        }
    }

    private void restoreViewTabs(IMemoryRendering[] renderings) {
        int i = 0;
        while (i < renderings.length) {
            this.memoryBlockRenderingAdded(renderings[i]);
            ++i;
        }
    }

    private void handleDebugElementSelection(IMemoryViewTab lastViewTab, IAdaptable element) {
        IMemoryBlockRetrieval retrieve;
        IMemoryBlockRetrieval currentRetrieve = null;
        CTabFolder tabFolder = (CTabFolder)this.fStackLayout.topControl;
        IMemoryBlock currentBlock = (IMemoryBlock)this.fMemoryBlockFromTabFolder.get(tabFolder);
        if (currentBlock != null && (currentRetrieve = MemoryViewUtil.getMemoryBlockRetrieval(currentBlock)) != null && tabFolder != null) {
            this.fTabFolderForDebugView.put(currentRetrieve, tabFolder);
        }
        if ((retrieve = MemoryViewUtil.getMemoryBlockRetrieval(element)) != null && retrieve != currentRetrieve) {
            CTabFolder folder = (CTabFolder)this.fTabFolderForDebugView.get(retrieve);
            if (folder != null) {
                this.setTabFolder(folder);
                this.fTabFolderForDebugView.put(retrieve, folder);
                this.fViewPaneCanvas.layout();
            } else {
                IMemoryBlock[] blocks = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(retrieve);
                if (blocks.length > 0) {
                    this.handleMemoryBlockSelection(null, blocks[0]);
                } else {
                    this.emptyFolder();
                    this.fTabFolderForDebugView.put(retrieve, this.fEmptyTabFolder);
                    this.fViewPaneCanvas.layout();
                }
            }
        }
        IMemoryViewTab newViewTab = this.getTopMemoryTab();
        if (lastViewTab != null && lastViewTab != newViewTab) {
            lastViewTab.setEnabled(false);
        }
        if (newViewTab != null) {
            if (!newViewTab.isEnabled() && this.fVisible) {
                newViewTab.setEnabled(this.fVisible);
            }
            if (lastViewTab != newViewTab) {
                this.setRenderingSelection(newViewTab.getRendering());
            }
        }
        this.updateToolBarActionsEnablement();
    }

    protected void addListeners() {
        super.addListeners();
        this.fParent.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void removeListeners() {
        super.removeListeners();
        this.fParent.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.getTopMemoryTab() == null) {
            return;
        }
        IMemoryRendering rendering = this.getTopMemoryTab().getRendering();
        if (rendering != null) {
            this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)rendering));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Object getCurrentSelection() {
        if (this.getTopMemoryTab() != null && this.getTopMemoryTab().getRendering() != null) {
            return this.getTopMemoryTab().getRendering();
        }
        return null;
    }

    public IMemoryViewTab[] getAllViewTabs() {
        CTabFolder folder = (CTabFolder)this.fStackLayout.topControl;
        CTabItem[] items = folder.getItems();
        IMemoryViewTab[] viewTabs = new IMemoryViewTab[folder.getItemCount()];
        int i = 0;
        while (i < items.length) {
            viewTabs[i] = (IMemoryViewTab)items[i].getData();
            ++i;
        }
        return viewTabs;
    }

    public void moveToTop(IMemoryViewTab viewTab) {
        IMemoryViewTab lastViewTab = this.getTopMemoryTab();
        if (viewTab == lastViewTab) {
            return;
        }
        CTabFolder folder = (CTabFolder)this.fStackLayout.topControl;
        CTabItem[] items = folder.getItems();
        int i = 0;
        while (i < items.length) {
            IMemoryViewTab tab = (IMemoryViewTab)items[i].getData();
            if (viewTab == tab) {
                boolean isEnabled = lastViewTab.isEnabled();
                lastViewTab.setEnabled(false);
                folder.setSelection(i);
                this.setRenderingSelection(tab.getRendering());
                this.getTopMemoryTab().setEnabled(isEnabled && this.fVisible);
                break;
            }
            ++i;
        }
    }

    private CTabFolder createTabFolder(Composite parent) {
        CTabFolder folder = new CTabFolder(parent, 0x900008);
        ColorRegistry reg = JFaceResources.getColorRegistry();
        Color c1 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
        Color c2 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
        folder.setSelectionBackground(new Color[]{c1, c2}, new int[]{100}, true);
        folder.setSelectionForeground(reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR"));
        folder.setSimple(PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        folder.setBorderVisible(true);
        folder.setFont(this.fViewPaneCanvas.getFont());
        folder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                if (event.item.getData() instanceof MemoryViewTab) {
                    RenderingViewPane.this.removeMemoryRendering(((MemoryViewTab)event.item.getData()).getRendering());
                }
                event.doit = false;
            }
        });
        return folder;
    }

    public void restoreViewPane() {
        IMemoryBlock[] blocks;
        IMemoryBlockRetrieval retrieval;
        IAdaptable context;
        ISelection selection = null;
        if (this.fParent.getSite().getSelectionProvider() != null) {
            selection = this.fParent.getSite().getSelectionProvider().getSelection();
        }
        IMemoryBlock memoryBlock = null;
        if (selection != null) {
            memoryBlock = this.getMemoryBlock(selection);
        }
        if (memoryBlock == null && MemoryViewUtil.isValidSelection(selection = this.fSelectionProvider.getSelection())) {
            Object elem = ((IStructuredSelection)selection).getFirstElement();
            if (!(elem instanceof IMemoryBlock)) {
                return;
            }
            memoryBlock = (IMemoryBlock)elem;
        }
        if (memoryBlock == null && (context = DebugUITools.getDebugContext()) != null && (retrieval = MemoryViewUtil.getMemoryBlockRetrieval(context)) != null && (blocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(retrieval)).length > 0) {
            memoryBlock = blocks[0];
        }
        if (memoryBlock != null) {
            IMemoryViewTab top;
            CTabFolder toDisplay;
            if (!this.fTabFolderForMemoryBlock.containsKey(memoryBlock)) {
                CTabFolder folder = this.createTabFolder(this.fViewPaneCanvas);
                this.fTabFolderForMemoryBlock.put(memoryBlock, folder);
                this.fMemoryBlockFromTabFolder.put(folder, memoryBlock);
                this.setTabFolder((CTabFolder)this.fTabFolderForMemoryBlock.get(memoryBlock));
                retrieval = MemoryViewUtil.getMemoryBlockRetrieval(memoryBlock);
                if (retrieval != null) {
                    this.fTabFolderForDebugView.put(retrieval, this.fTabFolderForMemoryBlock.get(memoryBlock));
                } else {
                    DebugUIPlugin.logErrorMessage("Memory block retrieval for memory block is null.");
                }
                this.fViewPaneCanvas.layout();
                this.fAddedMemoryBlocks.add(memoryBlock);
                this.newCreateRenderingForFolder(memoryBlock, folder);
            }
            if (this.fTabFolderForMemoryBlock.containsKey(memoryBlock) && (toDisplay = (CTabFolder)this.fTabFolderForMemoryBlock.get(memoryBlock)) != null) {
                this.setTabFolder(toDisplay);
                retrieval = MemoryViewUtil.getMemoryBlockRetrieval(memoryBlock);
                if (retrieval != null) {
                    this.fTabFolderForDebugView.put(retrieval, toDisplay);
                } else {
                    DebugUIPlugin.logErrorMessage("Memory block retrieval is null for memory block.");
                }
                this.fViewPaneCanvas.layout();
                IMemoryRendering[] renderings = this.fRenderingMgr.getRenderingsFromMemoryBlock(memoryBlock);
                if (this.isRestoreViewTabs(toDisplay)) {
                    this.restoreViewTabs(renderings);
                }
            }
            if ((top = this.getTopMemoryTab()) != null) {
                top.setEnabled(this.fVisible);
            }
        }
    }

    public void dispose() {
        this.fIsDisposed = true;
        super.dispose();
        this.fTabFolderForMemoryBlock.clear();
        this.fTabFolderForMemoryBlock = null;
        this.fMemoryBlockFromTabFolder.clear();
        this.fMemoryBlockFromTabFolder = null;
        this.fRenderingMgr.dispose();
        this.fRenderingMgr = null;
        this.fAddedMemoryBlocks.clear();
        this.fAddedRenderings.clear();
    }

    public Control createViewPane(Composite parent, String paneId, String label, boolean canAddRendering, boolean canRemoveRendering) {
        return this.doCreateViewPane(parent, paneId, label, canAddRendering, canRemoveRendering);
    }

    public Control createViewPane(Composite parent, String paneId, String label) {
        return this.doCreateViewPane(parent, paneId, label, true, true);
    }

    private Control doCreateViewPane(Composite parent, String paneId, String label, boolean canAddRendering, boolean canRemoveRendering) {
        Control control = super.createViewPane(parent, paneId, label);
        this.fCanAddRendering = canAddRendering;
        this.fCanRemoveRendering = canRemoveRendering;
        this.fRenderingMgr = new ViewPaneRenderingMgr(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.debug.ui.MemoryRenderingView_context");
        return control;
    }

    public IAction[] getActions() {
        return new IAction[0];
    }

    protected void updateToolBarActionsEnablement() {
    }

    protected void emptyFolder() {
        super.emptyFolder();
        this.updateToolBarActionsEnablement();
        this.fSelectionProvider.setSelection((ISelection)AbstractMemoryViewPane.EMPTY);
    }

    public void addMemoryRendering(IMemoryRendering rendering) {
        if (rendering == null) {
            return;
        }
        this.memoryBlockRenderingAdded(rendering);
        this.fRenderingMgr.addMemoryBlockRendering(rendering);
    }

    public void removeMemoryRendering(IMemoryRendering rendering) {
        if (rendering == null) {
            return;
        }
        this.memoryBlockRenderingRemoved(rendering);
        if (this.fRenderingMgr != null) {
            this.fRenderingMgr.removeMemoryBlockRendering(rendering);
        }
    }

    private RenderingViewPane getInstance() {
        return this;
    }

    private IMemoryBlock getMemoryBlock(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        if (selection.isEmpty() || ((IStructuredSelection)selection).size() > 1) {
            return null;
        }
        Object elem = ((IStructuredSelection)selection).getFirstElement();
        if (elem instanceof IMemoryBlock) {
            return (IMemoryBlock)elem;
        }
        if (elem instanceof IMemoryRendering) {
            return ((IMemoryRendering)elem).getMemoryBlock();
        }
        return null;
    }

    private void deactivateRendering(IMemoryViewTab viewTab) {
        if (viewTab == null) {
            return;
        }
        if (!viewTab.isDisposed()) {
            viewTab.getRendering().deactivated();
        }
    }

    public IMemoryRenderingSite getMemoryRenderingSite() {
        return this.fRenderingSite;
    }

    public String getId() {
        return this.getPaneId();
    }

    public IMemoryRendering[] getRenderings() {
        return this.fRenderingMgr.getRenderings();
    }

    public IMemoryRendering getActiveRendering() {
        if (this.getTopMemoryTab() == null) {
            return null;
        }
        return this.getTopMemoryTab().getRendering();
    }

    public void resetRenderings(IMemoryBlock memoryBlock, boolean resetVisible) {
        if (resetVisible && !this.isVisible()) {
            return;
        }
        if (resetVisible) {
            IMemoryRendering rendering = this.getActiveRendering();
            if (rendering != null && rendering.getMemoryBlock() == memoryBlock && rendering instanceof IResettableMemoryRendering) {
                IResettableMemoryRendering resettableRendering = (IResettableMemoryRendering)rendering;
                try {
                    resettableRendering.resetRendering();
                }
                catch (DebugException debugException) {}
            }
        } else {
            IMemoryRendering[] renderings = this.fRenderingMgr.getRenderingsFromMemoryBlock(memoryBlock);
            IMemoryRendering originalProvider = null;
            IMemoryRenderingSynchronizationService service = this.getMemoryRenderingSite().getSynchronizationService();
            if (service != null) {
                originalProvider = service.getSynchronizationProvider();
            }
            int i = 0;
            while (i < renderings.length) {
                if (renderings[i] instanceof IResettableMemoryRendering) {
                    try {
                        if (service != null) {
                            service.setSynchronizationProvider(renderings[i]);
                        }
                        ((IResettableMemoryRendering)renderings[i]).resetRendering();
                    }
                    catch (DebugException debugException) {}
                }
                ++i;
            }
            if (service != null) {
                service.setSynchronizationProvider(originalProvider);
            }
        }
    }

    private boolean isDisposed() {
        return this.fIsDisposed;
    }

    public void showCreateRenderingTab() {
        IMemoryRendering activeRendering = this.getActiveRendering();
        if (activeRendering == null) {
            return;
        }
        IMemoryBlock memoryblk = activeRendering.getMemoryBlock();
        final CTabFolder tabFolder = (CTabFolder)this.fTabFolderForMemoryBlock.get(memoryblk);
        if (tabFolder != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    int index = RenderingViewPane.this.getIndexOfCreateRenderingTab(tabFolder);
                    if (index >= 0) {
                        tabFolder.setSelection(index);
                    }
                }
            });
        }
    }

    public void contextActivated(final ISelection selection) {
        UIJob job = new UIJob("contextActivated"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (RenderingViewPane.this.isDisposed()) {
                    return Status.OK_STATUS;
                }
                IMemoryViewTab lastViewTab = RenderingViewPane.this.getTopMemoryTab();
                if (MemoryViewUtil.isValidSelection(selection)) {
                    if (!(selection instanceof IStructuredSelection)) {
                        return Status.OK_STATUS;
                    }
                    Object elem = ((IStructuredSelection)selection).getFirstElement();
                    if (elem instanceof IAdaptable) {
                        RenderingViewPane.this.handleDebugElementSelection(lastViewTab, (IAdaptable)elem);
                    }
                } else {
                    if (lastViewTab != null) {
                        lastViewTab.setEnabled(false);
                    }
                    if (RenderingViewPane.this.fStackLayout.topControl != RenderingViewPane.this.fEmptyTabFolder) {
                        RenderingViewPane.this.emptyFolder();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private CTabFolder createFolderForMemoryBlock(IMemoryBlock memory) {
        CTabFolder folder = this.createTabFolder(this.fViewPaneCanvas);
        this.fTabFolderForMemoryBlock.put(memory, folder);
        this.fMemoryBlockFromTabFolder.put(folder, memory);
        IMemoryBlockRetrieval retrieval = MemoryViewUtil.getMemoryBlockRetrieval(memory);
        if (retrieval != null) {
            this.fTabFolderForDebugView.put(retrieval, folder);
        } else {
            DebugUIPlugin.logErrorMessage("Memory block retrieval for memory block is null");
        }
        this.newCreateRenderingForFolder(memory, folder);
        return folder;
    }

    private void newCreateRenderingForFolder(IMemoryBlock memory, CTabFolder folder) {
        if (!this.canAddRendering()) {
            return;
        }
        CTabItem newItem = new CTabItem(folder, 0);
        CreateRendering rendering = new CreateRendering(this.getInstance());
        rendering.init(this.getInstance(), memory);
        new MemoryViewTab(newItem, rendering, this.getInstance());
        folder.setSelection(0);
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            this.contextActivated(event.getContext());
        }
    }

    public boolean canAddRendering() {
        return this.fCanAddRendering;
    }

    public boolean canRemoveRendering() {
        return this.fCanRemoveRendering;
    }

    private CTabItem createTab(CTabFolder tabFolder, int index) {
        int swtStyle = 64;
        if (!this.canRemoveRendering()) {
            swtStyle = 0;
        }
        CTabItem tab = new CTabItem(tabFolder, swtStyle, index);
        return tab;
    }
}

