/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;

public abstract class CleanUpAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public CleanUpAction(IWorkbenchSite site) {
        super(site);
    }

    public CleanUpAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(CleanUpAction.getCompilationUnit(this.fEditor) != null);
    }

    protected abstract String getActionName();

    protected abstract ICleanUp[] createCleanUps(ICompilationUnit[] var1);

    protected void performRefactoring(ICompilationUnit[] units, ICleanUp[] cleanUps) throws JavaModelException, InvocationTargetException {
        RefactoringExecutionStarter.startCleanupRefactoring(units, cleanUps, this.getShell(), false, this.getActionName());
    }

    public void run(ITextSelection selection) {
        ICompilationUnit cu = CleanUpAction.getCompilationUnit(this.fEditor);
        if (cu != null) {
            this.run(cu);
        }
    }

    public void run(IStructuredSelection selection) {
        ICompilationUnit[] cus = this.getCompilationUnits(selection);
        if (cus.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.getActionName(), (String)ActionMessages.CleanUpAction_EmptySelection_description);
        } else if (cus.length == 1) {
            this.run(cus[0]);
        } else {
            this.runOnMultiple(cus);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(CleanUpAction.getCompilationUnit(this.fEditor) != null);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEnabled(IStructuredSelection selection) {
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            block14: {
                try {
                    if (selected[i] instanceof IJavaElement) {
                        IJavaElement elem = (IJavaElement)selected[i];
                        if (elem.exists()) {
                            switch (elem.getElementType()) {
                                case 7: {
                                    return elem.getParent().getElementType() == 5;
                                }
                                case 5: {
                                    return true;
                                }
                                case 12: {
                                    return true;
                                }
                                case 3: 
                                case 4: {
                                    IPackageFragmentRoot root = (IPackageFragmentRoot)elem.getAncestor(3);
                                    return root.getKind() == 1;
                                }
                                case 2: {
                                    return true;
                                }
                            }
                        }
                        break block14;
                    }
                    if (selected[i] instanceof LogicalPackage) {
                        return true;
                    }
                    if (selected[i] instanceof IWorkingSet) {
                        IWorkingSet workingSet = (IWorkingSet)selected[i];
                        return "org.eclipse.jdt.ui.JavaWorkingSetPage".equals(workingSet.getId());
                    }
                }
                catch (JavaModelException e) {
                    if (e.isDoesNotExist()) break block14;
                    JavaPlugin.log(e);
                }
            }
            ++i;
        }
        return false;
    }

    private void run(ICompilationUnit cu) {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)cu)) {
            return;
        }
        ICleanUp[] cleanUps = this.createCleanUps(new ICompilationUnit[]{cu});
        if (cleanUps == null) {
            return;
        }
        if (!ElementValidator.check((IJavaElement)cu, this.getShell(), this.getActionName(), this.fEditor != null)) {
            return;
        }
        try {
            this.performRefactoring(new ICompilationUnit[]{cu}, cleanUps);
        }
        catch (InvocationTargetException e) {
            JavaPlugin.log(e);
            if (e.getCause() instanceof CoreException) {
                this.showUnexpectedError((CoreException)e.getCause());
            }
        }
        catch (JavaModelException e) {
            this.showUnexpectedError((CoreException)((Object)e));
        }
    }

    private void runOnMultiple(ICompilationUnit[] cus) {
        ICleanUp[] cleanUps = this.createCleanUps(cus);
        if (cleanUps == null) {
            return;
        }
        MultiStatus status = new MultiStatus("org.eclipse.jdt.ui", 0, ActionMessages.CleanUpAction_MultiStateErrorTitle, null);
        int i = 0;
        while (i < cus.length) {
            ICompilationUnit cu = cus[i];
            if (!ActionUtil.isOnBuildPath((IJavaElement)cu)) {
                String cuLocation = BasicElementLabels.getPathLabel(cu.getPath(), false);
                String message = Messages.format(ActionMessages.CleanUpAction_CUNotOnBuildpathMessage, cuLocation);
                status.add((IStatus)new Status(1, "org.eclipse.jdt.ui", 4, message, null));
            }
            ++i;
        }
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)this.getActionName(), null, (IStatus)status);
            return;
        }
        try {
            this.performRefactoring(cus, cleanUps);
        }
        catch (InvocationTargetException e) {
            JavaPlugin.log(e);
            if (e.getCause() instanceof CoreException) {
                this.showUnexpectedError((CoreException)e.getCause());
            }
        }
        catch (JavaModelException e) {
            this.showUnexpectedError((CoreException)((Object)e));
        }
    }

    private void showUnexpectedError(CoreException e) {
        String message2 = Messages.format(ActionMessages.CleanUpAction_UnexpectedErrorMessage, e.getStatus().getMessage());
        Status status = new Status(4, "org.eclipse.jdt.ui", 4, message2, null);
        ErrorDialog.openError((Shell)this.getShell(), (String)this.getActionName(), null, (IStatus)status);
    }

    public ICompilationUnit[] getCompilationUnits(IStructuredSelection selection) {
        HashSet result = new HashSet();
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            Object element = selected[i];
            this.collectCompilationUnits(element, result);
            ++i;
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private void collectCompilationUnits(Object element, Collection result) {
        block19: {
            try {
                if (element instanceof IJavaElement) {
                    IJavaElement elem = (IJavaElement)element;
                    if (!elem.exists()) break block19;
                    switch (elem.getElementType()) {
                        case 7: {
                            if (elem.getParent().getElementType() == 5) {
                                result.add(elem.getParent());
                                break;
                            }
                            break block19;
                        }
                        case 5: {
                            result.add(elem);
                            break;
                        }
                        case 12: {
                            result.add(elem.getParent());
                            break;
                        }
                        case 4: {
                            this.collectCompilationUnits((IPackageFragment)elem, result);
                            break;
                        }
                        case 3: {
                            this.collectCompilationUnits((IPackageFragmentRoot)elem, result);
                            break;
                        }
                        case 2: {
                            IPackageFragmentRoot[] roots = ((IJavaProject)elem).getPackageFragmentRoots();
                            int k = 0;
                            while (k < roots.length) {
                                this.collectCompilationUnits(roots[k], result);
                                ++k;
                            }
                            break block1;
                        }
                    }
                    break block19;
                }
                if (element instanceof LogicalPackage) {
                    IPackageFragment[] packageFragments = ((LogicalPackage)((Object)element)).getFragments();
                    int k = 0;
                    while (k < packageFragments.length) {
                        IPackageFragment pack = packageFragments[k];
                        if (pack.exists()) {
                            this.collectCompilationUnits(pack, result);
                        }
                        ++k;
                    }
                } else if (element instanceof IWorkingSet) {
                    IWorkingSet workingSet = (IWorkingSet)element;
                    IAdaptable[] elements = workingSet.getElements();
                    int j = 0;
                    while (j < elements.length) {
                        this.collectCompilationUnits(elements[j], result);
                        ++j;
                    }
                }
            }
            catch (JavaModelException e) {
                if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) break block19;
                JavaPlugin.log(e);
            }
        }
    }

    private void collectCompilationUnits(IPackageFragment pack, Collection result) throws JavaModelException {
        result.addAll(Arrays.asList(pack.getCompilationUnits()));
    }

    private void collectCompilationUnits(IPackageFragmentRoot root, Collection result) throws JavaModelException {
        if (root.getKind() == 1) {
            IJavaElement[] children = root.getChildren();
            int i = 0;
            while (i < children.length) {
                this.collectCompilationUnits((IPackageFragment)children[i], result);
                ++i;
            }
        }
    }

    private static ICompilationUnit getCompilationUnit(JavaEditor editor) {
        IJavaElement element = JavaUI.getEditorInputJavaElement(editor.getEditorInput());
        if (!(element instanceof ICompilationUnit)) {
            return null;
        }
        return (ICompilationUnit)element;
    }
}

