/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling.engine;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.spelling.engine.AbstractSpellDictionary;

public class PersistentSpellDictionary
extends AbstractSpellDictionary {
    private final URL fLocation;

    public PersistentSpellDictionary(URL url) {
        this.fLocation = url;
    }

    public boolean acceptsWords() {
        return true;
    }

    public void addWord(String word) {
        if (this.isCorrect(word)) {
            return;
        }
        OutputStreamWriter writer = null;
        try {
            try {
                byte[] byteArray;
                Charset charset = Charset.forName(this.getEncoding());
                ByteBuffer byteBuffer = charset.encode(String.valueOf(word) + "\n");
                int size = byteBuffer.limit();
                if (byteBuffer.hasArray()) {
                    byteArray = byteBuffer.array();
                } else {
                    byteArray = new byte[size];
                    byteBuffer.get(byteArray);
                }
                FileOutputStream fileStream = new FileOutputStream(this.fLocation.getPath(), true);
                int bomCutSize = 0;
                if (!this.isEmpty() && "UTF-16".equals(charset.name())) {
                    bomCutSize = 2;
                }
                fileStream.write(byteArray, bomCutSize, size - bomCutSize);
            }
            catch (IOException exception) {
                JavaPlugin.log(exception);
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {}
        this.hashWord(word);
    }

    protected final URL getURL() {
        return this.fLocation;
    }
}

