/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class JavaElementLabels {
    public static final long M_PARAMETER_TYPES = 1L;
    public static final long M_PARAMETER_NAMES = 2L;
    public static final long M_PRE_TYPE_PARAMETERS = 4L;
    public static final long M_APP_TYPE_PARAMETERS = 8L;
    public static final long M_EXCEPTIONS = 16L;
    public static final long M_APP_RETURNTYPE = 32L;
    public static final long M_PRE_RETURNTYPE = 64L;
    public static final long M_FULLY_QUALIFIED = 128L;
    public static final long M_POST_QUALIFIED = 256L;
    public static final long I_FULLY_QUALIFIED = 1024L;
    public static final long I_POST_QUALIFIED = 2048L;
    public static final long F_APP_TYPE_SIGNATURE = 16384L;
    public static final long F_PRE_TYPE_SIGNATURE = 32768L;
    public static final long F_FULLY_QUALIFIED = 65536L;
    public static final long F_POST_QUALIFIED = 131072L;
    public static final long T_FULLY_QUALIFIED = 262144L;
    public static final long T_CONTAINER_QUALIFIED = 524288L;
    public static final long T_POST_QUALIFIED = 0x100000L;
    public static final long T_TYPE_PARAMETERS = 0x200000L;
    public static final long D_QUALIFIED = 0x1000000L;
    public static final long D_POST_QUALIFIED = 0x2000000L;
    public static final long CF_QUALIFIED = 0x8000000L;
    public static final long CF_POST_QUALIFIED = 0x10000000L;
    public static final long CU_QUALIFIED = 0x80000000L;
    public static final long CU_POST_QUALIFIED = 0x100000000L;
    public static final long P_QUALIFIED = 0x800000000L;
    public static final long P_POST_QUALIFIED = 0x1000000000L;
    public static final long P_COMPRESSED = 0x2000000000L;
    public static final long ROOT_VARIABLE = 0x10000000000L;
    public static final long ROOT_QUALIFIED = 0x20000000000L;
    public static final long ROOT_POST_QUALIFIED = 0x40000000000L;
    public static final long APPEND_ROOT_PATH = 0x80000000000L;
    public static final long PREPEND_ROOT_PATH = 0x100000000000L;
    public static final long REFERENCED_ROOT_POST_QUALIFIED = 0x200000000000L;
    public static final long USE_RESOLVED = 0x1000000000000L;
    public static final long COLORIZE = 0x80000000000000L;
    public static final long F_CATEGORY = 0x2000000000000L;
    public static final long M_CATEGORY = 0x4000000000000L;
    public static final long T_CATEGORY = 0x8000000000000L;
    public static final long ALL_CATEGORY = new Long(0xE000000000000L);
    public static final long ALL_FULLY_QUALIFIED = new Long(2235681801344L);
    public static final long ALL_POST_QUALIFIED = new Long(4471364126976L);
    public static final long ALL_DEFAULT = new Long(0x200009L);
    public static final long DEFAULT_QUALIFIED = new Long(2298807424L);
    public static final long DEFAULT_POST_QUALIFIED = new Long(4598139136L);
    public static final String CONCAT_STRING = JavaUIMessages.JavaElementLabels_concat_string;
    public static final String COMMA_STRING = JavaUIMessages.JavaElementLabels_comma_string;
    public static final String DECL_STRING = JavaUIMessages.JavaElementLabels_declseparator_string;
    private static final String CATEGORY_SEPARATOR_STRING = JavaUIMessages.JavaElementLabels_category_separator_string;
    public static final String ELLIPSIS_STRING = "...";
    public static final String DEFAULT_PACKAGE = JavaUIMessages.JavaElementLabels_default_package;
    private static final long QUALIFIER_FLAGS = 0x1002000000000L;
    private static final StyledString.Styler QUALIFIER_STYLE = StyledString.QUALIFIER_STYLER;
    private static final StyledString.Styler COUNTER_STYLE = StyledString.COUNTER_STYLER;
    private static final StyledString.Styler DECORATIONS_STYLE = StyledString.DECORATIONS_STYLER;
    private static String fgPkgNamePattern = "";
    private static String fgPkgNamePrefix;
    private static String fgPkgNamePostfix;
    private static int fgPkgNameChars;
    private static int fgPkgNameLength;
    static /* synthetic */ Class class$0;

    static {
        fgPkgNameLength = -1;
    }

    private JavaElementLabels() {
    }

    private static final boolean getFlag(long flags, long flag) {
        return (flags & flag) != 0L;
    }

    public static String getTextLabel(Object obj, long flags) {
        return JavaElementLabels.getStyledTextLabel(obj, flags).getString();
    }

    public static StyledString getStyledTextLabel(Object obj, long flags) {
        if (obj instanceof IJavaElement) {
            return JavaElementLabels.getStyledElementLabel((IJavaElement)obj, flags);
        }
        if (obj instanceof IResource) {
            return JavaElementLabels.getStyledResourceLabel((IResource)obj);
        }
        if (obj instanceof ClassPathContainer) {
            ClassPathContainer container = (ClassPathContainer)obj;
            return JavaElementLabels.getStyledContainerEntryLabel(container.getClasspathEntry().getPath(), container.getJavaProject());
        }
        if (obj instanceof IStorage) {
            return JavaElementLabels.getStyledStorageLabel((IStorage)obj);
        }
        if (obj instanceof IAdaptable) {
            IWorkbenchAdapter wbadapter;
            IAdaptable iAdaptable = (IAdaptable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((wbadapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return new StyledString(wbadapter.getLabel(obj));
            }
        }
        return new StyledString();
    }

    private static StyledString getStyledResourceLabel(IResource resource) {
        StyledString result = new StyledString(resource.getName());
        return Strings.markLTR(result);
    }

    private static StyledString getStyledStorageLabel(IStorage storage) {
        StyledString result = new StyledString(storage.getName());
        return Strings.markLTR(result);
    }

    public static String getElementLabel(IJavaElement element, long flags) {
        return JavaElementLabels.getStyledTextLabel(element, flags).getString();
    }

    public static StyledString getStyledElementLabel(IJavaElement element, long flags) {
        StyledString result = new StyledString();
        JavaElementLabels.getElementLabel(element, flags, result);
        return Strings.markLTR(result, "<>(),?:{}");
    }

    public static void getElementLabel(IJavaElement element, long flags, StringBuffer buf) {
        buf.append(JavaElementLabels.getElementLabel(element, flags));
    }

    public static void getElementLabel(IJavaElement element, long flags, StyledString result) {
        int type = element.getElementType();
        IPackageFragmentRoot root = null;
        if (type != 1 && type != 2 && type != 3) {
            root = JavaModelUtil.getPackageFragmentRoot(element);
        }
        if (root != null && JavaElementLabels.getFlag(flags, 0x100000000000L)) {
            JavaElementLabels.getPackageFragmentRootLabel(root, 0x20000000000L, result);
            result.append(CONCAT_STRING);
        }
        switch (type) {
            case 9: {
                JavaElementLabels.getMethodLabel((IMethod)element, flags, result);
                break;
            }
            case 8: {
                JavaElementLabels.getFieldLabel((IField)element, flags, result);
                break;
            }
            case 14: {
                JavaElementLabels.getLocalVariableLabel((ILocalVariable)element, flags, result);
                break;
            }
            case 10: {
                JavaElementLabels.getInitializerLabel((IInitializer)element, flags, result);
                break;
            }
            case 7: {
                JavaElementLabels.getTypeLabel((IType)element, flags, result);
                break;
            }
            case 6: {
                JavaElementLabels.getClassFileLabel((IClassFile)element, flags, result);
                break;
            }
            case 5: {
                JavaElementLabels.getCompilationUnitLabel((ICompilationUnit)element, flags, result);
                break;
            }
            case 4: {
                JavaElementLabels.getPackageFragmentLabel((IPackageFragment)element, flags, result);
                break;
            }
            case 3: {
                JavaElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)element, flags, result);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                JavaElementLabels.getDeclarationLabel(element, flags, result);
                break;
            }
            case 1: 
            case 2: {
                result.append(element.getElementName());
                break;
            }
            default: {
                result.append(element.getElementName());
            }
        }
        if (root != null && JavaElementLabels.getFlag(flags, 0x80000000000L)) {
            int offset = result.length();
            result.append(CONCAT_STRING);
            JavaElementLabels.getPackageFragmentRootLabel(root, 0x20000000000L, result);
            if (JavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.setStyle(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public static void getMethodLabel(IMethod method, long flags, StringBuffer buf) {
        StyledString builder = new StyledString();
        JavaElementLabels.getMethodLabel(method, flags, builder);
        buf.append(builder.getString());
    }

    public static void getMethodLabel(IMethod method, long flags, StyledString result) {
        try {
            String[] types;
            String resolvedSig;
            BindingKey resolvedKey = JavaElementLabels.getFlag(flags, 0x1000000000000L) && method.isResolved() ? new BindingKey(method.getKey()) : null;
            String string = resolvedSig = resolvedKey != null ? resolvedKey.toSignature() : null;
            if (JavaElementLabels.getFlag(flags, 4L)) {
                ITypeParameter[] typeParameters;
                if (resolvedKey != null) {
                    if (resolvedKey.isParameterizedMethod()) {
                        String[] typeArgRefs = resolvedKey.getTypeArguments();
                        if (typeArgRefs.length > 0) {
                            JavaElementLabels.getTypeArgumentSignaturesLabel(typeArgRefs, flags, result);
                            result.append(' ');
                        }
                    } else {
                        String[] typeParameterSigs = Signature.getTypeParameters((String)resolvedSig);
                        if (typeParameterSigs.length > 0) {
                            JavaElementLabels.getTypeParameterSignaturesLabel(typeParameterSigs, flags, result);
                            result.append(' ');
                        }
                    }
                } else if (method.exists() && (typeParameters = method.getTypeParameters()).length > 0) {
                    JavaElementLabels.getTypeParametersLabel(typeParameters, flags, result);
                    result.append(' ');
                }
            }
            if (JavaElementLabels.getFlag(flags, 64L) && method.exists() && !method.isConstructor()) {
                String returnTypeSig = resolvedSig != null ? Signature.getReturnType((String)resolvedSig) : method.getReturnType();
                JavaElementLabels.getTypeSignatureLabel(returnTypeSig, flags, result);
                result.append(' ');
            }
            if (JavaElementLabels.getFlag(flags, 128L)) {
                JavaElementLabels.getTypeLabel(method.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, result);
                result.append('.');
            }
            result.append(method.getElementName());
            result.append('(');
            if (JavaElementLabels.getFlag(flags, 3L)) {
                types = null;
                int nParams = 0;
                boolean renderVarargs = false;
                if (JavaElementLabels.getFlag(flags, 1L)) {
                    types = resolvedSig != null ? Signature.getParameterTypes((String)resolvedSig) : method.getParameterTypes();
                    nParams = types.length;
                    renderVarargs = method.exists() && Flags.isVarargs((int)method.getFlags());
                }
                String[] names = null;
                if (JavaElementLabels.getFlag(flags, 2L) && method.exists()) {
                    names = method.getParameterNames();
                    if (types == null) {
                        nParams = names.length;
                    } else if (nParams != names.length) {
                        if (resolvedSig != null && types.length > names.length) {
                            nParams = names.length;
                            String[] typesWithoutSyntheticParams = new String[nParams];
                            System.arraycopy(types, types.length - nParams, typesWithoutSyntheticParams, 0, nParams);
                            types = typesWithoutSyntheticParams;
                        } else {
                            names = null;
                        }
                    }
                }
                int i = 0;
                while (i < nParams) {
                    if (i > 0) {
                        result.append(COMMA_STRING);
                    }
                    if (types != null) {
                        String paramSig = types[i];
                        if (renderVarargs && i == nParams - 1) {
                            int newDim = Signature.getArrayCount((String)paramSig) - 1;
                            JavaElementLabels.getTypeSignatureLabel(Signature.getElementType((String)paramSig), flags, result);
                            int k = 0;
                            while (k < newDim) {
                                result.append('[').append(']');
                                ++k;
                            }
                            result.append(ELLIPSIS_STRING);
                        } else {
                            JavaElementLabels.getTypeSignatureLabel(paramSig, flags, result);
                        }
                    }
                    if (names != null) {
                        if (types != null) {
                            result.append(' ');
                        }
                        result.append(names[i]);
                    }
                    ++i;
                }
            } else if (method.getParameterTypes().length > 0) {
                result.append(ELLIPSIS_STRING);
            }
            result.append(')');
            if (JavaElementLabels.getFlag(flags, 16L)) {
                if (resolvedKey != null) {
                    types = resolvedKey.getThrownExceptions();
                } else {
                    String[] stringArray = types = method.exists() ? method.getExceptionTypes() : new String[]{};
                }
                if (types.length > 0) {
                    result.append(" throws ");
                    int i = 0;
                    while (i < types.length) {
                        if (i > 0) {
                            result.append(COMMA_STRING);
                        }
                        JavaElementLabels.getTypeSignatureLabel(types[i], flags, result);
                        ++i;
                    }
                }
            }
            if (JavaElementLabels.getFlag(flags, 8L)) {
                ITypeParameter[] typeParameters;
                int offset = result.length();
                if (resolvedKey != null) {
                    if (resolvedKey.isParameterizedMethod()) {
                        String[] typeArgRefs = resolvedKey.getTypeArguments();
                        if (typeArgRefs.length > 0) {
                            result.append(' ');
                            JavaElementLabels.getTypeArgumentSignaturesLabel(typeArgRefs, flags, result);
                        }
                    } else {
                        String[] typeParameterSigs = Signature.getTypeParameters((String)resolvedSig);
                        if (typeParameterSigs.length > 0) {
                            result.append(' ');
                            JavaElementLabels.getTypeParameterSignaturesLabel(typeParameterSigs, flags, result);
                        }
                    }
                } else if (method.exists() && (typeParameters = method.getTypeParameters()).length > 0) {
                    result.append(' ');
                    JavaElementLabels.getTypeParametersLabel(typeParameters, flags, result);
                }
                if (JavaElementLabels.getFlag(flags, 0x80000000000000L) && offset != result.length()) {
                    result.setStyle(offset, result.length() - offset, DECORATIONS_STYLE);
                }
            }
            if (JavaElementLabels.getFlag(flags, 32L) && method.exists() && !method.isConstructor()) {
                int offset = result.length();
                result.append(DECL_STRING);
                String returnTypeSig = resolvedSig != null ? Signature.getReturnType((String)resolvedSig) : method.getReturnType();
                JavaElementLabels.getTypeSignatureLabel(returnTypeSig, flags, result);
                if (JavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                    result.setStyle(offset, result.length() - offset, DECORATIONS_STYLE);
                }
            }
            if (JavaElementLabels.getFlag(flags, 0x4000000000000L) && method.exists()) {
                JavaElementLabels.getCategoryLabel((IMember)method, flags, result);
            }
            if (JavaElementLabels.getFlag(flags, 256L)) {
                int offset = result.length();
                result.append(CONCAT_STRING);
                JavaElementLabels.getTypeLabel(method.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, result);
                if (JavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                    result.setStyle(offset, result.length() - offset, QUALIFIER_STYLE);
                }
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    private static void getCategoryLabel(IMember member, long flags, StyledString result) throws JavaModelException {
        String[] categories = member.getCategories();
        if (categories.length > 0) {
            int offset = result.length();
            StringBuffer categoriesBuf = new StringBuffer();
            int i = 0;
            while (i < categories.length) {
                if (i > 0) {
                    categoriesBuf.append(CATEGORY_SEPARATOR_STRING);
                }
                categoriesBuf.append(categories[i]);
                ++i;
            }
            result.append(CONCAT_STRING);
            result.append(Messages.format(JavaUIMessages.JavaElementLabels_category, categoriesBuf.toString()));
            if (JavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.setStyle(offset, result.length() - offset, COUNTER_STYLE);
            }
        }
    }

    private static void getTypeParametersLabel(ITypeParameter[] typeParameters, long flags, StyledString result) {
        if (typeParameters.length > 0) {
            result.append('<');
            int i = 0;
            while (i < typeParameters.length) {
                if (i > 0) {
                    result.append(COMMA_STRING);
                }
                result.append(typeParameters[i].getElementName());
                ++i;
            }
            result.append('>');
        }
    }

    public static void getFieldLabel(IField field, long flags, StringBuffer buf) {
        StyledString builder = new StyledString();
        JavaElementLabels.getFieldLabel(field, flags, builder);
        buf.append(builder.getString());
    }

    public static void getFieldLabel(IField field, long flags, StyledString result) {
        try {
            int offset;
            if (JavaElementLabels.getFlag(flags, 32768L) && field.exists() && !Flags.isEnum((int)field.getFlags())) {
                if (JavaElementLabels.getFlag(flags, 0x1000000000000L) && field.isResolved()) {
                    JavaElementLabels.getTypeSignatureLabel(new BindingKey(field.getKey()).toSignature(), flags, result);
                } else {
                    JavaElementLabels.getTypeSignatureLabel(field.getTypeSignature(), flags, result);
                }
                result.append(' ');
            }
            if (JavaElementLabels.getFlag(flags, 65536L)) {
                JavaElementLabels.getTypeLabel(field.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, result);
                result.append('.');
            }
            result.append(field.getElementName());
            if (JavaElementLabels.getFlag(flags, 16384L) && field.exists() && !Flags.isEnum((int)field.getFlags())) {
                offset = result.length();
                result.append(DECL_STRING);
                if (JavaElementLabels.getFlag(flags, 0x1000000000000L) && field.isResolved()) {
                    JavaElementLabels.getTypeSignatureLabel(new BindingKey(field.getKey()).toSignature(), flags, result);
                } else {
                    JavaElementLabels.getTypeSignatureLabel(field.getTypeSignature(), flags, result);
                }
                if (JavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                    result.setStyle(offset, result.length() - offset, DECORATIONS_STYLE);
                }
            }
            if (JavaElementLabels.getFlag(flags, 0x2000000000000L) && field.exists()) {
                JavaElementLabels.getCategoryLabel((IMember)field, flags, result);
            }
            if (JavaElementLabels.getFlag(flags, 131072L)) {
                offset = result.length();
                result.append(CONCAT_STRING);
                JavaElementLabels.getTypeLabel(field.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, result);
                if (JavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                    result.setStyle(offset, result.length() - offset, QUALIFIER_STYLE);
                }
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    public static void getLocalVariableLabel(ILocalVariable localVariable, long flags, StringBuffer buf) {
        StyledString builder = new StyledString();
        JavaElementLabels.getLocalVariableLabel(localVariable, flags, builder);
        buf.append(builder.getString());
    }

    public static void getLocalVariableLabel(ILocalVariable localVariable, long flags, StyledString result) {
        if (JavaElementLabels.getFlag(flags, 32768L)) {
            JavaElementLabels.getTypeSignatureLabel(localVariable.getTypeSignature(), flags, result);
            result.append(' ');
        }
        if (JavaElementLabels.getFlag(flags, 65536L)) {
            JavaElementLabels.getElementLabel(localVariable.getParent(), 0x40081L | flags & 0x1002000000000L, result);
            result.append('.');
        }
        result.append(localVariable.getElementName());
        if (JavaElementLabels.getFlag(flags, 16384L)) {
            int offset = result.length();
            result.append(DECL_STRING);
            JavaElementLabels.getTypeSignatureLabel(localVariable.getTypeSignature(), flags, result);
            if (JavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.setStyle(offset, result.length() - offset, DECORATIONS_STYLE);
            }
        }
        if (JavaElementLabels.getFlag(flags, 131072L)) {
            result.append(CONCAT_STRING);
            JavaElementLabels.getElementLabel(localVariable.getParent(), 0x40081L | flags & 0x1002000000000L, result);
        }
    }

    public static void getInitializerLabel(IInitializer initializer, long flags, StringBuffer buf) {
        StyledString builder = new StyledString();
        JavaElementLabels.getInitializerLabel(initializer, flags, builder);
        buf.append(builder.getString());
    }

    public static void getInitializerLabel(IInitializer initializer, long flags, StyledString result) {
        if (JavaElementLabels.getFlag(flags, 1024L)) {
            JavaElementLabels.getTypeLabel(initializer.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, result);
            result.append('.');
        }
        result.append(JavaUIMessages.JavaElementLabels_initializer);
        if (JavaElementLabels.getFlag(flags, 2048L)) {
            int offset = result.length();
            result.append(CONCAT_STRING);
            JavaElementLabels.getTypeLabel(initializer.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, result);
            if (JavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.setStyle(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    private static void getTypeSignatureLabel(String typeSig, long flags, StyledString result) {
        int sigKind = Signature.getTypeSignatureKind((String)typeSig);
        switch (sigKind) {
            case 2: {
                result.append(Signature.toString((String)typeSig));
                break;
            }
            case 4: {
                JavaElementLabels.getTypeSignatureLabel(Signature.getElementType((String)typeSig), flags, result);
                int dim = Signature.getArrayCount((String)typeSig);
                while (dim > 0) {
                    result.append('[').append(']');
                    --dim;
                }
                break;
            }
            case 1: {
                String baseType = Signature.toString((String)Signature.getTypeErasure((String)typeSig));
                result.append(Signature.getSimpleName((String)baseType));
                String[] typeArguments = Signature.getTypeArguments((String)typeSig);
                JavaElementLabels.getTypeArgumentSignaturesLabel(typeArguments, flags, result);
                break;
            }
            case 3: {
                result.append(Signature.toString((String)typeSig));
                break;
            }
            case 5: {
                char ch = typeSig.charAt(0);
                if (ch == '*') {
                    result.append('?');
                    break;
                }
                if (ch == '+') {
                    result.append("? extends ");
                    JavaElementLabels.getTypeSignatureLabel(typeSig.substring(1), flags, result);
                    break;
                }
                if (ch != '-') break;
                result.append("? super ");
                JavaElementLabels.getTypeSignatureLabel(typeSig.substring(1), flags, result);
                break;
            }
            case 6: {
                JavaElementLabels.getTypeSignatureLabel(typeSig.substring(1), flags, result);
            }
        }
    }

    private static void getTypeArgumentSignaturesLabel(String[] typeArgsSig, long flags, StyledString result) {
        if (typeArgsSig.length > 0) {
            result.append('<');
            int i = 0;
            while (i < typeArgsSig.length) {
                if (i > 0) {
                    result.append(COMMA_STRING);
                }
                JavaElementLabels.getTypeSignatureLabel(typeArgsSig[i], flags, result);
                ++i;
            }
            result.append('>');
        }
    }

    private static void getTypeParameterSignaturesLabel(String[] typeParamSigs, long flags, StyledString result) {
        if (typeParamSigs.length > 0) {
            result.append('<');
            int i = 0;
            while (i < typeParamSigs.length) {
                if (i > 0) {
                    result.append(COMMA_STRING);
                }
                result.append(Signature.getTypeVariable((String)typeParamSigs[i]));
                ++i;
            }
            result.append('>');
        }
    }

    public static void getTypeLabel(IType type, long flags, StringBuffer buf) {
        StyledString builder = new StyledString();
        JavaElementLabels.getTypeLabel(type, flags, builder);
        buf.append(builder.getString());
    }

    public static void getTypeLabel(IType type, long flags, StyledString result) {
        String typeName;
        IPackageFragment pack;
        if (JavaElementLabels.getFlag(flags, 262144L) && !(pack = type.getPackageFragment()).isDefaultPackage()) {
            JavaElementLabels.getPackageFragmentLabel(pack, flags & 0x1002000000000L, result);
            result.append('.');
        }
        if (JavaElementLabels.getFlag(flags, 786432L)) {
            int parentType;
            IType declaringType = type.getDeclaringType();
            if (declaringType != null) {
                JavaElementLabels.getTypeLabel(declaringType, 0x80000L | flags & 0x1002000000000L, result);
                result.append('.');
            }
            if ((parentType = type.getParent().getElementType()) == 9 || parentType == 8 || parentType == 10) {
                JavaElementLabels.getElementLabel(type.getParent(), 0L, result);
                result.append('.');
            }
        }
        if ((typeName = type.getElementName()).length() == 0) {
            try {
                if (type.getParent() instanceof IField && type.isEnum()) {
                    typeName = "{...}";
                } else {
                    String[] superInterfaceNames = type.getSuperInterfaceNames();
                    String supertypeName = superInterfaceNames.length > 0 ? Signature.getSimpleName((String)superInterfaceNames[0]) : Signature.getSimpleName((String)type.getSuperclassName());
                    typeName = Messages.format(JavaUIMessages.JavaElementLabels_anonym_type, supertypeName);
                }
            }
            catch (JavaModelException javaModelException) {
                typeName = JavaUIMessages.JavaElementLabels_anonym;
            }
        }
        result.append(typeName);
        if (JavaElementLabels.getFlag(flags, 0x200000L)) {
            if (JavaElementLabels.getFlag(flags, 0x1000000000000L) && type.isResolved()) {
                BindingKey key = new BindingKey(type.getKey());
                if (key.isParameterizedType()) {
                    String[] typeArguments = key.getTypeArguments();
                    JavaElementLabels.getTypeArgumentSignaturesLabel(typeArguments, flags, result);
                } else {
                    String[] typeParameters = Signature.getTypeParameters((String)key.toSignature());
                    JavaElementLabels.getTypeParameterSignaturesLabel(typeParameters, flags, result);
                }
            } else if (type.exists()) {
                try {
                    JavaElementLabels.getTypeParametersLabel(type.getTypeParameters(), flags, result);
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        if (JavaElementLabels.getFlag(flags, 0x8000000000000L) && type.exists()) {
            try {
                JavaElementLabels.getCategoryLabel((IMember)type, flags, result);
            }
            catch (JavaModelException javaModelException) {}
        }
        if (JavaElementLabels.getFlag(flags, 0x100000L)) {
            int offset = result.length();
            result.append(CONCAT_STRING);
            IType declaringType = type.getDeclaringType();
            if (declaringType != null) {
                JavaElementLabels.getTypeLabel(declaringType, 0x40000L | flags & 0x1002000000000L, result);
                int parentType = type.getParent().getElementType();
                if (parentType == 9 || parentType == 8 || parentType == 10) {
                    result.append('.');
                    JavaElementLabels.getElementLabel(type.getParent(), 0L, result);
                }
            } else {
                JavaElementLabels.getPackageFragmentLabel(type.getPackageFragment(), flags & 0x1002000000000L, result);
            }
            if (JavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.setStyle(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public static void getDeclarationLabel(IJavaElement declaration, long flags, StringBuffer buf) {
        StyledString builder = new StyledString();
        JavaElementLabels.getDeclarationLabel(declaration, flags, builder);
        buf.append(builder.getString());
    }

    public static void getDeclarationLabel(IJavaElement declaration, long flags, StyledString result) {
        IJavaElement openable;
        if (JavaElementLabels.getFlag(flags, 0x1000000L) && (openable = (IJavaElement)declaration.getOpenable()) != null) {
            result.append(JavaElementLabels.getElementLabel(openable, 0x88000000L | flags & 0x1002000000000L));
            result.append('/');
        }
        if (declaration.getElementType() == 12) {
            result.append(JavaUIMessages.JavaElementLabels_import_container);
        } else {
            result.append(declaration.getElementName());
        }
        if (JavaElementLabels.getFlag(flags, 0x2000000L)) {
            int offset = result.length();
            IJavaElement openable2 = (IJavaElement)declaration.getOpenable();
            if (openable2 != null) {
                result.append(CONCAT_STRING);
                result.append(JavaElementLabels.getElementLabel(openable2, 0x88000000L | flags & 0x1002000000000L));
            }
            if (JavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.setStyle(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public static void getClassFileLabel(IClassFile classFile, long flags, StringBuffer buf) {
        StyledString builder = new StyledString();
        JavaElementLabels.getClassFileLabel(classFile, flags, builder);
        buf.append(builder.getString());
    }

    public static void getClassFileLabel(IClassFile classFile, long flags, StyledString result) {
        IPackageFragment pack;
        if (JavaElementLabels.getFlag(flags, 0x8000000L) && !(pack = (IPackageFragment)classFile.getParent()).isDefaultPackage()) {
            JavaElementLabels.getPackageFragmentLabel(pack, flags & 0x1002000000000L, result);
            result.append('.');
        }
        result.append(classFile.getElementName());
        if (JavaElementLabels.getFlag(flags, 0x10000000L)) {
            int offset = result.length();
            result.append(CONCAT_STRING);
            JavaElementLabels.getPackageFragmentLabel((IPackageFragment)classFile.getParent(), flags & 0x1002000000000L, result);
            if (JavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.setStyle(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public static void getCompilationUnitLabel(ICompilationUnit cu, long flags, StringBuffer buf) {
        StyledString builder = new StyledString();
        JavaElementLabels.getCompilationUnitLabel(cu, flags, builder);
        buf.append(builder.getString());
    }

    public static void getCompilationUnitLabel(ICompilationUnit cu, long flags, StyledString result) {
        IPackageFragment pack;
        if (JavaElementLabels.getFlag(flags, 0x80000000L) && !(pack = (IPackageFragment)cu.getParent()).isDefaultPackage()) {
            JavaElementLabels.getPackageFragmentLabel(pack, flags & 0x1002000000000L, result);
            result.append('.');
        }
        result.append(cu.getElementName());
        if (JavaElementLabels.getFlag(flags, 0x100000000L)) {
            int offset = result.length();
            result.append(CONCAT_STRING);
            JavaElementLabels.getPackageFragmentLabel((IPackageFragment)cu.getParent(), flags & 0x1002000000000L, result);
            if (JavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.setStyle(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public static void getPackageFragmentLabel(IPackageFragment pack, long flags, StringBuffer buf) {
        StyledString builder = new StyledString();
        JavaElementLabels.getPackageFragmentLabel(pack, flags, builder);
        buf.append(builder.getString());
    }

    public static void getPackageFragmentLabel(IPackageFragment pack, long flags, StyledString result) {
        if (JavaElementLabels.getFlag(flags, 0x800000000L)) {
            JavaElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)pack.getParent(), 0x20000000000L, result);
            result.append('/');
        }
        if (pack.isDefaultPackage()) {
            result.append(DEFAULT_PACKAGE);
        } else if (JavaElementLabels.getFlag(flags, 0x2000000000L)) {
            JavaElementLabels.getCompressedPackageFragment(pack, result);
        } else {
            result.append(pack.getElementName());
        }
        if (JavaElementLabels.getFlag(flags, 0x1000000000L)) {
            int offset = result.length();
            result.append(CONCAT_STRING);
            JavaElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)pack.getParent(), 0x20000000000L, result);
            if (JavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.setStyle(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    private static void getCompressedPackageFragment(IPackageFragment pack, StyledString result) {
        JavaElementLabels.refreshPackageNamePattern();
        if (fgPkgNameLength < 0) {
            result.append(pack.getElementName());
            return;
        }
        String name = pack.getElementName();
        int start = 0;
        int dot = name.indexOf(46, start);
        while (dot > 0) {
            if (dot - start > fgPkgNameLength - 1) {
                result.append(fgPkgNamePrefix);
                if (fgPkgNameChars > 0) {
                    result.append(name.substring(start, Math.min(start + fgPkgNameChars, dot)));
                }
                result.append(fgPkgNamePostfix);
            } else {
                result.append(name.substring(start, dot + 1));
            }
            start = dot + 1;
            dot = name.indexOf(46, start);
        }
        result.append(name.substring(start));
    }

    public static void getPackageFragmentRootLabel(IPackageFragmentRoot root, long flags, StringBuffer buf) {
        StyledString builder = new StyledString();
        JavaElementLabels.getPackageFragmentRootLabel(root, flags, builder);
        buf.append(builder.getString());
    }

    public static void getPackageFragmentRootLabel(IPackageFragmentRoot root, long flags, StyledString result) {
        if (JavaElementLabels.getFlag(flags, 0x10000000000L) && JavaElementLabels.getVariableLabel(root, flags, result)) {
            return;
        }
        if (root.isArchive()) {
            JavaElementLabels.getArchiveLabel(root, flags, result);
        } else {
            JavaElementLabels.getFolderLabel(root, flags, result);
        }
    }

    private static void getArchiveLabel(IPackageFragmentRoot root, long flags, StyledString result) {
        boolean external = root.isExternal();
        if (external) {
            JavaElementLabels.getExternalArchiveLabel(root, flags, result);
        } else {
            JavaElementLabels.getInternalArchiveLabel(root, flags, result);
        }
    }

    private static boolean getVariableLabel(IPackageFragmentRoot root, long flags, StyledString result) {
        try {
            IClasspathEntry rawEntry = root.getRawClasspathEntry();
            if (rawEntry != null && rawEntry.getEntryKind() == 4) {
                IPath path = rawEntry.getPath().makeRelative();
                if (JavaElementLabels.getFlag(flags, 0x200000000000L)) {
                    int segements = path.segmentCount();
                    if (segements > 0) {
                        result.append(path.segment(segements - 1));
                        if (segements > 1) {
                            int offset = result.length();
                            result.append(CONCAT_STRING);
                            result.append(path.removeLastSegments(1).toOSString());
                            if (JavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                                result.setStyle(offset, result.length() - offset, QUALIFIER_STYLE);
                            }
                        }
                    } else {
                        result.append(path.toString());
                    }
                } else {
                    result.append(path.toString());
                }
                int offset = result.length();
                result.append(CONCAT_STRING);
                if (root.isExternal()) {
                    result.append(root.getPath().toOSString());
                } else {
                    result.append(root.getPath().makeRelative().toString());
                }
                if (JavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                    result.setStyle(offset, result.length() - offset, QUALIFIER_STYLE);
                }
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        return false;
    }

    private static void getExternalArchiveLabel(IPackageFragmentRoot root, long flags, StyledString result) {
        IPath path = root.getPath();
        if (JavaElementLabels.getFlag(flags, 0x200000000000L)) {
            int segements = path.segmentCount();
            if (segements > 0) {
                result.append(path.segment(segements - 1));
                int offset = result.length();
                if (segements > 1 || path.getDevice() != null) {
                    result.append(CONCAT_STRING);
                    result.append(path.removeLastSegments(1).toOSString());
                }
                if (JavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                    result.setStyle(offset, result.length() - offset, QUALIFIER_STYLE);
                }
            } else {
                result.append(path.toOSString());
            }
        } else {
            result.append(path.toOSString());
        }
    }

    private static void getInternalArchiveLabel(IPackageFragmentRoot root, long flags, StyledString result) {
        boolean referencedQualified;
        IResource resource = root.getResource();
        boolean rootQualified = JavaElementLabels.getFlag(flags, 0x20000000000L);
        boolean bl = referencedQualified = JavaElementLabels.getFlag(flags, 0x200000000000L) && JavaElementLabels.isReferenced(root);
        if (rootQualified) {
            result.append(root.getPath().makeRelative().toString());
        } else {
            result.append(root.getElementName());
            int offset = result.length();
            if (referencedQualified) {
                result.append(CONCAT_STRING);
                result.append(resource.getParent().getFullPath().makeRelative().toString());
            } else if (JavaElementLabels.getFlag(flags, 0x40000000000L)) {
                result.append(CONCAT_STRING);
                result.append(root.getParent().getPath().makeRelative().toString());
            } else {
                return;
            }
            if (JavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.setStyle(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    private static void getFolderLabel(IPackageFragmentRoot root, long flags, StyledString result) {
        boolean referencedQualified;
        IResource resource = root.getResource();
        if (resource == null) {
            JavaElementLabels.getExternalArchiveLabel(root, flags, result);
            return;
        }
        boolean rootQualified = JavaElementLabels.getFlag(flags, 0x20000000000L);
        boolean bl = referencedQualified = JavaElementLabels.getFlag(flags, 0x200000000000L) && JavaElementLabels.isReferenced(root);
        if (rootQualified) {
            result.append(root.getPath().makeRelative().toString());
        } else {
            IPath projectRelativePath = resource.getProjectRelativePath();
            if (projectRelativePath.segmentCount() == 0) {
                result.append(resource.getName());
                referencedQualified = false;
            } else {
                result.append(projectRelativePath.toString());
            }
            int offset = result.length();
            if (referencedQualified) {
                result.append(CONCAT_STRING);
                result.append(resource.getProject().getName());
            } else if (JavaElementLabels.getFlag(flags, 0x40000000000L)) {
                result.append(CONCAT_STRING);
                result.append(root.getParent().getElementName());
            } else {
                return;
            }
            if (JavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.setStyle(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    private static boolean isReferenced(IPackageFragmentRoot root) {
        IResource resource = root.getResource();
        if (resource != null) {
            IProject jarProject = resource.getProject();
            IProject container = root.getJavaProject().getProject();
            return !container.equals((Object)jarProject);
        }
        return false;
    }

    private static void refreshPackageNamePattern() {
        String pattern = JavaElementLabels.getPkgNamePatternForPackagesView();
        if (pattern.equals(fgPkgNamePattern)) {
            return;
        }
        if (pattern.length() == 0) {
            fgPkgNamePattern = "";
            fgPkgNameLength = -1;
            return;
        }
        fgPkgNamePattern = pattern;
        int i = 0;
        fgPkgNameChars = 0;
        fgPkgNamePrefix = "";
        fgPkgNamePostfix = "";
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (Character.isDigit(ch)) {
                fgPkgNameChars = ch - 48;
                if (i > 0) {
                    fgPkgNamePrefix = pattern.substring(0, i);
                }
                if (i >= 0) {
                    fgPkgNamePostfix = pattern.substring(i + 1);
                }
                fgPkgNameLength = fgPkgNamePrefix.length() + fgPkgNameChars + fgPkgNamePostfix.length();
                return;
            }
            ++i;
        }
        fgPkgNamePrefix = pattern;
        fgPkgNameLength = pattern.length();
    }

    private static String getPkgNamePatternForPackagesView() {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        if (!store.getBoolean("org.eclipse.jdt.ui.compresspackagenames")) {
            return "";
        }
        return store.getString("PackagesView.pkgNamePatternForPackagesView");
    }

    public static String getContainerEntryLabel(IPath containerPath, IJavaProject project) throws JavaModelException {
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)project);
        if (container != null) {
            return container.getDescription();
        }
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0));
        if (initializer != null) {
            return initializer.getDescription(containerPath, project);
        }
        return BasicElementLabels.getPathLabel(containerPath, false);
    }

    public static StyledString getStyledContainerEntryLabel(IPath containerPath, IJavaProject project) {
        try {
            ClasspathContainerInitializer initializer;
            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)project);
            String description = null;
            if (container != null) {
                description = container.getDescription();
            }
            if (description == null && (initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0))) != null) {
                description = initializer.getDescription(containerPath, project);
            }
            if (description != null) {
                int index;
                StyledString str = new StyledString(description);
                if (containerPath.segmentCount() > 0 && JavaRuntime.JRE_CONTAINER.equals(containerPath.segment(0)) && (index = description.indexOf(91)) != -1) {
                    str.setStyle(index, description.length() - index, DECORATIONS_STYLE);
                }
                return Strings.markLTR(str);
            }
        }
        catch (JavaModelException javaModelException) {}
        return new StyledString(containerPath.toString());
    }
}

