/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.DefaultAnimationFeedback;
import org.eclipse.ui.internal.RectangleAnimation;

public class ImageAnimationFeedback
extends DefaultAnimationFeedback {
    private Display display;
    private Shell theShell;
    private List startRects = new ArrayList();
    private List endRects = new ArrayList();
    private List controls = new ArrayList();
    private Image backingStore;

    public void initialize(Shell parentShell, Rectangle startRect, Rectangle endRect) {
        this.display = parentShell.getDisplay();
        Rectangle psRect = parentShell.getBounds();
        this.theShell = new Shell(parentShell, 16392);
        this.theShell.setBounds(parentShell.getBounds());
        this.addStartRect(startRect);
        this.addEndRect(endRect);
        this.backingStore = new Image((Device)this.theShell.getDisplay(), psRect);
        GC gc = new GC((Drawable)this.display);
        gc.copyArea(this.backingStore, psRect.x, psRect.y);
        gc.dispose();
        this.theShell.setBackgroundImage(this.backingStore);
        this.theShell.setVisible(true);
        this.display.update();
    }

    public void addStartRect(Rectangle rect) {
        if (rect != null) {
            Rectangle start = Geometry.toControl((Control)this.theShell, (Rectangle)rect);
            this.startRects.add(start);
            Image image = new Image((Device)this.display, rect.width, rect.height);
            GC gc = new GC((Drawable)this.display);
            gc.copyArea(image, rect.x, rect.y);
            gc.dispose();
            ImageCanvas canvas = new ImageCanvas((Composite)this.theShell, 264192, image);
            this.controls.add(canvas);
        }
    }

    public void addEndRect(Rectangle rect) {
        if (rect != null) {
            Rectangle end = Geometry.toControl((Control)this.theShell, (Rectangle)rect);
            this.endRects.add(end);
        }
    }

    public void renderStep(double amount) {
        Iterator startIter = this.startRects.iterator();
        Iterator endIter = this.endRects.iterator();
        Iterator ctrlIter = this.controls.iterator();
        while (startIter.hasNext()) {
            Rectangle start = (Rectangle)startIter.next();
            Rectangle end = (Rectangle)endIter.next();
            ImageCanvas canvas = (ImageCanvas)((Object)ctrlIter.next());
            Rectangle curRect = RectangleAnimation.interpolate(start, end, amount);
            canvas.setBounds(curRect);
        }
        this.display.update();
    }

    public void jobInit() {
    }

    public void dispose() {
        this.backingStore.dispose();
        Iterator ctrlIter = this.controls.iterator();
        while (ctrlIter.hasNext()) {
            ImageCanvas canvas = (ImageCanvas)((Object)ctrlIter.next());
            canvas.dispose();
        }
        this.theShell.setVisible(false);
        this.theShell.dispose();
    }

    private class ImageCanvas
    extends Canvas {
        private Image image;

        public ImageCanvas(Composite parent, int style, Image image) {
            super(parent, style);
            this.image = image;
            this.addPaintListener(new PaintListener(this){
                final /* synthetic */ ImageCanvas this$1;
                {
                    this.this$1 = imageCanvas;
                }

                public void paintControl(PaintEvent e) {
                    this.this$1.paintImage(e.gc);
                }
            });
        }

        protected void paintImage(GC gc) {
            gc.drawImage(this.image, 0, 0, this.image.getBounds().width, this.image.getBounds().height, 0, 0, this.getBounds().width, this.getBounds().height);
        }

        public void dispose() {
            super.dispose();
            this.image.dispose();
        }
    }
}

