/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile.validator;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilableModel;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.reconcile.DocumentAdapter;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredReconcileStep;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.AnnotationInfo;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.IncrementalHelper;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.IncrementalReporter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ReconcileStepForValidator
extends StructuredReconcileStep {
    protected static final boolean DEBUG;
    private final IReconcileResult[] EMPTY_RECONCILE_RESULT_SET = new IReconcileResult[0];
    private IncrementalHelper fHelper = null;
    private IncrementalReporter fReporter = null;
    private int fScope = -1;
    private IValidator fValidator = null;
    private final String QUICKASSISTPROCESSOR;
    static /* synthetic */ Class class$0;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/reconcilerjob");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public ReconcileStepForValidator(IValidator v, int scope) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.quickassist.IQuickAssistProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.QUICKASSISTPROCESSOR = clazz.getName();
        if (v == null) {
            throw new IllegalArgumentException("validator cannot be null");
        }
        this.fValidator = v;
        this.fScope = scope;
    }

    protected IReconcileResult[] createAnnotations(AnnotationInfo[] infos) {
        ArrayList<TemporaryAnnotation> annotations = new ArrayList<TemporaryAnnotation>();
        int i = 0;
        while (i < infos.length) {
            block6: {
                AnnotationInfo info = infos[i];
                IMessage validationMessage = info.getMessage();
                int offset = validationMessage.getOffset();
                if (offset >= 0) {
                    String messageText = null;
                    try {
                        messageText = validationMessage.getText(validationMessage.getClass().getClassLoader());
                    }
                    catch (Exception t) {
                        Logger.logException("exception reporting message from validator", t);
                        break block6;
                    }
                    String type = this.getSeverity(validationMessage);
                    int length = validationMessage.getLength();
                    if (length >= 0) {
                        Position p = new Position(offset, length);
                        ReconcileAnnotationKey key = this.createKey(this.getPartitionType(this.getDocument(), offset), this.getScope());
                        TemporaryAnnotation annotation = new TemporaryAnnotation(p, type, messageText, key);
                        Object extraInfo = info.getAdditionalFixInfo();
                        if (extraInfo == null) {
                            extraInfo = validationMessage.getAttribute(this.QUICKASSISTPROCESSOR);
                        }
                        annotation.setAdditionalFixInfo(extraInfo);
                        annotation.setAttributes(validationMessage.getAttributes());
                        annotations.add(annotation);
                    }
                }
            }
            ++i;
        }
        return annotations.toArray(new IReconcileResult[annotations.size()]);
    }

    private String getSeverity(IMessage validationMessage) {
        String type = "org.eclipse.wst.sse.ui.temp.info";
        switch (validationMessage.getSeverity()) {
            case 1: {
                type = "org.eclipse.wst.sse.ui.temp.error";
                break;
            }
            case 2: {
                type = "org.eclipse.wst.sse.ui.temp.warning";
                break;
            }
            case 4: {
                type = "org.eclipse.wst.sse.ui.temp.warning";
                break;
            }
            case 3: {
                type = "org.eclipse.wst.sse.ui.temp.warning";
            }
        }
        return type;
    }

    /*
     * Exception decompiling
     */
    private IFile getFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 103->106)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IncrementalHelper getHelper(IProject project) {
        if (this.fHelper == null) {
            this.fHelper = new IncrementalHelper(this.getDocument(), project);
        }
        return this.fHelper;
    }

    private IncrementalReporter getReporter() {
        if (this.fReporter == null) {
            this.fReporter = new IncrementalReporter(this.getProgressMonitor());
        }
        return this.fReporter;
    }

    public int getScope() {
        return this.fScope;
    }

    public void initialReconcile() {
    }

    protected IReconcileResult[] reconcileModel(DirtyRegion dirtyRegion, IRegion subRegion) {
        if (DEBUG) {
            System.out.println("[trace reconciler] > reconciling model in VALIDATOR step w/ dirty region: [" + dirtyRegion.getText() + "]");
        }
        IReconcileResult[] results = this.EMPTY_RECONCILE_RESULT_SET;
        if (dirtyRegion != null) {
            try {
                results = this.fValidator instanceof ISourceValidator ? this.validate(dirtyRegion, subRegion) : this.validate();
            }
            catch (Exception ex) {
                Logger.logException("EXEPTION IN RECONCILE STEP FOR VALIDATOR", ex);
            }
        }
        if (DEBUG) {
            System.out.println("[trace reconciler] > VALIDATOR step done");
        }
        return results;
    }

    public String toString() {
        StringBuffer debugString = new StringBuffer("ValidatorStep: ");
        if (this.fValidator != null) {
            debugString.append(this.fValidator.toString());
        }
        return debugString.toString();
    }

    protected IReconcileResult[] validate() {
        IReconcileResult[] results = this.EMPTY_RECONCILE_RESULT_SET;
        IFile file = this.getFile();
        try {
            IncrementalHelper helper = this.getHelper(file != null ? file.getProject() : null);
            IncrementalReporter reporter = this.getReporter();
            if (file != null && file.exists()) {
                helper.setURI(file.getFullPath().toString());
            }
            this.fValidator.validate((IValidationContext)helper, (IReporter)reporter);
            results = this.createAnnotations(reporter.getAnnotationInfo());
            reporter.removeAllMessages(this.fValidator);
            this.fValidator.cleanup((IReporter)reporter);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return results;
    }

    public void setInputModel(IReconcilableModel inputModel) {
        IDocument document;
        if (inputModel instanceof DocumentAdapter && (document = ((DocumentAdapter)inputModel).getDocument()) != null && this.fValidator instanceof ISourceValidator) {
            ((ISourceValidator)this.fValidator).connect(document);
        }
        super.setInputModel(inputModel);
    }

    public void release() {
        if (this.fValidator instanceof ISourceValidator) {
            IDocument document = this.getDocument();
            if (document != null) {
                ((ISourceValidator)this.fValidator).disconnect(document);
            }
            this.fValidator.cleanup((IReporter)this.getReporter());
        }
        super.release();
    }

    protected IReconcileResult[] validate(DirtyRegion dirtyRegion, IRegion subRegion) {
        IReconcileResult[] results = this.EMPTY_RECONCILE_RESULT_SET;
        IFile file = this.getFile();
        try {
            IncrementalHelper helper = this.getHelper(file != null ? file.getProject() : null);
            if (file != null && file.exists()) {
                helper.setURI(file.getFullPath().toString());
            }
            if (this.fValidator instanceof ISourceValidator) {
                IncrementalReporter reporter = this.getReporter();
                ((ISourceValidator)this.fValidator).validate((IRegion)dirtyRegion, helper, reporter);
                results = this.createAnnotations(reporter.getAnnotationInfo());
                reporter.removeAllMessages(this.fValidator);
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return results;
    }
}

