/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.utils.UserData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GraphMLFileHandler
extends DefaultHandler {
    private Graph mGraph;
    private StringLabeller mLabeller;
    private boolean default_directed;

    protected Graph getGraph() {
        return this.mGraph;
    }

    protected StringLabeller getLabeller() {
        return this.mLabeller;
    }

    private Map getAttributeMap(Attributes attrs) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                map.put(attrs.getQName(i), attrs.getValue(i));
            }
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    protected Edge createEdge(Map attributeMap) {
        void var7_7;
        boolean directed;
        if (this.mGraph == null) {
            throw new FatalException("Error parsing graph. Graph element must be specified before edge element.");
        }
        String sourceId = (String)attributeMap.remove("source");
        Vertex sourceVertex = this.mLabeller.getVertex(sourceId);
        String targetId = (String)attributeMap.remove("target");
        Vertex targetVertex = this.mLabeller.getVertex(targetId);
        String direction = (String)attributeMap.remove("directed");
        if (direction == null) {
            directed = this.default_directed;
        } else if (direction.equals("true")) {
            directed = true;
        } else if (direction.equals("false")) {
            directed = false;
        } else {
            throw new FatalException("Error parsing graph: 'directed' tag has invalid value: " + direction);
        }
        Edge e = var7_7 != false ? this.mGraph.addEdge(new DirectedSparseEdge(sourceVertex, targetVertex)) : this.mGraph.addEdge(new UndirectedSparseEdge(sourceVertex, targetVertex));
        Iterator keyIt = attributeMap.keySet().iterator();
        while (keyIt.hasNext()) {
            Object key = keyIt.next();
            Object value = attributeMap.get(key);
            e.setUserDatum(key, value, UserData.SHARED);
        }
        return e;
    }

    protected void createGraph(Map attributeMap) {
        String edgeDefaultType = (String)attributeMap.remove("edgedefault");
        this.mGraph = new SparseGraph();
        if (edgeDefaultType.equals("directed")) {
            this.default_directed = true;
        } else if (edgeDefaultType.equals("undirected")) {
            this.default_directed = false;
        } else {
            throw new FatalException("Error parsing graph. Edge default type not specified.");
        }
        this.mLabeller = StringLabeller.getLabeller(this.mGraph);
        Iterator keyIt = attributeMap.keySet().iterator();
        while (keyIt.hasNext()) {
            Object key = keyIt.next();
            Object value = attributeMap.get(key);
            this.mGraph.setUserDatum(key, value, UserData.SHARED);
        }
    }

    protected ArchetypeVertex createVertex(Map attributeMap) {
        if (this.mGraph == null) {
            throw new FatalException("Error parsing graph. Graph element must be specified before node element.");
        }
        Vertex vertex = this.mGraph.addVertex(new SparseVertex());
        String idString = (String)attributeMap.remove("id");
        try {
            this.mLabeller.setLabel(vertex, idString);
        }
        catch (StringLabeller.UniqueLabelException ule) {
            throw new FatalException("Ids must be unique");
        }
        Iterator keyIt = attributeMap.keySet().iterator();
        while (keyIt.hasNext()) {
            Object key = keyIt.next();
            Object value = attributeMap.get(key);
            vertex.setUserDatum(key, value, UserData.SHARED);
        }
        return vertex;
    }

    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        Map attributeMap = this.getAttributeMap(attrs);
        if (qName.toLowerCase().equals("graph")) {
            this.createGraph(attributeMap);
        } else if (qName.toLowerCase().equals("node")) {
            this.createVertex(attributeMap);
        } else if (qName.toLowerCase().equals("edge")) {
            this.createEdge(attributeMap);
        }
    }
}

