/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.commons.collections.Predicate;

public class PartitionDecorationReader {
    public static void loadStrings(Graph bg, Reader name_reader, Predicate partition, Object string_key) {
        StringLabeller id_label = StringLabeller.getLabeller(bg, partition);
        StringLabeller string_label = StringLabeller.getLabeller(bg, string_key);
        try {
            String curLine;
            BufferedReader br = new BufferedReader(name_reader);
            while (br.ready() && (curLine = br.readLine()) != null && !curLine.equals("end_of_file")) {
                if (curLine.trim().length() == 0) continue;
                String[] parts = curLine.trim().split("\\s+", 2);
                Vertex v = id_label.getVertex(parts[0]);
                if (v == null) {
                    throw new FatalException("Invalid vertex label");
                }
                string_label.setLabel(v, parts[1]);
            }
            br.close();
            name_reader.close();
        }
        catch (IOException ioe) {
            throw new FatalException("Error loading names from reader " + name_reader, ioe);
        }
        catch (StringLabeller.UniqueLabelException ule) {
            throw new FatalException("Unexpected duplicate name in reader " + name_reader, ule);
        }
    }

    public static int loadCounts(Graph bg, Reader count_reader, Predicate partition, Object count_key, UserDataContainer.CopyAction copyact) {
        StringLabeller id_label = StringLabeller.getLabeller(bg, partition);
        HashSet<String> types = new HashSet<String>();
        try {
            String curLine;
            BufferedReader br = new BufferedReader(count_reader);
            while (br.ready() && (curLine = br.readLine()) != null && !curLine.equals("end_of_file")) {
                if (curLine.trim().length() == 0) continue;
                StringTokenizer st = new StringTokenizer(curLine);
                String entity_id = st.nextToken();
                String type_id = st.nextToken();
                Integer count = new Integer(st.nextToken());
                types.add(type_id);
                Vertex v = id_label.getVertex(entity_id);
                if (v == null) {
                    throw new IllegalArgumentException("Unrecognized vertex " + entity_id);
                }
                HashMap<String, Integer> count_map = (HashMap<String, Integer>)v.getUserDatum(count_key);
                if (count_map == null) {
                    count_map = new HashMap<String, Integer>();
                    v.addUserDatum(count_key, count_map, copyact);
                }
                count_map.put(type_id, count);
            }
            br.close();
            count_reader.close();
        }
        catch (IOException ioe) {
            throw new FatalException("Error in loading counts from " + count_reader);
        }
        return types.size();
    }

    public static void loadCounts(Graph bg, Reader count_reader, Predicate partition, Object count_key, UserDataContainer.CopyAction copyact, int num_types) {
        StringLabeller id_label = StringLabeller.getLabeller(bg, partition);
        try {
            String curLine;
            BufferedReader br = new BufferedReader(count_reader);
            while (br.ready() && (curLine = br.readLine()) != null && !curLine.equals("end_of_file")) {
                if (curLine.trim().length() == 0) continue;
                StringTokenizer st = new StringTokenizer(curLine);
                String entity_id = st.nextToken();
                int type_id = new Integer(st.nextToken()) - 1;
                int count = new Integer(st.nextToken());
                Vertex v = id_label.getVertex(entity_id);
                if (v == null) {
                    throw new IllegalArgumentException("Unrecognized vertex " + entity_id);
                }
                double[] counts = (double[])v.getUserDatum(count_key);
                if (counts == null) {
                    counts = new double[num_types];
                    v.addUserDatum(count_key, counts, copyact);
                }
                counts[type_id] = count;
            }
            br.close();
        }
        catch (IOException ioe) {
            throw new FatalException("Error in loading counts from " + count_reader);
        }
    }
}

