/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.notation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.NodeContainer;

public class Node
extends AbstractNotationElement {
    private NodeContainer container;
    private Rectangle constraint = new Rectangle(new Point(0, 0), new Dimension(132, 36));
    private List leavingEdges = new ArrayList();
    private List arrivingEdges = new ArrayList();

    public void setConstraint(Rectangle newConstraint) {
        Rectangle oldConstraint = this.constraint;
        this.constraint = newConstraint;
        this.firePropertyChange("constraint", oldConstraint, newConstraint);
    }

    public Rectangle getConstraint() {
        return this.constraint;
    }

    public void addLeavingEdge(Edge edge) {
        this.leavingEdges.add(edge);
        edge.setSource(this);
        this.firePropertyChange("leavingEdgeAdd", null, edge);
    }

    public void removeLeavingEdge(Edge edge) {
        this.leavingEdges.remove(edge);
        edge.setSource(null);
        this.firePropertyChange("leavingEdgeRemove", null, edge);
    }

    public List getLeavingEdges() {
        return this.leavingEdges;
    }

    public void addArrivingEdge(Edge edge) {
        this.arrivingEdges.add(edge);
        edge.setTarget(this);
        this.firePropertyChange("arrivingEdgeAdd", null, edge);
    }

    public void removeArrivingEdge(Edge edge) {
        this.arrivingEdges.remove(edge);
        edge.setTarget(null);
        this.firePropertyChange("arrivingEdgeRemove", null, edge);
    }

    public List getArrivingEdges() {
        return this.arrivingEdges;
    }

    public void setContainer(NodeContainer notationElement) {
        this.container = notationElement;
    }

    public NodeContainer getContainer() {
        return this.container;
    }
}

