/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.registry;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.jbpm.gd.common.xml.XmlElementMapper;
import org.jbpm.gd.jpdl.Logger;
import org.w3c.dom.Node;

public class XmlAdapterRegistry {
    Map xmlElementMap = new HashMap();
    Map semanticElementIdMap = new HashMap();

    public XmlAdapterRegistry(Set elementIds) {
        this.initializeMaps(elementIds);
    }

    private void initializeMaps(Set elementIds) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.jbpm.gd.jpdl.xmlMappings");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String semanticElement = configElements[j].getAttribute("semanticElement");
                if (elementIds.contains(semanticElement)) {
                    this.semanticElementIdMap.put(semanticElement, configElements[j]);
                    String xmlElement = configElements[j].getAttribute("xmlElement");
                    if (xmlElement != null) {
                        TreeSet<IConfigurationElement> set = (TreeSet<IConfigurationElement>)this.xmlElementMap.get(xmlElement);
                        if (set == null) {
                            set = new TreeSet<IConfigurationElement>(PriorityComparator.INSTANCE);
                            this.xmlElementMap.put(xmlElement, set);
                        }
                        set.add(configElements[j]);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public IConfigurationElement getConfigurationElementByXmlNode(Node node) {
        String nodeName = node.getNodeName();
        SortedSet set = (SortedSet)this.xmlElementMap.get(nodeName);
        if (set == null) {
            return null;
        }
        for (IConfigurationElement element : set) {
            if (element.getAttribute("mapperClass") == null) {
                return element;
            }
            if (!this.createXmlElementMapper(element).accept(node)) continue;
            return element;
        }
        return null;
    }

    private XmlElementMapper createXmlElementMapper(IConfigurationElement element) {
        XmlElementMapper result = null;
        try {
            result = (XmlElementMapper)element.createExecutableExtension("mapperClass");
        }
        catch (CoreException e) {
            Logger.logError("Could not create mapper class", e);
        }
        return result;
    }

    public IConfigurationElement getConfigurationElementBySemanticElementId(String semanticElementId) {
        return (IConfigurationElement)this.semanticElementIdMap.get(semanticElementId);
    }

    private static class PriorityComparator
    implements Comparator {
        private static PriorityComparator INSTANCE = new PriorityComparator();

        private PriorityComparator() {
        }

        public int compare(Object left, Object right) {
            int result = this.getPriority(right) - this.getPriority(left);
            if (result == 0) {
                result = right.hashCode() - left.hashCode();
            }
            return result;
        }

        private int getPriority(Object object) {
            int result = 0;
            String priority = ((IConfigurationElement)object).getAttribute("mapperClassPriority");
            if (priority != null) {
                result = Integer.valueOf(priority);
            }
            return result;
        }
    }
}

