/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.deployment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.jbpm.gd.jpdl.Logger;
import org.jbpm.gd.jpdl.Plugin;
import org.jbpm.gd.jpdl.deployment.IncludeClassesTreeContentProvider;
import org.jbpm.gd.jpdl.deployment.IncludeFilesTreeContentProvider;
import org.jbpm.gd.jpdl.deployment.IncludeInDeploymentTreeViewer;
import org.jbpm.gd.jpdl.editor.JpdlEditor;
import org.jbpm.gd.jpdl.util.JavaClassNameCollector;
import org.jbpm.gd.jpdl.util.ProcessDeployer;

public class DeploymentForm {
    public static final int NONE = 0;
    public static final int EXPRESSION = 1;
    public static final int HANDLER = 2;
    private FormToolkit toolkit;
    private Composite composite;
    private IFolder processFolder;
    private JpdlEditor editor;
    private Form form;
    private Text nameText;
    private Text portText;
    private Text deployerText;
    private Text locationText;
    private Button deployButton;
    private Button saveButton;
    private Button locationButton;
    private Button testConnectionButton;
    private Button saveLocallyButton;
    private IncludeInDeploymentTreeViewer includeFilesTreeViewer;
    private IncludeInDeploymentTreeViewer includeClassesTreeViewer;

    public DeploymentForm(FormToolkit toolkit, Composite composite, IFolder processFolder, JpdlEditor editor) {
        this.toolkit = toolkit;
        this.composite = composite;
        this.processFolder = processFolder;
        this.editor = editor;
    }

    public void create() {
        this.createMainForm();
        this.createIncludeFilesSection();
        this.createIncludeClassesSection();
        this.createLocalSaveSection();
        this.createServerInfoSection();
        this.toolkit.createForm(this.form.getBody());
        this.createDeployButton();
    }

    private void createMainForm() {
        this.form = this.toolkit.createForm(this.composite);
        GridData layoutData = new GridData(1808);
        this.form.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        this.form.getBody().setLayout((Layout)layout);
        this.form.getBody().setLayoutData((Object)new GridData(1808));
    }

    private void createDeployButton() {
        this.deployButton = this.toolkit.createButton(this.form.getBody(), "Deploy Process Archive...", 8);
        this.deployButton.setLayoutData((Object)new GridData(128));
        this.deployButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DeploymentForm.this.cancelOrSaveAndContinue()) {
                    DeploymentForm.this.createProcessDeployer().deploy();
                }
            }
        });
    }

    private ProcessDeployer createProcessDeployer() {
        ProcessDeployer result = new ProcessDeployer();
        String location = null;
        if (this.saveButton.isEnabled()) {
            location = this.locationText.getText();
        }
        result.setTargetLocation(location);
        result.setServerName(this.nameText.getText());
        result.setServerPort(this.portText.getText());
        result.setServerDeployer(this.deployerText.getText());
        result.setShell(this.form.getShell());
        result.setProcessFolder(this.processFolder);
        result.setFilesAndFolders(this.getIncludedFiles());
        result.setClassesAndResources(this.getClassesAndResources());
        return result;
    }

    private ArrayList getIncludedFiles() {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] objects = this.includeFilesTreeViewer.getCheckedElements();
        int i = 0;
        while (i < objects.length) {
            result.add(objects[i]);
            ++i;
        }
        return result;
    }

    private ArrayList getClassesAndResources() {
        ArrayList<String> result = new ArrayList<String>();
        Object[] objects = this.includeClassesTreeViewer.getCheckedElements();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof ICompilationUnit) {
                String string = this.getResourceName(((ICompilationUnit)objects[i]).getResource());
                result.add(String.valueOf(string.substring(0, string.lastIndexOf(".java"))) + ".class");
            } else if (objects[i] instanceof IFile) {
                result.add(this.getResourceName((IResource)((IFile)objects[i])));
            }
            ++i;
        }
        return result;
    }

    private String getResourceName(IResource resource) {
        IPackageFragmentRoot root = this.getPackageFragmentRoot(resource);
        if (root == null) {
            return null;
        }
        int index = root.getResource().getProjectRelativePath().toString().length() + 1;
        return resource.getProjectRelativePath().toString().substring(index);
    }

    private IPackageFragmentRoot getPackageFragmentRoot(IResource resource) {
        IPackageFragmentRoot root = null;
        IResource r = resource;
        while (r != null) {
            IJavaElement javaElement = JavaCore.create((IResource)r);
            if (javaElement != null && javaElement instanceof IPackageFragmentRoot) {
                root = (IPackageFragmentRoot)javaElement;
                break;
            }
            r = r.getParent();
        }
        return root;
    }

    private Composite createServerInfoFormClient() {
        Section serverInfoDetails = this.toolkit.createSection(this.form.getBody(), 384);
        serverInfoDetails.marginWidth = 5;
        serverInfoDetails.setText("Deployment Server Settings");
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 1;
        serverInfoDetails.setLayoutData((Object)gridData);
        Composite infoFormClient = this.toolkit.createComposite((Composite)serverInfoDetails);
        serverInfoDetails.setClient((Control)infoFormClient);
        serverInfoDetails.setDescription("Specify the settings of the server you wish to deploy to.");
        this.toolkit.paintBordersFor(infoFormClient);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.numColumns = 3;
        infoFormClient.setLayout((Layout)layout);
        return infoFormClient;
    }

    private void createServerInfoSection() {
        Composite serverInfoFormClient = this.createServerInfoFormClient();
        this.createServerNameField(serverInfoFormClient);
        this.createServerPortField(serverInfoFormClient);
        this.createServerDeployerField(serverInfoFormClient);
        this.createTestConnectionButton(serverInfoFormClient);
    }

    private void createLocalSaveSection() {
        Composite localSaveFormClient = this.createLocalSaveFormClient();
        this.createSaveLocallyCheckBox(localSaveFormClient);
        this.createSaveLocationField(localSaveFormClient);
        this.createSaveButton(localSaveFormClient);
    }

    private void createServerNameField(Composite infoFormClient) {
        Label nameLabel = this.toolkit.createLabel(infoFormClient, "Server Name:");
        nameLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.nameText = this.toolkit.createText(infoFormClient, "");
        String nameString = Plugin.getDefault().getPreferenceStore().getString("server name");
        this.nameText.setText(nameString == null || "".equals(nameString) ? "localhost" : nameString);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gridData);
        this.nameText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                DeploymentForm.this.updateTestConnectionAndDeployButtons();
            }
        });
    }

    private void createServerPortField(Composite infoFormClient) {
        Label portLabel = this.toolkit.createLabel(infoFormClient, "Server Port:");
        portLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.portText = this.toolkit.createText(infoFormClient, "");
        String portString = Plugin.getDefault().getPreferenceStore().getString("server port");
        this.portText.setText(portString == null || "".equals(portString) ? "8080" : portString);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.portText.setLayoutData((Object)gridData);
        this.portText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                DeploymentForm.this.updateTestConnectionAndDeployButtons();
            }
        });
    }

    private void createServerDeployerField(Composite infoFormClient) {
        Label deployerLabel = this.toolkit.createLabel(infoFormClient, "Server Deployer:");
        deployerLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.deployerText = this.toolkit.createText(infoFormClient, "");
        String deployerString = Plugin.getDefault().getPreferenceStore().getString("server deployer");
        this.deployerText.setText(deployerString == null || "".equals(deployerString) ? "/jbpm-console/upload" : deployerString);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.deployerText.setLayoutData((Object)gridData);
        this.deployerText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                DeploymentForm.this.updateTestConnectionAndDeployButtons();
            }
        });
    }

    private void createTestConnectionButton(Composite infoFormClient) {
        this.testConnectionButton = this.toolkit.createButton(infoFormClient, "Test Connection...", 8);
        this.testConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentForm.this.createProcessDeployer().pingServer();
            }
        });
    }

    private Composite createIncludeFilesSection() {
        Section includeFilesDetails = this.toolkit.createSection(this.form.getBody(), 384);
        includeFilesDetails.marginWidth = 5;
        includeFilesDetails.setText("Files and Folders");
        includeFilesDetails.setLayoutData((Object)new GridData(1808));
        Composite includeFilesFormClient = this.toolkit.createComposite((Composite)includeFilesDetails);
        includeFilesDetails.setClient((Control)includeFilesFormClient);
        includeFilesDetails.setDescription("Select the files and folders to include in the process archive.");
        this.toolkit.paintBordersFor(includeFilesFormClient);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.numColumns = 1;
        includeFilesFormClient.setLayout((Layout)layout);
        Tree tree = this.toolkit.createTree(includeFilesFormClient, 32);
        tree.setLayoutData((Object)new GridData(1808));
        this.includeFilesTreeViewer = new IncludeInDeploymentTreeViewer(tree);
        this.includeFilesTreeViewer.setContentProvider((IContentProvider)new IncludeFilesTreeContentProvider());
        this.includeFilesTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.includeFilesTreeViewer.setInput(this.processFolder);
        tree.getDisplay().asyncExec(new Runnable(){

            public void run() {
                DeploymentForm.this.includeFilesTreeViewer.setCheckedElements(DeploymentForm.this.getElementsToCheckFor(DeploymentForm.this.processFolder).toArray());
            }
        });
        final Button includeFilesDefaultButton = this.toolkit.createButton(includeFilesFormClient, "Reset Defaults", 8);
        includeFilesDefaultButton.setLayoutData((Object)new GridData(128));
        includeFilesDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                includeFilesDefaultButton.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        DeploymentForm.this.includeFilesTreeViewer.setCheckedElements(DeploymentForm.this.getElementsToCheckFor(DeploymentForm.this.processFolder).toArray());
                    }
                });
            }
        });
        return includeFilesFormClient;
    }

    private ArrayList getElementsToCheckFor(IFolder folder) {
        ArrayList<IResource> list = new ArrayList<IResource>();
        try {
            IResource[] members = folder.members();
            int i = 0;
            while (i < members.length) {
                list.add(members[i]);
                if (members[i] instanceof IFolder) {
                    list.addAll(this.getElementsToCheckFor((IFolder)members[i]));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Logger.logError(e);
        }
        return list;
    }

    private Set getElementsToCheckFor(IJavaProject project) {
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>();
        try {
            if (project != null) {
                Set javaClassNames = JavaClassNameCollector.getJavaClassNames(this.editor.getProcessDefinition());
                Iterator iterator = javaClassNames.iterator();
                while (iterator.hasNext()) {
                    IType type = project.findType((String)iterator.next());
                    if (type == null) continue;
                    result.add(type.getCompilationUnit());
                }
            }
        }
        catch (JavaModelException e) {
            Logger.logError(e);
        }
        return result;
    }

    private Composite createIncludeClassesSection() {
        Section includeClassesDetails = this.toolkit.createSection(this.form.getBody(), 384);
        includeClassesDetails.marginWidth = 5;
        includeClassesDetails.setText("Java Classes and Resources");
        includeClassesDetails.setLayoutData((Object)new GridData(1808));
        Composite includeClassesFormClient = this.toolkit.createComposite((Composite)includeClassesDetails);
        includeClassesDetails.setClient((Control)includeClassesFormClient);
        includeClassesDetails.setDescription("Select the Java classes and resources to include in the process archive.");
        this.toolkit.paintBordersFor(includeClassesFormClient);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.numColumns = 1;
        includeClassesFormClient.setLayout((Layout)layout);
        Tree tree = this.toolkit.createTree(includeClassesFormClient, 32);
        tree.setLayoutData((Object)new GridData(1808));
        this.includeClassesTreeViewer = new IncludeInDeploymentTreeViewer(tree);
        this.includeClassesTreeViewer.setContentProvider((IContentProvider)new IncludeClassesTreeContentProvider());
        this.includeClassesTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        final IJavaProject project = JavaCore.create((IProject)this.processFolder.getProject());
        if (project != null) {
            this.includeClassesTreeViewer.setInput(project);
        }
        this.composite.getDisplay().asyncExec(new Runnable(){

            public void run() {
                DeploymentForm.this.includeClassesTreeViewer.setCheckedElements(DeploymentForm.this.getElementsToCheckFor(project).toArray());
            }
        });
        Button includeClassesDefaultButton = this.toolkit.createButton(includeClassesFormClient, "Reset Defaults", 8);
        includeClassesDefaultButton.setLayoutData((Object)new GridData(128));
        includeClassesDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentForm.this.composite.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        DeploymentForm.this.includeClassesTreeViewer.setCheckedElements(DeploymentForm.this.getElementsToCheckFor(project).toArray());
                    }
                });
            }
        });
        return includeClassesFormClient;
    }

    private Composite createLocalSaveFormClient() {
        Section httpInfoDetails = this.toolkit.createSection(this.form.getBody(), 384);
        httpInfoDetails.marginWidth = 5;
        httpInfoDetails.setText("Local Save Settings");
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 1;
        httpInfoDetails.setLayoutData((Object)gridData);
        Composite detailClient = this.toolkit.createComposite((Composite)httpInfoDetails);
        httpInfoDetails.setClient((Control)detailClient);
        httpInfoDetails.setDescription("Choose if and where you wish to save the process archive locally.");
        this.toolkit.paintBordersFor(detailClient);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.numColumns = 3;
        detailClient.setLayout((Layout)layout);
        return detailClient;
    }

    private void createSaveLocallyCheckBox(Composite localSaveFormclient) {
        this.saveLocallyButton = this.toolkit.createButton(localSaveFormclient, "Save Process Archive Locally", 32);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.saveLocallyButton.setLayoutData((Object)gridData);
        this.saveLocallyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = ((Button)e.widget).getSelection();
                DeploymentForm.this.locationText.setEditable(selection);
                DeploymentForm.this.locationButton.setEnabled(selection);
                DeploymentForm.this.updateSaveAndDeployButtons(selection);
            }
        });
    }

    private void updateSaveAndDeployButtons(boolean selection) {
        if (!selection) {
            this.deployButton.setEnabled(this.testConnectionButton.isEnabled());
            this.saveButton.setEnabled(false);
        } else if (this.notEmpty(this.locationText)) {
            this.saveButton.setEnabled(true);
            this.deployButton.setEnabled(this.testConnectionButton.isEnabled());
        } else {
            this.saveButton.setEnabled(false);
            this.deployButton.setEnabled(false);
        }
    }

    private boolean notEmpty(Text text) {
        String string = text.getText();
        return string != null && !"".equals(string);
    }

    private void updateTestConnectionAndDeployButtons() {
        if (this.notEmpty(this.nameText) && this.notEmpty(this.portText) && this.notEmpty(this.deployerText)) {
            this.testConnectionButton.setEnabled(true);
            if (this.saveLocallyButton.getSelection()) {
                this.deployButton.setEnabled(this.saveButton.isEnabled());
            } else {
                this.deployButton.setEnabled(true);
            }
        } else {
            this.testConnectionButton.setEnabled(false);
            this.deployButton.setEnabled(false);
        }
    }

    private void createSaveLocationField(Composite localSaveFormclient) {
        Label locationLabel = this.toolkit.createLabel(localSaveFormclient, "Location:");
        locationLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.locationText = this.toolkit.createText(localSaveFormclient, "");
        this.locationText.setLayoutData((Object)new GridData(768));
        this.locationText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                DeploymentForm.this.updateSaveAndDeployButtons(true);
            }
        });
        this.locationText.setEditable(false);
        this.locationButton = this.toolkit.createButton(localSaveFormclient, "Search...", 8);
        this.locationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentForm.this.searchLocation();
            }
        });
        this.locationButton.setEnabled(false);
    }

    private void searchLocation() {
        FileDialog dialog = new FileDialog(this.form.getShell(), 4096);
        String result = dialog.open();
        if (result != null) {
            this.locationText.setText(result);
            this.updateSaveAndDeployButtons(true);
        }
    }

    private void createSaveButton(Composite localSaveFormClient) {
        this.saveButton = this.toolkit.createButton(localSaveFormClient, "Save Without Deploying...", 8);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 1;
        this.saveButton.setLayoutData((Object)gridData);
        this.saveButton.setEnabled(false);
        this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DeploymentForm.this.cancelOrSaveAndContinue()) {
                    DeploymentForm.this.createProcessDeployer().saveWithoutDeploying();
                }
            }
        });
    }

    public void refresh(final ArrayList objectsToRefresh) {
        this.form.getDisplay().asyncExec(new Runnable(){

            public void run() {
                DeploymentForm.this.refreshIncludeClassesTreeViewer(objectsToRefresh);
                DeploymentForm.this.refreshIncludeFilesTreeViewer(objectsToRefresh);
            }
        });
    }

    private void refreshIncludeFilesTreeViewer(ArrayList objectsToRefresh) {
        Object[] elements = this.includeFilesTreeViewer.getCheckedElements();
        this.includeFilesTreeViewer.refresh();
        this.includeFilesTreeViewer.setCheckedElements(elements);
        IWorkspaceRoot root = this.processFolder.getWorkspace().getRoot();
        int i = 0;
        while (i < objectsToRefresh.size()) {
            IPath path = (IPath)objectsToRefresh.get(i);
            if (root.getFile(path).exists()) {
                this.includeFilesTreeViewer.setChecked(root.getFile(path), true);
            } else if (root.getFolder(path).exists()) {
                this.includeFilesTreeViewer.setChecked(root.getFolder(path), true);
            }
            ++i;
        }
    }

    private void refreshIncludeClassesTreeViewer(ArrayList objectsToRefresh) {
        Set referencedJavaClassNames = null;
        Object[] elements = this.includeClassesTreeViewer.getCheckedElements();
        this.includeClassesTreeViewer.refresh();
        this.includeClassesTreeViewer.setCheckedElements(elements);
        IWorkspaceRoot root = this.processFolder.getWorkspace().getRoot();
        int i = 0;
        while (i < objectsToRefresh.size()) {
            IPath path = (IPath)objectsToRefresh.get(i);
            IJavaElement javaElement = JavaCore.create((IFile)root.getFile(path));
            if (javaElement != null && javaElement instanceof ICompilationUnit) {
                if (referencedJavaClassNames == null) {
                    referencedJavaClassNames = JavaClassNameCollector.getJavaClassNames(this.editor.getProcessDefinition());
                }
                String name = this.getTypeName((ICompilationUnit)javaElement);
                boolean checkNeeded = referencedJavaClassNames.contains(name);
                this.includeClassesTreeViewer.setChecked(javaElement, checkNeeded);
            }
            ++i;
        }
    }

    private String getTypeName(ICompilationUnit unit) {
        try {
            IType[] types = unit.getTypes();
            if (types.length > 0) {
                return types[0].getFullyQualifiedName();
            }
        }
        catch (JavaModelException e) {
            Logger.logError(e);
        }
        return null;
    }

    private boolean cancelOrSaveAndContinue() {
        IEditorPart editor = this.getEditorPart();
        boolean result = true;
        if (editor.isDirty()) {
            int saveProceedCancel = this.openSaveProceedCancelDialog();
            if (saveProceedCancel == 2) {
                result = false;
            } else if (saveProceedCancel == 0) {
                editor.doSave(null);
            }
        }
        return result;
    }

    private int openSaveProceedCancelDialog() {
        MessageDialog dialog = new MessageDialog(this.getWorkBenchWindow().getShell(), "Save Resource", null, "'" + this.processFolder.getName() + "' has been modified. Save changes before deploying?", 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        return dialog.open();
    }

    private IWorkbenchWindow getWorkBenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    private IEditorPart getEditorPart() {
        return this.getWorkBenchWindow().getActivePage().getActiveEditor();
    }

    public void refresh() {
        if (this.composite.isDisposed()) {
            return;
        }
        final IJavaProject project = JavaCore.create((IProject)this.processFolder.getProject());
        this.composite.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!DeploymentForm.this.includeClassesTreeViewer.getTree().isDisposed()) {
                    DeploymentForm.this.includeClassesTreeViewer.refresh();
                    DeploymentForm.this.includeClassesTreeViewer.setCheckedElements(DeploymentForm.this.getElementsToCheckFor(project).toArray());
                }
            }
        });
        this.composite.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!DeploymentForm.this.includeFilesTreeViewer.getTree().isDisposed()) {
                    DeploymentForm.this.includeFilesTreeViewer.refresh();
                    DeploymentForm.this.includeFilesTreeViewer.setCheckedElements(DeploymentForm.this.getElementsToCheckFor(DeploymentForm.this.processFolder).toArray());
                }
            }
        });
    }
}

