/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.editor;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.jbpm.gd.common.editor.ContentProvider;
import org.jbpm.gd.common.editor.Editor;
import org.jbpm.gd.common.editor.GraphicalViewer;
import org.jbpm.gd.common.editor.OutlineViewer;
import org.jbpm.gd.common.editor.SelectionSynchronizer;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.jpdl.editor.JpdlContentProvider;
import org.jbpm.gd.jpdl.editor.JpdlDeploymentEditorPage;
import org.jbpm.gd.jpdl.editor.JpdlSelectionSynchronizer;
import org.jbpm.gd.jpdl.model.ProcessDefinition;
import org.jbpm.gd.jpdl.part.JpdlEditorOutlineEditPartFactory;
import org.jbpm.gd.jpdl.part.JpdlGraphicalEditPartFactory;

public class JpdlEditor
extends Editor {
    private IResourceChangeListener resourceChangeListener;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.initResourceChangeListener();
        this.initPartName();
    }

    private void initResourceChangeListener() {
        this.resourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                JpdlEditor.this.handleResourceChange(event);
            }
        };
        this.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    private void handleResourceChange(IResourceChangeEvent event) {
        IFile file;
        if (event.getType() == 1 && !(file = ((IFileEditorInput)this.getEditorInput()).getFile()).exists()) {
            this.deleteProcessFolder(file);
        }
    }

    private void deleteProcessFolder(IFile file) {
        IFolder processFolder = this.getWorkspace().getRoot().getFolder(file.getFullPath().removeLastSegments(1));
        if (processFolder != null && processFolder.exists()) {
            WorkspaceJob job = new WorkspaceJob("delete", (IContainer)processFolder){
                private final /* synthetic */ IContainer val$processFolder;
                {
                    this.val$processFolder = iContainer;
                    super($anonymous0);
                }

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    this.val$processFolder.delete(true, null);
                    return Status.OK_STATUS;
                }
            };
            job.setRule(this.getWorkspace().getRuleFactory().deleteRule((IResource)processFolder));
            job.schedule();
        }
    }

    private IWorkspace getWorkspace() {
        return ((IFileEditorInput)this.getEditorInput()).getFile().getWorkspace();
    }

    private void initPartName() {
        FileEditorInput fileInput = (FileEditorInput)this.getEditorInput();
        IPath path = fileInput.getPath().removeLastSegments(1);
        path = path.removeFirstSegments(path.segmentCount() - 1);
        this.setPartName(path.lastSegment());
    }

    protected SelectionSynchronizer createSelectionSynchronizer() {
        return new JpdlSelectionSynchronizer();
    }

    protected ContentProvider createContentProvider() {
        return new JpdlContentProvider();
    }

    protected GraphicalViewer createGraphicalViewer() {
        return new GraphicalViewer(this){

            protected void initEditPartFactory() {
                this.setEditPartFactory(new JpdlGraphicalEditPartFactory());
            }
        };
    }

    protected OutlineViewer createOutlineViewer() {
        return new OutlineViewer(this){

            protected void initEditPartFactory() {
                this.getViewer().setEditPartFactory((EditPartFactory)new JpdlEditorOutlineEditPartFactory());
            }
        };
    }

    protected void createPages() {
        super.createPages();
        this.addPage(1, (IEditorPart)new JpdlDeploymentEditorPage(this), "Deployment");
    }

    protected SemanticElement createMainElement() {
        return this.getSemanticElementFactory().createById("org.jbpm.gd.jpdl.processDefinition");
    }

    public ProcessDefinition getProcessDefinition() {
        return (ProcessDefinition)this.getRootContainer().getSemanticElement();
    }

    public void dispose() {
        this.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        super.dispose();
    }

    public String getDefaultImageFileName() {
        return "processimage.jpg";
    }
}

